/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.shoebox;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.shoebox.AnnotationSize;
import mpi.eudico.server.corpora.clomimpl.shoebox.AnnotationSizeContainer;
import mpi.eudico.server.corpora.clomimpl.shoebox.ShoeboxTypFile;
import mpi.eudico.server.corpora.clomimpl.shoebox.utr22.SimpleConverter;

public class SBLayout {
    protected TierImpl _ref_tier;
    protected Vector _vBlockOrder;
    protected int _nBlockPos;
    protected Transcription _transcription;
    private ShoeboxTypFile _sbxtf;
    private SimpleConverter _simpleConverter;
    protected Vector _vRefTags;
    protected Annotation _ref_tag;
    protected int _ref_tag_pos;
    private Writer _writer;
    private Vector _vSBTags = new Vector();

    public SBLayout(Transcription trans) {
        this._transcription = trans;
        try {
            this._simpleConverter = new SimpleConverter(null);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public SBLayout(Transcription trans, ShoeboxTypFile sbxtf) {
        this(trans);
        this._sbxtf = sbxtf;
    }

    public void getRefTierOrder() {
        int i;
        Vector<AnnotationContainer> vSort = new Vector<AnnotationContainer>();
        if (this._transcription == null) {
            this._vBlockOrder = vSort;
            return;
        }
        try {
            Vector v = ((TranscriptionImpl)this._transcription).getTopTiers();
            for (i = 0; i < v.size(); ++i) {
                TierImpl ti = (TierImpl)v.elementAt(i);
                Vector wv = ti.getAnnotations();
                for (int ii = 0; ii < wv.size(); ++ii) {
                    vSort.add(new AnnotationContainer((Annotation)wv.elementAt(ii)));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Collections.sort(vSort);
        Vector<Annotation> vecRet = new Vector<Annotation>();
        for (i = 0; i < vSort.size(); ++i) {
            Annotation a = ((AnnotationContainer)vSort.elementAt(i)).getAnnotation();
            vecRet.add(a);
        }
        this._vBlockOrder = vecRet;
    }

    public void getSegOrder() {
        this.getRefTierOrder();
        this._nBlockPos = 0;
    }

    public void setWorkingSegmentsRange(int size, int pos) {
        Vector retVec = new Vector();
        if (this._nBlockPos >= this._vBlockOrder.size() && this._nBlockPos > this._vBlockOrder.size()) {
            this._nBlockPos = this._vBlockOrder.size() - 1;
        }
        for (int i = 0; i < size; ++i) {
            this._nBlockPos = pos == 1 ? ++this._nBlockPos : --this._nBlockPos;
            if (this._nBlockPos >= this._vBlockOrder.size()) {
                this._nBlockPos = this._vBlockOrder.size() - 1;
            }
            if (this._nBlockPos < 0) {
                this._nBlockPos = 0;
            }
            retVec.add(this._vBlockOrder.elementAt(this._nBlockPos));
        }
        if (retVec.size() > 0) {
            this._vRefTags = retVec;
        }
    }

    public boolean setBlocksVisibleAtTime(long time) {
        Annotation af = null;
        Annotation al = null;
        if (this._vRefTags == null || this._vRefTags.size() == 0) {
            return false;
        }
        af = (Annotation)this._vRefTags.firstElement();
        al = (Annotation)this._vRefTags.lastElement();
        if (af.getBeginTimeBoundary() <= time && al.getEndTimeBoundary() >= time) {
            return false;
        }
        boolean bf = false;
        long lasttime = -1L;
        while (af.getEndTimeBoundary() < time) {
            bf = true;
            if (lasttime == af.getEndTimeBoundary()) {
                return false;
            }
            lasttime = af.getEndTimeBoundary();
            this.setWorkingSegmentsRange(1, 1);
            af = (Annotation)this._vRefTags.firstElement();
            al = (Annotation)this._vRefTags.lastElement();
        }
        if (bf) {
            return true;
        }
        lasttime = -1L;
        while (al.getBeginTimeBoundary() > time) {
            bf = true;
            if (lasttime == af.getBeginTimeBoundary()) {
                return false;
            }
            lasttime = af.getBeginTimeBoundary();
            this.setWorkingSegmentsRange(1, -1);
            af = (Annotation)this._vRefTags.firstElement();
            al = (Annotation)this._vRefTags.lastElement();
        }
        return bf;
    }

    protected Vector getAnnBetweenTime(Tier tier, long start, long end) {
        Vector v = null;
        TierImpl ti = (TierImpl)tier;
        Vector<Annotation> vecRet = new Vector<Annotation>();
        try {
            v = ti.getAnnotations();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        for (int i = 0; i < v.size(); ++i) {
            Annotation a = (Annotation)v.elementAt(i);
            if (a.getBeginTimeBoundary() < start || a.getEndTimeBoundary() > end) continue;
            vecRet.add(a);
        }
        return vecRet;
    }

    public Vector getSBTags() {
        return this._vSBTags;
    }

    public long getCurrentRefStartTime() {
        if (this._ref_tag == null) {
            return 0L;
        }
        return this._ref_tag.getBeginTimeBoundary();
    }

    public long getCurrentRefEndTime() {
        if (this._ref_tag == null) {
            return 0L;
        }
        return this._ref_tag.getEndTimeBoundary();
    }

    public boolean getPrevRef() {
        Annotation an = null;
        if (this._ref_tier == null) {
            return false;
        }
        an = this._ref_tier.getAnnotationBefore(this._ref_tag);
        return an != null;
    }

    public Annotation getRefAnn() {
        Annotation refann = (Annotation)this._vBlockOrder.elementAt(this._nBlockPos);
        return refann;
    }

    public boolean isRefAnnAvailable() {
        if (this._vBlockOrder == null) {
            return false;
        }
        return this._nBlockPos < this._vBlockOrder.size() && this._nBlockPos >= 0;
    }

    public void exportAll(String filename, String header) {
        try {
            this.openWriter(filename);
            this.getSegOrder();
            this.write(header + "\r\r\n");
            for (int i = 0; i < this._vBlockOrder.size(); ++i) {
                Annotation refann = (Annotation)this._vBlockOrder.elementAt(i);
                AnnotationSize as = new AnnotationSize(this._transcription, refann);
                Vector vtiers = as.getTiers();
                Enumeration e = vtiers.elements();
                while (e.hasMoreElements()) {
                    Tier tier = (Tier)e.nextElement();
                    this.write(this.chopAtChar(tier.getName()) + " ");
                    boolean isSILIPAcharacterset = this._sbxtf != null && this._sbxtf.isIPAtier(this.chopAtChar(tier.getName()));
                    ArrayList tierAnn = as.getTierLayoutInPixels(tier, null);
                    Iterator it = tierAnn.iterator();
                    String wstr = "";
                    while (it.hasNext()) {
                        AnnotationSizeContainer asc = (AnnotationSizeContainer)it.next();
                        Annotation a = asc.getAnnotation();
                        if (a == null) {
                            wstr = this.padString("", asc.getSize() + 1);
                        } else {
                            String trimedValueofa = a.getValue().trim();
                            if (isSILIPAcharacterset) {
                                trimedValueofa = this._simpleConverter.toBinary(trimedValueofa);
                            }
                            wstr = this.padString(trimedValueofa, asc.getSize() + 1);
                        }
                        this.write(this.padString(wstr, asc.getSize()));
                        this.writeBlockStamp(a, refann);
                    }
                    this.write("\r\n");
                }
                this.write("\r\n");
            }
            this._writer.flush();
            this._writer.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private String padString(String orig, int totallen) {
        orig.trim();
        int len = totallen - orig.length();
        if (len < 0) {
            return orig;
        }
        for (int i = 0; i < len; ++i) {
            orig = orig + " ";
        }
        return orig;
    }

    private String chopAtChar(String str) {
        int in = str.indexOf("@");
        if (in == -1) {
            return this.addSlash(str);
        }
        return this.addSlash(str.substring(0, in));
    }

    private String addSlash(String str) {
        int in = str.indexOf("\\");
        if (in == -1) {
            str = "\\" + str;
        }
        return str;
    }

    private String getSpeakerFormat(String str) {
        int in = str.indexOf("@");
        if (in == -1) {
            return "\\EUDICOp unknown";
        }
        return "\\EUDICOp " + str.substring(in + 1);
    }

    private void writeBlockStamp(Annotation a, Annotation refann) throws IOException {
        if (a == null) {
            return;
        }
        if (a.equals(refann)) {
            String wkstr = "\r\n";
            try {
                Tier t = a.getTier();
                wkstr = wkstr + this.getSpeakerFormat(t.getName()) + "\r\n";
            }
            catch (Exception e) {
                // empty catch block
            }
            wkstr = wkstr + "\\EUDICOt0 " + (double)a.getBeginTimeBoundary() * 0.001 + "\r\n\\EUDICOt1 " + (double)a.getEndTimeBoundary() * 0.001;
            this.write(wkstr + "\r\n");
        }
    }

    private void openWriter(String file) throws IOException {
        FileOutputStream fos = new FileOutputStream(file);
        this._writer = new OutputStreamWriter((OutputStream)fos, "ISO-8859-1");
    }

    private void write(String text) throws IOException {
        this._writer.write(text);
    }

    public class AnnotationContainer
    implements Comparable {
        Annotation _ann;

        public AnnotationContainer(Annotation a) {
            this._ann = a;
        }

        public Annotation getAnnotation() {
            return this._ann;
        }

        public int compareTo(Object obj) {
            AnnotationContainer ac = (AnnotationContainer)obj;
            Annotation a = ac.getAnnotation();
            if (this._ann.getBeginTimeBoundary() > a.getBeginTimeBoundary()) {
                return 1;
            }
            if (this._ann.getBeginTimeBoundary() < a.getBeginTimeBoundary()) {
                return -1;
            }
            return 0;
        }
    }
}

