/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.shoebox;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import mpi.eudico.server.corpora.clom.AnnotationDocEncoder;
import mpi.eudico.server.corpora.clom.EncoderInfo;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.shoebox.MarkerRecord;
import mpi.eudico.server.corpora.clomimpl.shoebox.ToolboxEncoderInfo;
import mpi.eudico.server.corpora.clomimpl.shoebox.interlinear.Interlinearizer;
import mpi.eudico.server.corpora.clomimpl.shoebox.interlinear.TimeCodedTranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.shoebox.utr22.SimpleConverter;

public class ShoeboxEncoder
implements AnnotationDocEncoder {
    public static final String defaultDBType = "ElanExport";
    public static final String elanELANLabel = "\\ELANExport";
    public static final String elanBlockStart = "\\block";
    public static final String elanBeginLabel = "\\ELANBegin";
    public static final String elanEndLabel = "\\ELANEnd";
    public static final String elanParticipantLabel = "\\ELANParticipant";
    public static final String elanMediaURLLabel = "\\ELANMediaURL";
    public static final String elanMediaExtractedLabel = "\\ELANMediaExtracted";
    public static final String elanMediaMIMELabel = "\\ELANMediaMIME";
    public static final String elanMediaOriginLabel = "\\ELANMediaOrigin";
    private OutputStreamWriter isoLatinWriter;
    private OutputStreamWriter utf8Writer;
    private SimpleConverter simpleConverter;

    public ShoeboxEncoder(String path) {
        try {
            FileOutputStream out = new FileOutputStream(path);
            this.isoLatinWriter = new OutputStreamWriter((OutputStream)out, "ISO-8859-1");
            this.utf8Writer = new OutputStreamWriter((OutputStream)out, "UTF-8");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void encodeAndSave(Transcription theTranscription, EncoderInfo encoderInfo, List tierOrder, String path) throws IOException {
        this.writeHeader(theTranscription, encoderInfo);
        this.writeBlocks(theTranscription, tierOrder, encoderInfo);
        this.writeMediaDescriptors(theTranscription);
        this.closeFile();
    }

    private void writeHeader(Transcription theTranscription, EncoderInfo encoderInfo) {
        String dbType = ((ToolboxEncoderInfo)encoderInfo).getDatabaseType();
        if (dbType == null || dbType.equals("")) {
            dbType = defaultDBType;
        }
        this.write("\\_sh v3.0  400  " + dbType + "\n");
        this.write("\\_DateStampHasFourDigitYear\n");
        if (((ToolboxEncoderInfo)encoderInfo).getMarkerSource() == 2) {
            this.write("\n\\ELANExport\n");
        }
    }

    private void writeMediaDescriptors(Transcription theTranscription) {
        Vector mediaDescriptors = null;
        try {
            mediaDescriptors = theTranscription.getMediaDescriptors();
        }
        catch (Exception rex) {
            rex.printStackTrace();
        }
        for (int i = 0; i < mediaDescriptors.size(); ++i) {
            this.write("\n");
            MediaDescriptor md = (MediaDescriptor)mediaDescriptors.elementAt(i);
            if (md.mediaURL != null && !md.mediaURL.equals("")) {
                this.write("\\ELANMediaURL " + md.mediaURL + "\n");
            }
            if (md.mimeType != null && !md.mimeType.equals("")) {
                this.write("\\ELANMediaMIME " + md.mimeType + "\n");
            }
            if (md.timeOrigin != 0L) {
                this.write("\\ELANMediaOrigin " + md.timeOrigin + "\n");
            }
            if (md.extractedFrom == null || md.extractedFrom.equals("")) continue;
            this.write("\\ELANMediaExtracted " + md.extractedFrom + "\n");
        }
    }

    private void writeBlocks(Transcription theTranscription, List tierOrder, EncoderInfo encoderInfo) {
        boolean lineForRootAnnot = false;
        boolean justOneRoot = false;
        int blockCounter = 1;
        Interlinearizer interlinearizer = new Interlinearizer(new TimeCodedTranscriptionImpl((TranscriptionImpl)theTranscription));
        this.setShoeboxArguments(theTranscription, interlinearizer, tierOrder, encoderInfo);
        String[] outputLines = interlinearizer.renderAsText();
        String participantString = "";
        Hashtable<String, String> rootTierNames = new Hashtable<String, String>();
        try {
            Vector topTiers = ((TranscriptionImpl)theTranscription).getTopTiers();
            for (TierImpl t : topTiers) {
                rootTierNames.put(t.getName(), t.getParticipant());
            }
            if (topTiers.size() == 1) {
                justOneRoot = true;
            } else {
                justOneRoot = true;
                String prefix = null;
                int atIndex = -1;
                for (String name : rootTierNames.keySet()) {
                    atIndex = name.indexOf(64);
                    if (atIndex < 1) {
                        justOneRoot = false;
                        break;
                    }
                    String curPref = name.substring(0, atIndex);
                    if (prefix == null) {
                        prefix = curPref;
                        continue;
                    }
                    if (prefix.equals(curPref)) continue;
                    justOneRoot = false;
                    break;
                }
            }
            for (int i = 0; i < outputLines.length; ++i) {
                String tierLabel = interlinearizer.getMetrics().getTierLabelAt(i);
                if (tierLabel == null) {
                    tierLabel = "";
                }
                if (rootTierNames.get(tierLabel) != null) {
                    participantString = (String)rootTierNames.get(tierLabel);
                    lineForRootAnnot = true;
                }
                if (!tierLabel.startsWith("\\") && !tierLabel.equals("")) {
                    tierLabel = "\\" + tierLabel;
                }
                if (tierLabel.indexOf("@") > 0) {
                    tierLabel = tierLabel.substring(0, tierLabel.indexOf("@"));
                }
                if (tierLabel.indexOf(" ") >= 0) {
                    tierLabel = tierLabel.replace(' ', '_');
                }
                if (tierLabel.startsWith("\\TC")) {
                    String beginString = outputLines[i].substring(0, outputLines[i].indexOf("-")).trim();
                    String endString = outputLines[i].substring(outputLines[i].indexOf("-") + 1).trim();
                    if (!beginString.startsWith("?.???")) {
                        this.write("\\ELANBegin " + beginString + "\n");
                    }
                    if (!endString.startsWith("?.???")) {
                        this.write("\\ELANEnd " + endString + "\n");
                    }
                    if (participantString == null || participantString.equals("")) continue;
                    this.write("\\ELANParticipant " + participantString + "\n");
                    continue;
                }
                int charEncoding = interlinearizer.getCharEncoding(interlinearizer.getMetrics().getTierLabelAt(i));
                String encodingString = "ISO-8859-1";
                if (charEncoding == 0) {
                    encodingString = "UTF-8";
                } else if (charEncoding == 2) {
                    encodingString = "SIL-IPA93";
                }
                if (lineForRootAnnot) {
                    if (!justOneRoot) {
                        DecimalFormat df = new DecimalFormat("#000");
                        String cntString = df.format(blockCounter++);
                        this.write("\\block " + cntString + "\n");
                    }
                    lineForRootAnnot = false;
                }
                this.write(tierLabel + " " + outputLines[i].replace('\n', ' ') + "\n", encodingString);
            }
        }
        catch (Exception rex) {
            rex.printStackTrace();
        }
    }

    private void setShoeboxArguments(Transcription transcription, Interlinearizer interlinearizer, List tierOrder, EncoderInfo encoderInfo) {
        String[] visTiers = tierOrder.toArray(new String[0]);
        int width = 80;
        int timeFormat = 1;
        if (encoderInfo != null) {
            width = ((ToolboxEncoderInfo)encoderInfo).getPageWidth();
            timeFormat = ((ToolboxEncoderInfo)encoderInfo).getTimeFormat();
        }
        interlinearizer.setVisibleTiers(visTiers);
        interlinearizer.setAlignmentUnit(1);
        interlinearizer.setBlockWrapStyle(0);
        interlinearizer.setWidth(width);
        interlinearizer.setBlockSpacing(1);
        interlinearizer.setTierLabelsShown(false);
        interlinearizer.setTimeCodeShown(true);
        interlinearizer.setTimeCodeType(timeFormat);
        interlinearizer.setCorrectAnnotationTimes(((ToolboxEncoderInfo)encoderInfo).getCorrectAnnotationTimes());
        if (((ToolboxEncoderInfo)encoderInfo).getMarkerSource() == 2) {
            this.setDefaultCharEncodings(transcription, interlinearizer, 0);
        } else if (((ToolboxEncoderInfo)encoderInfo).getMarkerSource() == 0) {
            if (((ToolboxEncoderInfo)encoderInfo).isAllUnicode()) {
                this.setDefaultCharEncodings(transcription, interlinearizer, 0);
            } else {
                this.setDefaultCharEncodings(transcription, interlinearizer, 1);
            }
        } else {
            this.setDefaultCharEncodings(transcription, interlinearizer, 1);
            List markers = ((ToolboxEncoderInfo)encoderInfo).getMarkers();
            if (markers != null) {
                for (int i = 0; i < markers.size(); ++i) {
                    MarkerRecord mkrRec = (MarkerRecord)markers.get(i);
                    List matchingTiers = this.getMatchingTiers(transcription, mkrRec.getMarker());
                    for (int j = 0; j < matchingTiers.size(); ++j) {
                        String name = (String)matchingTiers.get(j);
                        if ("".equals(name)) continue;
                        if (mkrRec.getCharset() == 1) {
                            interlinearizer.setCharEncoding(name, 1);
                            continue;
                        }
                        if (mkrRec.getCharset() == 0) {
                            interlinearizer.setCharEncoding(name, 0);
                            continue;
                        }
                        if (mkrRec.getCharset() != 2) continue;
                        interlinearizer.setCharEncoding(name, 2);
                    }
                }
            }
        }
    }

    private void setDefaultCharEncodings(Transcription transcription, Interlinearizer interlinearizer, int encoding) {
        Vector tiers = transcription.getTiers();
        for (int i = 0; i < tiers.size(); ++i) {
            String tierName = ((Tier)tiers.elementAt(i)).getName();
            interlinearizer.setCharEncoding(tierName, encoding);
        }
    }

    private List getMatchingTiers(Transcription transcription, String marker) {
        ArrayList<String> tierList = new ArrayList<String>(5);
        Vector tiers = transcription.getTiers();
        for (int i = 0; i < tiers.size(); ++i) {
            String tierName = ((Tier)tiers.elementAt(i)).getName();
            if (!tierName.startsWith(marker) || tierName.length() != marker.length() && tierName.indexOf(64) != marker.length()) continue;
            tierList.add(tierName);
        }
        return tierList;
    }

    private void write(String string) {
        this.write(string, "ISO-8859-1");
    }

    private void write(String string, String charsetName) {
        OutputStreamWriter osw = this.isoLatinWriter;
        try {
            if (charsetName.equals("SIL-IPA93")) {
                if (this.simpleConverter == null) {
                    this.simpleConverter = new SimpleConverter(null);
                }
                string = this.simpleConverter.toBinary(string);
            } else if (charsetName.equals("UTF-8")) {
                osw = this.utf8Writer;
            }
            osw.write(string);
            osw.flush();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void closeFile() {
        try {
            this.isoLatinWriter.flush();
            this.utf8Writer.flush();
            this.isoLatinWriter.close();
            this.utf8Writer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

