/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.shoebox.interlinear;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.Vector;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clomimpl.shoebox.interlinear.Interlinearizer;
import mpi.eudico.server.corpora.clomimpl.shoebox.interlinear.Metrics;
import mpi.eudico.server.corpora.clomimpl.shoebox.interlinear.Renderer;

public class ImageRenderer
extends Renderer {
    public static void render(Metrics metrics, BufferedImage bi, int[] offset) {
        Graphics2D g2d = (Graphics2D)bi.getGraphics();
        g2d.setColor(Color.LIGHT_GRAY);
        g2d.fillRect(0, 0, bi.getWidth(), bi.getHeight());
        int[] visibleRect = new int[]{bi.getWidth(), bi.getHeight()};
        ImageRenderer.render(metrics, bi.getGraphics(), offset, visibleRect);
    }

    public static boolean render(Metrics metrics, Graphics g, int pageIndex) {
        boolean pageExists = true;
        int[] pageBoundaries = metrics.getPageBoundaries(pageIndex, metrics.getInterlinearizer().getHeight());
        if (pageBoundaries[0] == pageBoundaries[1]) {
            pageExists = false;
        } else {
            int[] offset = new int[]{0, pageBoundaries[0]};
            int[] visibleRect = new int[]{metrics.getInterlinearizer().getWidth(), pageBoundaries[1] - pageBoundaries[0]};
            ImageRenderer.render(metrics, g, offset, visibleRect);
        }
        return pageExists;
    }

    private static void render(Metrics metrics, Graphics g, int[] offset, int[] visibleRect) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setColor(Color.WHITE);
        g2d.fillRect(0, 0, metrics.getInterlinearizer().getWidth(), metrics.getInterlinearizer().getHeight());
        if (metrics.getInterlinearizer().forPrinting() && metrics.getInterlinearizer().getPageHeight() > 0) {
            int[] pageBoundaries = metrics.getPageBoundaries(metrics.getInterlinearizer().getPageHeight());
            int width = metrics.getInterlinearizer().getWidth();
            g2d.setColor(Color.LIGHT_GRAY);
            for (int i = 0; i < pageBoundaries.length; ++i) {
                if (pageBoundaries[i] <= offset[1] || pageBoundaries[i] >= offset[1] + visibleRect[1]) continue;
                g2d.drawLine(0, pageBoundaries[i] - offset[1], width, pageBoundaries[i] - offset[1]);
            }
        }
        if (metrics.leftMarginShown() && metrics.getLeftMargin() > offset[0]) {
            g2d.setColor(Color.LIGHT_GRAY);
            g2d.drawLine(metrics.getLeftMargin() - offset[0], 0, metrics.getLeftMargin() - offset[0], metrics.getInterlinearizer().getHeight());
            ImageRenderer.drawTierLabels(metrics, g2d, offset, visibleRect);
        }
        ImageRenderer.drawAnnotationValues(metrics, g2d, offset, visibleRect);
    }

    private static void drawTierLabels(Metrics metrics, Graphics2D g2d, int[] offset, int[] visibleRect) {
        g2d.setColor(Color.LIGHT_GRAY);
        if (metrics.getInterlinearizer().getEmptyLineStyle() == 1) {
            ImageRenderer.drawLabelsForVisibleAnnots(metrics, g2d, offset, visibleRect);
        } else {
            ImageRenderer.drawLabelsAsTemplates(metrics, g2d, offset, visibleRect);
        }
    }

    private static void drawLabelsForVisibleAnnots(Metrics metrics, Graphics2D g2d, int[] offset, int[] visibleRect) {
        Integer vPos2 = null;
        String tierLabel = "";
        int vShift = 0;
        int hShift = 0;
        Vector vPositions = metrics.getPositionsOfNonEmptyTiers();
        for (Integer vPos2 : vPositions) {
            tierLabel = metrics.getTierLabelAt(vPos2);
            if (offset != null && visibleRect != null && (vPos2 < offset[1] || vPos2 > offset[1] + visibleRect[1])) continue;
            if (offset != null) {
                hShift = offset[0];
                vShift = offset[1];
            }
            Font font = metrics.getInterlinearizer().getFont(tierLabel);
            FontMetrics fontMetrics = g2d.getFontMetrics(font);
            g2d.setFont(font);
            if (!tierLabel.startsWith("TC-")) {
                g2d.drawString(tierLabel, -hShift, vPos2 - fontMetrics.getDescent() - vShift);
                continue;
            }
            g2d.drawString("TC", -hShift, vPos2 - fontMetrics.getDescent() - vShift);
        }
    }

    private static void drawLabelsAsTemplates(Metrics metrics, Graphics2D g2d, int[] offset, int[] visibleRect) {
        int currentBlockPosition = 0;
        int vPos = 0;
        int hShift = 0;
        int vShift = 0;
        String templateLabel = "";
        Interlinearizer interlinearizer = metrics.getInterlinearizer();
        int maxPosition = metrics.getMaxVerticalPosition();
        int[] templatePositions = metrics.getVPositionsInTemplate();
        String[] templateLabels = interlinearizer.getVisibleTiers();
        int blockIncrement = 0;
        if (templatePositions.length > 0) {
            blockIncrement = templatePositions[templatePositions.length - 1];
        }
        blockIncrement += interlinearizer.getBlockSpacing() + interlinearizer.getLineSpacing();
        while (currentBlockPosition < maxPosition) {
            for (int i = 0; i < templatePositions.length; ++i) {
                vPos = currentBlockPosition + templatePositions[i];
                templateLabel = templateLabels[i];
                if (offset != null && visibleRect != null && (vPos < offset[1] || vPos > offset[1] + visibleRect[1])) continue;
                if (offset != null) {
                    hShift = offset[0];
                    vShift = offset[1];
                }
                Font font = metrics.getInterlinearizer().getFont(templateLabel);
                FontMetrics fontMetrics = g2d.getFontMetrics(font);
                g2d.setFont(font);
                if (!templateLabel.startsWith("TC-")) {
                    g2d.drawString(templateLabel, -hShift, vPos - fontMetrics.getDescent() - vShift);
                    continue;
                }
                g2d.drawString("TC", -hShift, vPos - fontMetrics.getDescent() - vShift);
            }
            currentBlockPosition += blockIncrement;
        }
    }

    private static void drawAnnotationValues(Metrics metrics, Graphics2D g2d, int[] offset, int[] visibleRect) {
        int hShift = 0;
        int vShift = 0;
        g2d.setColor(Color.BLACK);
        Vector annots = metrics.getBlockWiseOrdered();
        for (Annotation a : annots) {
            String tierName;
            int vPos = metrics.getVerticalPosition(a);
            if (offset != null && visibleRect != null && (vPos < offset[1] || vPos > offset[1] + visibleRect[1])) continue;
            if (offset != null) {
                hShift = offset[0];
                vShift = offset[1];
            }
            if ((tierName = a.getTier().getName()).startsWith("TC-")) {
                g2d.setColor(Color.RED);
            }
            Font font = metrics.getInterlinearizer().getFont(tierName);
            FontMetrics fontMetrics = g2d.getFontMetrics(font);
            g2d.setFont(font);
            g2d.drawString(a.getValue(), metrics.getLeftMargin() + metrics.getHorizontalPosition(a) - hShift, metrics.getVerticalPosition(a) - fontMetrics.getDescent() - vShift);
            if (!tierName.startsWith("TC-")) continue;
            g2d.setColor(Color.BLACK);
        }
    }
}

