/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.editable;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;
import mpi.eudico.server.corpora.editable.EditIdentity;
import mpi.eudico.server.corpora.editable.EditMonitor;
import mpi.eudico.server.corpora.editable.EditPreferences;
import mpi.eudico.server.corpora.editable.Editable;
import mpi.eudico.server.corpora.editable.LockedException;
import mpi.eudico.server.corpora.editable.NotLockedException;
import mpi.eudico.server.corpora.editable.UnicastRemoteObservable;

public abstract class RemoteEditable
extends UnicastRemoteObservable
implements Editable,
ActionListener {
    private EditIdentity ownerIdentity = null;
    private EditMonitor ownerEditMonitor = null;
    private Timer livelinessTimer = new Timer(EditPreferences.LIVELINESS_CHECK_PERIOD, this);
    private long timeOfLastSaveAction;
    private boolean locked = false;

    @Override
    public synchronized EditIdentity getOwnerIdentity() {
        return this.ownerIdentity;
    }

    protected abstract void setEditableDataValue(Object var1);

    @Override
    public abstract Object getEditableDataValue();

    @Override
    public synchronized void setEditableDataValue(Object value, EditIdentity identity) throws LockedException, NotLockedException {
        if (!this.locked) {
            throw new NotLockedException();
        }
        if (!identity.equals(this.ownerIdentity)) {
            throw new LockedException();
        }
        this.setEditableDataValue(value);
        this.notifyObservers("ValueChange");
        this.timeOfLastSaveAction = System.currentTimeMillis();
    }

    @Override
    public synchronized boolean isLocked() {
        return this.locked;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized void setLocked(boolean mustBeLocked, EditIdentity identity, EditMonitor editMonitor) throws LockedException {
        if (mustBeLocked) {
            if (identity != null && editMonitor != null && this.ownerIdentity == null) {
                this.locked = true;
                this.ownerIdentity = identity;
                this.ownerEditMonitor = editMonitor;
                this.notifyObservers("StateChange");
                this.timeOfLastSaveAction = System.currentTimeMillis();
                this.livelinessTimer.start();
                return;
            } else {
                if (!this.ownerIdentity.equals(identity)) throw new LockedException();
                if (this.locked) return;
                this.locked = true;
                this.notifyObservers("StateChange");
            }
            return;
        } else {
            if (!this.locked) return;
            if (!this.ownerIdentity.equals(identity)) throw new LockedException();
            this.locked = false;
            this.ownerIdentity = null;
            this.ownerEditMonitor = null;
            this.notifyObservers("StateChange");
            this.livelinessTimer.stop();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.ownerEditMonitor != null) {
            System.out.println("CHECK LIVELINESS OF " + this.ownerIdentity.getName() + " (" + this.ownerIdentity.getNumber() + ")");
            try {
                this.ownerEditMonitor.isCallable();
                long now = System.currentTimeMillis();
                if (now - this.timeOfLastSaveAction > (long)EditPreferences.MAX_TIME_BETWEEN_SAVE_ACTIONS) {
                    System.out.println("CHECK EDIT MODE OF " + this.ownerIdentity.getName() + " (" + this.ownerIdentity.getNumber() + ")");
                    this.livelinessTimer.stop();
                    if (!this.ownerEditMonitor.isInEditMode()) {
                        this.locked = false;
                        this.ownerEditMonitor = null;
                        this.ownerIdentity = null;
                        this.notifyObservers("StateChange");
                    } else {
                        this.timeOfLastSaveAction = System.currentTimeMillis();
                        this.livelinessTimer.start();
                    }
                }
            }
            catch (Exception ex) {
                this.locked = false;
                this.ownerEditMonitor = null;
                this.ownerIdentity = null;
                this.notifyObservers("StateChange");
            }
        }
    }
}

