/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.location;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import mpi.eudico.server.corpora.location.DirectoryTree;

public class LocalDirectoryTree
implements DirectoryTree {
    private File topNode;

    public LocalDirectoryTree(File theTopNode) {
        this.topNode = theTopNode;
    }

    @Override
    public Vector getDirectories(File subDirectory) {
        Vector<File> subDirectories = new Vector<File>();
        File absolutePath = new File(this.topNode, subDirectory.getPath());
        String[] listing = absolutePath.list();
        if (listing != null) {
            for (int i = 0; i < listing.length; ++i) {
                File file = new File(absolutePath, listing[i]);
                if (!file.isDirectory()) continue;
                subDirectories.add(file);
            }
        }
        return subDirectories;
    }

    @Override
    public Vector getFiles(File subDirectory) {
        Vector<File> files = new Vector<File>();
        File absolutePath = new File(this.topNode, subDirectory.getPath());
        String[] listing = absolutePath.list();
        if (listing != null) {
            for (int i = 0; i < listing.length; ++i) {
                File file = new File(absolutePath, listing[i]);
                if (!file.isFile()) continue;
                files.add(file);
            }
        }
        return files;
    }

    @Override
    public String getOwner(File theFile) {
        return null;
    }

    @Override
    public String getAccessRights(File theFile) {
        return null;
    }

    @Override
    public boolean containsDirectories(File subDirectory) {
        boolean containsDirs = false;
        File absolutePath = new File(this.topNode, subDirectory.getPath());
        String[] listing = absolutePath.list();
        if (listing != null) {
            for (int i = 0; i < listing.length; ++i) {
                File file = new File(absolutePath, listing[i]);
                if (!file.isDirectory()) continue;
                containsDirs = true;
                break;
            }
        }
        return containsDirs;
    }

    @Override
    public String getPath() {
        return this.topNode.getPath();
    }

    @Override
    public Vector getTierNames(File theFile) {
        Vector<String> tierNames = new Vector<String>();
        File file = new File(this.topNode, theFile.getPath());
        String participantLine = this.getParticipantLine(file);
        StringTokenizer st = new StringTokenizer(participantLine, ":,\n");
        if (st.hasMoreTokens()) {
            st.nextToken();
        }
        while (st.hasMoreTokens()) {
            StringTokenizer st2 = new StringTokenizer(st.nextToken().trim());
            if (!st2.hasMoreTokens()) continue;
            String tierName = st2.nextToken();
            tierNames.add(tierName);
        }
        return tierNames;
    }

    public String getParticipant(File theFile, String theTierName) {
        String participant = null;
        File file = new File(this.topNode, theFile.getPath());
        String participantLine = this.getParticipantLine(file);
        return participant;
    }

    private String getParticipantLine(File theFile) {
        String line = null;
        String pLine = null;
        boolean recording = false;
        try {
            FileReader fr = new FileReader(theFile);
            BufferedReader br = new BufferedReader(fr);
            while ((line = br.readLine()) != null) {
                if (line.startsWith("@Participants:")) {
                    recording = true;
                    pLine = line;
                    continue;
                }
                if (!recording) continue;
                if (!(line.startsWith("@") || line.startsWith("*") || line.startsWith("%"))) {
                    pLine = pLine + line;
                    continue;
                }
                recording = false;
                break;
            }
        }
        catch (FileNotFoundException fex) {
            fex.printStackTrace();
        }
        catch (IOException iex) {
            iex.printStackTrace();
        }
        return pLine;
    }

    private final BufferedReader file2br(File file) throws IOException {
        InputStreamReader filereader = -1 != file.getName().lastIndexOf(".utf8.") ? new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8") : new FileReader(file);
        BufferedReader br = new BufferedReader(filereader);
        return br;
    }

    @Override
    public Vector getCHATBlocks(File theFile, String theTierName) {
        boolean recording = false;
        String line = null;
        String previousLine = null;
        Vector blocks = new Vector();
        HashMap chatBlock = null;
        try {
            File file = new File(this.topNode, theFile.getPath());
            BufferedReader br = this.file2br(file);
            while ((line = br.readLine()) != null) {
                if (line.startsWith("*") || line.startsWith("@")) {
                    if (recording) {
                        recording = false;
                        if (chatBlock != null) {
                            blocks.add(chatBlock);
                        }
                    }
                    if (!line.startsWith("*" + theTierName)) continue;
                    recording = true;
                    chatBlock = new HashMap();
                    previousLine = line;
                    this.addLineToBlock(line, chatBlock);
                    continue;
                }
                if (!recording) continue;
                if (line.startsWith("%") || line.startsWith("*")) {
                    previousLine = line;
                } else {
                    line = previousLine + line;
                }
                this.addLineToBlock(line, chatBlock);
            }
        }
        catch (FileNotFoundException fex) {
            fex.printStackTrace();
        }
        catch (IOException iex) {
            iex.printStackTrace();
        }
        return blocks;
    }

    @Override
    public Vector getCHATBlocks(File theFile) {
        boolean recording = false;
        String line = null;
        String previousLine = null;
        Vector blocks = new Vector();
        HashMap chatBlock = null;
        try {
            File file = new File(this.topNode, theFile.getPath());
            BufferedReader br = this.file2br(file);
            while ((line = br.readLine()) != null) {
                if (line.startsWith("*")) {
                    if (chatBlock != null) {
                        blocks.add(chatBlock);
                    }
                    chatBlock = new HashMap();
                    previousLine = line;
                    this.addLineToBlock(line, chatBlock);
                    continue;
                }
                if (line.startsWith("%")) {
                    previousLine = line;
                    this.addLineToBlock(line, chatBlock);
                    continue;
                }
                if (line.startsWith("@")) continue;
                line = previousLine + line;
                this.addLineToBlock(line, chatBlock);
            }
            if (chatBlock != null) {
                blocks.add(chatBlock);
            }
        }
        catch (FileNotFoundException fex) {
            fex.printStackTrace();
        }
        catch (IOException iex) {
            iex.printStackTrace();
        }
        return blocks;
    }

    private void addLineToBlock(String theLine, HashMap theBlock) {
        String label = null;
        String value = null;
        label = this.getLabelPart(theLine);
        value = this.getValuePart(theLine);
        if (label != null && value != null) {
            theBlock.put(label, value);
        }
    }

    private String getLabelPart(String theLine) {
        String label = null;
        int index = theLine.indexOf(58);
        if (index > 0) {
            label = theLine.substring(0, index);
        }
        return label;
    }

    private String getValuePart(String theLine) {
        String value = null;
        int index = theLine.indexOf(58);
        if (index < theLine.length() - 2) {
            value = theLine.substring(index + 1).trim();
        }
        return value;
    }

    @Override
    public String getMediaFileName(File theFile) {
        String line = null;
        String mediaFileName = null;
        try {
            File file = new File(this.topNode, theFile.getPath());
            FileReader fr = new FileReader(file);
            BufferedReader br = new BufferedReader(fr);
            while ((line = br.readLine()) != null) {
                if (!line.startsWith("%snd:")) continue;
                StringTokenizer st = new StringTokenizer(line);
                if (st.hasMoreTokens()) {
                    st.nextToken();
                }
                if (st.hasMoreTokens()) {
                    mediaFileName = st.nextToken();
                }
                if (mediaFileName.startsWith("\"")) {
                    mediaFileName = mediaFileName.substring(1);
                }
                if (!mediaFileName.endsWith("\"")) continue;
                mediaFileName = mediaFileName.substring(0, mediaFileName.length() - 1);
            }
        }
        catch (FileNotFoundException fex) {
            fex.printStackTrace();
        }
        catch (IOException iex) {
            iex.printStackTrace();
        }
        return mediaFileName;
    }
}

