/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.webserviceclient.weblicht;

import java.io.IOException;
import java.util.HashMap;
import mpi.eudico.server.corpora.util.ServerLogger;
import mpi.eudico.webserviceclient.WsClientRest;

public class WebLichtWsClient {
    public static String baseUrl = "http://weblicht.sfs.uni-tuebingen.de/rws/";
    private String convertUrl = "convert-all/qp";
    private WsClientRest wsClient = new WsClientRest();

    public String convertPlainText(String text) {
        if (text == null || text.length() == 0) {
            return text;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("informat", "plaintext");
        params.put("outformat", "tcf04");
        params.put("language", "de");
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("Accept", "text/xml");
        properties.put("User-Agent", "ELAN");
        properties.put("Connection", "Keep-Alive");
        try {
            String result = this.wsClient.callServicePostMethodWithString(baseUrl + this.convertUrl, params, properties, text, null, null, 0.0f, 0.0f);
            return result;
        }
        catch (IOException ioe) {
            ServerLogger.LOG.warning("Call failed: " + ioe.getMessage());
            return null;
        }
    }

    public String callWithTCF(String toolUrl, String tcfString) {
        if (toolUrl == null || tcfString == null) {
            ServerLogger.LOG.warning("No url or input specified.");
            return null;
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("Accept", "text/xml");
        properties.put("User-Agent", "ELAN");
        properties.put("Connection", "Keep-Alive");
        try {
            String result = this.wsClient.callServicePostMethodWithString(baseUrl + toolUrl, null, properties, tcfString, null, null, 0.0f, 0.0f);
            return result;
        }
        catch (IOException ioe) {
            ServerLogger.LOG.warning("Call failed: " + ioe.getMessage());
            return null;
        }
    }
}

