/*
 * Decompiled with CFR 0.152.
 */
package mpi.search.content.query.model;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import mpi.search.content.query.model.Constraint;

public abstract class AbstractConstraint
implements Constraint {
    protected String mode = "Search.Constraint.Temporal";
    protected String quantifier = "Search.Constraint.Any";
    protected String[] tierNames = new String[0];
    private Constraint parent = null;
    private HashMap attributes;
    private String patternString = "";
    private String unit;
    private Vector children = new Vector();
    private boolean isCaseSensitive = false;
    private boolean isRegEx = false;
    private long lowerBoundary = Long.MIN_VALUE;
    private long upperBoundary = Long.MAX_VALUE;

    public AbstractConstraint() {
    }

    public AbstractConstraint(String[] tierNames, String patternString, long lowerBoundary, long upperBoundary, String unit, boolean isRegEx, boolean isCaseSensitive, HashMap attributes) {
        this.tierNames = tierNames;
        this.patternString = patternString;
        this.lowerBoundary = lowerBoundary;
        this.upperBoundary = upperBoundary;
        this.unit = unit;
        this.isRegEx = isRegEx;
        this.isCaseSensitive = isCaseSensitive;
        this.attributes = attributes;
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public void setAttributes(HashMap h) {
        this.attributes = h;
    }

    @Override
    public HashMap getAttributes() {
        return this.attributes;
    }

    @Override
    public void setCaseSensitive(boolean b) {
        this.isCaseSensitive = b;
    }

    @Override
    public boolean isCaseSensitive() {
        return this.isCaseSensitive;
    }

    @Override
    public TreeNode getChildAt(int i) {
        return (MutableTreeNode)this.children.get(i);
    }

    @Override
    public int getChildCount() {
        return this.children.size();
    }

    @Override
    public boolean isEditable() {
        return true;
    }

    @Override
    public String getId() {
        return this.parent != null ? this.parent.getId() + "." + this.parent.getIndex(this) : "C";
    }

    @Override
    public int getIndex(TreeNode node) {
        return this.children.indexOf(node);
    }

    @Override
    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    @Override
    public void setLowerBoundary(long l) {
        this.lowerBoundary = l;
    }

    @Override
    public long getLowerBoundary() {
        return this.lowerBoundary;
    }

    @Override
    public String getLowerBoundaryAsString() {
        return this.lowerBoundary == Long.MIN_VALUE ? "-X" : "" + this.lowerBoundary;
    }

    @Override
    public String getMode() {
        return this.mode;
    }

    @Override
    public void setParent(MutableTreeNode parent) {
        this.parent = (Constraint)parent;
    }

    @Override
    public TreeNode getParent() {
        return this.parent;
    }

    @Override
    public void setPattern(String s) {
        this.patternString = s;
    }

    @Override
    public String getPattern() {
        return this.patternString;
    }

    @Override
    public String getQuantifier() {
        return this.quantifier;
    }

    @Override
    public void setRegEx(boolean b) {
        this.isRegEx = b;
    }

    @Override
    public boolean isRegEx() {
        return this.isRegEx;
    }

    public void setTierName(String s) {
        this.tierNames = new String[]{s};
    }

    @Override
    public String getTierName() {
        return this.tierNames.length > 0 ? this.tierNames[0] : null;
    }

    @Override
    public void setTierNames(String[] s) {
        this.tierNames = s;
    }

    @Override
    public String[] getTierNames() {
        return this.tierNames;
    }

    @Override
    public void setUnit(String s) {
        this.unit = s;
    }

    @Override
    public String getUnit() {
        return this.unit;
    }

    @Override
    public void setUpperBoundary(long l) {
        this.upperBoundary = l;
    }

    @Override
    public long getUpperBoundary() {
        return this.upperBoundary;
    }

    @Override
    public String getUpperBoundaryAsString() {
        return this.upperBoundary == Long.MAX_VALUE ? "+X" : "" + this.upperBoundary;
    }

    @Override
    public void setUserObject(Object object) {
    }

    @Override
    public void addAttribute(String name, String value) {
        this.attributes.put(name, value);
    }

    public Enumeration children() {
        return this.children.elements();
    }

    @Override
    public Object clone() {
        AbstractConstraint newConstraint = null;
        try {
            newConstraint = (AbstractConstraint)super.clone();
            newConstraint.setTierNames(this.getTierNames());
            newConstraint.setPattern(this.getPattern());
            newConstraint.setCaseSensitive(this.isCaseSensitive());
            newConstraint.setRegEx(this.isRegEx());
            newConstraint.setUnit(this.getUnit());
            newConstraint.setLowerBoundary(this.getLowerBoundary());
            newConstraint.setUpperBoundary(this.getUpperBoundary());
            newConstraint.setAttributes(this.getAttributes());
            newConstraint.children = new Vector();
            newConstraint.parent = null;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return newConstraint;
    }

    public boolean equals(Object object) {
        if (!(object instanceof AbstractConstraint)) {
            return false;
        }
        AbstractConstraint constraint = (AbstractConstraint)object;
        if (constraint.isCaseSensitive() != this.isCaseSensitive()) {
            return false;
        }
        if (constraint.isRegEx() != this.isRegEx()) {
            return false;
        }
        if (!constraint.getPattern().equals(this.getPattern())) {
            return false;
        }
        if (constraint.getLowerBoundary() != this.getLowerBoundary()) {
            return false;
        }
        if (constraint.getUpperBoundary() != this.getUpperBoundary()) {
            return false;
        }
        if (constraint.getUnit() == null && this.getUnit() != null || constraint.getUnit() != null && !constraint.getUnit().equals(this.getUnit())) {
            return false;
        }
        return (constraint.getAttributes() != null || constraint.getAttributes() == null) && (constraint.getAttributes() == null || constraint.getAttributes().equals(this.getAttributes()));
    }

    @Override
    public void insert(MutableTreeNode child, int index) {
        this.children.insertElementAt(child, index);
        child.setParent(this);
    }

    @Override
    public void remove(int index) {
        MutableTreeNode child = (MutableTreeNode)this.children.get(index);
        this.children.remove(index);
        child.setParent(null);
    }

    @Override
    public void remove(MutableTreeNode node) {
        this.children.remove(node);
        node.setParent(null);
    }

    @Override
    public void removeFromParent() {
        if (this.parent != null) {
            this.parent.remove(this);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Quantifier:\t" + this.quantifier + "\n");
        for (int i = 0; i < this.tierNames.length; ++i) {
            sb.append("Tier name:\t" + this.tierNames[i] + "\n");
        }
        sb.append("Pattern:\t" + this.patternString + "\n");
        sb.append("Unit:\t" + this.unit + "\n");
        sb.append("Lower boundary:\t" + this.lowerBoundary + "\n");
        sb.append("Upper boundary:\t" + this.upperBoundary + "\n");
        return sb.toString();
    }
}

