/*
 * Decompiled with CFR 0.152.
 */
package mpi.search.content.query.model;

import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.TreeNode;
import mpi.search.content.model.CorpusType;
import mpi.search.content.query.model.AnchorConstraint;
import mpi.search.content.query.model.Constraint;
import mpi.search.content.query.model.RestrictedAnchorConstraint;
import mpi.search.content.result.model.ContentResult;
import mpi.search.query.model.Query;
import mpi.search.result.model.Result;

public class ContentQuery
extends Query {
    private final ContentResult result = new ContentResult();
    private AnchorConstraint anchorConstraint;
    private final CorpusType type;
    private final File[] files;

    public ContentQuery(AnchorConstraint rootConstraint, CorpusType type) {
        this(rootConstraint, type, null);
    }

    public ContentQuery(AnchorConstraint rootConstraint, CorpusType type, File[] files) {
        this.anchorConstraint = rootConstraint;
        this.type = type;
        this.files = files;
    }

    public final void setAnchorConstraint(AnchorConstraint rootConstraint) {
        this.anchorConstraint = rootConstraint;
    }

    public final AnchorConstraint getAnchorConstraint() {
        return this.anchorConstraint;
    }

    public final List getConstraints() {
        ArrayList constraintList = new ArrayList();
        this.addChildren(constraintList, this.anchorConstraint);
        return constraintList;
    }

    public File[] getFiles() {
        return this.files;
    }

    public final boolean isRestricted() {
        return this.anchorConstraint instanceof RestrictedAnchorConstraint;
    }

    @Override
    public Result getResult() {
        return this.result;
    }

    public final CorpusType getType() {
        return this.type;
    }

    public final boolean isWellSpecified() {
        boolean wellSpecified = true;
        List constraintList = this.getConstraints();
        for (int i = 0; i < constraintList.size(); ++i) {
            if (constraintList.get(i) == null || !((Constraint)constraintList.get(i)).isRegEx() || !((Constraint)constraintList.get(i)).getPattern().equals("")) continue;
            wellSpecified = false;
        }
        return wellSpecified;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ContentQuery)) {
            return false;
        }
        return ((Object)this.getConstraints()).equals(((ContentQuery)object).getConstraints());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        List constraintList = this.getConstraints();
        for (int i = 0; i < constraintList.size(); ++i) {
            sb.append(constraintList.get(i).toString());
        }
        return sb.toString();
    }

    private final void addChildren(List list, TreeNode node) {
        list.add(node);
        Enumeration<? extends TreeNode> e = node.children();
        while (e.hasMoreElements()) {
            this.addChildren(list, e.nextElement());
        }
    }
}

