/*
 * Decompiled with CFR 0.152.
 */
package mpi.search.content.query.viewer;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.tree.DefaultTreeModel;
import mpi.search.SearchLocale;
import mpi.search.content.model.CorpusType;
import mpi.search.content.query.model.Constraint;
import mpi.search.content.query.model.DependentConstraint;
import mpi.search.content.query.model.RestrictedAnchorConstraint;
import mpi.search.content.query.viewer.AttributeConstraintPanel;
import mpi.search.content.query.viewer.PatternPanel;
import mpi.search.content.query.viewer.RelationPanel;

public abstract class AbstractConstraintPanel
extends JPanel
implements ItemListener,
PopupMenuListener {
    protected static int tierComboBoxWidth = 0;
    protected final Action startAction;
    protected final CardLayout framedPanelLayout = new CardLayout();
    protected final Constraint constraint;
    protected final CorpusType type;
    protected final DefaultTreeModel treeModel;
    protected final JCheckBox caseCheckBox = new JCheckBox(SearchLocale.getString("Search.Constraint.CaseSensitive"), false);
    protected final JCheckBox regExCheckBox = new JCheckBox(SearchLocale.getString("Search.Constraint.RegularExpression"), false);
    protected AttributeConstraintPanel attributePanel;
    protected final JPanel framedPanel = new JPanel(this.framedPanelLayout);
    protected final JPanel optionPanel = new JPanel(new BorderLayout());
    protected JComboBox tierComboBox;
    protected List<String> selectedTiers;
    protected JPanel titleComponent = new JPanel(new FlowLayout(0, 5, 1));
    protected PatternPanel patternPanel;
    protected RelationPanel relationPanel;
    protected final Border blueBorder = new CompoundBorder(new EmptyBorder(1, 0, 1, 0), new CompoundBorder(new LineBorder(Color.BLUE), new EmptyBorder(0, 3, 0, 0)));

    public AbstractConstraintPanel(Constraint constraint, DefaultTreeModel treeModel, CorpusType type, Action startAction) {
        this.type = type;
        this.constraint = constraint;
        this.treeModel = treeModel;
        this.startAction = startAction;
    }

    public void setConstraint(Constraint c) {
        this.setRegEx(c.isRegEx());
        this.setCaseSensitive(c.isCaseSensitive());
        this.setPattern(c.getPattern());
        this.relationPanel.setLowerBoundary(c.getLowerBoundary());
        this.relationPanel.setUpperBoundary(c.getUpperBoundary());
        this.relationPanel.setUnit(c.getUnit());
    }

    public boolean isRegEx() {
        return this.regExCheckBox.isSelected();
    }

    public String getTierName() {
        return this.getTierNames()[0];
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1 && e.getSource() == this.tierComboBox) {
            boolean caseSensitiveFixed;
            if (e.getItem() != "Search.Constraint.CustomTiers" && this.selectedTiers != null) {
                this.selectedTiers.clear();
            }
            if (this.type.isClosedVoc((String)e.getItem())) {
                this.regExCheckBox.setEnabled(false);
                this.setRegEx(false);
                this.setCaseSensitive(false);
                if (this.type.getClosedVoc((String)e.getItem()).isEmpty()) {
                    this.startAction.setEnabled(false);
                } else {
                    this.startAction.setEnabled(true);
                }
            } else {
                this.startAction.setEnabled(true);
                this.regExCheckBox.setEnabled(true);
            }
            if (this.type.strictCaseSensitive((String)e.getItem())) {
                this.setCaseSensitive(true);
            }
            boolean bl = caseSensitiveFixed = this.type.isClosedVoc((String)e.getItem()) || this.type.strictCaseSensitive((String)e.getItem());
            if (!caseSensitiveFixed && !this.caseCheckBox.isEnabled()) {
                this.setCaseSensitive(false);
            }
            this.caseCheckBox.setEnabled(!caseSensitiveFixed);
            if (this.attributePanel != null) {
                this.attributePanel.setTier((String)e.getItem());
            }
        }
    }

    @Override
    public String toString() {
        String s = super.toString();
        return s;
    }

    protected HashMap getAttributes() {
        HashMap<String, String> attributes = new HashMap<String, String>();
        if (this.attributePanel != null) {
            String[] attributeNames = this.type.getAttributeNames(this.getTierName());
            for (int i = 0; i < attributeNames.length; ++i) {
                attributes.put(attributeNames[i], this.attributePanel.getAttributeValue(attributeNames[i]));
            }
        }
        return attributes;
    }

    protected void setCaseSensitive(boolean sensitiv) {
        this.caseCheckBox.setSelected(sensitiv);
    }

    protected boolean isCaseSensitive() {
        return this.caseCheckBox.isSelected();
    }

    protected Constraint getConstraint() {
        this.updateNode();
        return this.constraint;
    }

    protected void setPattern(String pattern) {
        this.patternPanel.setPattern(pattern);
    }

    protected String getPattern() {
        return this.patternPanel.getPattern();
    }

    protected void setRegEx(boolean regEx) {
        this.regExCheckBox.setSelected(regEx);
    }

    protected void setTierName(String tierName) {
        this.tierComboBox.setSelectedItem(tierName);
    }

    protected String[] getTierNames() {
        if (this.selectedTiers != null && this.selectedTiers.size() > 0) {
            return this.selectedTiers.toArray(new String[0]);
        }
        Object[] selectedObjects = this.tierComboBox.getSelectedObjects();
        if (selectedObjects == null || selectedObjects.length == 0) {
            return new String[]{"Search.Constraint.AllTiers"};
        }
        String[] tierNames = new String[selectedObjects.length];
        for (int i = 0; i < selectedObjects.length; ++i) {
            tierNames[i] = (String)selectedObjects[i];
        }
        return tierNames;
    }

    protected void makeLayout() {
        this.patternPanel = new PatternPanel(this.type, this.tierComboBox, this.regExCheckBox, this.constraint, this.startAction);
        this.relationPanel = new RelationPanel(this.type, this.constraint);
        JPanel checkBoxPanel = new JPanel(new GridLayout(2, 1));
        this.regExCheckBox.setFont(this.getFont().deriveFont(0, 9.0f));
        this.caseCheckBox.setFont(this.getFont().deriveFont(0, 9.0f));
        checkBoxPanel.add(this.regExCheckBox);
        checkBoxPanel.add(this.caseCheckBox);
        this.optionPanel.add((Component)checkBoxPanel, "West");
        JPanel inputPanel = new JPanel(new GridLayout(2, 1, 0, 1));
        inputPanel.add(this.patternPanel);
        inputPanel.add(this.relationPanel);
        if (this.type.hasAttributes()) {
            this.attributePanel = new AttributeConstraintPanel(this.type);
            this.optionPanel.add((Component)this.attributePanel, "Center");
            this.attributePanel.setTier(this.getTierName());
        }
        JPanel specificationPanel = new JPanel(new FlowLayout(0, 0, 1));
        specificationPanel.add(inputPanel);
        specificationPanel.add(this.optionPanel);
        this.framedPanel.add((Component)specificationPanel, "");
        this.framedPanel.setBorder(this.blueBorder);
        this.framedPanelLayout.show(this.framedPanel, "");
        this.setLayout(new BorderLayout());
        this.add((Component)this.titleComponent, "North");
        this.add((Component)this.framedPanel, "Center");
        this.tierComboBox.addItemListener(this);
        JPanel buttonPanel = new JPanel(new FlowLayout(0, 5, 1));
        AbstractAction addConstraintAction = new AbstractAction(SearchLocale.getString("Search.Query.Add")){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractConstraintPanel.this.addConstraint();
            }
        };
        KeyStroke ks = KeyStroke.getKeyStroke(65, 2);
        addConstraintAction.putValue("AcceleratorKey", ks);
        JButton addButton = new JButton(addConstraintAction);
        addButton.setFont(this.getFont().deriveFont(11.0f));
        buttonPanel.add(addButton);
        if (this.constraint.getParent() != null && !(this.constraint.getParent() instanceof RestrictedAnchorConstraint)) {
            AbstractAction deleteConstraintAction = new AbstractAction(SearchLocale.getString("Search.Query.Delete")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AbstractConstraintPanel.this.deleteConstraint();
                }
            };
            ks = KeyStroke.getKeyStroke(68, 2);
            deleteConstraintAction.putValue("AcceleratorKey", ks);
            JButton deleteButton = new JButton(deleteConstraintAction);
            deleteButton.setFont(this.getFont().deriveFont(11.0f));
            buttonPanel.add(deleteButton);
        }
        this.add((Component)buttonPanel, "South");
        try {
            Class popupMenu = this.type.getInputMethodClass();
            popupMenu.getConstructor(Component.class, AbstractConstraintPanel.class).newInstance(this.patternPanel.getDefaultInputComponent(), this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected static void updateComboBox(JComboBox comboBox, String[] units) {
        int i;
        if (units.length == comboBox.getItemCount()) {
            boolean equal = true;
            for (i = 0; i < units.length; ++i) {
                if (units[i].equals(comboBox.getItemAt(i))) continue;
                equal = false;
                break;
            }
            if (equal) {
                return;
            }
        }
        Object oldItem = comboBox.getSelectedItem();
        comboBox.removeAllItems();
        for (i = 0; i < units.length; ++i) {
            comboBox.addItem(units[i]);
        }
        comboBox.setSelectedItem(oldItem);
        if (comboBox.getSelectedItem() == null) {
            comboBox.setSelectedIndex(0);
        }
    }

    protected void updateNode() {
        try {
            this.constraint.setTierNames(this.getTierNames());
            this.constraint.setPattern(this.getPattern());
            this.constraint.setLowerBoundary(this.relationPanel.getLowerBoundary());
            this.constraint.setUpperBoundary(this.relationPanel.getUpperBoundary());
            this.constraint.setUnit(this.relationPanel.getUnit());
            this.constraint.setRegEx(this.isRegEx());
            this.constraint.setCaseSensitive(this.isCaseSensitive());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void addConstraint() {
        this.treeModel.insertNodeInto(new DependentConstraint(this.getTierNames()), this.constraint, this.constraint.getChildCount());
    }

    protected void deleteConstraint() {
        this.treeModel.removeNodeFromParent(this.constraint);
    }

    protected void selectCustomTierSet() {
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        if (e.getSource() == this.tierComboBox && this.tierComboBox.getSelectedItem() == "Search.Constraint.CustomTiers") {
            SwingUtilities.invokeLater(new Thread(new Runnable(){

                @Override
                public void run() {
                    AbstractConstraintPanel.this.selectCustomTierSet();
                }
            }));
        }
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
    }
}

