/*
 * Decompiled with CFR 0.152.
 */
package mpi.search.content.viewer;

import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import mpi.eudico.client.annotator.gui.HTMLViewer;
import mpi.search.SearchLocale;
import mpi.search.content.viewer.AbstractComplexSearchPanel;

public class AbstractComplexSearchFrame
extends JFrame {
    private Action helpAction;
    protected final AbstractComplexSearchPanel searchPanel;

    public AbstractComplexSearchFrame(AbstractComplexSearchPanel searchPanel) {
        super(SearchLocale.getString("SearchDialog.Title"));
        this.searchPanel = searchPanel;
        this.getContentPane().add(searchPanel);
        this.createMenuBar();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                AbstractComplexSearchFrame.this.searchPanel.stopSearch();
            }
        });
    }

    private void createMenuBar() {
        this.helpAction = new AbstractAction(SearchLocale.getString("Action.Help")){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractComplexSearchFrame.this.showInfoDialog();
            }
        };
        this.helpAction.putValue("ShortDescription", SearchLocale.getString("Action.Tooltip.Help"));
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu(SearchLocale.getString("SearchDialog.File"));
        fileMenu.add(this.searchPanel.getCloseAction());
        menuBar.add(fileMenu);
        JMenu queryMenu = new JMenu(SearchLocale.getString("SearchDialog.Query"));
        queryMenu.add(this.searchPanel.getStartAction());
        queryMenu.add(this.searchPanel.zoomAction);
        queryMenu.addSeparator();
        queryMenu.add(this.searchPanel.saveAction);
        queryMenu.add(this.searchPanel.readAction);
        queryMenu.add(this.searchPanel.getExportAction());
        menuBar.add(queryMenu);
        JMenu helpMenu = new JMenu(SearchLocale.getString("SearchDialog.Help"));
        helpMenu.add(this.helpAction);
        menuBar.add(helpMenu);
        this.setJMenuBar(menuBar);
    }

    private void showInfoDialog() {
        try {
            HTMLViewer viewer = new HTMLViewer("/mpi/eudico/client/annotator/resources/SearchHelp.html", false, "Search Info");
            JDialog infoDialog = viewer.createHTMLDialog(this);
            infoDialog.pack();
            infoDialog.setSize(600, 400);
            infoDialog.setVisible(true);
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(this, "Unable to load the Search help file " + ioe.getMessage(), "Warning", 2, null);
        }
    }
}

