/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.jmmf;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import nl.mpi.jmmf.JMMFPlayer;

public class JMMFCanvas
extends Canvas
implements ComponentListener,
HierarchyListener {
    JMMFPlayer player;

    public JMMFCanvas() {
    }

    public JMMFCanvas(JMMFPlayer player) {
        this.player = player;
        this.setBackground(Color.GREEN);
        super.setIgnoreRepaint(true);
        this.addComponentListener(this);
        this.addHierarchyListener(this);
    }

    public JMMFCanvas(GraphicsConfiguration gc) {
        super(gc);
    }

    public void setPlayer(JMMFPlayer player) {
        this.player = player;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        System.out.println("Panel add notify...");
        if (this.player != null && this.isDisplayable()) {
            this.player.setVisualComponent(this);
            this.player.setVisible(true);
            this.player.repaintVideo();
        }
    }

    @Override
    public void removeNotify() {
        if (this.player != null) {
            // empty if block
        }
        super.removeNotify();
    }

    @Override
    public void componentHidden(ComponentEvent ce) {
        if (this.player != null) {
            this.player.setVisible(false);
        }
    }

    @Override
    public void componentMoved(ComponentEvent ce) {
        this.componentResized(ce);
        this.player.repaintVideo();
    }

    @Override
    public void componentResized(ComponentEvent ce) {
        if (this.player != null && this.isDisplayable()) {
            this.player.setVisualComponentSize(this.getWidth(), this.getHeight());
            this.player.repaintVideo();
        }
    }

    @Override
    public void componentShown(ComponentEvent ce) {
        this.componentResized(ce);
        this.player.repaintVideo();
    }

    @Override
    public void hierarchyChanged(HierarchyEvent e) {
        if (e.getChangeFlags() == 2L && this.isDisplayable() && this.player != null) {
            this.player.setVisualComponent(this);
            this.player.setVisible(true);
            this.player.repaintVideo();
        }
    }

    @Override
    public void repaint() {
        if (this.player != null) {
            this.player.repaintVideo();
        }
    }

    @Override
    public void paint(Graphics g) {
        if (this.player != null) {
            this.player.repaintVideo();
        }
    }

    @Override
    public void update(Graphics g) {
        if (this.player != null) {
            this.player.repaintVideo();
        }
    }
}

