/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.swing.gvt;

import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import org.apache.batik.swing.gvt.InteractorAdapter;
import org.apache.batik.swing.gvt.JGVTComponent;

public abstract class AbstractPanInteractor
extends InteractorAdapter {
    public static final Cursor PAN_CURSOR = new Cursor(13);
    protected boolean finished = true;
    protected int xStart;
    protected int yStart;
    protected int xCurrent;
    protected int yCurrent;
    protected Cursor previousCursor;

    public boolean endInteraction() {
        return this.finished;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (!this.finished) {
            this.mouseExited(mouseEvent);
            return;
        }
        this.finished = false;
        this.xStart = mouseEvent.getX();
        this.yStart = mouseEvent.getY();
        JGVTComponent jGVTComponent = (JGVTComponent)mouseEvent.getSource();
        this.previousCursor = jGVTComponent.getCursor();
        jGVTComponent.setCursor(PAN_CURSOR);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.finished = true;
        JGVTComponent jGVTComponent = (JGVTComponent)mouseEvent.getSource();
        AffineTransform affineTransform = jGVTComponent.getPaintingTransform();
        if (affineTransform != null) {
            AffineTransform affineTransform2 = (AffineTransform)jGVTComponent.getRenderingTransform().clone();
            affineTransform2.preConcatenate(affineTransform);
            jGVTComponent.setRenderingTransform(affineTransform2);
        }
        if (jGVTComponent.getCursor() == PAN_CURSOR) {
            jGVTComponent.setCursor(this.previousCursor);
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.finished = true;
        JGVTComponent jGVTComponent = (JGVTComponent)mouseEvent.getSource();
        jGVTComponent.setPaintingTransform(null);
        if (jGVTComponent.getCursor() == PAN_CURSOR) {
            jGVTComponent.setCursor(this.previousCursor);
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        JGVTComponent jGVTComponent = (JGVTComponent)mouseEvent.getSource();
        this.xCurrent = mouseEvent.getX();
        this.yCurrent = mouseEvent.getY();
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(this.xCurrent - this.xStart, this.yCurrent - this.yStart);
        jGVTComponent.setPaintingTransform(affineTransform);
    }
}

