/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.annot.search.mfsearch;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import javax.swing.JCheckBox;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import mpi.eudico.client.annotator.export.ExportTabCustomizePanel;
import nl.mpi.annot.search.mfsearch.ExportResultStatsDialog;
import nl.mpi.annot.search.mfsearch.SearchMediator;

public class ExportHitsOptionsDialog
extends ExportResultStatsDialog {
    private ExportTabCustomizePanel custPanel;
    private TitledBorder columnBorder;
    private JCheckBox multiRowCB;
    private final boolean _complex;

    public ExportHitsOptionsDialog(Frame owner, ResourceBundle bundle, SearchMediator mediator, boolean complex) throws HeadlessException {
        super(owner, bundle, mediator);
        this._complex = complex;
        this.updateComplexity();
    }

    public ExportHitsOptionsDialog(Dialog owner, ResourceBundle bundle, SearchMediator mediator, boolean complex) throws HeadlessException {
        super(owner, bundle, mediator);
        this._complex = complex;
        this.updateComplexity();
    }

    @Override
    protected void initComponents() {
        String multiRowPref;
        super.initComponents();
        this.columnBorder = new TitledBorder("");
        this.multiRowCB = new JCheckBox();
        String string = multiRowPref = this.mediator == null ? null : this.mediator.getPersistent("MFSearchResultComplex.ExportMultipleRowsPerHit");
        if (multiRowPref != null) {
            this.multiRowCB.setSelected(Boolean.valueOf(multiRowPref));
        }
        Insets insets = new Insets(2, 6, 2, 6);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = insets;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.panel.add((Component)this.multiRowCB, gridBagConstraints);
    }

    @Override
    protected void postInit() {
        this.pack();
        int w = 640;
        if (this.getParent() != null && this.getParent().getWidth() > w) {
            w = this.getParent().getWidth() - 10;
        }
        this.setSize(this.getSize().width < w ? w : this.getSize().width, this.getSize().height);
        this.setLocationRelativeTo(this.getParent());
    }

    private void updateComplexity() {
        String storedSortedColumns;
        this.multiRowCB.setVisible(this._complex);
        this.distinguishHitsCB.setVisible(!this._complex);
        String[] headers = (this._complex ? "Annotation,HitPositionInTier,BeginTime,EndTime,Duration,TranscriptionName" : "Annotation,HitPositionInAnnotation,HitLength,HitNumberInAnnotation,AnnotationBeginTime,AnnotationEndTime,AnnotationDuration,HitPositionInTier,TierName,TierType,TierParticipant,TierAnnotator,LeftContext,RightContext,TranscriptionName").split(",");
        String string = this.mediator == null ? null : (storedSortedColumns = this.mediator.getPersistent("MFSearchResult" + (this._complex ? "Complex" : "") + ".ExportColumnOrder"));
        if (storedSortedColumns != null) {
            if (!this._complex && headers.length > 11) {
                if (!storedSortedColumns.contains(headers[10])) {
                    storedSortedColumns = storedSortedColumns + "," + headers[10];
                }
                if (!storedSortedColumns.contains(headers[11])) {
                    storedSortedColumns = storedSortedColumns + "," + headers[11];
                }
            }
            headers = storedSortedColumns.split(",");
        }
        String storedIncluded = this.mediator == null ? null : this.mediator.getPersistent("MFSearchResult" + (this._complex ? "Complex" : "") + ".ExportColumnIncluded");
        int[] incCols = null;
        if (storedIncluded != null) {
            String[] colInd = storedIncluded.split(",");
            incCols = new int[colInd.length];
            for (int i = 0; i < colInd.length; ++i) {
                try {
                    incCols[i] = Integer.parseInt(colInd[i]);
                    if (incCols[i] >= 0 && incCols[i] < headers.length) continue;
                    incCols[i] = 0;
                    continue;
                }
                catch (NumberFormatException nfe) {
                    incCols[i] = 0;
                }
            }
        } else {
            incCols = new int[headers.length];
            for (int i = 0; i < incCols.length; ++i) {
                incCols[i] = i;
            }
        }
        this.getContentPane().remove(this.buttonPanel);
        if (this.custPanel != null) {
            this.getContentPane().remove((Component)this.custPanel);
        }
        this.custPanel = new ExportTabCustomizePanel(headers, incCols);
        this.custPanel.setBorder((Border)this.columnBorder);
        this.custPanel.setPreferredSize(new Dimension(550, 80));
        Insets insets = new Insets(2, 6, 2, 6);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = insets;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.getContentPane().add((Component)this.custPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = insets;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.getContentPane().add((Component)this.buttonPanel, gridBagConstraints);
        this.postInit();
    }

    @Override
    public void updateLocale() {
        super.updateLocale();
        if (this.columnBorder != null) {
            this.columnBorder.setTitle("Select and order columns");
        }
        if (this.multiRowCB != null) {
            this.multiRowCB.setText("Export multiple rows per hit");
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.mediator != null && this.custPanel != null) {
            String[] heads = this.custPanel.getColumnOrder();
            int[] selectInd = this.custPanel.getSelectedColumnIndices();
            if (heads != null) {
                int i;
                StringBuilder sb = new StringBuilder();
                for (i = 0; i < heads.length; ++i) {
                    sb.append(heads[i]);
                    if (i == heads.length - 1) continue;
                    sb.append(',');
                }
                this.mediator.putPersistent("MFSearchResult" + (this._complex ? "Complex" : "") + ".ExportColumnOrder", sb.toString());
                sb = new StringBuilder();
                for (i = 0; i < selectInd.length; ++i) {
                    sb.append(selectInd[i]);
                    if (i == selectInd.length - 1) continue;
                    sb.append(',');
                }
                this.mediator.putPersistent("MFSearchResult" + (this._complex ? "Complex" : "") + ".ExportColumnIncluded", sb.toString());
            }
        }
        if (this.mediator != null && this.multiRowCB != null && this._complex) {
            this.mediator.putPersistent("MFSearchResultComplex.ExportMultipleRowsPerHit", String.valueOf(this.multiRowCB.isSelected()));
        }
        super.actionPerformed(e);
    }
}

