/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.annot.search.mfsearch;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import nl.mpi.annot.search.mfsearch.SearchListener;
import nl.mpi.annot.search.mfsearch.SearchMediator;
import nl.mpi.annot.search.mfsearch.SwingSearchFonts;

public final class SearchDomainPanel
extends JPanel
implements ItemListener,
ActionListener,
Runnable {
    private SearchMediator mediator;
    private String queryId;
    private JPanel domainNamePanel;
    private JPanel domainTypePanel;
    private JLabel domainLabel;
    private JProgressBar progressBar;
    private Color backgroundColor;
    private JButton domainButton;
    private JLabel nEafLabel;
    private String domainTypes;
    private int nEaf;
    private int nChat;
    private int nShoebox;
    private int nPlainText;
    private int nXmlText;
    private int nHtmlText;
    private JCheckBox checkEaf;
    private JCheckBox checkChat;
    private JCheckBox checkShoebox;
    private JCheckBox checkText;
    private JCheckBox checkXml;
    private JCheckBox checkHtml;
    private ArrayList domainInfo;
    private SearchListener searchListener;

    public SearchDomainPanel(SearchMediator mediator, String queryId, SearchListener searchListener) {
        this.mediator = mediator;
        this.queryId = queryId;
        this.searchListener = searchListener;
        mediator.addDomainPanel(queryId, this);
        this.setLayout(new BoxLayout(this, 1));
        this.backgroundColor = mediator.getBackgroundColor();
        this.setBackground(this.backgroundColor);
        this.add(Box.createVerticalStrut(5));
        this.domainNamePanel = new JPanel();
        this.domainNamePanel.setBackground(this.backgroundColor);
        this.domainNamePanel.setLayout(new BoxLayout(this.domainNamePanel, 0));
        this.domainNamePanel.add(Box.createHorizontalStrut(5));
        this.domainLabel = new JLabel("Domain: ");
        this.domainLabel.setFont(SwingSearchFonts.bigBoldFont);
        this.domainNamePanel.add(this.domainLabel);
        this.add(this.domainNamePanel);
        this.nEafLabel = new JLabel();
        this.nEafLabel.setFont(SwingSearchFonts.normalFont);
        this.domainNamePanel.add(this.nEafLabel);
        this.domainNamePanel.add(Box.createHorizontalGlue());
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setStringPainted(true);
        this.progressBar.setString("Initializing");
        this.progressBar.setVisible(true);
        this.domainNamePanel.add(this.progressBar);
        this.domainNamePanel.add(Box.createHorizontalStrut(20));
        this.domainButton = new JButton("Define Domain");
        this.domainButton.addActionListener(this);
        this.domainButton.setEnabled(false);
        this.domainNamePanel.add(this.domainButton);
        this.domainNamePanel.add(Box.createHorizontalStrut(30));
        new Thread(this).start();
    }

    @Override
    public void run() {
        while (this.mediator.getDomainInitializationProgress(this.queryId) < 1.0f) {
            int pBarValue = (int)(this.mediator.getDomainInitializationProgress(this.queryId) * (float)this.progressBar.getMaximum());
            this.progressBar.setValue(pBarValue);
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.nEafLabel.setText(this.mediator.getDomainSize(this.queryId) + " eaf files");
        this.domainButton.setEnabled(true);
        this.progressBar.setVisible(false);
        if (this.searchListener != null) {
            this.searchListener.domainChanged();
        }
        this.mediator.checkForDomainErrors(this.queryId);
        this.validate();
    }

    public void newDomainFromOtherPanel() {
        this.domainButton.setEnabled(false);
        this.progressBar.setVisible(true);
        new Thread(this).start();
    }

    private JCheckBox addTypeInfo(JCheckBox checkBox, String label, int size) {
        if (size <= 0) {
            return null;
        }
        checkBox = new JCheckBox(label);
        checkBox.setBackground(this.backgroundColor);
        String nTypeFiles = Integer.toString(size) + "  ";
        JLabel typeSize = new JLabel(nTypeFiles);
        typeSize.setFont(SwingSearchFonts.smallFont);
        checkBox.setSelected(true);
        checkBox.addItemListener(this);
        this.domainTypePanel.add(checkBox);
        this.domainTypePanel.add(typeSize);
        return checkBox;
    }

    public int getDomainLabelWidth() {
        return this.getStringWidth(this.domainLabel.getText(), this.domainLabel.getFont());
    }

    private int getStringWidth(String str, Font fnt) {
        FontRenderContext frc = new FontRenderContext(new AffineTransform(), false, false);
        Rectangle2D rect = fnt.getStringBounds(str, frc);
        return (int)rect.getWidth();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.domainTypes = "";
        if (this.checkEaf != null && this.checkEaf.isSelected()) {
            this.domainTypes = this.domainTypes + "-eaf-";
        }
        if (this.checkChat != null && this.checkChat.isSelected()) {
            this.domainTypes = this.domainTypes + "-chat-";
        }
        if (this.checkShoebox != null && this.checkShoebox.isSelected()) {
            this.domainTypes = this.domainTypes + "-shoebox-";
        }
        if (this.checkText != null && this.checkText.isSelected()) {
            this.domainTypes = this.domainTypes + "-plaintext-";
        }
        if (this.checkXml != null && this.checkXml.isSelected()) {
            this.domainTypes = this.domainTypes + "-xmltext-";
        }
        if (this.checkHtml != null && this.checkHtml.isSelected()) {
            this.domainTypes = this.domainTypes + "-htmltext-";
        }
        this.mediator.setQueryDomain(this.domainTypes, this.queryId);
        if (e != null) {
            this.searchListener.domainChanged();
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.domainButton) {
            this.mediator.setQueryDomain(this.domainTypes, this.queryId);
            this.domainButton.setEnabled(false);
            this.progressBar.setVisible(true);
            new Thread(this).start();
        }
    }
}

