/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.annot.search.mfsearch;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.event.MouseInputAdapter;
import mpi.eudico.client.annotator.gui.JFontChooser;
import nl.mpi.annot.search.lib.FrequencyInfo;
import nl.mpi.annot.search.lib.SearchHit;
import nl.mpi.annot.search.lib.SearchStatistics;
import nl.mpi.annot.search.mfsearch.ExportHitsOptionsDialog;
import nl.mpi.annot.search.mfsearch.ExportResultStatsDialog;
import nl.mpi.annot.search.mfsearch.SaverAllHits;
import nl.mpi.annot.search.mfsearch.SaverFrequencyInfo;
import nl.mpi.annot.search.mfsearch.SaverHitStatistics;
import nl.mpi.annot.search.mfsearch.SaverInterface;
import nl.mpi.annot.search.mfsearch.SearchMediator;
import nl.mpi.annot.search.mfsearch.SearchUtil;
import nl.mpi.annot.search.mfsearch.SwingSearchFonts;

public class SearchResultPanel
extends JPanel
implements ActionListener {
    private SearchMediator mediator;
    private String queryId;
    public static final int POLLING_INTERVAL = 500;
    public static final int CONCORDANCE_MODE = 0;
    public static final int FREQUENCY_MODE = 1;
    public static final int FREQUENCY_BY_COUNT_MODE = 2;
    private static final int N_EMPTY_HIT_LINES = 1;
    private static final int MAX_VISIBLE_HITS_PER_SCREEN = 100;
    private static final int HIT_DISPLAY_Y = 35;
    private int HIT_HEIGHT;
    private MouseListener mouseListener;
    private Timer pollTimer;
    private Dimension dimension;
    private JProgressBar progressBar;
    private JLabel hitStatsLabel;
    private JButton cancelButton;
    private JButton nextButton;
    private JButton prevButton;
    private JMenu _contextSizeMenu;
    private JPopupMenu concordancePopup;
    private JPopupMenu frequencyPopup;
    private JMenuItem chooseFontMenuItem;
    private JMenuItem infoBalloonToggleMenuItem;
    private JMenuItem showHitMenuItem;
    private JMenuItem concordanceDisplayModeItem;
    private JMenuItem frequencyDisplayModeItem;
    private JMenuItem frequencyDisplayModeItemByFreq;
    private JMenuItem saveHitsMenuItem;
    private JMenuItem saveHitsStatisticsMenuItem;
    private JMenuItem saveFrequencyInfoMenuItem;
    private JMenuItem showSampleHitMenuItem;
    private JPanel hitPanel;
    private JLabel[] hitLabelsLeftContext;
    private JLabel[] prefixLabels;
    private JLabel[] hitLabels;
    private JLabel[] postfixLabels;
    private JLabel[] hitLabelsRightContext;
    private JLabel[] headerLabel;
    private JLabel hitNrLabel;
    private DelayedNewLayout delayedNewLayout;
    private HashMap<Component, Object> labelToHit;
    private int hitContextSize;
    private int nrOfVisibleHits;
    private int nHitsPrev;
    private boolean tooltipVisible;
    private SaverInterface currentSaver = null;
    private File lastSavedFile;
    private Object activeHit;
    private boolean simpleQueryMode = false;
    private int resultMode;
    private int firstVisibleHitIndex;
    private int lastVisibleHitIndex;
    private int firstVisibleFrequencyInfoIndex;
    private int lastVisibleFrequencyInfoIndex;

    public SearchResultPanel(SearchMediator mediator, String queryId) {
        int i;
        this.mediator = mediator;
        this.queryId = queryId;
        this.pollTimer = new Timer(500, this);
        mediator.addResultPanel(queryId, this);
        this.setLayout(new BoxLayout(this, 1));
        this.setBackground(mediator.getBackgroundColor());
        this.mouseListener = new MouseHandler();
        JPanel progressPanel = new JPanel();
        progressPanel.setLayout(new BoxLayout(progressPanel, 0));
        progressPanel.add(Box.createHorizontalStrut(30));
        this.hitStatsLabel = new JLabel("Found 0 hits in 0 annotations (of 0)");
        this.hitStatsLabel.setFont(SwingSearchFonts.normalFont);
        progressPanel.add(this.hitStatsLabel);
        progressPanel.add(Box.createHorizontalStrut(10));
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setStringPainted(true);
        this.progressBar.setString("");
        this.progressBar.setSize(150, 20);
        this.progressBar.setVisible(true);
        progressPanel.add(this.progressBar);
        progressPanel.add(Box.createHorizontalStrut(10));
        this.cancelButton = new JButton("Cancel");
        if (System.getProperty("os.name").toUpperCase().contains("MAC")) {
            this.cancelButton.setBackground(mediator.getBackgroundColor());
        }
        this.cancelButton.addActionListener(this);
        progressPanel.add(this.cancelButton);
        this.cancelButton.setVisible(true);
        this.cancelButton.setEnabled(false);
        progressPanel.add(Box.createHorizontalStrut(30));
        progressPanel.setMaximumSize(new Dimension(4000, 30));
        this.add(progressPanel);
        this.hitPanel = new JPanel();
        this.hitPanel.setBackground(mediator.getBackgroundColor());
        this.hitPanel.setLayout(null);
        this.hitPanel.addMouseListener(this.mouseListener);
        this.prevButton = new JButton("<");
        if (System.getProperty("os.name").toUpperCase().contains("MAC")) {
            this.prevButton.setBackground(mediator.getBackgroundColor());
        }
        this.prevButton.setBounds(0, 0, 0, 0);
        this.prevButton.addActionListener(this);
        this.prevButton.setVisible(false);
        this.hitPanel.add(this.prevButton);
        this.nextButton = new JButton(">");
        if (System.getProperty("os.name").toUpperCase().contains("MAC")) {
            this.nextButton.setBackground(mediator.getBackgroundColor());
        }
        this.nextButton.setBounds(0, 0, 0, 0);
        this.nextButton.addActionListener(this);
        this.nextButton.setVisible(false);
        this.hitPanel.add(this.nextButton);
        this.hitNrLabel = new JLabel();
        this.hitNrLabel.setFont(SwingSearchFonts.normalFont);
        this.hitNrLabel.setBounds(0, 0, 0, 0);
        this.hitNrLabel.setVisible(true);
        this.hitPanel.add(this.hitNrLabel);
        this.labelToHit = new HashMap();
        this.hitLabels = new JLabel[100];
        this.hitLabelsLeftContext = new JLabel[100];
        this.hitLabelsRightContext = new JLabel[100];
        this.prefixLabels = new JLabel[100];
        this.postfixLabels = new JLabel[100];
        for (i = 0; i < 100; ++i) {
            JLabel hitLabel = new JLabel();
            hitLabel.setFont(SwingSearchFonts.hitFont);
            hitLabel.setVisible(true);
            hitLabel.addMouseListener(this.mouseListener);
            this.hitPanel.add(hitLabel);
            this.hitLabels[i] = hitLabel;
            JLabel prefix = new JLabel();
            prefix.setFont(SwingSearchFonts.normalFont);
            prefix.setVisible(true);
            prefix.addMouseListener(this.mouseListener);
            this.hitPanel.add(prefix);
            this.prefixLabels[i] = prefix;
            JLabel postfix = new JLabel();
            postfix.setFont(SwingSearchFonts.normalFont);
            postfix.setVisible(true);
            postfix.addMouseListener(this.mouseListener);
            this.hitPanel.add(postfix);
            this.postfixLabels[i] = postfix;
            JLabel hitLabelBefore = new JLabel();
            hitLabelBefore.setFont(SwingSearchFonts.italicFont);
            hitLabelBefore.setVisible(true);
            hitLabelBefore.addMouseListener(this.mouseListener);
            this.hitPanel.add(hitLabelBefore);
            this.hitLabelsLeftContext[i] = hitLabelBefore;
            JLabel hitLabelAfter = new JLabel();
            hitLabelAfter.setFont(SwingSearchFonts.italicFont);
            hitLabelAfter.setVisible(true);
            hitLabelAfter.addMouseListener(this.mouseListener);
            this.hitPanel.add(hitLabelAfter);
            this.hitLabelsRightContext[i] = hitLabelAfter;
        }
        this.headerLabel = new JLabel[20];
        for (i = 0; i < this.headerLabel.length; ++i) {
            this.headerLabel[i] = new JLabel();
            this.headerLabel[i].setFont(SwingSearchFonts.bigBoldFont);
            this.headerLabel[i].setVisible(true);
            this.hitPanel.add(this.headerLabel[i]);
        }
        this.add(this.hitPanel);
        this.concordancePopup = new JPopupMenu();
        this.frequencyDisplayModeItem = new JMenuItem("  Show Frequency view");
        this.frequencyDisplayModeItem.addActionListener(this);
        this.concordancePopup.add(this.frequencyDisplayModeItem);
        this.frequencyDisplayModeItemByFreq = new JMenuItem("  Show Frequency view (by frequency)");
        this.frequencyDisplayModeItemByFreq.addActionListener(this);
        this.concordancePopup.add(this.frequencyDisplayModeItemByFreq);
        this.concordancePopup.addSeparator();
        this.showHitMenuItem = new JMenuItem("  Show hit in transcription");
        this.showHitMenuItem.addActionListener(this);
        this.concordancePopup.add(this.showHitMenuItem);
        this.tooltipVisible = Boolean.parseBoolean(mediator.getPersistent("MFS.ToolTipVisible"));
        this.infoBalloonToggleMenuItem = new JMenuItem("  Show info balloons");
        if (this.tooltipVisible) {
            this.infoBalloonToggleMenuItem.setText("  Hide info balloons");
        }
        this.infoBalloonToggleMenuItem.addActionListener(this);
        this.concordancePopup.add(this.infoBalloonToggleMenuItem);
        this.hitContextSize = 3;
        String csPref = mediator.getPersistent("MFS.ContextSize");
        if (csPref != null) {
            try {
                this.hitContextSize = Integer.parseInt(csPref);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        this._contextSizeMenu = new JMenu("  Context Size");
        this._contextSizeMenu.setBackground(mediator.getBackgroundColor());
        ButtonGroup sizeGroup = new ButtonGroup();
        for (int size = 0; size <= 8; ++size) {
            JRadioButtonMenuItem sizeItem = new JRadioButtonMenuItem(Integer.toString(size));
            if (size == this.hitContextSize) {
                sizeItem.setSelected(true);
            }
            sizeGroup.add(sizeItem);
            this._contextSizeMenu.add(sizeItem);
            sizeItem.addActionListener(this);
        }
        this.concordancePopup.add(this._contextSizeMenu);
        this.concordancePopup.addSeparator();
        this.chooseFontMenuItem = new JMenuItem("  Font");
        this.chooseFontMenuItem.addActionListener(this);
        this.concordancePopup.add(this.chooseFontMenuItem);
        this.concordancePopup.addSeparator();
        this.saveHitsMenuItem = new JMenuItem("  Save hits");
        this.saveHitsMenuItem.addActionListener(this);
        this.concordancePopup.add(this.saveHitsMenuItem);
        this.saveHitsStatisticsMenuItem = new JMenuItem("  Save hit statistics");
        this.saveHitsStatisticsMenuItem.addActionListener(this);
        this.concordancePopup.add(this.saveHitsStatisticsMenuItem);
        this.frequencyPopup = new JPopupMenu();
        this.concordanceDisplayModeItem = new JMenuItem("  Show Concordance view");
        this.concordanceDisplayModeItem.addActionListener(this);
        this.frequencyPopup.add(this.concordanceDisplayModeItem);
        this.frequencyPopup.addSeparator();
        this.showSampleHitMenuItem = new JMenuItem("  Show hit in transcription");
        this.showSampleHitMenuItem.addActionListener(this);
        this.frequencyPopup.add(this.showSampleHitMenuItem);
        this.frequencyPopup.addSeparator();
        this.saveFrequencyInfoMenuItem = new JMenuItem("  Save frequency info");
        this.saveFrequencyInfoMenuItem.addActionListener(this);
        this.frequencyPopup.add(this.saveFrequencyInfoMenuItem);
        this.resultMode = 0;
        String rModePref = mediator.getPersistent("MFS.ResultMode");
        if (rModePref != null) {
            try {
                this.resultMode = Integer.parseInt(rModePref);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        ToolTipManager.sharedInstance().setInitialDelay(100);
        String ff = mediator.getPersistent("MFS.FontFamily");
        if (ff != null) {
            String fs = mediator.getPersistent("MFS.FontSize");
            try {
                int size = Integer.parseInt(fs);
                this.setHitFont(ff, size);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        this.addComponentListener(new ComponentHandler());
        this.dimension = new Dimension(690, 300);
        this.setSize(this.dimension);
    }

    public void clear() {
        this.nHitsPrev = 0;
        this.firstVisibleHitIndex = 0;
        this.hitNrLabel.setBounds(0, 0, 0, 0);
        this.prevButton.setVisible(false);
        this.nextButton.setVisible(false);
        this.saveHitsMenuItem.setEnabled(false);
        this.resultMode = 0;
        this.updateStatistics();
        this.newLayout();
    }

    public void startUpdating() {
        this.pollTimer.stop();
        this.nHitsPrev = 0;
        this.firstVisibleHitIndex = 0;
        this.firstVisibleFrequencyInfoIndex = 0;
        this.hitNrLabel.setBounds(0, 0, 0, 0);
        this.prevButton.setVisible(false);
        this.nextButton.setVisible(false);
        this.saveHitsMenuItem.setEnabled(false);
        this.resultMode = 0;
        this.frequencyDisplayModeItem.setEnabled(false);
        this.frequencyDisplayModeItemByFreq.setEnabled(false);
        this.updateStatistics();
        this.newLayout();
        this.cancelButton.setEnabled(true);
        this.progressBar.setValue(0);
        this.progressBar.setString("Progress");
        this.pollTimer.start();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source instanceof JRadioButtonMenuItem) {
            try {
                this.hitContextSize = Integer.parseInt(event.getActionCommand());
                this.mediator.putPersistent("MFS.ContextSize", String.valueOf(this.hitContextSize));
                this.newLayout();
            }
            catch (NumberFormatException e) {}
        } else if (source == this.chooseFontMenuItem) {
            Font currentFont = this.hitLabels[0].getFont();
            JFontChooser chooser = new JFontChooser(JFontChooser.FONT_SIZE);
            JPopupMenu popupMenu = (JPopupMenu)((JMenuItem)source).getParent();
            Component invoker = popupMenu.getInvoker();
            JComponent invokerAsJComponent = (JComponent)invoker;
            Container topLevel = invokerAsJComponent.getTopLevelAncestor();
            Font font = chooser.showDialog((JFrame)topLevel, true, currentFont);
            if (font != null) {
                this.mediator.putPersistent("MFS.FontFamily", font.getFamily());
                this.mediator.putPersistent("MFS.FontSize", String.valueOf(font.getSize()));
                this.setHitFont(font.getFamily(), font.getSize());
            }
        } else if (source == this.concordanceDisplayModeItem) {
            this.resultMode = 0;
            this.mediator.putPersistent("MFS.ResultMode", String.valueOf(this.resultMode));
            if (this.tooltipVisible) {
                this.infoBalloonToggleMenuItem.setText("  Hide info balloons");
            } else {
                this.infoBalloonToggleMenuItem.setText("  Show info balloons");
            }
            this.newLayout();
        } else if (source == this.frequencyDisplayModeItem || source == this.frequencyDisplayModeItemByFreq) {
            this.resultMode = 1;
            if (source == this.frequencyDisplayModeItemByFreq) {
                this.resultMode = 2;
            }
            this.mediator.putPersistent("MFS.ResultMode", String.valueOf(this.resultMode));
            this.newLayout();
        } else if (source == this.infoBalloonToggleMenuItem) {
            if (this.infoBalloonToggleMenuItem.getText().equals("  Show info balloons")) {
                this.infoBalloonToggleMenuItem.setText("  Hide info balloons");
                this.enableToolTips(true);
            } else {
                this.infoBalloonToggleMenuItem.setText("  Show info balloons");
                this.enableToolTips(false);
            }
            this.mediator.putPersistent("MFS.ToolTipVisible", String.valueOf(this.tooltipVisible));
        } else if (source == this.showHitMenuItem || source == this.showSampleHitMenuItem) {
            if (this.activeHit != null) {
                this.mediator.showInViewer(this.activeHit, this.queryId);
            }
        } else if (source == this.saveHitsMenuItem) {
            if (this.currentSaver != null && this.currentSaver.getSaving()) {
                JOptionPane.showMessageDialog(null, "Already saving, press Cancel button to interrupt", "Save Hits", 1);
                return;
            }
            if (this.simpleQueryMode) {
                Window w = SwingUtilities.getWindowAncestor(this);
                ExportHitsOptionsDialog opDialog = w instanceof Frame ? new ExportHitsOptionsDialog((Frame)w, null, this.mediator, false) : (w instanceof Dialog ? new ExportHitsOptionsDialog((Dialog)w, null, this.mediator, false) : new ExportHitsOptionsDialog((Frame)null, null, this.mediator, false));
                opDialog.setVisible(true);
            } else {
                Window w = SwingUtilities.getWindowAncestor(this);
                ExportHitsOptionsDialog opcDialog = w instanceof Frame ? new ExportHitsOptionsDialog((Frame)w, null, this.mediator, true) : (w instanceof Dialog ? new ExportHitsOptionsDialog((Dialog)w, null, this.mediator, true) : new ExportHitsOptionsDialog((Frame)null, null, this.mediator, true));
                opcDialog.setVisible(true);
            }
            File saveFile = this.commonSaverPreparations("Save Hits", "LastMFSaveDir");
            if (saveFile != null) {
                this.currentSaver = new SaverAllHits(saveFile, this.mediator.getSearchStatistics((String)this.queryId).nHits, this.mediator, this.queryId, this.hitContextSize);
                new Thread(this.currentSaver).start();
                this.progressBar.setString("Saving hits");
            }
        } else if (source == this.saveHitsStatisticsMenuItem) {
            if (this.currentSaver != null && this.currentSaver.getSaving()) {
                JOptionPane.showMessageDialog(null, "Already saving, press Cancel button to interrupt", "Save Hits", 1);
                return;
            }
            ExportResultStatsDialog exDialog = null;
            Window w = SwingUtilities.getWindowAncestor(this);
            exDialog = w instanceof Frame ? new ExportResultStatsDialog((Frame)w, null, this.mediator) : (w instanceof Dialog ? new ExportResultStatsDialog((Dialog)w, null, this.mediator) : new ExportResultStatsDialog((Frame)null, null, this.mediator));
            exDialog.setVisible(true);
            File saveFile = this.commonSaverPreparations("Save Hits", "LastMFSaveDir");
            if (saveFile != null) {
                this.currentSaver = new SaverHitStatistics(saveFile, this.mediator.getSearchStatistics((String)this.queryId).nHits, this.mediator, this.queryId, exDialog.distinguishHits, exDialog.includeFileName, exDialog.includeFilePath, exDialog.msFormat);
                new Thread(this.currentSaver).start();
                this.progressBar.setString("Saving hit statistics");
            }
        } else if (source == this.saveFrequencyInfoMenuItem) {
            boolean sortByFreq = this.resultMode == 2;
            File saveFile = this.commonSaverPreparations("Save Frequency Info", null);
            if (saveFile != null) {
                this.currentSaver = new SaverFrequencyInfo(saveFile, this.mediator.getSearchStatistics((String)this.queryId).nFrequencyInfoItems, this.mediator, this.queryId, sortByFreq);
                new Thread(this.currentSaver).start();
                this.progressBar.setString("Saving frequency info");
            }
        } else if (source == this.prevButton) {
            if (this.currentSaver != null && this.currentSaver.getSaving()) {
                return;
            }
            if (this.resultMode == 0) {
                this.firstVisibleHitIndex -= this.nrOfVisibleHits;
            } else if (this.resultMode == 1 || this.resultMode == 2) {
                this.firstVisibleFrequencyInfoIndex -= this.nrOfVisibleHits;
            }
            this.newLayout();
        } else if (source == this.nextButton) {
            if (this.currentSaver != null && this.currentSaver.getSaving()) {
                return;
            }
            if (this.resultMode == 0) {
                this.firstVisibleHitIndex += this.nrOfVisibleHits;
            } else if (this.resultMode == 1 || this.resultMode == 2) {
                this.firstVisibleFrequencyInfoIndex += this.nrOfVisibleHits;
            }
            this.newLayout();
        } else if (source == this.cancelButton) {
            if (this.currentSaver != null && this.currentSaver.getSaving()) {
                this.currentSaver.cancel();
                this.stopUpdating();
                JOptionPane.showMessageDialog(null, "Stopped saving results", "Save Results", 1);
                return;
            }
            this.mediator.cancelQuery(this.queryId);
            this.stopUpdating();
            if (this.mediator.getSearchStatistics((String)this.queryId).nHits > 0) {
                this.saveHitsMenuItem.setEnabled(true);
            }
            this.updateStatistics();
            this.progressBar.setString("Canceled");
        } else if (source == this.pollTimer) {
            if (this.currentSaver != null && this.currentSaver.getSaving() && this.currentSaver.getProgress() == -1.0f) {
                this.pollTimer.stop();
                this.progressBar.setValue(0);
                this.progressBar.setString("");
                this.cancelButton.setEnabled(false);
            }
            if (this.currentSaver != null && this.currentSaver.getSaving()) {
                int pBarValue = (int)(this.currentSaver.getProgress() * (float)this.progressBar.getMaximum());
                this.progressBar.setValue(pBarValue < 0 ? 0 : (pBarValue > 100 ? 100 : pBarValue));
                return;
            }
            this.updateStatistics();
            this.nextButton.setVisible(this.mediator.getSearchStatistics((String)this.queryId).nHits > this.lastVisibleHitIndex);
            if (this.mediator.getSearchStatistics((String)this.queryId).nHits > this.nHitsPrev) {
                if (this.lastVisibleHitIndex > this.nHitsPrev) {
                    this.newLayout();
                }
                this.nHitsPrev = this.mediator.getSearchStatistics((String)this.queryId).nHits;
            }
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return this.dimension;
    }

    private void stopUpdating() {
        this.pollTimer.stop();
        this.cancelButton.setEnabled(false);
        this.frequencyDisplayModeItem.setEnabled(true);
        this.frequencyDisplayModeItemByFreq.setEnabled(true);
        this.saveFrequencyInfoMenuItem.setEnabled(true);
        this.newLayout();
    }

    private void updateStatistics() {
        SearchStatistics stat = this.mediator.getSearchStatistics(this.queryId);
        this.hitStatsLabel.setText("Found " + stat.nHits + " hits in " + stat.nAnnotationsWithHit + " annotations (of " + stat.nAnnotationsSearched + ")");
        int pBarValue = (int)(stat.progress * (float)this.progressBar.getMaximum());
        this.progressBar.setValue(pBarValue < 0 ? 0 : (pBarValue > 100 ? 100 : pBarValue));
        if (stat.progress <= 0.0f) {
            this.progressBar.setString("");
        } else if (stat.progress >= 1.0f) {
            this.progressBar.setString("Ready");
            this.stopUpdating();
            this.saveHitsMenuItem.setEnabled(this.mediator.getSearchStatistics((String)this.queryId).nHits > 0);
        }
        this.newLayout();
    }

    private File commonSaverPreparations(String topic, String key) {
        JFileChooser chooser;
        int returnVal;
        String lastDir;
        if (this.currentSaver != null && this.currentSaver.getSaving()) {
            JOptionPane.showMessageDialog(null, "Already saving, press Cancel button to interrupt", topic, 1);
            return null;
        }
        if (key != null && (lastDir = this.mediator.getPersistent(key)) != null) {
            this.lastSavedFile = new File(lastDir);
        }
        if ((returnVal = (chooser = new JFileChooser(this.lastSavedFile)).showSaveDialog(this)) != 0) {
            return null;
        }
        File saveFile = chooser.getSelectedFile();
        if (saveFile.exists() && (returnVal = JOptionPane.showConfirmDialog(null, saveFile.getName() + " already exists, overwrite?", topic, 0)) != 0) {
            return null;
        }
        this.cancelButton.setEnabled(true);
        this.lastSavedFile = saveFile;
        if (key != null) {
            this.mediator.putPersistent(key, chooser.getCurrentDirectory().getAbsolutePath());
        }
        this.pollTimer.start();
        return saveFile;
    }

    private void setHitFont(String fontFamily, int fontSize) {
        Font bFont = new Font(fontFamily, 1, fontSize);
        Font pFont = new Font(fontFamily, 0, fontSize);
        Font iFont = new Font(fontFamily, 2, fontSize);
        for (int i = 0; i < 100; ++i) {
            this.hitLabels[i].setFont(bFont);
            this.prefixLabels[i].setFont(pFont);
            this.postfixLabels[i].setFont(pFont);
            this.hitLabelsLeftContext[i].setFont(iFont);
            this.hitLabelsRightContext[i].setFont(iFont);
        }
        this.newLayout();
    }

    private synchronized void enableToolTips(boolean enabled) {
        if (enabled && !ToolTipManager.sharedInstance().isEnabled()) {
            ToolTipManager.sharedInstance().setEnabled(true);
        }
        this.tooltipVisible = enabled;
        this.newLayout();
    }

    private void newLayout() {
        if (this.resultMode == 0) {
            this.newConcordanceLayout();
        } else if (this.resultMode == 1 || this.resultMode == 2) {
            this.newFrequencyLayout(this.resultMode == 2);
        }
        this.validate();
    }

    private int layoutHitNavigation() {
        int panelMiddle = this.hitPanel.getWidth() / 2;
        int hitNrWidth = this.getStringWidth(this.hitNrLabel.getText(), this.hitNrLabel.getFont());
        int hitNrHeight = this.getStringHeight(this.hitNrLabel.getText(), this.hitNrLabel.getFont());
        this.prevButton.setBounds(30, 15, 55, 25);
        this.nextButton.setBounds(100, 15, 55, 25);
        this.hitNrLabel.setBounds(170, 15 + (25 - hitNrHeight) / 2, hitNrWidth, hitNrHeight);
        return panelMiddle;
    }

    private void newFrequencyLayout(boolean sortByFrequency) {
        JLabel countLabel;
        JLabel percentageLabel;
        JLabel postfixLabel;
        JLabel prefixLabel;
        JLabel hitLabel;
        int i;
        this.hitPanel.setBounds(10, 35, this.getWidth() - 20, this.getHeight() - 35);
        int panelMiddle = this.layoutHitNavigation();
        int yMargin = 55;
        this.HIT_HEIGHT = this.getStringHeight("knoep", this.hitLabels[0].getFont()) + 5;
        this.labelToHit.clear();
        SearchStatistics searchStatistics = this.mediator.getSearchStatistics(this.queryId);
        this.hitNrLabel.setText("");
        this.nrOfVisibleHits = (this.hitPanel.getHeight() - yMargin) / this.HIT_HEIGHT - 1;
        if (this.nrOfVisibleHits < 0) {
            this.nrOfVisibleHits = 0;
        }
        if (this.nrOfVisibleHits <= 0) {
            this.hitNrLabel.setText("Cannot show " + searchStatistics.nFrequencyInfoItems + " frequency items, need more space");
        }
        this.lastVisibleFrequencyInfoIndex = this.firstVisibleFrequencyInfoIndex + this.nrOfVisibleHits;
        if (this.firstVisibleFrequencyInfoIndex <= 0) {
            this.firstVisibleFrequencyInfoIndex = 0;
            this.prevButton.setVisible(false);
            this.prevButton.setEnabled(false);
        } else {
            this.prevButton.setVisible(true);
            this.prevButton.setEnabled(true);
        }
        if (this.lastVisibleFrequencyInfoIndex >= searchStatistics.nFrequencyInfoItems - 1) {
            this.lastVisibleFrequencyInfoIndex = searchStatistics.nFrequencyInfoItems - 1;
            this.nextButton.setVisible(false);
        } else {
            this.nextButton.setVisible(true);
        }
        int count = 1 + this.lastVisibleFrequencyInfoIndex - this.firstVisibleFrequencyInfoIndex;
        ArrayList<FrequencyInfo> frequencyStatistics = this.mediator.getFrequencyInfo(this.firstVisibleFrequencyInfoIndex, count, this.queryId, sortByFrequency);
        FrequencyInfo freqInfo = null;
        if (frequencyStatistics.size() > 0) {
            freqInfo = frequencyStatistics.get(0);
        }
        if (freqInfo != null && freqInfo.numberOfHits < 0) {
            for (int i2 = 0; i2 < this.nrOfVisibleHits + 1 + 1; ++i2) {
                JLabel hitLabel2 = this.hitLabels[i2];
                JLabel prefixLabel2 = this.prefixLabels[i2];
                JLabel postfixLabel2 = this.postfixLabels[i2];
                JLabel percentageLabel2 = this.hitLabelsLeftContext[i2];
                JLabel countLabel2 = this.hitLabelsRightContext[i2];
                this.clearLabel(hitLabel2);
                this.clearLabel(prefixLabel2);
                this.clearLabel(postfixLabel2);
                this.clearLabel(percentageLabel2);
                this.clearLabel(countLabel2);
            }
            this.headerLabel[0].setText("");
            this.headerLabel[1].setText("");
            this.headerLabel[2].setText("");
            this.saveFrequencyInfoMenuItem.setEnabled(false);
            this.hitLabels[0].setText(freqInfo.annotation);
            this.hitLabels[0].setBounds(50, 100, 1000, this.HIT_HEIGHT);
            this.nextButton.setVisible(false);
            return;
        }
        this.headerLabel[0].setText("Percentage");
        int percentageLabelWidth = this.getStringWidth(this.headerLabel[0].getText(), this.headerLabel[0].getFont());
        this.headerLabel[0].setBounds(5, 55, percentageLabelWidth + 25, this.HIT_HEIGHT);
        this.headerLabel[1].setText("Count");
        int countLabelWidth = this.getStringWidth(this.headerLabel[1].getText(), this.headerLabel[1].getFont());
        this.headerLabel[1].setBounds(5 + percentageLabelWidth + 25, 55, percentageLabelWidth + 20, this.HIT_HEIGHT);
        this.headerLabel[2].setText("Annotation");
        int annoAreaStart = 5 + percentageLabelWidth + 25 + countLabelWidth;
        int annoAreaWidth = this.hitPanel.getWidth() - annoAreaStart;
        int annoAreaCenter = annoAreaStart + annoAreaWidth / 2;
        int annotationLabelWidth = this.getStringWidth(this.headerLabel[2].getText(), this.headerLabel[2].getFont());
        this.headerLabel[2].setBounds(annoAreaStart + (annoAreaWidth - (annotationLabelWidth + 25)) / 2, 55, annotationLabelWidth + 25, this.HIT_HEIGHT);
        for (i = 0; i < this.nrOfVisibleHits; ++i) {
            hitLabel = this.hitLabels[i];
            prefixLabel = this.prefixLabels[i];
            postfixLabel = this.postfixLabels[i];
            percentageLabel = this.hitLabelsLeftContext[i];
            countLabel = this.hitLabelsRightContext[i];
            if (i < frequencyStatistics.size()) {
                this.hitNrLabel.setText("Frequency " + (this.firstVisibleFrequencyInfoIndex + 1) + " - " + (this.firstVisibleFrequencyInfoIndex + i + 1) + " of " + freqInfo.nOccurences);
                this.layoutHitNavigation();
                freqInfo = frequencyStatistics.get(i);
                this.labelToHit.put(hitLabel, freqInfo);
                this.labelToHit.put(prefixLabel, freqInfo);
                this.labelToHit.put(postfixLabel, freqInfo);
                this.labelToHit.put(percentageLabel, freqInfo);
                this.labelToHit.put(countLabel, freqInfo);
                if (freqInfo.hitLength == 0) {
                    hitLabel.setBounds(0, 0, 0, 0);
                    String prefixString = freqInfo.annotation;
                    int shorten = 0;
                    int prefixX = -1;
                    do {
                        prefixLabel.setText((shorten > 0 ? "..." : "") + prefixString.substring(shorten));
                        int prefixW = this.getStringWidth(prefixLabel.getText(), prefixLabel.getFont());
                        prefixX = annoAreaCenter - prefixW / 2;
                        prefixLabel.setToolTipText(null);
                        prefixLabel.setBounds(prefixX, yMargin + (i + 1) * this.HIT_HEIGHT, prefixW + 20, this.HIT_HEIGHT);
                    } while (prefixX < annoAreaStart && ++shorten < prefixString.length());
                    postfixLabel.setBounds(0, 0, 0, 0);
                } else {
                    String hitString = freqInfo.annotation.substring(freqInfo.hitPositionInAnnotation, freqInfo.hitPositionInAnnotation + freqInfo.hitLength);
                    hitLabel.setText(hitString);
                    int hitW = this.getStringWidth(hitLabel.getText(), hitLabel.getFont());
                    int hitX = annoAreaCenter - hitW / 2;
                    hitLabel.setToolTipText(null);
                    hitLabel.setBounds(hitX, yMargin + (i + 1) * this.HIT_HEIGHT, hitX + 20, this.HIT_HEIGHT);
                    String prefixString = freqInfo.annotation.substring(0, freqInfo.hitPositionInAnnotation);
                    int shorten = 0;
                    int prefixX = -1;
                    do {
                        prefixLabel.setText((shorten > 0 ? "..." : "") + prefixString.substring(shorten));
                        int prefixW = this.getStringWidth(prefixLabel.getText(), prefixLabel.getFont());
                        prefixX = hitX - prefixW;
                        prefixLabel.setToolTipText(null);
                        prefixLabel.setBounds(prefixX, yMargin + (i + 1) * this.HIT_HEIGHT, prefixW + 20, this.HIT_HEIGHT);
                    } while (prefixX < annoAreaStart && ++shorten < prefixString.length());
                    String postfixString = freqInfo.annotation.substring(freqInfo.hitPositionInAnnotation + freqInfo.hitLength);
                    postfixLabel.setText(postfixString);
                    int postfixW = this.getStringWidth(postfixLabel.getText(), postfixLabel.getFont());
                    int postfixX = hitX + hitW;
                    postfixLabel.setToolTipText(null);
                    postfixLabel.setBounds(postfixX, yMargin + (i + 1) * this.HIT_HEIGHT, postfixW + 20, this.HIT_HEIGHT);
                }
                float percentage = 100.0f * (float)freqInfo.numberOfHits / (float)searchStatistics.nAnnotationsWithHit;
                String fmt = "##0.00";
                DecimalFormat df = new DecimalFormat(fmt);
                String percentageString = df.format(percentage) + "%";
                int percentageStringWidth = this.getStringWidth(percentageString, percentageLabel.getFont());
                percentageLabel.setText(percentageString);
                percentageLabel.setToolTipText(null);
                percentageLabel.setBounds(5 + percentageLabelWidth + 25 - (percentageStringWidth + 50), yMargin + (i + 1) * this.HIT_HEIGHT, percentageStringWidth + 20, this.HIT_HEIGHT);
                String countString = Integer.toString(freqInfo.numberOfHits);
                int countStringWidth = this.getStringWidth(countString, countLabel.getFont());
                countLabel.setText(countString);
                countLabel.setToolTipText(null);
                countLabel.setBounds(annoAreaStart - (countStringWidth + 50), yMargin + (i + 1) * this.HIT_HEIGHT, countStringWidth + 20, this.HIT_HEIGHT);
                continue;
            }
            this.clearLabel(hitLabel);
            this.clearLabel(prefixLabel);
            this.clearLabel(postfixLabel);
            this.clearLabel(percentageLabel);
            this.clearLabel(countLabel);
        }
        for (i = this.nrOfVisibleHits; i < this.nrOfVisibleHits + 1 + 1; ++i) {
            if (i < 0) continue;
            hitLabel = this.hitLabels[i];
            prefixLabel = this.prefixLabels[i];
            postfixLabel = this.postfixLabels[i];
            percentageLabel = this.hitLabelsLeftContext[i];
            countLabel = this.hitLabelsRightContext[i];
            this.clearLabel(hitLabel);
            this.clearLabel(prefixLabel);
            this.clearLabel(postfixLabel);
            this.clearLabel(percentageLabel);
            this.clearLabel(countLabel);
        }
    }

    private void newConcordanceLayout() {
        JLabel hitAfterLabel;
        JLabel hitBeforeLabel;
        JLabel postfixLabel;
        JLabel prefixLabel;
        JLabel hitLabel;
        int i;
        int i2;
        this.hitPanel.setBounds(10, 35, this.getWidth() - 20, this.getHeight() - 35);
        int panelMiddle = this.layoutHitNavigation();
        int yMargin = 25;
        this.tooltipVisible = !this.infoBalloonToggleMenuItem.getText().equals("  Show info balloons");
        for (i2 = 0; i2 < this.headerLabel.length; ++i2) {
            this.headerLabel[i2].setBounds(0, 0, 0, 0);
        }
        this.HIT_HEIGHT = this.getStringHeight("knoep", this.hitLabels[0].getFont()) + 5;
        this.labelToHit.clear();
        this.hitNrLabel.setText("");
        this.nrOfVisibleHits = (this.hitPanel.getHeight() - yMargin) / this.HIT_HEIGHT - 1;
        if (this.nrOfVisibleHits < 0) {
            this.nrOfVisibleHits = 0;
        }
        if (this.nrOfVisibleHits <= 0) {
            this.hitNrLabel.setText("Cannot show " + this.mediator.getSearchStatistics((String)this.queryId).nHits + " hits, need more space");
        }
        this.lastVisibleHitIndex = this.firstVisibleHitIndex + this.nrOfVisibleHits;
        if (this.firstVisibleHitIndex <= 0) {
            this.firstVisibleHitIndex = 0;
        }
        this.prevButton.setVisible(this.firstVisibleHitIndex > 0);
        this.prevButton.setEnabled(this.firstVisibleHitIndex > 0);
        this.nextButton.setVisible(this.mediator.getSearchStatistics((String)this.queryId).nHits > this.lastVisibleHitIndex);
        for (i2 = 0; i2 < 100; ++i2) {
            this.clearLabel(this.hitLabels[i2]);
            this.clearLabel(this.prefixLabels[i2]);
            this.clearLabel(this.postfixLabels[i2]);
            this.clearLabel(this.hitLabelsLeftContext[i2]);
            this.clearLabel(this.hitLabelsRightContext[i2]);
        }
        int count = 1 + this.lastVisibleHitIndex - this.firstVisibleHitIndex;
        List<SearchHit> hits = this.mediator.getHits(this.firstVisibleHitIndex, count, 8, this.queryId);
        boolean[][] cellsInUse = this.mediator.getMatrixUsage(this.queryId);
        boolean anyComplexHits = false;
        for (i = 0; i < this.nrOfVisibleHits; ++i) {
            hitLabel = this.hitLabels[i];
            prefixLabel = this.prefixLabels[i];
            postfixLabel = this.postfixLabels[i];
            hitBeforeLabel = this.hitLabelsLeftContext[i];
            hitAfterLabel = this.hitLabelsRightContext[i];
            if (i < hits.size()) {
                String hitString;
                this.hitNrLabel.setText("Hit " + (this.firstVisibleHitIndex + 1) + " - " + (this.firstVisibleHitIndex + i + 1) + " of " + this.mediator.getSearchStatistics((String)this.queryId).nHits);
                this.layoutHitNavigation();
                SearchHit hit = hits.get(i);
                this.labelToHit.put(hitLabel, hit);
                this.labelToHit.put(prefixLabel, hit);
                this.labelToHit.put(postfixLabel, hit);
                this.labelToHit.put(hitBeforeLabel, hit);
                this.labelToHit.put(hitAfterLabel, hit);
                if (hit.complex) {
                    hitString = "";
                    String htmlInfo = "";
                    String[] layerStrings = hit.annotation.trim().split("xxxLAYER_SPLITTERxxx");
                    anyComplexHits = true;
                    for (int j = 1; j < layerStrings.length; ++j) {
                        String[] layerParts = layerStrings[j].trim().split("xxxSAFE_SPLITTERxxx");
                        hitString = hitString + " #" + layerParts[0] + " ";
                        for (int k = 1; k < layerParts.length; ++k) {
                            boolean doProcess;
                            String part = layerParts[k];
                            boolean bl = cellsInUse != null ? cellsInUse[j - 1][k - 1] : (doProcess = part.charAt(1) != '|');
                            if (doProcess) {
                                if (part.contains("xxxNUMBER_SPLITTERxxx")) {
                                    String[] patternParts = part.split("xxxNUMBER_SPLITTERxxx");
                                    String annotation = patternParts[0].substring(1, patternParts[0].length() - 1);
                                    if (annotation.length() > 15) {
                                        annotation = annotation.substring(0, 15) + "...";
                                    } else if (annotation.length() == 0) {
                                        annotation = "|| ";
                                    }
                                    int pos = Integer.parseInt(patternParts[1]) + 1;
                                    String position = pos + "";
                                    while (position.length() < 4) {
                                        position = "0" + position;
                                    }
                                    long bt = Long.parseLong(patternParts[2]);
                                    long et = Long.parseLong(patternParts[3]);
                                    String beginTime = SearchUtil.HHMMSSmmmFormat(bt);
                                    String endTime = SearchUtil.HHMMSSmmmFormat(et);
                                    String duration = SearchUtil.HHMMSSmmmFormat(et - bt);
                                    hitString = hitString + patternParts[0] + " ";
                                    htmlInfo = htmlInfo + "<tr><td>" + annotation + "</td><td>" + "&nbsp;&nbsp;Position: " + position + "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Time: " + beginTime + "&nbsp;-&nbsp;" + endTime + "&nbsp;&nbsp;&nbsp;Duration: " + duration + "</td></tr>";
                                    continue;
                                }
                                hitString = hitString + "|| ";
                                htmlInfo = htmlInfo + "<tr><td>||</td><td>&nbsp;</td></tr>";
                                continue;
                            }
                            hitString = hitString + "|| ";
                        }
                    }
                    hitLabel.setText(hitString);
                    String toolTipText = "<html><table border=\"0\"><tr><td> Transcription: </td><td>&nbsp;&nbsp;" + hit.transcriptionName + "</td></tr>" + htmlInfo + "</table></html>";
                    int hitW = this.getStringWidth(hitLabel.getText(), hitLabel.getFont());
                    int hitX = panelMiddle - hitW / 2;
                    hitLabel.setToolTipText(this.tooltipVisible ? toolTipText : null);
                    hitLabel.setBounds(hitX, yMargin + (i + 1) * this.HIT_HEIGHT, hitW, this.HIT_HEIGHT);
                    this.clearLabel(prefixLabel);
                    this.clearLabel(postfixLabel);
                    this.clearLabel(hitBeforeLabel);
                    this.clearLabel(hitAfterLabel);
                    continue;
                }
                this.simpleQueryMode = true;
                hitString = "";
                hitString = hit.hitPositionInAnnotation > -1 && hit.hitPositionInAnnotation + hit.hitLength <= hit.annotation.length() ? hit.annotation.substring(hit.hitPositionInAnnotation, hit.hitPositionInAnnotation + hit.hitLength) : "[" + hit.hitPositionInAnnotation + "-" + hit.hitLength + "] " + hit.annotation;
                if (hitString.length() == 0) {
                    hitString = "...";
                }
                hitLabel.setText(hitString);
                String toolTipText = "<html><table border=\"0\"><tr><td> Transcription: </td><td>" + hit.transcriptionName + "</td></tr>" + "<tr><td> Tier name: </td><td>" + hit.tierName + "</td></tr>" + "<tr><td> Tier type: </td><td>" + hit.tierType + "</td></tr>" + (hit.participant != null ? "<tr><td> Participant: </td><td>" + hit.participant + "</td></tr>" : "") + (hit.annotator != null ? "<tr><td> Annotator: </td><td>" + hit.annotator + "</td></tr>" : "") + "<tr><td> Position in tier: </td><td>" + hit.positionInTier + "</td></tr>";
                toolTipText = hit.aligned ? toolTipText + "<tr><td> begin time: </td><td>" + SearchUtil.HHMMSSmmmFormat(hit.beginTime) + "</td></tr>" + "<tr><td> end time: </td><td>" + SearchUtil.HHMMSSmmmFormat(hit.endTime) + "</td></tr>" + "<tr><td> duration: </td><td>" + SearchUtil.HHMMSSmmmFormat(hit.endTime - hit.beginTime) + "</td></tr>" : toolTipText + "<tr><td> alignment: </td><td> not aligned </td></tr>";
                toolTipText = toolTipText + "</table></html>";
                int hitW = this.getStringWidth(hitLabel.getText(), hitLabel.getFont());
                int hitX = panelMiddle - hitW / 2;
                hitLabel.setToolTipText(this.tooltipVisible ? toolTipText : null);
                hitLabel.setBounds(hitX, yMargin + (i + 1) * this.HIT_HEIGHT, hitW, this.HIT_HEIGHT);
                String prefixString = hit.annotation.substring(0, hit.hitPositionInAnnotation);
                prefixLabel.setText(prefixString);
                int prefixW = this.getStringWidth(prefixLabel.getText(), prefixLabel.getFont());
                int prefixX = hitX - prefixW;
                prefixLabel.setToolTipText(this.tooltipVisible ? toolTipText : null);
                prefixLabel.setBounds(prefixX, yMargin + (i + 1) * this.HIT_HEIGHT, prefixW, this.HIT_HEIGHT);
                String postfixString = hit.annotation.substring(hit.hitPositionInAnnotation + hit.hitLength);
                postfixLabel.setText(postfixString);
                int postfixW = this.getStringWidth(postfixLabel.getText(), postfixLabel.getFont());
                int postfixX = hitX + hitW;
                postfixLabel.setToolTipText(this.tooltipVisible ? toolTipText : null);
                postfixLabel.setBounds(postfixX, yMargin + (i + 1) * this.HIT_HEIGHT, postfixW, this.HIT_HEIGHT);
                int totalHitW = prefixW + hitW + postfixW;
                int totalHitX = prefixX;
                String beforeString = "";
                int maxLeftContext = this.hitContextSize <= hit.leftContext.size() ? this.hitContextSize : hit.leftContext.size();
                for (int j = 0; j < maxLeftContext; ++j) {
                    beforeString = (String)hit.leftContext.get(j) + "  " + beforeString;
                }
                hitBeforeLabel.setText(beforeString);
                int beforeW = this.getStringWidth(hitBeforeLabel.getText(), hitBeforeLabel.getFont());
                int beforeX = totalHitX - beforeW;
                hitBeforeLabel.setToolTipText(this.tooltipVisible ? toolTipText : null);
                hitBeforeLabel.setBounds(beforeX, yMargin + (i + 1) * this.HIT_HEIGHT, beforeW, this.HIT_HEIGHT);
                StringBuilder afterString = new StringBuilder("");
                int maxRightContext = this.hitContextSize <= hit.rightContext.size() ? this.hitContextSize : hit.rightContext.size();
                for (int j = 0; j < maxRightContext; ++j) {
                    afterString.append("  ");
                    afterString.append((String)hit.rightContext.get(j));
                }
                hitAfterLabel.setText(afterString.toString());
                int afterW = this.getStringWidth(hitAfterLabel.getText(), hitAfterLabel.getFont());
                hitAfterLabel.setToolTipText(this.tooltipVisible ? toolTipText : null);
                hitAfterLabel.setBounds(totalHitX + totalHitW, yMargin + (i + 1) * this.HIT_HEIGHT, afterW, this.HIT_HEIGHT);
                continue;
            }
            this.clearLabel(hitLabel);
            this.clearLabel(prefixLabel);
            this.clearLabel(postfixLabel);
            this.clearLabel(hitBeforeLabel);
            this.clearLabel(hitAfterLabel);
        }
        this._contextSizeMenu.setEnabled(!anyComplexHits);
        for (i = this.nrOfVisibleHits; i < this.nrOfVisibleHits + 1 + 1; ++i) {
            if (i < 0) continue;
            hitLabel = this.hitLabels[i];
            prefixLabel = this.prefixLabels[i];
            postfixLabel = this.postfixLabels[i];
            hitBeforeLabel = this.hitLabelsLeftContext[i];
            hitAfterLabel = this.hitLabelsRightContext[i];
            this.clearLabel(hitLabel);
            this.clearLabel(prefixLabel);
            this.clearLabel(postfixLabel);
            this.clearLabel(hitBeforeLabel);
            this.clearLabel(hitAfterLabel);
        }
    }

    private void clearLabel(JLabel label) {
        label.setText("");
        label.setToolTipText(null);
        label.setBounds(0, 0, 0, 0);
    }

    private int getStringWidth(String str, Font fnt) {
        FontRenderContext frc = new FontRenderContext(new AffineTransform(), false, false);
        Rectangle2D rect = fnt.getStringBounds(str, frc);
        return (int)rect.getWidth();
    }

    private int getStringHeight(String str, Font fnt) {
        FontRenderContext frc = new FontRenderContext(new AffineTransform(), false, false);
        Rectangle2D rect = fnt.getStringBounds(str, frc);
        return (int)rect.getHeight();
    }

    private class MouseHandler
    extends MouseInputAdapter
    implements Serializable {
        private MouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger() || SwingUtilities.isRightMouseButton(e)) {
                if (SearchResultPanel.this.resultMode == 0) {
                    SearchResultPanel.this.activeHit = SearchResultPanel.this.labelToHit.get(e.getSource());
                    if (SearchResultPanel.this.activeHit != null) {
                        SearchResultPanel.this.showHitMenuItem.setEnabled(true);
                    } else {
                        SearchResultPanel.this.showHitMenuItem.setEnabled(false);
                    }
                    SearchResultPanel.this.concordancePopup.show(e.getComponent(), e.getX(), e.getY());
                } else if (SearchResultPanel.this.resultMode == 1 || SearchResultPanel.this.resultMode == 2) {
                    SearchResultPanel.this.activeHit = SearchResultPanel.this.labelToHit.get(e.getSource());
                    SearchResultPanel.this.frequencyPopup.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                SearchResultPanel.this.activeHit = SearchResultPanel.this.labelToHit.get(e.getSource());
                if (SearchResultPanel.this.activeHit != null) {
                    SearchResultPanel.this.mediator.showInViewer(SearchResultPanel.this.activeHit, SearchResultPanel.this.queryId);
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (SearchResultPanel.this.infoBalloonToggleMenuItem.getText().equals("  Show info balloons")) {
                if (SearchResultPanel.this.tooltipVisible) {
                    SearchResultPanel.this.enableToolTips(false);
                }
            } else if (!SearchResultPanel.this.tooltipVisible) {
                SearchResultPanel.this.enableToolTips(true);
            }
        }
    }

    private class DelayedNewLayout
    extends Thread {
        private DelayedNewLayout() {
        }

        @Override
        public void run() {
            try {
                DelayedNewLayout.sleep(200L);
                SearchResultPanel.this.newLayout();
                SearchResultPanel.this.validate();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private class ComponentHandler
    extends ComponentAdapter {
        private ComponentHandler() {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            SearchResultPanel.this.dimension = new Dimension(SearchResultPanel.this.getWidth(), SearchResultPanel.this.getHeight());
            if (SearchResultPanel.this.delayedNewLayout != null) {
                SearchResultPanel.this.delayedNewLayout.interrupt();
            }
            SearchResultPanel.this.delayedNewLayout = new DelayedNewLayout();
            SearchResultPanel.this.delayedNewLayout.start();
        }
    }
}

