/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.annot.search.mfsearch;

import java.text.DecimalFormat;

public class SearchUtil {
    public static final long ILLEGAL_TIME_FLAG = 98373696L;
    private static final DecimalFormat twoDigits = new DecimalFormat("00");
    private static final DecimalFormat threeFracs = new DecimalFormat("000");

    public static String HHMMSSmmmFormat(long timeInMillis) {
        long msecs = timeInMillis % 1000L;
        long seconds = timeInMillis / 1000L % 60L;
        long minutes = timeInMillis / 60000L % 60L;
        long hours = timeInMillis / 3600000L;
        return twoDigits.format(hours) + ":" + twoDigits.format(minutes) + ":" + twoDigits.format(seconds) + "." + threeFracs.format(msecs);
    }

    public static String formatShortTimeString(long timeInMillis) {
        String big = SearchUtil.HHMMSSmmmFormat(timeInMillis);
        while (big.indexOf("00:") == 0) {
            big = big.substring(3);
        }
        if (timeInMillis < 10000L) {
            big = big.substring(1);
        }
        big = big.replace(".000", "");
        return big;
    }

    public static long parseTimeString(String timeString) {
        timeString = timeString.replace(',', '.');
        try {
            String[] seconds;
            int colonPos = timeString.indexOf(58);
            int dotPos = timeString.indexOf(46);
            if (colonPos < 0 && dotPos < 0) {
                return Long.parseLong(timeString.trim());
            }
            String[] parts = timeString.trim().split(":");
            if (parts.length != 3) {
                return 98373696L;
            }
            if (parts[2].indexOf(46) == -1) {
                parts[2] = parts[2] + ".000";
            }
            if ((seconds = parts[2].split("\\.")).length != 2) {
                return 98373696L;
            }
            while (seconds[1].length() < 3) {
                seconds[1] = seconds[1] + "0";
            }
            long round = 0L;
            if (seconds[1].length() > 3) {
                if (seconds[1].charAt(3) < '0' || seconds[1].charAt(3) > '9') {
                    return 98373696L;
                }
                round = seconds[1].charAt(3) > '4' ? 1L : 0L;
                seconds[1] = seconds[1].substring(0, 3);
            }
            long value = 3600000L * (long)Integer.parseInt(parts[0].trim());
            value += 60000L * (long)Integer.parseInt(parts[1].trim());
            value += 1000L * (long)Integer.parseInt(seconds[0].trim());
            return (value += (long)Integer.parseInt(seconds[1].trim())) + round;
        }
        catch (NumberFormatException nfe) {
            return 98373696L;
        }
    }

    public static void main(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            System.out.println("Parsing time: '" + args[i] + "'");
            long msec = SearchUtil.parseTimeString(args[i]);
            System.out.println("Milliseconds: " + msec);
            System.out.println("Short time:   " + SearchUtil.formatShortTimeString(msec));
            System.out.println("Long time:    " + SearchUtil.HHMMSSmmmFormat(msec));
        }
    }
}

