/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.annot.search.lib;

import java.text.DecimalFormat;
import java.util.Set;
import nl.mpi.annot.search.lib.FrequencyInfo;
import nl.mpi.annot.search.lib.SearchHit;
import nl.mpi.annot.search.lib.SearchStatistics;

public class CsvOutput {
    private static final String delimiter = ";";
    private StringBuilder resultString = new StringBuilder();
    private Set<String> fieldSet = null;

    public CsvOutput(Set<String> fieldSet) {
        this.fieldSet = fieldSet;
    }

    public static String getInfoAsTabDelimited(FrequencyInfo freqInfo, boolean includeHeader, SearchStatistics stats) {
        StringBuilder result = new StringBuilder("");
        if (includeHeader) {
            result.append("\"Annotation\"").append(delimiter).append("\"Percentage\"").append(delimiter).append("\"Count\"").append(delimiter).append("\"HitPositionInAnnotation\"").append(delimiter).append("\"HitLength\"\n");
        }
        float percentage = 100.0f * (float)freqInfo.numberOfHits / (float)stats.nAnnotationsWithHit;
        String fmt = "##0.00";
        DecimalFormat df = new DecimalFormat(fmt);
        String percentageString = df.format(percentage);
        result.append('\"').append(freqInfo.annotation.replaceAll("\"", "\"\"")).append('\"').append(delimiter);
        result.append(percentageString).append(delimiter);
        result.append(freqInfo.numberOfHits).append(delimiter);
        result.append(freqInfo.hitPositionInAnnotation).append(delimiter);
        result.append(freqInfo.hitLength).append("\n");
        return result.toString();
    }

    public static String getHitAsTabDelimited(SearchHit hit, boolean includeHeader, int contextSize, Set<String> fieldSet) {
        CsvOutput csvo = new CsvOutput(fieldSet);
        if (hit.complex) {
            String part;
            int n;
            int k;
            String[] layerStrings = hit.annotation.trim().split("xxxLAYER_SPLITTERxxx");
            String[] layerParts = null;
            if (includeHeader) {
                for (k = 1; k < layerStrings.length; ++k) {
                    layerParts = layerStrings[k].trim().split("xxxSAFE_SPLITTERxxx");
                    for (n = 1; n < layerParts.length; ++n) {
                        part = layerParts[n];
                        if (part.charAt(1) == '|') continue;
                        csvo.addHeader("Annotation", "Annotation" + k + "-" + n);
                        csvo.addHeader("HitPositionInAnnotation", "Position");
                        csvo.addHeader("AnnotationBeginTime", "Begin Time");
                        csvo.addHeader("AnnotationEndTime", "End Time");
                    }
                }
                csvo.addHeader("TranscriptionName");
                csvo.addLastHeader("TranscriptionURL");
            }
            layerStrings = hit.annotation.trim().split("xxxLAYER_SPLITTERxxx");
            for (k = 1; k < layerStrings.length; ++k) {
                layerParts = layerStrings[k].trim().split("xxxSAFE_SPLITTERxxx");
                for (n = 1; n < layerParts.length; ++n) {
                    part = layerParts[n];
                    if (part.charAt(1) == '|') continue;
                    String[] patternParts = part.split("xxxNUMBER_SPLITTERxxx");
                    String annotation = patternParts[0].substring(1, patternParts[0].length() - 1);
                    int position = Integer.parseInt(patternParts[1]);
                    long beginTime = Long.parseLong(patternParts[2]);
                    long endTime = Long.parseLong(patternParts[3]);
                    csvo.addField("Annotation", annotation);
                    csvo.addField("HitPositionInAnnotation", position);
                    csvo.addField("AnnotationBeginTime", beginTime);
                    csvo.addField("AnnotationEndTime", endTime);
                }
            }
            csvo.addField("TranscriptionName", hit.transcriptionName);
            csvo.addField("TranscriptionURL", hit.transcriptionURL, "\n");
        } else {
            int k;
            if (includeHeader) {
                if (contextSize > 0) {
                    csvo.addHeader("LeftContext");
                }
                csvo.addHeader("Annotation");
                if (contextSize > 0) {
                    csvo.addHeader("RightContext");
                }
                csvo.addHeader("HitPositionInAnnotation");
                csvo.addHeader("HitLength");
                csvo.addHeader("HitNumberInAnnotation");
                csvo.addHeader("AnnotationBeginTime");
                csvo.addHeader("AnnotationEndTime");
                csvo.addHeader("HitPositionInTier");
                csvo.addHeader("TierName");
                csvo.addHeader("TierType");
                csvo.addHeader("TierParticipant");
                csvo.addHeader("TierAnnotator");
                csvo.addHeader("TranscriptionName");
                csvo.addLastHeader("TranscriptionURL");
            }
            if (contextSize > 0) {
                if (hit.leftContext.size() > 0) {
                    String leftContext = hit.leftContext.get(0);
                    for (k = 1; k < hit.leftContext.size(); ++k) {
                        leftContext = hit.leftContext.get(k) + "  " + leftContext;
                    }
                    csvo.addField("LeftContext", leftContext);
                } else {
                    csvo.addField("LeftContext", "");
                }
            }
            csvo.addField("Annotation", hit.annotation);
            if (contextSize > 0) {
                if (hit.rightContext.size() > 0) {
                    StringBuilder rightContext = new StringBuilder(hit.rightContext.get(0));
                    for (k = 1; k < hit.rightContext.size(); ++k) {
                        rightContext.append("  ");
                        rightContext.append(hit.rightContext.get(k));
                    }
                    csvo.addField("RightContext", rightContext.toString());
                } else {
                    csvo.addField("RightContext", "");
                }
            }
            csvo.addField("HitPositionInAnnotation", hit.hitPositionInAnnotation + 1);
            csvo.addField("HitLength", hit.hitLength);
            csvo.addField("HitNumberInAnnotation", hit.hitNumberInAnnotation);
            csvo.addField("AnnotationBeginTime", hit.beginTime);
            csvo.addField("AnnotationEndTime", hit.endTime);
            csvo.addField("HitPositionInTier", hit.positionInTier);
            csvo.addField("TierName", hit.tierName);
            csvo.addField("TierType", hit.tierType);
            if (hit.participant == null) {
                hit.participant = "";
            }
            csvo.addField("TierParticipant", hit.participant);
            if (hit.annotator == null) {
                hit.annotator = "";
            }
            csvo.addField("TierAnnotator", hit.annotator);
            csvo.addField("TranscriptionName", hit.transcriptionName);
            csvo.addField("TranscriptionURL", hit.transcriptionURL, "\n");
        }
        return csvo.getResultString();
    }

    private void addHeader(String field) {
        this.addHeader(field, field, delimiter);
    }

    private void addLastHeader(String field) {
        this.addHeader(field, field, "\n");
    }

    private void addHeader(String canonicalField, String displayField) {
        this.addHeader(canonicalField, displayField, delimiter);
    }

    private void addHeader(String canonicalField, String displayField, String delim) {
        if (this.fieldSet == null || this.fieldSet.contains(canonicalField)) {
            this.resultString.append('\"').append(displayField).append('\"').append(delim);
        }
    }

    private void addField(String field, String value) {
        this.addField(field, value, delimiter);
    }

    private void addField(String field, String value, String delim) {
        if (this.fieldSet == null || this.fieldSet.contains(field)) {
            this.resultString.append('\"').append(value.replaceAll("\"", "\"\"")).append('\"').append(delim);
        }
    }

    private void addField(String field, long value) {
        this.addField(field, value, delimiter);
    }

    private void addField(String field, long value, String delim) {
        if (this.fieldSet == null || this.fieldSet.contains(field)) {
            this.resultString.append(value).append(delim);
        }
    }

    private String getResultString() {
        return this.resultString.toString();
    }
}

