/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.annot.search.lib;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import nl.mpi.annot.search.lib.FrequencyInfo;

public class FrequencyInfoTools {
    public static synchronized void updateFrequencyStatistics(HashMap<String, FrequencyInfo> frequencyMap, String annotation, int annId, int fileIndex, int layerIndex, int patternIndex) {
        FrequencyInfo info = frequencyMap.get(annotation);
        if (info != null) {
            ++info.numberOfHits;
        } else if (frequencyMap.size() < 100000) {
            info = new FrequencyInfo();
            info.annotation = annotation;
            info.annId = annId;
            info.fileIndex = fileIndex;
            info.layerIndex = layerIndex;
            info.patternIndex = patternIndex;
            info.numberOfHits = 1;
            frequencyMap.put(annotation, info);
        }
    }

    public static ArrayList<FrequencyInfo> getFrequencyInfo(HashMap<String, FrequencyInfo> frequencyMap, ArrayList<FrequencyInfo> orderedFrequencyInfoByAnnotation, ArrayList<FrequencyInfo> orderedFrequencyInfoByFrequency, int from, int count, boolean sortByFreq) {
        Iterator<FrequencyInfo> iter2;
        FrequencyInfo freqInfo;
        String annotation;
        TreeSet<FrequencyInfo> frequencyInfoTree;
        Comparator<FrequencyInfo> comparator;
        ArrayList<FrequencyInfo> info = new ArrayList<FrequencyInfo>();
        if (frequencyMap.size() >= 100000) {
            FrequencyInfo freqInfo2 = new FrequencyInfo();
            freqInfo2.annotation = "No frequency statistics available, there were more than 100000 different hit patterns";
            freqInfo2.numberOfHits = -1;
            info.add(freqInfo2);
            return info;
        }
        if (orderedFrequencyInfoByAnnotation.size() != frequencyMap.size()) {
            comparator = new Comparator<FrequencyInfo>(){

                @Override
                public int compare(FrequencyInfo left, FrequencyInfo right) {
                    int valueCompare = left.annotation.compareToIgnoreCase(right.annotation);
                    if (valueCompare < 0) {
                        return 1;
                    }
                    if (valueCompare > 0) {
                        return -1;
                    }
                    valueCompare = left.annotation.compareTo(right.annotation);
                    if (valueCompare != 0) {
                        return valueCompare < 0 ? 1 : -1;
                    }
                    return left.numberOfHits > right.numberOfHits ? 1 : -1;
                }
            };
            frequencyInfoTree = new TreeSet<FrequencyInfo>(comparator);
            for (Map.Entry<String, FrequencyInfo> item : frequencyMap.entrySet()) {
                annotation = item.getKey();
                freqInfo = item.getValue();
                freqInfo.annotation = annotation;
                frequencyInfoTree.add(freqInfo);
            }
            orderedFrequencyInfoByAnnotation.clear();
            iter2 = frequencyInfoTree.iterator();
            while (iter2.hasNext()) {
                orderedFrequencyInfoByAnnotation.add(0, iter2.next());
            }
        }
        if (orderedFrequencyInfoByFrequency.size() != frequencyMap.size()) {
            comparator = new Comparator<FrequencyInfo>(){

                @Override
                public int compare(FrequencyInfo left, FrequencyInfo right) {
                    if (left.numberOfHits > right.numberOfHits) {
                        return 1;
                    }
                    if (left.numberOfHits < right.numberOfHits) {
                        return -1;
                    }
                    int valueCompare = left.annotation.compareToIgnoreCase(right.annotation);
                    if (valueCompare == 0) {
                        valueCompare = left.annotation.compareTo(right.annotation);
                    }
                    return valueCompare < 0 ? 1 : -1;
                }
            };
            frequencyInfoTree = new TreeSet<FrequencyInfo>(comparator);
            for (Map.Entry<String, FrequencyInfo> item : frequencyMap.entrySet()) {
                annotation = item.getKey();
                freqInfo = item.getValue();
                freqInfo.annotation = annotation;
                frequencyInfoTree.add(freqInfo);
            }
            orderedFrequencyInfoByFrequency.clear();
            iter2 = frequencyInfoTree.iterator();
            while (iter2.hasNext()) {
                orderedFrequencyInfoByFrequency.add(0, iter2.next());
            }
        }
        int available = orderedFrequencyInfoByFrequency.size();
        if (from < 0 || from >= available || from + count > available || count < 0) {
            FrequencyInfo freqInfo3 = new FrequencyInfo();
            freqInfo3.annotation = "Requested sub-list out of range: " + count + " items starting at index " + from + " but only " + available + " items available";
            freqInfo3.numberOfHits = -1;
            info.add(freqInfo3);
            return info;
        }
        for (int i = 0; i < count; ++i) {
            FrequencyInfo freqInfo4 = sortByFreq ? orderedFrequencyInfoByFrequency.get(from + i) : orderedFrequencyInfoByAnnotation.get(from + i);
            info.add(freqInfo4);
        }
        return info;
    }
}

