/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.annot.search.lib;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;

public final class LuceneNGramTokenizer
extends Tokenizer {
    private int minGram;
    private int maxGram;
    private int gramSize;
    private int pos;
    private int inLen;
    private String inStr;
    private boolean started;
    private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private final OffsetAttribute offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);

    public LuceneNGramTokenizer(Reader input, int minGram, int maxGram) {
        super(input);
        this.init(minGram, maxGram);
    }

    private void init(int minGram, int maxGram) {
        if (minGram < 1) {
            throw new IllegalArgumentException("minGram must be greater than zero");
        }
        if (minGram > maxGram) {
            throw new IllegalArgumentException("minGram must not be greater than maxGram");
        }
        this.minGram = minGram;
        this.maxGram = maxGram;
    }

    public boolean incrementToken() throws IOException {
        this.clearAttributes();
        if (!this.started) {
            int numChars;
            this.started = true;
            this.gramSize = this.minGram;
            char[] chars = new char[8192];
            StringBuilder builder = new StringBuilder(8192);
            while ((numChars = this.input.read(chars, 0, chars.length)) > 0) {
                builder.append(chars, 0, numChars);
            }
            this.inStr = builder.toString().toLowerCase();
            this.inLen = this.inStr.length();
            if (this.inLen == 0) {
                return false;
            }
        }
        if (this.pos + this.gramSize > this.inLen) {
            this.pos = 0;
            ++this.gramSize;
            if (this.gramSize > this.maxGram) {
                return false;
            }
            if (this.pos + this.gramSize > this.inLen) {
                return false;
            }
        }
        int oldPos = this.pos++;
        this.termAtt.setEmpty().append((CharSequence)this.inStr, oldPos, oldPos + this.gramSize);
        this.offsetAtt.setOffset(oldPos, oldPos + this.gramSize);
        return true;
    }

    public void end() {
        this.offsetAtt.setOffset(this.inLen, this.inLen);
    }

    public void reset() throws IOException {
        super.reset();
        this.started = false;
        this.pos = 0;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof LuceneNGramTokenizer) {
            return obj.toString().equals(this.toString());
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return "LuceneNGramTokenizer[" + this.minGram + ";" + this.maxGram + "] '" + this.inStr + "'";
    }
}

