/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.annot.search.lib;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.FieldSelectorResult;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.NIOFSDirectory;

public class LuceneQuery {
    private static Logger _logger = Logger.getLogger((String)"Searchlib.LuceneQuery");
    private final IndexSearcher _indexSearcher;
    private final int _maxNgramLength;

    public LuceneQuery(File luceneIndexDirectory) throws IOException {
        int lastDot = luceneIndexDirectory.getCanonicalPath().lastIndexOf(46);
        try {
            this._maxNgramLength = Integer.parseInt(luceneIndexDirectory.getCanonicalPath().substring(lastDot + 1));
        }
        catch (NumberFormatException nfe) {
            throw new IOException("Maximum N-gram size not found in index path name: " + luceneIndexDirectory.getCanonicalPath());
        }
        if (this._maxNgramLength < 1) {
            throw new IOException("Index must contain at least 1-grams!");
        }
        this._indexSearcher = new IndexSearcher(IndexReader.open((Directory)NIOFSDirectory.open((File)luceneIndexDirectory)));
    }

    public Set<Integer> getTierCandidates(List<String> keywords) {
        boolean madeSense = false;
        BooleanQuery booleanQuery = new BooleanQuery();
        for (String keyword : keywords) {
            if (keyword.length() == 0) continue;
            madeSense = true;
            if ((keyword = keyword.toLowerCase()).length() < this._maxNgramLength) {
                booleanQuery.add((Query)new TermQuery(new Term(Integer.toString(keyword.length()) + "grams", keyword)), BooleanClause.Occur.MUST);
                continue;
            }
            for (int i = 0; i <= keyword.length() - this._maxNgramLength; ++i) {
                String part = keyword.substring(i, i + this._maxNgramLength);
                booleanQuery.add((Query)new TermQuery(new Term("contents", part)), BooleanClause.Occur.MUST);
            }
        }
        if (!madeSense) {
            return null;
        }
        TierCollector tierIdCollector = new TierCollector(new HashSet<Integer>());
        try {
            this._indexSearcher.search((Query)booleanQuery, (Collector)tierIdCollector);
        }
        catch (IOException ioe) {
            _logger.warn((Object)("Lucene search caused IOException, not using results: " + ioe));
            return null;
        }
        return tierIdCollector.getTiers();
    }

    public void close() throws IOException {
        this._indexSearcher.getIndexReader().close();
        this._indexSearcher.close();
    }

    public static class TierCollector
    extends Collector {
        private final Set<Integer> tiers;
        private int lastHitDoc = -1;
        private IndexReader indexReader = null;
        private final FieldSelector tierIdOnlySelector = new TierIdSelector();

        public TierCollector(Set<Integer> tierSet) {
            this.tiers = tierSet;
        }

        public void setScorer(Scorer scorer) throws IOException {
        }

        public void collect(int doc) throws IOException {
            if (this.lastHitDoc == doc) {
                return;
            }
            this.lastHitDoc = doc;
            Document hitDetails = this.indexReader.document(doc, this.tierIdOnlySelector);
            String tierIdString = hitDetails.get("tierid");
            this.tiers.add(Integer.parseInt(tierIdString));
        }

        public void setNextReader(IndexReader reader, int docBase) {
            this.indexReader = reader;
            this.lastHitDoc = -1;
        }

        public boolean acceptsDocsOutOfOrder() {
            return true;
        }

        public Set<Integer> getTiers() {
            return Collections.unmodifiableSet(this.tiers);
        }
    }

    public static class TierIdSelector
    implements FieldSelector {
        public FieldSelectorResult accept(String fieldName) {
            if ("tierid".equals(fieldName)) {
                return FieldSelectorResult.LOAD_AND_BREAK;
            }
            return FieldSelectorResult.NO_LOAD;
        }
    }
}

