/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.annot.search.lib;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import nl.mpi.annot.search.lib.FrequencyInfo;
import nl.mpi.annot.search.lib.FrequencyInfoTools;
import nl.mpi.annot.search.lib.PostgresQuery;
import nl.mpi.annot.search.lib.QueryServer;
import nl.mpi.annot.search.lib.SearchHit;
import nl.mpi.annot.search.lib.SearchStatistics;
import nl.mpi.annot.search.lib.TierCollection;
import nl.mpi.annot.tools.data.AnnexFileTypes;
import org.apache.log4j.Logger;

public class MultiPostgresQuery
implements QueryServer {
    private static Logger _logger = Logger.getLogger((String)"Searchlib.MultiPostgresQuery");
    private PostgresQuery[] _queryFarm;
    private long _queryStartTime = System.currentTimeMillis();
    private int _searchedAnnotations = 0;
    private HashMap<String, FrequencyInfo> _frequencyMap = new HashMap();
    private ArrayList<FrequencyInfo> _orderedFrequencyInfoByAnnotation = new ArrayList();
    private ArrayList<FrequencyInfo> _orderedFrequencyInfoByFrequency = new ArrayList();

    public MultiPostgresQuery(String url, String usr, String pwd, File luceneDirectory, int farmSize) throws IOException, SQLException {
        this._queryFarm = new PostgresQuery[farmSize];
        for (int i = 0; i < this._queryFarm.length; ++i) {
            this._queryFarm[i] = new PostgresQuery(url, usr, pwd, luceneDirectory, "MultiThreaded_" + (i + 1) + "_" + System.currentTimeMillis());
        }
    }

    @Override
    public void setSimpleQuery(String pattern, String matchScope, boolean caseInsensitive, String matchMode, ArrayList<String> tierConstraints) {
        for (int i = 0; i < this._queryFarm.length; ++i) {
            this._queryFarm[i].setSimpleQuery(pattern, matchScope, caseInsensitive, matchMode, tierConstraints);
        }
    }

    @Override
    public void setGlobalTimeConstraints(long minDuration, long maxDuration, long minStart, long maxEnd) {
        for (int i = 0; i < this._queryFarm.length; ++i) {
            this._queryFarm[i].setGlobalTimeConstraints(minDuration, maxDuration, minStart, maxEnd);
        }
    }

    @Override
    public void createLayers(String encodedQuery) {
        for (int i = 0; i < this._queryFarm.length; ++i) {
            this._queryFarm[i].createLayers(encodedQuery);
        }
    }

    @Override
    public boolean isRunning() {
        for (int i = 0; i < this._queryFarm.length; ++i) {
            if (!this._queryFarm[i].isRunning()) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized SearchStatistics getSearchStatistics() {
        SearchStatistics combinedStats = new SearchStatistics();
        combinedStats.setStartTime(this._queryStartTime);
        for (int i = 0; i < this._queryFarm.length; ++i) {
            SearchStatistics oneStat = this._queryFarm[i].getSearchStatistics();
            combinedStats.progress += oneStat.progress;
            combinedStats.nAnnotationsWithHit += oneStat.nAnnotationsWithHit;
            combinedStats.nHits += oneStat.nHits;
        }
        combinedStats.progress /= (float)this._queryFarm.length;
        if (this.isRunning()) {
            combinedStats.nFrequencyInfoItems = 0;
        } else {
            this.setupFrequencyInfo();
            combinedStats.nFrequencyInfoItems = this._frequencyMap.size();
        }
        combinedStats.nAnnotationsSearched = this._searchedAnnotations;
        return combinedStats;
    }

    @Override
    public synchronized void doQuery(TierCollection domain, List<Integer> fileTypes, String encodedQuery) {
        int i;
        HashSet<String> domainNodeIds = new HashSet<String>();
        this._queryStartTime = System.currentTimeMillis();
        this._frequencyMap.clear();
        this._orderedFrequencyInfoByAnnotation.clear();
        this._orderedFrequencyInfoByFrequency.clear();
        int annotationsInDomain = 0;
        if (fileTypes != null) {
            for (i = 0; i < fileTypes.size(); ++i) {
                domainNodeIds.addAll(domain.getNodesForType(fileTypes.get(i)));
                annotationsInDomain += domain.getAnnoCountForType(fileTypes.get(i));
            }
        } else {
            for (i = 0; i < AnnexFileTypes.getFileTypeCount(); ++i) {
                domainNodeIds.addAll(domain.getNodesForType(i));
                annotationsInDomain += domain.getAnnoCountForType(i);
            }
        }
        this._searchedAnnotations = annotationsInDomain;
        ArrayList subDomains = new ArrayList();
        for (int i2 = 0; i2 < this._queryFarm.length; ++i2) {
            subDomains.add(new HashSet());
        }
        int worker = 0;
        for (String nodeId : domainNodeIds) {
            ((HashSet)subDomains.get(worker)).add(nodeId);
            if (++worker < this._queryFarm.length) continue;
            worker = 0;
        }
        String tierConstraintSQL = domain.getRawSQLFilter(fileTypes);
        for (int i3 = 0; i3 < this._queryFarm.length; ++i3) {
            this._queryFarm[i3].doQuery((HashSet)subDomains.get(i3), tierConstraintSQL, encodedQuery);
        }
    }

    @Override
    public void cancelQuery() {
        for (int i = 0; i < this._queryFarm.length; ++i) {
            this._queryFarm[i].cancelQuery();
        }
    }

    @Override
    public ArrayList<Object> getViewerParametersFor(int annId, int fileId) {
        return this._queryFarm[0].getViewerParametersFor(annId, fileId);
    }

    @Override
    public ArrayList<SearchHit> getHits(int fromIndex, int count, int contextSize) {
        ArrayList<SearchHit> hitList = new ArrayList<SearchHit>();
        SearchHit errorHit = null;
        int originalCount = count;
        int workerOffset = 0;
        for (int i = 0; i < this._queryFarm.length; ++i) {
            int workerSize = this._queryFarm[i].getSearchStatistics().nHits;
            int nextOffset = workerOffset + workerSize;
            if (fromIndex < nextOffset) {
                ArrayList<SearchHit> workerHits;
                int subCount;
                int subFrom = fromIndex - workerOffset;
                if (subFrom < 0) {
                    subFrom = 0;
                }
                if (subFrom + (subCount = count) > workerSize) {
                    subCount = workerSize - subFrom;
                }
                if ((workerHits = this._queryFarm[i].getHits(subFrom, subCount, contextSize)).size() < subCount) {
                    _logger.debug((Object)("Hit list truncated at " + hitList.size() + " of " + originalCount + " hits, offset: " + fromIndex + " by worker: " + (i + 1) + " of " + this._queryFarm.length));
                    if (!workerHits.isEmpty()) {
                        errorHit = workerHits.remove(workerHits.size() - 1);
                    }
                }
                count -= workerHits.size();
                hitList.addAll(workerHits);
            }
            if (count == 0) break;
            workerOffset = nextOffset;
        }
        if (count == 0) {
            return hitList;
        }
        if (errorHit == null) {
            _logger.error((Object)("Returned " + hitList.size() + " real hits while " + originalCount + " were requested, offset: " + fromIndex + " (caller too optimistic about stats?)"));
            return hitList;
        }
        if (count == 1 && hitList.isEmpty()) {
            _logger.warn((Object)("One item requested at offset " + fromIndex + " but none available, returning nothing, not even an error item"));
            return hitList;
        }
        if (count == 1) {
            hitList.remove(hitList.size() - 1);
        }
        _logger.warn((Object)("Returned " + hitList.size() + " real hits and 1 error item while " + originalCount + " were requested, offset: " + fromIndex + " (caller too optimistic about stats?)"));
        hitList.add(errorHit);
        return hitList;
    }

    @Override
    public ArrayList<FrequencyInfo> getFrequencyInfo(int fromIndex, int count, boolean sortByFreq) {
        this.setupFrequencyInfo();
        return FrequencyInfoTools.getFrequencyInfo(this._frequencyMap, this._orderedFrequencyInfoByAnnotation, this._orderedFrequencyInfoByFrequency, fromIndex, count, sortByFreq);
    }

    private synchronized void setupFrequencyInfo() {
        if (this._frequencyMap.size() > 0 || this.isRunning()) {
            return;
        }
        this._frequencyMap.clear();
        this._orderedFrequencyInfoByAnnotation.clear();
        this._orderedFrequencyInfoByFrequency.clear();
        for (int i = 0; i < this._queryFarm.length; ++i) {
            int items = this._queryFarm[i].getSearchStatistics().nFrequencyInfoItems;
            if (items == 0) continue;
            ArrayList<FrequencyInfo> subInfo = this._queryFarm[i].getFrequencyInfo(0, items, false);
            for (int j = 0; j < subInfo.size(); ++j) {
                FrequencyInfo info = subInfo.get(j);
                FrequencyInfoTools.updateFrequencyStatistics(this._frequencyMap, info.annotation, info.annId, info.fileIndex, info.layerIndex, info.patternIndex);
                FrequencyInfo info2 = this._frequencyMap.get(info.annotation);
                if (info2 == null) continue;
                info2.numberOfHits += info.numberOfHits - 1;
                if (info.hitLength != 0 || info.hitPositionInAnnotation != 0) {
                    info2.hitLength = info.hitLength;
                    info2.hitPositionInAnnotation = info.hitPositionInAnnotation;
                }
                info2.nOccurences = this._frequencyMap.size();
            }
        }
    }
}

