/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.annot.search.lib;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import nl.mpi.annot.search.lib.LuceneQuery;
import nl.mpi.annot.search.lib.PostgresQueryHelpers;
import nl.mpi.annot.search.lib.QueryServer;
import nl.mpi.annot.search.lib.SearchHit;
import nl.mpi.annot.search.lib.SearchLayer;
import nl.mpi.annot.search.lib.SearchQuery;
import nl.mpi.annot.search.lib.TierCollection;
import nl.mpi.annot.tools.data.AnnexFileTypes;
import nl.mpi.corpusstructure.NodeIdUtils;
import org.apache.log4j.Logger;

public class PostgresQuery
extends SearchQuery
implements QueryServer {
    private static Logger logger = Logger.getLogger((String)"Searchlib.PostgresQuery");
    private static int _haveLoggedSettings = 0;
    private static final boolean ENABLE_RECURSIVE_LOG = false;
    private final String _jdbcSearchURL;
    private final String _jdbcSearchUser;
    private final String _jdbcSearchPass;
    private final File _luceneIndexDirectory;
    private final String _threadName;
    private static final String schemaName = "search";
    private ArrayList<Integer> _domainTiers;

    private static void logSettings() {
        if (_haveLoggedSettings > 3) {
            return;
        }
        ++_haveLoggedSettings;
        logger.info((Object)("Current default locale: " + Locale.getDefault().toString() + " String \"caf\u00e9\".toUpperCase() is: \"" + "caf\u00e9".toUpperCase() + "\", Character: '\u00e9' to '" + Character.toUpperCase('\u00e9') + "'"));
        Properties props = new Properties(System.getProperties());
        logger.info((Object)("user.language=\"" + props.getProperty("user.language", "") + "\" user.region=\"" + props.getProperty("user.region", "") + "\" file.encoding=\"" + props.getProperty("file.encoding", "") + "\""));
    }

    public PostgresQuery(String url, String usr, String pwd, File dir, String threadName) throws IOException, SQLException {
        super(null);
        this._jdbcSearchURL = url;
        this._jdbcSearchUser = usr;
        this._jdbcSearchPass = pwd;
        this._threadName = threadName;
        DriverManager.getConnection(this._jdbcSearchURL, this._jdbcSearchUser, this._jdbcSearchPass).close();
        if (dir != null) {
            this._luceneIndexDirectory = dir;
            new LuceneQuery(this._luceneIndexDirectory).close();
        } else {
            this._luceneIndexDirectory = null;
        }
        this._domainTiers = new ArrayList();
        PostgresQuery.logSettings();
    }

    protected synchronized void doQuery(HashSet<String> domainNodeIds, String tierConstraintSQL, String encodedQuery) {
        this.cancelQuery();
        this.statistics.reset();
        this.clearFrequencyStatistics();
        if (encodedQuery != null && encodedQuery.trim().length() > 0) {
            this.createLayers(encodedQuery);
        } else if (this.searchLayers == null || this.searchLayers.length == 0 || this.searchLayers[0] == null) {
            logger.error((Object)"doQuery: No previous query set and no new query either - empty request ignored");
            this.isExecuting = false;
            this.keepExecuting = false;
            this.statistics.progress = 1.0f;
            return;
        }
        this.keepExecuting = true;
        this.isExecuting = true;
        try {
            new Thread((Runnable)new QueryExecutor(domainNodeIds, tierConstraintSQL), this._threadName).start();
        }
        catch (SQLException sqle) {
            logger.error((Object)("doQuery: Cannot start QueryExecutor thread, SQLException: " + sqle));
            this.isExecuting = false;
            this.keepExecuting = false;
            this.statistics.progress = 1.0f;
        }
    }

    @Override
    public void doQuery(TierCollection domain, List<Integer> fileTypes, String encodedQuery) {
        int i;
        HashSet<String> domainNodeIds = new HashSet<String>();
        int annotationsInDomain = 0;
        if (fileTypes != null) {
            for (i = 0; i < fileTypes.size(); ++i) {
                domainNodeIds.addAll(domain.getNodesForType(fileTypes.get(i)));
                annotationsInDomain += domain.getAnnoCountForType(fileTypes.get(i));
            }
        } else {
            for (i = 0; i < AnnexFileTypes.getFileTypeCount(); ++i) {
                domainNodeIds.addAll(domain.getNodesForType(i));
                annotationsInDomain += domain.getAnnoCountForType(i);
            }
        }
        String tierConstraintSQL = domain.getRawSQLFilter(fileTypes);
        this.doQuery(domainNodeIds, tierConstraintSQL, encodedQuery);
        this.statistics.nAnnotationsSearched = annotationsInDomain;
    }

    @Override
    public void cancelQuery() {
        if (this.isExecuting || this.keepExecuting) {
            this.keepExecuting = false;
            while (this.isExecuting) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    logger.debug((Object)"(waiting to stop query)");
                }
            }
        }
        this.isExecuting = false;
    }

    @Override
    protected String createQueryPatternPart(String pattern, String[] queryModes, Pattern regexpPattern, boolean patternNOTMode) {
        String sql = PostgresQueryHelpers.createQueryPatternPart(pattern, queryModes, patternNOTMode);
        this.patternNeedsFullStatistics = false;
        if (sql.startsWith("*")) {
            this.patternNeedsFullStatistics = true;
            return sql.substring(1);
        }
        return sql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String constructTierDomain(HashSet<String> domainNodeIds, String tierConstraintSQL, SearchLayer firstSearchLayer, LuceneQuery luceneQuery) {
        Set<Integer> luceneTierCandidates;
        long constructStart = System.currentTimeMillis();
        ArrayList<String> tierConstraints = firstSearchLayer.getTierConstraints();
        String candidateConstraint = PostgresQueryHelpers.constructCandidateConstraint(firstSearchLayer, luceneQuery != null);
        if (firstSearchLayer.isEmpty()) {
            candidateConstraint = "FALSE";
        }
        this._domainTiers.clear();
        Set<Integer> set = luceneTierCandidates = luceneQuery == null ? null : luceneQuery.getTierCandidates(PostgresQueryHelpers.gatherKeywords(firstSearchLayer));
        if (luceneTierCandidates != null && luceneTierCandidates.isEmpty()) {
            candidateConstraint = "FALSE";
        }
        if (tierConstraints != null && !tierConstraints.contains(" All Tiers ") && tierConstraints.size() > 0) {
            StringBuilder tierConstraintPart = new StringBuilder("");
            for (int i = 0; i < tierConstraints.size(); ++i) {
                String constraint = tierConstraints.get(i);
                if (constraint.equals(" Must be in same file")) continue;
                if (constraint.equals(" Must be parent and child") || constraint.equals(" Must have same parent")) {
                    logger.warn((Object)("constructTierDomain: Constraint makes no sense for 1st used layer, ignored: '" + constraint + "'"));
                    continue;
                }
                if (tierConstraintPart.length() > 0) {
                    tierConstraintPart.append(" OR ");
                }
                if (constraint.startsWith(" Tier Name: ")) {
                    tierConstraintPart.append(PostgresQueryHelpers.constructTierConstraintAtom("tier_name", " Tier Name: ", constraint));
                    continue;
                }
                if (constraint.startsWith(" Tier Type: ")) {
                    tierConstraintPart.append(PostgresQueryHelpers.constructTierConstraintAtom("tier_type", " Tier Type: ", constraint));
                    continue;
                }
                if (constraint.startsWith(" Participant: ")) {
                    tierConstraintPart.append(PostgresQueryHelpers.constructTierConstraintAtom("participant", " Participant: ", constraint));
                    continue;
                }
                if (constraint.startsWith(" Annotator: ")) {
                    tierConstraintPart.append(PostgresQueryHelpers.constructTierConstraintAtom("annotator", " Annotator: ", constraint));
                    continue;
                }
                logger.warn((Object)("constructTierDomain: Invalid constraint skipped in 1st used layer: '" + constraint + "'"));
                tierConstraintPart.append(" FALSE ");
            }
            if (tierConstraintPart.length() > 0) {
                tierConstraintSQL = tierConstraintSQL + " AND ( " + tierConstraintPart.toString() + " )";
            }
        } else if (luceneTierCandidates != null) {
            int progress = 3;
            long loopStart = System.currentTimeMillis();
            for (int tierId : luceneTierCandidates) {
                String nodeId = NodeIdUtils.TONODEID((int)(tierId / 256));
                if (domainNodeIds.contains(nodeId)) {
                    this._domainTiers.add(tierId);
                }
                this.statistics.progress = 0.01f * (float)Math.log(progress);
                ++progress;
            }
            logger.debug((Object)("constructTierDomain: found " + this._domainTiers.size() + " candidate tiers, Lucene pre-selected " + luceneTierCandidates.size() + " from " + domainNodeIds.size() + " domainNodeIds in " + (loopStart - constructStart) + " msec, set computation took " + (System.currentTimeMillis() - loopStart) + " msec for: " + PostgresQueryHelpers.gatherKeywords(firstSearchLayer)));
            return candidateConstraint + " AND " + tierConstraintSQL;
        }
        Connection con = null;
        Statement st = null;
        Statement ps = null;
        ResultSet rs = null;
        long loopStart = System.currentTimeMillis();
        try {
            con = DriverManager.getConnection(this._jdbcSearchURL, this._jdbcSearchUser, this._jdbcSearchPass);
            String tierQuery = "SELECT tier_id FROM search.tiers NATURAL JOIN search.fingerprints WHERE " + candidateConstraint + " AND " + tierConstraintSQL + " ORDER BY tier_id";
            logger.debug((Object)("constructTierDomain: " + tierQuery.replaceAll("0000+", "0...")));
            ps = con.prepareStatement(tierQuery);
            if (ps.getMaxRows() == 0 || ps.getMaxRows() > 5000) {
                ps.setFetchSize(5000);
            } else {
                ps.setFetchSize(ps.getMaxRows() - 1);
            }
            rs = ps.executeQuery();
            int considered = 0;
            while (rs.next()) {
                String nodeId;
                ++considered;
                int tierId = rs.getInt(1);
                if ((luceneTierCandidates == null || luceneTierCandidates.contains(tierId)) && domainNodeIds.contains(nodeId = NodeIdUtils.TONODEID((int)(tierId / 256)))) {
                    this._domainTiers.add(tierId);
                }
                this.statistics.progress = 0.01f * (float)Math.log(3 + considered);
            }
            logger.debug((Object)("#tiers in domain: " + this._domainTiers.size() + " Lucene: " + (luceneTierCandidates == null ? "n/a" : "" + luceneTierCandidates.size()) + " DomainNodeIds: " + domainNodeIds.size() + " Considered: " + considered + " Took: " + (loopStart - constructStart) + "+" + (System.currentTimeMillis() - loopStart) + " msec"));
            rs.close();
            rs = null;
            ps.close();
            ps = null;
        }
        catch (SQLException e) {
            logger.debug((Object)("setDomain: SQLException: " + e), (Throwable)e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e2) {
                    logger.error((Object)("constructTierDomain: ResultSet close failed: " + e2));
                }
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException e2) {
                    logger.error((Object)("constructTierDomain: Statement close failed: " + e2));
                }
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e2) {
                    logger.error((Object)("constructTierDomain: PreparedStatement close failed: " + e2));
                }
            }
            try {
                con.close();
            }
            catch (SQLException ex) {
                logger.debug((Object)"setDomain, close connection", (Throwable)ex);
            }
        }
        return candidateConstraint + " AND " + tierConstraintSQL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArrayList<Object> getViewerParametersFor(int annId, int fileId) {
        ArrayList<Object> parameters = new ArrayList<Object>();
        Connection con = null;
        Statement ps = null;
        ResultSet rs = null;
        try {
            con = DriverManager.getConnection(this._jdbcSearchURL, this._jdbcSearchUser, this._jdbcSearchPass);
            ps = con.prepareStatement("SELECT begin_time, end_time, ann_tier_id FROM search.annotations WHERE ann_id = ?");
            ps.setInt(1, annId);
            rs = ps.executeQuery();
            rs.next();
            long beginTime = PostgresQuery.getValue(rs, 1);
            long endTime = PostgresQuery.getValue(rs, 2);
            int tierId = rs.getInt(3);
            rs.close();
            ps.close();
            ps = con.prepareStatement("SELECT tier_name, node_id FROM search.tiers WHERE tier_id = ?");
            ps.setInt(1, tierId);
            rs = ps.executeQuery();
            rs.next();
            String tierName = rs.getString(1);
            String nodeId = rs.getString(2);
            rs.close();
            ps.close();
            rs = null;
            ps = null;
            parameters.add(nodeId);
            parameters.add(tierName);
            parameters.add(beginTime);
            parameters.add(endTime);
        }
        catch (SQLException e) {
            logger.warn((Object)("getViewerParametersFor: SQLException: " + e), (Throwable)e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e2) {
                    logger.debug((Object)("SQLException closing ResultSet in getViewerParametersFor 'finally': " + e2));
                }
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e2) {
                    logger.debug((Object)("SQLException closing PreparedStatement in getViewerParametersFor 'finally': " + e2));
                }
            }
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (SQLException ex) {
                logger.debug((Object)("SQLException closing Connection in getViewerParametersFor 'finally': " + ex));
            }
        }
        return parameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArrayList<SearchHit> getHits(int fromIndex, int count, int contextSize) {
        ArrayList<SearchHit> hitList = new ArrayList<SearchHit>();
        if (count == 0) {
            return hitList;
        }
        if (this.firstNonEmptyLayerIndex < 0 || this.firstNonEmptyLayerIndex >= this.nLayers || this.firstNonEmptyPatternIndex < 0 || this.firstNonEmptyPatternIndex >= this.nPatternsPerLayer) {
            logger.warn((Object)("Empty query? no results. FirstNonEmpty: " + this.firstNonEmptyPatternIndex + "/" + this.firstNonEmptyLayerIndex + " Matrix: " + this.nPatternsPerLayer + "*" + this.nLayers));
            return hitList;
        }
        Connection con = null;
        ResultSet rs = null;
        Statement psAnno = null;
        Statement psTier = null;
        Statement psNode = null;
        Statement psContext = null;
        int leftContextSize = -1;
        int rightContextSize = -1;
        try {
            String pattern = this.searchLayers[this.firstNonEmptyLayerIndex].getPattern(this.firstNonEmptyPatternIndex);
            boolean patternNOTMode = this.searchLayers[this.firstNonEmptyLayerIndex].getPatternNOTMode(this.firstNonEmptyPatternIndex);
            Pattern regExpPattern = this.searchLayers[this.firstNonEmptyLayerIndex].getRegExpPattern(this.firstNonEmptyPatternIndex);
            String[] queryModes = this.searchLayers[this.firstNonEmptyLayerIndex].getMode(this.firstNonEmptyPatternIndex);
            int[][] hitAnnIds = new int[this.nLayers][this.nPatternsPerLayer];
            con = DriverManager.getConnection(this._jdbcSearchURL, this._jdbcSearchUser, this._jdbcSearchPass);
            psAnno = con.prepareStatement("SELECT ann_position, annotation, begin_time, end_time, ann_tier_id FROM search.annotations WHERE ann_id = ?");
            psTier = con.prepareStatement("SELECT node_id, tier_name, tier_type, participant, annotator, n_annotations, aligned_annotations FROM search.tiers WHERE tier_id = ?");
            psNode = con.prepareStatement("SELECT url, name_path FROM search.nodes WHERE node_id = ?");
            if (queryModes[0].equals(" N-gram over annotations")) {
                leftContextSize = contextSize + this.nGramSizeLeftFromHit;
                rightContextSize = contextSize + this.nGramSizeRightFromHit;
                psContext = con.prepareStatement("SELECT annotation, ann_position, begin_time, end_time FROM search.annotations WHERE ann_tier_id = ? AND ann_position >= ?  AND ann_position <= ? ORDER BY ann_position");
            } else if (contextSize > 0) {
                psContext = con.prepareStatement("SELECT annotation, ann_position FROM search.annotations WHERE ann_tier_id = ? AND ann_position >= ?  AND ann_position <= ? ORDER BY ann_position");
            }
            for (int i = fromIndex; i < this.statistics.nHits; ++i) {
                SearchHit hit = new SearchHit();
                SearchQuery.ComplexHitData complexHitData = null;
                int annId = this.searchLayers[this.firstNonEmptyLayerIndex].getHitAnnIdForPattern(this.firstNonEmptyPatternIndex, i);
                hit.hitNumberInAnnotation = this.searchLayers[this.firstNonEmptyLayerIndex].getHitNumberForPattern(this.firstNonEmptyPatternIndex, i);
                if (hit.hitNumberInAnnotation == -1) {
                    if (count == 1 && hitList.isEmpty()) {
                    } else {
                        if (count == 1) {
                            hitList.remove(hitList.size() - 1);
                        }
                        hit.setError("[END OF HIT LIST DUE TO MEMORY LIMITATIONS]", !this.isSimpleQuery);
                        hitList.add(hit);
                    }
                } else {
                    psAnno.clearParameters();
                    psAnno.setInt(1, annId);
                    rs = psAnno.executeQuery();
                    rs.next();
                    hit.positionInTier = rs.getInt(1);
                    if (this.isSimpleQuery) {
                        hit.annotation = rs.getString(2);
                        hit.beginTime = PostgresQuery.getValue(rs, 3);
                        hit.endTime = PostgresQuery.getValue(rs, 4);
                    } else {
                        for (int layerIndex = 0; layerIndex < this.nLayers; ++layerIndex) {
                            for (int patternIndex = 0; patternIndex < this.nPatternsPerLayer; ++patternIndex) {
                                hitAnnIds[layerIndex][patternIndex] = this.searchLayers[layerIndex].getHitAnnIdForPattern(patternIndex, i);
                            }
                        }
                        Statement st2 = con.createStatement();
                        complexHitData = this.constructComplexHitResultString(null, st2, hitAnnIds, true);
                        st2.close();
                        hit.annotation = complexHitData.hitString;
                        hit.beginTime = complexHitData.beginTime;
                        hit.endTime = complexHitData.endTime;
                    }
                    int ann_tier_id = rs.getInt(5);
                    rs.close();
                    psTier.clearParameters();
                    psTier.setInt(1, ann_tier_id);
                    rs = psTier.executeQuery();
                    rs.next();
                    hit.transcriptionNodeId = rs.getString(1);
                    hit.tierName = rs.getString(2);
                    hit.tierType = rs.getString(3);
                    hit.complex = !this.isSimpleQuery;
                    hit.participant = rs.getString(4);
                    hit.annotator = rs.getString(5);
                    int nAnnotationsInTier = rs.getInt(6);
                    int nAlignedAnnotationsInTier = rs.getInt(7);
                    rs.close();
                    psNode.clearParameters();
                    psNode.setString(1, hit.transcriptionNodeId);
                    rs = psNode.executeQuery();
                    rs.next();
                    hit.transcriptionURL = rs.getString(1);
                    hit.transcriptionName = rs.getString(2);
                    rs.close();
                    rs = null;
                    boolean bl = hit.aligned = nAlignedAnnotationsInTier == nAnnotationsInTier;
                    if (complexHitData == null) {
                        hit.hitPositionInAnnotation = this.getHitPosition(hit.annotation, hit.hitNumberInAnnotation, queryModes, pattern, regExpPattern, patternNOTMode);
                        hit.hitLength = this.getHitLength(hit.annotation, hit.hitNumberInAnnotation, queryModes, pattern, regExpPattern, patternNOTMode);
                    } else {
                        hit.hitPositionInAnnotation = complexHitData.firstFieldOffset + this.getHitPosition(complexHitData.firstFieldText, hit.hitNumberInAnnotation, queryModes, pattern, regExpPattern, patternNOTMode);
                        hit.hitLength = this.getHitLength(complexHitData.firstFieldText, hit.hitNumberInAnnotation, queryModes, pattern, regExpPattern, patternNOTMode);
                    }
                    if (queryModes[0].equals(" N-gram over annotations")) {
                        StringBuilder anno = new StringBuilder(128);
                        psContext.clearParameters();
                        psContext.setInt(1, ann_tier_id);
                        psContext.setInt(2, hit.positionInTier - leftContextSize);
                        psContext.setInt(3, hit.positionInTier + rightContextSize);
                        rs = psContext.executeQuery();
                        boolean fixedStart = false;
                        while (rs.next()) {
                            String part = rs.getString(1);
                            int ann_position = rs.getInt(2);
                            if (ann_position >= hit.positionInTier - this.nGramSizeLeftFromHit && ann_position <= hit.positionInTier + this.nGramSizeRightFromHit) {
                                if (anno.length() > 0) {
                                    anno.append(' ');
                                }
                                anno.append(part);
                                if (ann_position < hit.positionInTier) {
                                    if (fixedStart) continue;
                                    hit.beginTime = PostgresQuery.getValue(rs, 3);
                                    fixedStart = true;
                                    continue;
                                }
                                if (ann_position <= hit.positionInTier) continue;
                                hit.endTime = PostgresQuery.getValue(rs, 4);
                                continue;
                            }
                            if (ann_position < hit.positionInTier) {
                                hit.leftContext.add(0, part);
                                continue;
                            }
                            if (ann_position <= hit.positionInTier) continue;
                            hit.rightContext.add(part);
                        }
                        hit.annotation = anno.toString();
                        hit.hitPositionInAnnotation = 0;
                        hit.hitLength = hit.annotation.length();
                        hit.positionInTier -= leftContextSize;
                    } else if (contextSize > 0) {
                        psContext.clearParameters();
                        psContext.setInt(1, ann_tier_id);
                        psContext.setInt(2, hit.positionInTier - contextSize);
                        psContext.setInt(3, hit.positionInTier + contextSize);
                        rs = psContext.executeQuery();
                        while (rs.next()) {
                            String part = rs.getString(1);
                            int ann_position = rs.getInt(2);
                            if (ann_position < hit.positionInTier) {
                                hit.leftContext.add(0, rs.getString(1));
                                continue;
                            }
                            if (ann_position <= hit.positionInTier) continue;
                            hit.rightContext.add(rs.getString(1));
                        }
                    }
                    if (rs != null) {
                        rs.close();
                    }
                    rs = null;
                    ++hit.positionInTier;
                    hitList.add(hit);
                    if (--count != 0) continue;
                }
                break;
            }
        }
        catch (SQLException e) {
            logger.warn((Object)("getHits: SQLException: " + e), (Throwable)e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e2) {
                    logger.debug((Object)("SQLException closing ResultSet in getHits 'finally': " + e2));
                }
            }
            if (psContext != null) {
                try {
                    psContext.close();
                }
                catch (SQLException e2) {
                    logger.debug((Object)("SQLException closing PreparedStatement for context in getHits 'finally': " + e2));
                }
            }
            if (psAnno != null) {
                try {
                    psAnno.close();
                }
                catch (SQLException e2) {
                    logger.debug((Object)("SQLException closing PreparedStatement for annotations in getHits 'finally': " + e2));
                }
            }
            if (psTier != null) {
                try {
                    psTier.close();
                }
                catch (SQLException e2) {
                    logger.debug((Object)("SQLException closing PreparedStatement for tiers in getHits 'finally': " + e2));
                }
            }
            if (psNode != null) {
                try {
                    psNode.close();
                }
                catch (SQLException e2) {
                    logger.debug((Object)("SQLException closing PreparedStatement for nodes in getHits 'finally': " + e2));
                }
            }
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (SQLException ex) {
                logger.debug((Object)("SQLException closing Connection in getHits 'finally': " + ex));
            }
        }
        return hitList;
    }

    @Override
    protected String convertRegexpPatternsIfNeeded(String queryString) {
        return this.convertRegexpPatternsForPostgres(queryString);
    }

    private String convertRegexpPatternsForPostgres(String queryString) {
        for (int i = 2; i < queryString.length(); ++i) {
            if (queryString.charAt(i) == 'b' && queryString.charAt(i - 1) == '\\' && queryString.charAt(i - 2) == '\\') {
                queryString = queryString.substring(0, i) + "y" + queryString.substring(i + 1);
                continue;
            }
            if (queryString.charAt(i) != 'B' || queryString.charAt(i - 1) != '\\' || queryString.charAt(i - 2) != '\\') continue;
            queryString = queryString.substring(0, i) + "Y" + queryString.substring(i + 1);
        }
        return queryString;
    }

    static {
        try {
            Class.forName("org.postgresql.Driver");
        }
        catch (ClassNotFoundException e) {
            System.out.println("You need the PostgreSQL JDBC JAR in ClassPath");
            System.exit(1);
        }
    }

    private class QueryExecutor
    implements Runnable {
        private static final int TIER_BLOCK_SIZE = 42;
        private final Connection con;
        private final String pattern;
        private final boolean _patternNOTMode;
        private final Pattern _regExpPattern;
        private final String[] queryModes;
        private final Statement statement;
        private PreparedStatement _getHitsInTier;
        private String _queryTierConstraint = "TRUE";
        private final String _initialTierConstraint;
        private HashSet<String> _initialDomainNodeIds;
        protected LuceneQuery _luceneQuery;

        protected QueryExecutor(HashSet<String> domainNodeIds, String tierConstraintSQL) throws SQLException {
            this._initialTierConstraint = tierConstraintSQL;
            this._initialDomainNodeIds = domainNodeIds;
            try {
                this.con = DriverManager.getConnection(PostgresQuery.this._jdbcSearchURL, PostgresQuery.this._jdbcSearchUser, PostgresQuery.this._jdbcSearchPass);
            }
            catch (SQLException e) {
                logger.debug((Object)("SQLEXception in QueryExecutor getConnection call: " + e));
                throw e;
            }
            try {
                this.statement = this.con.createStatement();
            }
            catch (SQLException e) {
                logger.debug((Object)("SQLEXception in QueryExecutor createStatement call: " + e));
                try {
                    this.con.close();
                }
                catch (SQLException ex) {
                    logger.debug((Object)("SQLException closing connection after failed createStatement: " + ex));
                }
                throw e;
            }
            if (PostgresQuery.this.firstNonEmptyPatternIndex >= 0) {
                this.pattern = PostgresQuery.this.searchLayers[PostgresQuery.this.firstNonEmptyLayerIndex].getPattern(PostgresQuery.this.firstNonEmptyPatternIndex);
                this._patternNOTMode = PostgresQuery.this.searchLayers[PostgresQuery.this.firstNonEmptyLayerIndex].getPatternNOTMode(PostgresQuery.this.firstNonEmptyPatternIndex);
                this._regExpPattern = PostgresQuery.this.searchLayers[PostgresQuery.this.firstNonEmptyLayerIndex].getRegExpPattern(PostgresQuery.this.firstNonEmptyPatternIndex);
                this.queryModes = PostgresQuery.this.searchLayers[PostgresQuery.this.firstNonEmptyLayerIndex].getMode(PostgresQuery.this.firstNonEmptyPatternIndex);
            } else {
                logger.warn((Object)"QueryExecutor: All patterns empty");
                this.pattern = null;
                this._patternNOTMode = false;
                this._regExpPattern = null;
                this.queryModes = new String[3];
                this.queryModes[0] = " Annotation";
                this.queryModes[1] = " case sensitive";
                this.queryModes[2] = " exact match";
            }
        }

        private void initQueryProperties() {
            if (PostgresQuery.this.firstNonEmptyLayerIndex >= 0) {
                PostgresQuery.this.statistics.progress = 0.001f;
                this._queryTierConstraint = PostgresQuery.this.constructTierDomain(this._initialDomainNodeIds, this._initialTierConstraint, PostgresQuery.this.searchLayers[PostgresQuery.this.firstNonEmptyLayerIndex], this._luceneQuery);
            } else {
                this._queryTierConstraint = " FALSE ";
                PostgresQuery.this._domainTiers.clear();
                logger.warn((Object)"QueryExecutor: All layers empty");
            }
            this._initialDomainNodeIds.clear();
            this._initialDomainNodeIds = null;
            StringBuilder queryString = new StringBuilder("SELECT ann_id, annotation, begin_time, end_time, ann_position, ann_tier_id FROM search.annotations WHERE ");
            queryString.append(" ann_tier_id ");
            queryString.append("IN (");
            for (int i = 0; i < 42; ++i) {
                queryString.append(" ?");
                queryString.append(i != 41 ? "," : " ");
            }
            queryString.append(")");
            queryString.append(" AND (ann_tier_id BETWEEN ? AND ?)");
            queryString.append(" AND ");
            if (this.pattern != null) {
                queryString.append(PostgresQuery.this.createQueryPatternPart(this.pattern, this.queryModes, this._regExpPattern, this._patternNOTMode));
            } else {
                logger.warn((Object)"QueryExecutor: Pattern empty");
                queryString.append(" 42 = 43");
            }
            queryString.append(PostgresQuery.this.createGlobalTimeConstraintPart());
            String query = PostgresQuery.this.convertRegexpPatternsForPostgres(queryString.toString());
            logger.debug((Object)("query: " + query.replaceAll("[?], [?, ]*", "... ")));
            try {
                this._getHitsInTier = this.con.prepareStatement(query);
                if (this._getHitsInTier.getMaxRows() == 0 || this._getHitsInTier.getMaxRows() > 500) {
                    this._getHitsInTier.setFetchSize(500);
                } else {
                    this._getHitsInTier.setFetchSize(this._getHitsInTier.getMaxRows() - 1);
                }
            }
            catch (SQLException e) {
                logger.debug((Object)("initQueryProperties SQLException: " + e));
                this._getHitsInTier = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long luceneStart = System.currentTimeMillis();
            if (PostgresQuery.this._luceneIndexDirectory != null) {
                try {
                    this._luceneQuery = new LuceneQuery(PostgresQuery.this._luceneIndexDirectory);
                    logger.debug((Object)("Opened Lucene index in " + (System.currentTimeMillis() - luceneStart) + " msec"));
                }
                catch (IOException ioe) {
                    logger.error((Object)("Failed to open Lucene index, not using it: " + PostgresQuery.this._luceneIndexDirectory + " IOException: " + ioe));
                }
            }
            this.initQueryProperties();
            if (this._getHitsInTier == null) {
                logger.error((Object)"initQueryProperties did not prepare statement, aborting query");
                try {
                    this.statement.close();
                    this.con.close();
                }
                catch (SQLException ex) {
                    logger.debug((Object)"closing connection", (Throwable)ex);
                }
                PostgresQuery.this.statistics.progress = 1.0f;
                PostgresQuery.this.isExecuting = false;
                return;
            }
            if (this.pattern == null || PostgresQuery.this.firstNonEmptyLayerIndex < 0 || PostgresQuery.this.firstNonEmptyPatternIndex < 0 || PostgresQuery.this._domainTiers.size() == 0) {
                if (PostgresQuery.this._domainTiers.size() > 0) {
                    logger.warn((Object)("Bad or empty query: " + (this.pattern == null ? "null" : "") + " at " + PostgresQuery.this.firstNonEmptyPatternIndex + "/" + PostgresQuery.this.firstNonEmptyLayerIndex));
                }
                PostgresQuery.this.statistics.progress = 1.0f;
                PostgresQuery.this.isExecuting = false;
                return;
            }
            ResultSet rs = null;
            try {
                String previousNodeId = "none";
                int previousTierId = -1;
                int whichParam = 1;
                int minTier = Integer.MAX_VALUE;
                int maxTier = Integer.MIN_VALUE;
                for (int i = 0; i < PostgresQuery.this._domainTiers.size(); ++i) {
                    int checkTierId = (Integer)PostgresQuery.this._domainTiers.get(i);
                    this._getHitsInTier.setInt(whichParam, checkTierId);
                    minTier = checkTierId < minTier ? checkTierId : minTier;
                    int n = maxTier = checkTierId > maxTier ? checkTierId : maxTier;
                    if (++whichParam <= 42 && i < PostgresQuery.this._domainTiers.size() - 1) continue;
                    while (whichParam <= 42) {
                        this._getHitsInTier.setInt(whichParam, Integer.MIN_VALUE);
                        ++whichParam;
                    }
                    this._getHitsInTier.setInt(whichParam++, minTier);
                    this._getHitsInTier.setInt(whichParam++, maxTier);
                    whichParam = 1;
                    rs = this._getHitsInTier.executeQuery();
                    boolean logLayerq = true;
                    boolean validNextLayers = true;
                    while (rs.next()) {
                        int annId = rs.getInt(1);
                        int tierId = rs.getInt(6);
                        String annotation = rs.getString(2);
                        if (PostgresQuery.this.isSimpleQuery) {
                            if (this.queryModes[0].equals(" Annotation")) {
                                long beginTime = SearchQuery.getValue(rs, 3);
                                long endTime = SearchQuery.getValue(rs, 4);
                                if (!PostgresQuery.this.isDurationInRange(endTime - beginTime)) continue;
                                PostgresQuery.this.updateFrequencyStatistics(annotation, annId, -1, PostgresQuery.this.firstNonEmptyLayerIndex, PostgresQuery.this.firstNonEmptyPatternIndex);
                                ++PostgresQuery.this.statistics.nAnnotationsWithHit;
                                int nHitsInAnnotation = 1;
                                if (PostgresQuery.this.patternNeedsFullStatistics) {
                                    nHitsInAnnotation = PostgresQuery.this.countHitsInAnnotation(annotation, this.queryModes, this.pattern, this._regExpPattern, this._patternNOTMode);
                                }
                                for (int j = 0; j < nHitsInAnnotation; ++j) {
                                    PostgresQuery.this.searchLayers[PostgresQuery.this.firstNonEmptyLayerIndex].setHitAnnIdForPattern(PostgresQuery.this.firstNonEmptyPatternIndex, PostgresQuery.this.statistics.nHits, annId);
                                    PostgresQuery.this.searchLayers[PostgresQuery.this.firstNonEmptyLayerIndex].setHitNumberForPattern(PostgresQuery.this.firstNonEmptyPatternIndex, PostgresQuery.this.statistics.nHits, j + 1);
                                    ++PostgresQuery.this.statistics.nHits;
                                }
                            } else {
                                String[] nGrams;
                                if (this.queryModes[0].equals(" N-gram over annotations")) {
                                    PostgresQuery.this.nGramSizeLeftFromHit = SearchQuery.getLongestNonWildcardPartPosition(this.pattern);
                                    PostgresQuery.this.nGramSizeRightFromHit = PostgresQuery.this.getNGramLength(this.pattern) - PostgresQuery.this.nGramSizeLeftFromHit - 1;
                                }
                                if ((nGrams = PostgresQuery.this.constructNGrams(annId, this.statement, null, this.pattern, this.queryModes)) != null) {
                                    boolean frequencyStatisticsUpdated = false;
                                    boolean firstNAnnotationsUpdate = true;
                                    int hitNumber = 1;
                                    for (int j = 0; j < nGrams.length; ++j) {
                                        String nGram = nGrams[j];
                                        if (!PostgresQuery.this.isNGramMatch(nGram, this.pattern, this.queryModes)) continue;
                                        if (!frequencyStatisticsUpdated) {
                                            nGram = nGram.replace("xxxSAFE_SPLITTERxxx", " ");
                                            PostgresQuery.this.updateFrequencyStatistics(nGram, annId, -1, PostgresQuery.this.firstNonEmptyLayerIndex, PostgresQuery.this.firstNonEmptyPatternIndex);
                                            frequencyStatisticsUpdated = true;
                                        }
                                        if (this.queryModes[0].equals(" N-gram over annotations") || firstNAnnotationsUpdate) {
                                            ++PostgresQuery.this.statistics.nAnnotationsWithHit;
                                            firstNAnnotationsUpdate = false;
                                        }
                                        PostgresQuery.this.searchLayers[PostgresQuery.this.firstNonEmptyLayerIndex].setHitAnnIdForPattern(PostgresQuery.this.firstNonEmptyPatternIndex, PostgresQuery.this.statistics.nHits, annId);
                                        PostgresQuery.this.searchLayers[PostgresQuery.this.firstNonEmptyLayerIndex].setHitNumberForPattern(PostgresQuery.this.firstNonEmptyPatternIndex, PostgresQuery.this.statistics.nHits, hitNumber++);
                                        ++PostgresQuery.this.statistics.nHits;
                                    }
                                }
                            }
                        } else {
                            String currentNodeId;
                            if (tierId != previousTierId) {
                                if (!validNextLayers) {
                                    // empty if block
                                }
                                validNextLayers = true;
                                previousTierId = tierId;
                            }
                            if (!(currentNodeId = NodeIdUtils.TONODEID((int)(tierId / 256))).equals(previousNodeId)) {
                                previousNodeId = currentNodeId;
                                if (PostgresQuery.this.isMultipleLayerQuery) {
                                    boolean bl = validNextLayers = !PostgresQuery.this.setTierDomainForLayers(true, this.con, currentNodeId);
                                }
                            }
                            if (PostgresQuery.this.isMultipleLayerQuery && !validNextLayers) continue;
                            PostgresQuery.this.clearHitData(-1);
                            PostgresQuery.this.globalHitAnnId[PostgresQuery.this.firstNonEmptyLayerIndex][PostgresQuery.this.firstNonEmptyPatternIndex] = annId;
                            PostgresQuery.this.globalHitTierId[PostgresQuery.this.firstNonEmptyLayerIndex][PostgresQuery.this.firstNonEmptyPatternIndex] = tierId;
                            PostgresQuery.this.globalHitBeginTime[PostgresQuery.this.firstNonEmptyLayerIndex][PostgresQuery.this.firstNonEmptyPatternIndex] = SearchQuery.getValue(rs, 3);
                            PostgresQuery.this.globalHitEndTime[PostgresQuery.this.firstNonEmptyLayerIndex][PostgresQuery.this.firstNonEmptyPatternIndex] = SearchQuery.getValue(rs, 4);
                            PostgresQuery.this.globalHitPosition[PostgresQuery.this.firstNonEmptyLayerIndex][PostgresQuery.this.firstNonEmptyPatternIndex] = rs.getInt(5);
                            PostgresQuery.this.investigateComplexPattern(PostgresQuery.this.firstNonEmptyLayerIndex, PostgresQuery.this.firstNonEmptyPatternIndex, this.con, logLayerq);
                            logLayerq = false;
                        }
                        if (PostgresQuery.this.keepExecuting) continue;
                        break;
                    }
                    rs.close();
                    if (i == PostgresQuery.this._domainTiers.size() - 1 || PostgresQuery.this._domainTiers.size() == 0) {
                        PostgresQuery.this.statistics.progress = 1.0f;
                    } else {
                        float realProgress = (float)i / (float)PostgresQuery.this._domainTiers.size();
                        if (realProgress > PostgresQuery.this.statistics.progress) {
                            PostgresQuery.this.statistics.progress = realProgress;
                        }
                    }
                    if (!PostgresQuery.this.keepExecuting) break;
                }
                PostgresQuery.this.statistics.progress = 1.0f;
            }
            catch (SQLException e) {
                logger.warn((Object)"exception during query execution", (Throwable)e);
                PostgresQuery.this.statistics.progress = 1.0f;
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException e2) {
                        logger.debug((Object)("SQLException closing ResultSet during finally part of query execution: " + e2));
                    }
                }
                try {
                    this.con.close();
                    this._getHitsInTier.close();
                }
                catch (SQLException ex) {
                    logger.debug((Object)"exception during finally part of query execution", (Throwable)ex);
                }
                if (this._luceneQuery != null) {
                    try {
                        this._luceneQuery.close();
                    }
                    catch (IOException ioe) {
                        logger.warn((Object)("IOException closing LuceneQuery object during finally part of query execution: " + ioe));
                    }
                }
            }
            String modeDescription = this.queryModes[0].equals(" Annotation") ? "" : (this.queryModes[0].equals(" N-gram over annotations") ? "N-grams over " : "N-grams within ");
            modeDescription = modeDescription + "case " + (this.queryModes[1].equals(" case sensitive") ? "" : "in") + "sensitive anno, ";
            modeDescription = modeDescription + (this.queryModes[2].equals(" exact match") ? "exact" : (this.queryModes[2].equals(" substring match") ? "substring" : "regexp"));
            logger.debug((Object)("Query finished: '" + PostgresQuery.this.searchLayers[PostgresQuery.this.firstNonEmptyLayerIndex].getPattern(PostgresQuery.this.firstNonEmptyPatternIndex) + "' [" + modeDescription + "] took: " + PostgresQuery.this.statistics.getAge() + " msec, hits: " + PostgresQuery.this.statistics.nHits));
            PostgresQuery.this.isExecuting = false;
        }
    }
}

