/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.annot.search.lib;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import java.util.regex.Pattern;
import nl.mpi.annot.search.lib.SearchLayer;
import nl.mpi.annot.search.lib.SearchQuery;
import nl.mpi.annot.tools.util.UTF8Validator;
import org.apache.log4j.Logger;

public class PostgresQueryHelpers {
    private static Logger logger = Logger.getLogger((String)"Searchlib.PostgresQueryHelpers");

    public static String createQueryPatternPart(String pattern, String[] queryModes, boolean patternNOTMode) {
        String exclam;
        if (queryModes[2].equals(" regular expression")) {
            try {
                Pattern.compile(pattern);
            }
            catch (RuntimeException re) {
                logger.warn((Object)("Invalid regular expression according to Java: '" + pattern + "' Error: " + re));
                return "42 = 43";
            }
            if (pattern.matches(".*\\\\[0-9].*")) {
                logger.warn((Object)("Rejected pattern with digit after backslash: '" + pattern + "'"));
                return "42 = 43";
            }
        }
        String queryPart = "";
        boolean patternNeedsFullStatistics = false;
        boolean caseSensitive = queryModes[1].equals(" case sensitive");
        String like = caseSensitive ? "LIKE" : "ILIKE";
        String tilde = caseSensitive ? "~" : "~*";
        String not = patternNOTMode ? "NOT " : "";
        String string = exclam = patternNOTMode ? "!" : "";
        if (queryModes[0].equals(" Annotation")) {
            if (queryModes[2].equals(" exact match")) {
                queryPart = caseSensitive ? "annotation " + exclam + "= E'" + PostgresQueryHelpers.escapeEString(pattern) + "'" : "LOWER(annotation) " + exclam + "= E'" + PostgresQueryHelpers.escapeEString(pattern.toLowerCase()) + "'";
            } else if (queryModes[2].equals(" substring match")) {
                patternNeedsFullStatistics = !patternNOTMode;
                queryPart = "annotation " + not + like + " E'%" + PostgresQueryHelpers.escapeELikeTilde(pattern) + "%' ESCAPE '~'";
            } else if (queryModes[2].equals(" regular expression")) {
                if (pattern.equals(".*")) {
                    queryPart = "" + !patternNOTMode;
                } else {
                    patternNeedsFullStatistics = !patternNOTMode;
                    queryPart = "annotation " + exclam + tilde + " E'" + PostgresQueryHelpers.escapeEString(pattern) + "'";
                }
            } else {
                logger.warn((Object)("Mode is neither EXACT nor SUBSTRING nor REGEXP for ANNOTATIONS but: " + queryModes[2]));
                queryPart = "42 = 43";
            }
        } else if (queryModes[0].equals(" N-gram over annotations") || queryModes[0].equals(" N-gram within annotation")) {
            String nGramPart = SearchQuery.getLongestNonWildcardPart(pattern);
            boolean bl = patternNeedsFullStatistics = !patternNOTMode;
            if (queryModes[2].equals(" regular expression")) {
                if (queryModes[0].equals(" N-gram within annotation")) {
                    if (nGramPart.startsWith("^")) {
                        nGramPart = nGramPart.substring(1);
                    }
                    if (nGramPart.endsWith("$")) {
                        nGramPart = nGramPart.substring(0, nGramPart.length() - 1);
                    }
                }
                queryPart = pattern.equals(".*") ? "" + !patternNOTMode : "annotation " + exclam + tilde + " E'" + PostgresQueryHelpers.escapeEString(nGramPart) + "'";
            } else {
                queryPart = "annotation " + not + like + " E'%" + PostgresQueryHelpers.escapeELikeTilde(nGramPart) + "%' ESCAPE '~'";
            }
        } else {
            logger.warn((Object)("Mode is neither ANNOTATIONS nor N_GRAMS_WITHIN_ANNOTATIONS nor N_GRAMS_OVER_ANNOTATIONS but: " + queryModes[0] + " (" + queryModes[1] + "/" + queryModes[2] + ")"));
            queryPart = "42 = 43";
        }
        if (patternNeedsFullStatistics) {
            return "*" + queryPart;
        }
        return queryPart;
    }

    public static List<String> gatherKeywords(SearchLayer searchLayer) {
        ArrayList<String> keywords = new ArrayList<String>();
        for (int i = 0; i < searchLayer.getNumberOfPatterns(); ++i) {
            String[] modes;
            if (searchLayer.getPatternNOTMode(i) || (modes = searchLayer.getMode(i)) == null) continue;
            if (searchLayer.getRegExpPattern(i) != null) {
                keywords.addAll(PostgresQueryHelpers.dissectRegexp(searchLayer.getPattern(i)));
                continue;
            }
            if (" Annotation".equals(modes[0])) {
                keywords.add(searchLayer.getPattern(i));
                continue;
            }
            String[] parts = searchLayer.getPattern(i).split(" +");
            for (int j = 0; j < parts.length; ++j) {
                if ("#".equals(parts[j]) || SearchLayer.isNOTPattern(parts[j])) continue;
                keywords.add(parts[j]);
            }
        }
        return keywords;
    }

    public static String constructCandidateConstraint(SearchLayer searchLayer, boolean shallow) {
        String constraint;
        String lengthHint;
        List<String> keywords = PostgresQueryHelpers.gatherKeywords(searchLayer);
        boolean exactMatch = false;
        for (int i = 0; i < searchLayer.getNumberOfPatterns(); ++i) {
            if (searchLayer.getPatternNOTMode(i) || searchLayer.getMode(i) == null || !" exact match".equals(searchLayer.getMode(i)[2])) continue;
            exactMatch = true;
        }
        int unigram_bits = 0;
        int language_bits = 0;
        long length_bits = 0L;
        int[] bigram_bits = UTF8Validator.fingerprintBigrams((String)"");
        int[] trigram_bits = UTF8Validator.fingerprintTrigrams((String)"");
        int[] fourgram_bits = UTF8Validator.fingerprint4grams((String)"");
        int minLength = 0;
        for (int i = 0; i < keywords.size(); ++i) {
            int keywordLength = keywords.get(i).length();
            minLength = minLength > keywordLength ? minLength : keywordLength;
            unigram_bits |= UTF8Validator.fingerprintChars((String)keywords.get(i));
            language_bits |= UTF8Validator.fingerprintLanguages((String)keywords.get(i));
            if (exactMatch) {
                length_bits |= 1L << UTF8Validator.binLength((int)keywordLength);
            }
            int[] bigram_bits_keyword = UTF8Validator.fingerprintBigrams((String)keywords.get(i));
            for (int j = 0; j < bigram_bits.length; ++j) {
                int n = j;
                bigram_bits[n] = bigram_bits[n] | bigram_bits_keyword[j];
            }
            int[] trigram_bits_keyword = UTF8Validator.fingerprintTrigrams((String)keywords.get(i));
            for (int j = 0; j < trigram_bits.length; ++j) {
                int n = j;
                trigram_bits[n] = trigram_bits[n] | trigram_bits_keyword[j];
            }
            int[] fourgram_bits_keyword = UTF8Validator.fingerprint4grams((String)keywords.get(i));
            for (int j = 0; j < fourgram_bits.length; ++j) {
                int n = j;
                fourgram_bits[n] = fourgram_bits[n] | fourgram_bits_keyword[j];
            }
        }
        if (!exactMatch) {
            length_bits = 1L << UTF8Validator.binLength((int)minLength);
            lengthHint = "length_bits >= " + length_bits + " AND ";
        } else {
            lengthHint = "~length_bits & " + length_bits + " = 0 AND ";
        }
        String bigram_string = UTF8Validator.hexifyBits((int[])bigram_bits);
        String trigram_string = UTF8Validator.hexifyBits((int[])trigram_bits);
        if (minLength >= 4) {
            String fourgram_string = UTF8Validator.hexifyBits((int[])fourgram_bits);
            String constraint2 = lengthHint + "~fourgram_bits & X'" + fourgram_string + "' = 0::bit(" + fourgram_string.length() * 4 + ") AND fourgram_bits IS NOT NULL";
            if (shallow) {
                return constraint2 + " AND ~unigram_bits & " + unigram_bits + " = 0";
            }
            return constraint2 + " AND " + "~trigram_bits & X'" + trigram_string + "' = 0::bit(" + trigram_string.length() * 4 + ") AND " + "~bigram_bits & X'" + bigram_string + "' = 0::bit(" + bigram_string.length() * 4 + ") AND " + "~unigram_bits & " + unigram_bits + " = 0 AND " + "unigram_bits >= " + unigram_bits + " AND " + "~language_bits & " + language_bits + " = 0 AND " + "language_bits >= " + language_bits;
        }
        if (minLength >= 3) {
            constraint = lengthHint + "~trigram_bits & X'" + trigram_string + "' = 0::bit(" + trigram_string.length() * 4 + ") AND trigram_bits IS NOT NULL";
            if (shallow) {
                return constraint + " AND ~unigram_bits & " + unigram_bits + " = 0";
            }
            return constraint + " AND " + "~bigram_bits & X'" + bigram_string + "' = 0::bit(" + bigram_string.length() * 4 + ") AND " + "~unigram_bits & " + unigram_bits + " = 0 AND " + "unigram_bits >= " + unigram_bits + " AND " + "~language_bits & " + language_bits + " = 0 AND " + "language_bits >= " + language_bits;
        }
        if (minLength >= 2) {
            constraint = lengthHint + "~bigram_bits & X'" + bigram_string + "' = 0::bit(" + bigram_string.length() * 4 + ") AND bigram_bits IS NOT NULL";
            if (shallow) {
                return constraint + " AND ~unigram_bits & " + unigram_bits + " = 0";
            }
            return constraint + " AND " + "~unigram_bits & " + unigram_bits + " = 0 AND " + "unigram_bits >= " + unigram_bits + " AND " + "~language_bits & " + language_bits + " = 0 AND " + "language_bits >= " + language_bits;
        }
        if (minLength >= 1) {
            constraint = lengthHint + "~unigram_bits & " + unigram_bits + " = 0 AND " + "unigram_bits >= " + unigram_bits;
            if (shallow) {
                return constraint;
            }
            return constraint + " AND " + "~language_bits & " + language_bits + " = 0 AND " + "language_bits >= " + language_bits;
        }
        return "TRUE";
    }

    public static Collection<String> dissectRegexp(String regexp) {
        HashSet<String> retval = new HashSet<String>();
        if (regexp.startsWith("***=")) {
            retval.add(regexp);
            return retval;
        }
        if (regexp.startsWith("***:")) {
            regexp = regexp.substring(4);
        }
        String simpler = regexp.replaceAll("\\\\\\\\", " ");
        simpler = simpler.replaceAll("[.^$]", " ");
        simpler = simpler.replaceAll("\\\\[0-9]{1,3}", " ").replaceAll("\\\\x[0-9a-fA-F]{2}", " ").replaceAll("\\\\u[0-9a-fA-F]{4}", " ").replaceAll("\\\\c.", " ").replaceAll("\\\\[tnrfaevbBmMdDsSwWyYZ0A1-9]", " ").replaceAll("\\\\[^a-zA-Z0-9]", " ");
        simpler = simpler.replaceAll("\\{([^0-9])", " $1");
        simpler = simpler.replaceAll("\\[[^\\]]*\\]+", " ");
        simpler = simpler.replaceAll("\\([^)(]*\\)", " ");
        simpler = simpler.replaceAll("\\(.*\\)", " ");
        if ((simpler = simpler.replaceAll(".\\{0[^\\}]*\\}[?]?", " ").replaceAll("\\{[^\\}]*\\}[?]?", "").replaceAll("[+][?+]?", "").replaceAll(".[?*][?+]?", " ")).indexOf(124) != -1) {
            return retval;
        }
        String[] tokens = simpler.split("\\s+");
        for (int i = 0; i < tokens.length; ++i) {
            if (tokens[i].length() <= 0) continue;
            retval.add(tokens[i]);
        }
        return retval;
    }

    public static String constructTierConstraintAtom(String field, String prefix, String value) {
        int prefixLength = prefix.length();
        StringBuilder atom = new StringBuilder();
        atom.append(' ').append(field).append(" = E'");
        atom.append(PostgresQueryHelpers.escapeEString(value.substring(prefixLength)));
        atom.append('\'');
        return atom.toString();
    }

    public static String escapeELikeTilde(String string) {
        String s = PostgresQueryHelpers.escapeEString(string).replaceAll("~", "~~");
        s = s.replaceAll("%", "~%");
        return s.replaceAll("_", "~_");
    }

    public static String escapeEString(String rawstring) {
        String s = rawstring.replaceAll("'", "''");
        return s.replaceAll("\\\\", "\\\\\\\\");
    }

    public static void main(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            System.out.println("Dissecting regexp: '" + args[i] + "'");
            Collection<String> words = PostgresQueryHelpers.dissectRegexp(args[i]);
            TreeSet<String> sortedWords = new TreeSet<String>();
            sortedWords.addAll(words);
            for (String word : sortedWords) {
                System.out.println("\t'" + word + "'");
            }
        }
    }
}

