/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.annot.search.lib;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import nl.mpi.annot.search.lib.MultiPostgresQuery;
import nl.mpi.annot.search.lib.PostgresQuery;
import nl.mpi.annot.search.lib.QueryServer;
import nl.mpi.annot.search.lib.SearchHit;
import nl.mpi.annot.search.lib.SearchStatistics;
import nl.mpi.annot.search.lib.TierCollection;
import nl.mpi.annot.search.lib.WritePostgreSQL;
import nl.mpi.annot.tools.data.AnnexFileTypes;
import nl.mpi.annot.tools.data.CorpusStructDB;

public class SearchClient {
    private final String url;
    private final String usr;
    private final String pwd;
    private final File luceneIndexDirectory;
    private final WritePostgreSQL writer;

    public SearchClient(String jdbc, String user, String pass) throws SQLException {
        this(jdbc, user, pass, null);
    }

    public SearchClient(String jdbc, String user, String pass, File luceneDir) throws SQLException {
        this.url = jdbc;
        if (user == null || pass == null) {
            System.err.println("User or password not set");
        }
        this.usr = user;
        this.pwd = pass;
        this.luceneIndexDirectory = luceneDir;
        this.writer = new WritePostgreSQL(this.url, this.usr, this.pwd);
    }

    public SearchClient(String corpusDbUrl, String corpusDbUser, String corpusDbPwd, File luceneDir, String searchDbUrl, String searchDbUser, String searchDbPwd) throws SQLException {
        CorpusStructDB.setCorpusDB((String)corpusDbUrl, (String)corpusDbUser, (String)corpusDbPwd);
        this.url = searchDbUrl;
        this.usr = searchDbUser;
        this.pwd = searchDbPwd;
        this.luceneIndexDirectory = luceneDir;
        this.writer = new WritePostgreSQL(searchDbUrl, searchDbUser, searchDbPwd);
    }

    public SearchClient getNewSearchClient() throws SQLException {
        return new SearchClient(this.url, this.usr, this.pwd, this.luceneIndexDirectory);
    }

    public static String[] getSearchableFormats() {
        ArrayList<String> formats = new ArrayList<String>();
        for (int i = 0; i < AnnexFileTypes.getFileTypeCount(); ++i) {
            formats.addAll(Arrays.asList(AnnexFileTypes.getMimeTypesForParserType((int)i)));
        }
        return formats.toArray(new String[formats.size()]);
    }

    public void close() {
        this.writer.close();
    }

    public QueryServer createQuery(int numberOfThreads) throws IOException, SQLException {
        if (numberOfThreads <= 1) {
            return new PostgresQuery(this.url, this.usr, this.pwd, this.luceneIndexDirectory, "SingleThreaded_" + System.currentTimeMillis());
        }
        return new MultiPostgresQuery(this.url, this.usr, this.pwd, this.luceneIndexDirectory, numberOfThreads);
    }

    public synchronized void add(String nodeId) throws SQLException {
        this.writer.addNode(nodeId);
    }

    public synchronized void remove(String nodeId) throws SQLException {
        this.writer.removeNode(nodeId);
    }

    public synchronized void update(String nodeId) throws SQLException {
        this.remove(nodeId);
        this.add(nodeId);
    }

    public PreparedStatement getPreparedStatement(String statement) throws SQLException {
        return this.writer.getPreparedStatement(statement);
    }

    private static void log(String what) {
        System.out.println(what);
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            SearchClient.log("Usage: java -cp ... nl.mpi.annot.search.lib.SearchClient your.properties term[s]");
            SearchClient.log("");
            SearchClient.log("Full example - log4jconfig/ is a DIRECTORY with a log4j.properties file!");
            SearchClient.log("java -cp log4jconfig/:annot-search-lib-1.2.jar:annot-tools-1.1.2.jar:corpusstructure-api-1.7.5.jar:log4j-1.2.16.jar:lucene-core-3.6.0.jar:mpi-util-1.0.0.jar:postgresql8jdbc3.jar:xercesImpl-2.9.0.jar:xml-apis-1.3.04.jar nl.mpi.annot.search.lib.SearchClient searchclient.properties elephant elefant olifant");
            SearchClient.log("");
            SearchClient.log("Example log4j.properties content:");
            SearchClient.log("log4j.rootCategory=INFO, stdout");
            SearchClient.log("log4j.appender.stdout=org.apache.log4j.ConsoleAppender");
            SearchClient.log("log4j.appender.stdout.layout=org.apache.log4j.PatternLayout");
            SearchClient.log("log4j.appender.stdout.layout.ConversionPattern=%5p (%F:%L) - %m%n");
            SearchClient.log("log4j.logger.nl.mpi.annot=debug");
            SearchClient.log("");
            SearchClient.log("An example searchclient.properties can be found in annot-search-lib-*.jar!");
            return;
        }
        Properties props = new Properties(System.getProperties());
        SearchClient.log("user.language='" + props.getProperty("user.language", "[UNSET]") + "'");
        SearchClient.log("user.region='" + props.getProperty("user.region", "[UNSET]") + "'");
        SearchClient.log("file.encoding='" + props.getProperty("file.encoding", "[UNSET]") + "'");
        try {
            props.load(new FileInputStream(args[0]));
        }
        catch (IOException ioe) {
            SearchClient.log("Could not read config file: " + args[0]);
            return;
        }
        long bootTime = System.currentTimeMillis();
        if (props.getProperty("corpusstructuredb.url") != null) {
            CorpusStructDB.setCorpusDB((String)props.getProperty("corpusstructuredb.url"), (String)props.getProperty("corpusstructuredb.user", "imdiArchive"), (String)props.getProperty("corpusstructuredb.pass", ""));
        }
        File luceneDir = null;
        if (props.getProperty("lucene.indexdir") != null) {
            luceneDir = new File(props.getProperty("lucene.indexdir"));
        }
        SearchClient search = null;
        try {
            search = new SearchClient(props.getProperty("searchdb.url"), props.getProperty("searchdb.user"), props.getProperty("searchdb.pass"), luceneDir);
        }
        catch (SQLException sqle) {
            SearchClient.log("Cannot connect to search database! " + sqle);
            return;
        }
        int queryThreads = Integer.parseInt(props.getProperty("query.threads", "1"));
        int tierCollectionThreads = Integer.parseInt(props.getProperty("tiercollection.threads", "1"));
        SearchClient.log("Query threads: " + queryThreads + " TierCollection threads: " + tierCollectionThreads + " CPU cores: " + Runtime.getRuntime().availableProcessors() + " Lucene: " + (luceneDir == null ? "n/a" : ".../" + luceneDir.getName()));
        SearchClient.log("Memory: " + Runtime.getRuntime().freeMemory() + " of " + Runtime.getRuntime().totalMemory() + " free");
        QueryServer query = null;
        try {
            query = search.createQuery(queryThreads);
        }
        catch (IOException ioe) {
            SearchClient.log("Cannot create query object! I/O error: " + ioe);
            search.close();
            return;
        }
        catch (SQLException sqle) {
            SearchClient.log("Cannot create query object! SQL error: " + sqle);
            search.close();
            return;
        }
        long connectTime = System.currentTimeMillis();
        SearchClient.log("Took " + (connectTime - bootTime) + " msec to connect to databases and indexes");
        String[] topNodeIds = new String[]{};
        if (props.getProperty("query.topnodes") != null) {
            topNodeIds = props.getProperty("query.topnodes").split(",");
        }
        TierCollection domain = new TierCollection(tierCollectionThreads, search, props.getProperty("query.user"), Arrays.asList(topNodeIds));
        long domainTime = System.currentTimeMillis();
        SearchClient.log("");
        SearchClient.log("Took " + (domainTime - connectTime) + " msec to gather properties of search domain below: " + Arrays.asList(topNodeIds) + " for user: " + props.getProperty("query.user"));
        for (int i = 0; i < AnnexFileTypes.getFileTypeCount(); ++i) {
            SearchClient.log(AnnexFileTypes.getFileTypeName((int)i) + ": " + domain.getInfoForType(i));
        }
        SearchClient.log("");
        long maxWait = Long.parseLong(props.getProperty("query.maxcomputetime", "3600000"));
        int wantedHits = Integer.parseInt(props.getProperty("query.wantedhitcount", "2147483647"));
        String searchMode = props.getProperty("query.searchmode", " Annotation");
        boolean caseSensitive = "true".equals(props.getProperty("query.casesensitive", "false"));
        String matchMode = props.getProperty("query.matchmode", " substring match");
        ArrayList<String> tierConstraints = null;
        long minDuration = Long.parseLong(props.getProperty("query.minimalduration", "-1"));
        long maxDuration = Long.parseLong(props.getProperty("query.maximalduration", "-1"));
        long minStart = Long.parseLong(props.getProperty("query.minimalstarttime", "-1"));
        long maxEnd = Long.parseLong(props.getProperty("query.maximalendtime", "-1"));
        for (int i = 1; i < args.length; ++i) {
            SearchStatistics stats;
            long startTime = System.currentTimeMillis();
            long deadline = startTime + maxWait;
            List<Integer> fileTypes = null;
            query.setSimpleQuery(args[i], searchMode, !caseSensitive, matchMode, tierConstraints);
            if (minDuration > 0L || maxDuration > 0L || minStart > 0L || maxEnd > 0L) {
                query.setGlobalTimeConstraints(minDuration, maxDuration, minStart, maxEnd);
            }
            query.doQuery(domain, fileTypes, null);
            do {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ie) {
                    SearchClient.log("yawn");
                }
                stats = query.getSearchStatistics();
                if (System.currentTimeMillis() > deadline) {
                    query.cancelQuery();
                }
                if (stats.nHits <= wantedHits) continue;
                query.cancelQuery();
            } while (query.isRunning());
            long endTime = System.currentTimeMillis();
            int nHits = stats.nHits;
            SearchClient.log("Took " + (endTime - startTime) + " msec to get " + (nHits >= wantedHits ? "first" : (endTime > deadline ? "first (timeout)" : "all")) + " " + nHits + " hits for: '" + args[i] + "'");
            int contextSize = Integer.parseInt(props.getProperty("results.contextsize", "0"));
            boolean verboseHits = "true".equals(props.getProperty("results.verbose", "false"));
            int from = 0;
            int n = 1;
            if ("true".equals(props.getProperty("results.show", "false"))) {
                do {
                    int chunkSize;
                    if (from + (chunkSize = 1000) > nHits) {
                        chunkSize = nHits - from;
                    }
                    ArrayList<SearchHit> hits = query.getHits(from, chunkSize, contextSize);
                    for (SearchHit hit : hits) {
                        StringBuilder hitText = new StringBuilder(64);
                        hitText.append(hit.transcriptionNodeId).append(" ");
                        if (verboseHits) {
                            hitText.append("File[").append(hit.transcriptionName).append("] ");
                            hitText.append("[").append(hit.beginTime).append(";").append(hit.endTime).append("] ");
                            hitText.append(hit.aligned ? "aligned " : "unaligned ");
                            hitText.append("#").append(hit.hitNumberInAnnotation).append(" ");
                            hitText.append("@").append(hit.hitPositionInAnnotation).append("-");
                            hitText.append(hit.hitPositionInAnnotation + hit.hitLength).append(" ");
                            hitText.append("@#").append(hit.positionInTier).append(" ");
                            hitText.append("Tier[").append(hit.tierName).append(", ");
                            hitText.append(hit.tierType).append(", ");
                            hitText.append(hit.participant == null ? "[noparticipant]" : hit.participant).append(", ");
                            hitText.append(hit.annotator == null ? "[noannotator]" : hit.annotator).append("] ");
                            hitText.append("Text: ");
                        }
                        Collections.reverse(hit.leftContext);
                        for (String left : hit.leftContext) {
                            hitText.append(left).append("  ");
                        }
                        if (hit.complex) {
                            hitText.append("Complex[");
                        }
                        hitText.append(hit.annotation);
                        if (hit.complex) {
                            hitText.append("]");
                        }
                        for (String right : hit.rightContext) {
                            hitText.append("  ").append(right);
                        }
                        SearchClient.log("Hit " + n + ": " + hitText.toString());
                        ++n;
                    }
                    from += chunkSize;
                    if (hits.size() >= chunkSize) continue;
                    SearchClient.log("Encountered early end of hit list at offset: " + (from + hits.size()) + " expected hits: " + nHits);
                    break;
                } while (from < nHits);
            }
            if (!"true".equals(props.getProperty("results.show", "false"))) continue;
            SearchClient.log("Took " + (System.currentTimeMillis() - endTime) + " msec to show " + nHits + " hits for: '" + args[i] + "'");
        }
        search.close();
        long oldFreeMemory = Runtime.getRuntime().freeMemory();
        Runtime.getRuntime().gc();
        SearchClient.log("Memory: " + Runtime.getRuntime().freeMemory() + " (before GC: " + oldFreeMemory + ") of " + Runtime.getRuntime().totalMemory() + " free");
    }
}

