/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.annot.search.lib;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nl.mpi.annot.search.lib.FrequencyInfo;
import nl.mpi.annot.search.lib.FrequencyInfoTools;
import nl.mpi.annot.search.lib.SearchLayer;
import nl.mpi.annot.search.lib.SearchStatistics;
import nl.mpi.annot.tools.util.UnicodeNormalizer;
import org.apache.log4j.Logger;

public abstract class SearchQuery {
    private static Logger _logger = Logger.getLogger((String)"Searchlib.SearchQuery");
    protected final String schemaName;
    protected ArrayList<FrequencyInfo> orderedFrequencyInfoByAnnotation = new ArrayList();
    protected ArrayList<FrequencyInfo> orderedFrequencyInfoByFrequency = new ArrayList();
    protected HashMap<String, FrequencyInfo> frequencyMap = new HashMap();
    protected SearchStatistics statistics = new SearchStatistics();
    protected boolean patternNeedsFullStatistics;
    protected int firstNonEmptyLayerIndex;
    protected int firstNonEmptyPatternIndex;
    protected boolean isSimpleQuery;
    protected boolean isMultipleLayerQuery;
    protected boolean isExecuting;
    protected boolean keepExecuting;
    protected int nGramSizeLeftFromHit;
    protected int nGramSizeRightFromHit;
    protected int nLayers;
    protected int nPatternsPerLayer;
    protected SearchLayer[] searchLayers;
    protected int[][] globalHitAnnId;
    protected int[][] globalHitTierId;
    protected int[][] globalHitPosition;
    protected long[][] globalHitBeginTime;
    protected long[][] globalHitEndTime;
    protected int globalHitFileId = -1;
    private PreparedStatement _prepStatComplexHitResultData;
    private PreparedStatement _prepStatCheckValidDuration;
    private long _minimalDuration = 0L;
    private long _maximalDuration = 0L;
    private long _beginAfter = 0L;
    private long _endBefore = 0L;
    protected String fullTranscriptionTierDomain;
    protected boolean thereIsALayerWithAnEmptyTierDomain;

    public SearchQuery(Integer index) {
        this.schemaName = "search" + (index == null ? "" : index.toString());
    }

    public void setSimpleQuery(String pattern, String matchScope, boolean caseInsensitive, String matchMode, ArrayList<String> tierConstraints) {
        if (pattern == null || pattern.length() == 0) {
            throw new IllegalArgumentException("Pattern must not be empty");
        }
        if (!(" Annotation".equals(matchScope) || " N-gram over annotations".equals(matchScope) || " N-gram within annotation".equals(matchScope))) {
            throw new IllegalArgumentException("Invalid matchScope");
        }
        if (!(" exact match".equals(matchMode) || " substring match".equals(matchMode) || " regular expression".equals(matchMode))) {
            throw new IllegalArgumentException("Invalid matchMode");
        }
        this.setQueryMatrixDimensions(1, 1);
        this.isMultipleLayerQuery = false;
        this.isSimpleQuery = true;
        String normalized = UnicodeNormalizer.normalizeToNFC((String)pattern, (String)" in setSimpleQuery");
        String denormalized = UnicodeNormalizer.checkNFC((String)normalized);
        if (denormalized != null || !normalized.equals(pattern)) {
            if (denormalized != null) {
                _logger.warn((Object)("Could not normalize simple pattern: " + denormalized));
            }
            pattern = normalized;
        }
        String mode = matchScope + "xxxMODE_SPLITTERxxx" + (caseInsensitive ? " case insensitive" : " case sensitive") + "xxxMODE_SPLITTERxxx" + matchMode;
        this.searchLayers[0].addPattern(pattern, mode, "cns none", "cns none");
        this.firstNonEmptyLayerIndex = 0;
        this.firstNonEmptyPatternIndex = 0;
        if (tierConstraints != null && !tierConstraints.contains(" All Tiers ")) {
            for (int i = 0; i < tierConstraints.size(); ++i) {
                this.searchLayers[0].addTierConstraint(tierConstraints.get(i));
            }
        }
    }

    public void setGlobalTimeConstraints(long minDuration, long maxDuration, long minStart, long maxEnd) {
        this._minimalDuration = minDuration;
        this._maximalDuration = maxDuration;
        this._beginAfter = minStart;
        this._endBefore = maxEnd;
    }

    private synchronized void setQueryMatrixDimensions(int layers, int patterns) {
        this.firstNonEmptyLayerIndex = -1;
        this.firstNonEmptyPatternIndex = -1;
        this._prepStatComplexHitResultData = null;
        this._prepStatCheckValidDuration = null;
        this.nLayers = layers;
        this.nPatternsPerLayer = patterns;
        this.searchLayers = new SearchLayer[layers];
        for (int i = 0; i < layers; ++i) {
            this.searchLayers[i] = new SearchLayer();
        }
        this.globalHitAnnId = new int[layers][patterns];
        this.globalHitTierId = new int[layers][patterns];
        this.globalHitPosition = new int[layers][patterns];
        this.globalHitBeginTime = new long[layers][patterns];
        this.globalHitEndTime = new long[layers][patterns];
    }

    public static long getValue(ResultSet rs, int column) throws SQLException {
        if (rs.getMetaData().getColumnType(column) == -5) {
            return rs.getLong(column);
        }
        return rs.getInt(column);
    }

    public static ArrayList<String> getSearchModes() {
        ArrayList<String> modes = new ArrayList<String>();
        String[] targetModes = " Annotation; N-gram over annotations; N-gram within annotation".split(";");
        String[] caseModes = " case insensitive; case sensitive".split(";");
        String[] matchModes = " substring match; exact match; regular expression".split(";");
        String[] interTierConstraintModes = " Must be in same file; Must be parent and child; Must have same parent".split(";");
        modes.add(Integer.toString(targetModes.length));
        Collections.addAll(modes, targetModes);
        modes.add(Integer.toString(caseModes.length));
        Collections.addAll(modes, caseModes);
        modes.add(Integer.toString(matchModes.length));
        Collections.addAll(modes, matchModes);
        modes.add(Integer.toString(interTierConstraintModes.length));
        Collections.addAll(modes, interTierConstraintModes);
        return modes;
    }

    public void createLayers(String encodedQuery) {
        String[] queryParts = encodedQuery.split("xxxSAFE_SPLITTERxxx");
        int partIndex = 0;
        String[] header = queryParts[partIndex++].split(",");
        this.setGlobalTimeConstraints(Long.parseLong(header[0].trim()), Long.parseLong(header[1].trim()), Long.parseLong(header[2].trim()), Long.parseLong(header[3].trim()));
        this.setQueryMatrixDimensions(Integer.parseInt(header[4].trim()), Integer.parseInt(header[5].trim()));
        int nPatterns = 0;
        for (int i = 0; i < this.nLayers; ++i) {
            this.searchLayers[i] = new SearchLayer();
            for (int j = 0; j < this.nPatternsPerLayer; ++j) {
                String pattern;
                if ((pattern = queryParts[partIndex++]).length() > 0) {
                    ++nPatterns;
                }
                String mode = queryParts[partIndex++];
                String innerConstraint = queryParts[partIndex++];
                String outerConstraint = queryParts[partIndex++];
                String normalized = UnicodeNormalizer.normalizeToNFC((String)pattern, (String)(" in createLayers, " + (i + 1) + ". layer, " + (j + 1) + ". pattern"));
                String denormalized = UnicodeNormalizer.checkNFC((String)normalized);
                if (denormalized != null || !normalized.equals(pattern)) {
                    if (denormalized != null) {
                        _logger.warn((Object)("Could not normalize query pattern: " + denormalized));
                    }
                    pattern = normalized;
                }
                this.searchLayers[i].addPattern(pattern, mode, innerConstraint, outerConstraint);
                if (this.firstNonEmptyPatternIndex >= 0 || pattern.length() <= 0) continue;
                this.firstNonEmptyLayerIndex = i;
                this.firstNonEmptyPatternIndex = j;
            }
            int nTiers = Integer.parseInt(header[i + 6].trim());
            for (int j = 0; j < nTiers; ++j) {
                this.searchLayers[i].addTierConstraint(queryParts[partIndex++]);
            }
        }
        int nNonEmptyLayers = 0;
        for (int i = 0; i < this.nLayers; ++i) {
            if (this.searchLayers[i].isEmpty()) continue;
            ++nNonEmptyLayers;
        }
        this.isMultipleLayerQuery = nNonEmptyLayers > 1;
        this.isSimpleQuery = nPatterns <= 1;
    }

    private void displayLayerInfo() {
        _logger.debug((Object)("nLayers: " + this.nLayers));
        for (int i = 0; i < this.nLayers; ++i) {
            _logger.debug((Object)("\nLayer " + i));
            _logger.debug((Object)this.searchLayers[i].display().trim());
        }
    }

    public boolean isRunning() {
        return this.isExecuting;
    }

    public SearchStatistics getSearchStatistics() {
        this.statistics.nFrequencyInfoItems = this.frequencyMap.size();
        return this.statistics;
    }

    protected void clearFrequencyStatistics() {
        this.frequencyMap.clear();
        this.orderedFrequencyInfoByAnnotation.clear();
        this.orderedFrequencyInfoByFrequency.clear();
    }

    protected void updateFrequencyStatistics(String annotation, int annId, int fileIndex, int layerIndex, int patternIndex) {
        FrequencyInfoTools.updateFrequencyStatistics(this.frequencyMap, annotation, annId, fileIndex, layerIndex, patternIndex);
    }

    public ArrayList<FrequencyInfo> getFrequencyInfo(int from, int count, boolean sortByFreq) {
        ArrayList<FrequencyInfo> info = FrequencyInfoTools.getFrequencyInfo(this.frequencyMap, this.orderedFrequencyInfoByAnnotation, this.orderedFrequencyInfoByFrequency, from, count, sortByFreq);
        if (this.frequencyMap.size() >= 100000) {
            return info;
        }
        int mapSize = this.frequencyMap.size();
        for (FrequencyInfo freqInfo : info) {
            freqInfo.nOccurences = mapSize;
            if (freqInfo.hitPositionInAnnotation != 0 || freqInfo.hitLength != 0) continue;
            String[] queryModes = this.searchLayers[freqInfo.layerIndex].getMode(freqInfo.patternIndex);
            String pattern = this.searchLayers[freqInfo.layerIndex].getPattern(freqInfo.patternIndex);
            boolean patternNOTMode = this.searchLayers[freqInfo.layerIndex].getPatternNOTMode(freqInfo.patternIndex);
            Pattern regExpPattern = this.searchLayers[freqInfo.layerIndex].getRegExpPattern(freqInfo.patternIndex);
            if (queryModes[0].equals(" Annotation") && this.isSimpleQuery) {
                freqInfo.hitPositionInAnnotation = this.getHitPosition(freqInfo.annotation, 1, queryModes, pattern, regExpPattern, patternNOTMode);
                freqInfo.hitLength = this.getHitLength(freqInfo.annotation, 1, queryModes, pattern, regExpPattern, patternNOTMode);
                continue;
            }
            freqInfo.hitPositionInAnnotation = 0;
            freqInfo.hitLength = 0;
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void investigateComplexPattern(int layerIndex, int patternIndex, Connection con, boolean logLayerq) {
        Statement statement = null;
        ResultSet rs = null;
        try {
            statement = con.createStatement();
            if (statement.getMaxRows() == 0 || statement.getMaxRows() > 500) {
                statement.setFetchSize(500);
            } else {
                statement.setFetchSize(statement.getMaxRows() - 1);
            }
            do {
                if (patternIndex + 1 < this.nPatternsPerLayer) {
                    ++patternIndex;
                } else {
                    ++layerIndex;
                    patternIndex = 0;
                }
                if (layerIndex < this.nLayers) continue;
                if (!this.isDurationInRange(this.getGlobalHitDuration())) {
                    return;
                }
                for (int i = 0; i < this.nLayers; ++i) {
                    boolean layerHasHit = false;
                    for (int j = 0; j < this.nPatternsPerLayer; ++j) {
                        if (this.globalHitAnnId[i][j] == -1) continue;
                        this.searchLayers[i].setHitAnnIdForPattern(j, this.statistics.nHits, this.globalHitAnnId[i][j]);
                        layerHasHit = true;
                    }
                    if (!layerHasHit) continue;
                    this.searchLayers[i].setHitFileId(this.statistics.nHits, this.globalHitFileId);
                }
                String complexHitResultString = this.constructComplexHitResultString((Connection)con, (Statement)statement, (int[][])this.globalHitAnnId, (boolean)false).hitString.replaceAll("xxxSAFE_SPLITTERxxx", " ");
                int annId = this.globalHitAnnId[this.firstNonEmptyLayerIndex][this.firstNonEmptyPatternIndex];
                int fileId = this.globalHitFileId;
                this.updateFrequencyStatistics(complexHitResultString.replaceAll("xxxLAYER_SPLITTERxxx", "  #"), annId, fileId, this.firstNonEmptyLayerIndex, this.firstNonEmptyPatternIndex);
                ++this.statistics.nHits;
                ++this.statistics.nAnnotationsWithHit;
                return;
            } while (this.searchLayers[layerIndex].getPattern(patternIndex).length() == 0);
            String pattern = this.searchLayers[layerIndex].getPattern(patternIndex);
            boolean patternNOTMode = this.searchLayers[layerIndex].getPatternNOTMode(patternIndex);
            Pattern regExpPattern = this.searchLayers[layerIndex].getRegExpPattern(patternIndex);
            String[] queryModes = this.searchLayers[layerIndex].getMode(patternIndex);
            String queryString = "SELECT ann_id, ann_tier_id, ann_position, begin_time, end_time FROM " + this.schemaName + ".annotations WHERE ";
            queryString = queryString + this.createQueryPatternPart(pattern, queryModes, regExpPattern, patternNOTMode);
            if (patternIndex > 0 && this.searchLayers[layerIndex].getPattern(patternIndex - 1).length() > 0) {
                queryString = queryString + this.createHorizontalConstraintPart(layerIndex, patternIndex, statement);
            }
            if (layerIndex > 0 && this.searchLayers[layerIndex - 1].getPattern(patternIndex).length() > 0) {
                queryString = queryString + this.createVerticalConstraintPart(layerIndex, patternIndex, statement);
            }
            queryString = queryString + this.createTierConstraintPart(layerIndex, patternIndex);
            queryString = queryString + this.createGlobalTimeConstraintPart();
            queryString = this.convertRegexpPatternsIfNeeded(queryString);
            if (logLayerq) {
                String hint = "[" + (layerIndex + 1) + "/" + this.nLayers + "][" + (patternIndex + 1) + "/" + this.nPatternsPerLayer + "] ";
                _logger.info((Object)("layerq: " + hint + queryString));
            }
            logLayerq = true;
            rs = statement.executeQuery(queryString);
            while (rs.next()) {
                int annId = rs.getInt(1);
                int tierId = rs.getInt(2);
                this.globalHitAnnId[layerIndex][patternIndex] = annId;
                this.globalHitTierId[layerIndex][patternIndex] = tierId;
                this.globalHitPosition[layerIndex][patternIndex] = rs.getInt(3);
                this.globalHitBeginTime[layerIndex][patternIndex] = SearchQuery.getValue(rs, 4);
                this.globalHitEndTime[layerIndex][patternIndex] = SearchQuery.getValue(rs, 5);
                this.investigateComplexPattern(layerIndex, patternIndex, con, logLayerq);
                logLayerq = false;
            }
            rs.close();
            rs = null;
            statement.close();
            statement = null;
        }
        catch (SQLException sqle) {
            _logger.error((Object)("investigateComplexPattern: SQLException: " + sqle), (Throwable)sqle);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sqle2) {
                    _logger.error((Object)("investigateComplexPattern: Finally close ResultSet failed: " + sqle2));
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sqle2) {
                    _logger.error((Object)("investigateComplexPattern: Finally close Statement failed: " + sqle2));
                }
            }
        }
    }

    protected abstract String createQueryPatternPart(String var1, String[] var2, Pattern var3, boolean var4);

    protected abstract String convertRegexpPatternsIfNeeded(String var1);

    private int constraintParseInt(String constraint) {
        String[] parts = constraint.split(":");
        if (parts.length != 2) {
            return -1;
        }
        try {
            return Integer.parseInt(parts[1]);
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
    }

    protected String createHorizontalConstraintPart(int layerIndex, int patternIndex, Statement statement) {
        String queryPart = "";
        try {
            if (patternIndex <= 0 || this.globalHitAnnId[layerIndex][patternIndex - 1] == -1) {
                return "";
            }
            int relativePosition = this.globalHitPosition[layerIndex][patternIndex - 1];
            long relativeEndTime = this.globalHitEndTime[layerIndex][patternIndex - 1];
            String constraint = this.searchLayers[layerIndex].getInnerConstraint(patternIndex - 1);
            if (constraint.equals("cns none")) {
                queryPart = " AND ann_position > " + relativePosition;
            } else if (constraint.contains("cns an=:")) {
                int nAnnotations = this.constraintParseInt(constraint) + 1;
                queryPart = " AND ann_position = " + (relativePosition + nAnnotations);
            } else if (constraint.contains("cns an-:")) {
                int nAnnotations = this.constraintParseInt(constraint) + 1;
                queryPart = " AND ann_position < " + (relativePosition + nAnnotations) + " AND ann_position > " + relativePosition;
            } else if (constraint.contains("cns an+:")) {
                int nAnnotations = this.constraintParseInt(constraint) + 1;
                queryPart = " AND ann_position > " + (relativePosition + nAnnotations);
            } else if (constraint.contains("cns ms=:")) {
                int nMilliSeconds = this.constraintParseInt(constraint);
                queryPart = " AND begin_time = " + (relativeEndTime + (long)nMilliSeconds);
            } else if (constraint.contains("cns ms-:")) {
                int nMilliSeconds = this.constraintParseInt(constraint);
                queryPart = " AND begin_time < " + (relativeEndTime + (long)nMilliSeconds) + " AND begin_time >= " + relativeEndTime;
            } else if (constraint.contains("cns ms+:")) {
                int nMilliSeconds = this.constraintParseInt(constraint);
                queryPart = " AND begin_time > " + (relativeEndTime + (long)nMilliSeconds);
            } else {
                _logger.warn((Object)("createHorizontalConstraintPart: Unknown constraint ignored: " + constraint));
            }
        }
        catch (RuntimeException re) {
            _logger.error((Object)("createHorizontalConstraintPart: RuntimeException: " + re), (Throwable)re);
        }
        return queryPart;
    }

    protected String createVerticalConstraintPart(int layerIndex, int patternIndex, Statement statement) {
        String queryPart = "";
        try {
            if (layerIndex <= 0 || this.globalHitAnnId[layerIndex - 1][patternIndex] == -1) {
                return "";
            }
            String constraint = this.searchLayers[layerIndex - 1].getOuterConstraint(patternIndex);
            if (constraint.equals("cns none")) {
                return "";
            }
            long relativeBeginTime = this.globalHitBeginTime[layerIndex - 1][patternIndex];
            long relativeEndTime = this.globalHitEndTime[layerIndex - 1][patternIndex];
            if (!constraint.equals("cns none")) {
                if (constraint.equals("cns aligned")) {
                    queryPart = " AND begin_time = " + relativeBeginTime + " AND end_time = " + relativeEndTime;
                } else if (constraint.equals("cns overlap")) {
                    queryPart = " AND end_time > " + relativeBeginTime + " AND begin_time < " + relativeEndTime;
                } else if (constraint.equals("cns l overlap")) {
                    queryPart = " AND begin_time <= " + relativeBeginTime + " AND end_time > " + relativeBeginTime + " AND end_time <= " + relativeEndTime;
                } else if (constraint.equals("cns r overlap")) {
                    queryPart = " AND begin_time < " + relativeEndTime + " AND end_time >= " + relativeEndTime + " AND begin_time >= " + relativeBeginTime;
                } else if (constraint.equals("cns surrounding")) {
                    queryPart = " AND begin_time <= " + relativeBeginTime + " AND end_time >= " + relativeEndTime;
                } else if (constraint.equals("cns within")) {
                    queryPart = " AND begin_time >= " + relativeBeginTime + " AND end_time <= " + relativeEndTime;
                } else if (constraint.equals("cns no overlap")) {
                    queryPart = " AND (end_time <= " + relativeBeginTime + " OR begin_time >= " + relativeEndTime + ")";
                } else if (constraint.contains("cns bb=:")) {
                    int nMilliSeconds = this.constraintParseInt(constraint);
                    queryPart = " AND begin_time = " + (relativeBeginTime + (long)nMilliSeconds);
                } else if (constraint.contains("cns bb-:")) {
                    int nMilliSeconds = this.constraintParseInt(constraint);
                    queryPart = " AND begin_time < " + (relativeBeginTime + (long)nMilliSeconds) + " AND begin_time >= " + relativeBeginTime;
                } else if (constraint.contains("cns bb+:")) {
                    int nMilliSeconds = this.constraintParseInt(constraint);
                    queryPart = " AND begin_time > " + (relativeBeginTime + (long)nMilliSeconds);
                } else if (constraint.contains("cns be=:")) {
                    int nMilliSeconds = this.constraintParseInt(constraint);
                    queryPart = " AND begin_time = " + (relativeEndTime + (long)nMilliSeconds);
                } else if (constraint.contains("cns be-:")) {
                    int nMilliSeconds = this.constraintParseInt(constraint);
                    queryPart = " AND begin_time < " + (relativeEndTime + (long)nMilliSeconds) + " AND begin_time >= " + relativeEndTime;
                } else if (constraint.contains("cns be+:")) {
                    int nMilliSeconds = this.constraintParseInt(constraint);
                    queryPart = " AND begin_time > " + (relativeEndTime + (long)nMilliSeconds);
                } else if (constraint.contains("cns eb=:")) {
                    int nMilliSeconds = this.constraintParseInt(constraint);
                    queryPart = " AND end_time = " + (relativeBeginTime + (long)nMilliSeconds);
                } else if (constraint.contains("cns eb-:")) {
                    int nMilliSeconds = this.constraintParseInt(constraint);
                    queryPart = " AND end_time < " + (relativeBeginTime + (long)nMilliSeconds) + " AND end_time >= " + relativeBeginTime;
                } else if (constraint.contains("cns eb+:")) {
                    int nMilliSeconds = this.constraintParseInt(constraint);
                    queryPart = " AND end_time > " + (relativeBeginTime + (long)nMilliSeconds);
                } else if (constraint.contains("cns ee=:")) {
                    int nMilliSeconds = this.constraintParseInt(constraint);
                    queryPart = " AND end_time = " + (relativeEndTime + (long)nMilliSeconds);
                } else if (constraint.contains("cns ee-:")) {
                    int nMilliSeconds = this.constraintParseInt(constraint);
                    queryPart = " AND end_time < " + (relativeEndTime + (long)nMilliSeconds) + " AND end_time >= " + relativeEndTime;
                } else if (constraint.contains("cns ee+:")) {
                    int nMilliSeconds = this.constraintParseInt(constraint);
                    queryPart = " AND end_time > " + (relativeEndTime + (long)nMilliSeconds);
                } else {
                    _logger.warn((Object)("createVerticalConstraintPart: Unknown constraint ignored: " + constraint));
                }
            }
        }
        catch (RuntimeException re) {
            _logger.error((Object)("createVerticalConstraintPart: RuntimeException: " + re), (Throwable)re);
        }
        return queryPart;
    }

    protected String createTierConstraintPart(int layerIndex, int patternIndex) {
        if (patternIndex > 0 && this.globalHitTierId[layerIndex][patternIndex - 1] != -1) {
            return " AND ann_tier_id = " + this.globalHitTierId[layerIndex][patternIndex - 1];
        }
        StringBuilder queryPart = new StringBuilder(128);
        String layerDomain = this.searchLayers[layerIndex].getTierIdsInLayerDomain();
        if (layerDomain != null) {
            queryPart.append(layerDomain);
        }
        ArrayList<String> tierConstraints = this.searchLayers[layerIndex].getTierConstraints();
        int parentTierId = -1;
        if (layerIndex > 0) {
            for (int i = 0; i < this.nPatternsPerLayer; ++i) {
                if (this.globalHitTierId[layerIndex - 1][i] == -1) continue;
                parentTierId = this.globalHitTierId[layerIndex - 1][i];
            }
        }
        if (tierConstraints.contains(" Must be parent and child")) {
            queryPart.append(" AND ann_tier_id IN ( SELECT tier_id FROM ");
            queryPart.append(this.schemaName).append(".tiers WHERE ref_tier_id = ");
            queryPart.append(parentTierId).append(" )");
        } else if (tierConstraints.contains(" Must have same parent")) {
            queryPart.append(" AND ann_tier_id IN ( SELECT tier_id FROM ");
            queryPart.append(this.schemaName).append(".tiers WHERE ref_tier_id = ");
            queryPart.append(" ( SELECT ref_tier_id FROM ");
            queryPart.append(this.schemaName).append(".tiers WHERE tier_id = ");
            queryPart.append(parentTierId).append(" ) AND node_id = ");
            queryPart.append(" ( SELECT node_id FROM ");
            queryPart.append(this.schemaName).append(".tiers WHERE tier_id = ");
            queryPart.append(parentTierId).append(" ) ");
            queryPart.append(" ) ");
        }
        --layerIndex;
        while (layerIndex >= 0) {
            int lastForbiddenTierId = -1;
            for (int i = 0; i < this.nPatternsPerLayer; ++i) {
                int forbiddenTierId = this.globalHitTierId[layerIndex][i];
                if (forbiddenTierId == -1 || forbiddenTierId == lastForbiddenTierId) continue;
                if (lastForbiddenTierId != -1) {
                    _logger.warn((Object)("createTierConstraintPart: Layer has matches in multiple tiers?? Old: " + lastForbiddenTierId + " New: " + forbiddenTierId));
                }
                queryPart.append(" AND ann_tier_id != ").append(forbiddenTierId);
                lastForbiddenTierId = forbiddenTierId;
            }
            --layerIndex;
        }
        return queryPart.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean setTierDomainForLayers(boolean defineFullTranscriptionTierDomain, Connection con, String currentNodeId) {
        this.fullTranscriptionTierDomain = "";
        this.thereIsALayerWithAnEmptyTierDomain = false;
        HashMap<String, TreeSet<Integer>> domainTierNames = new HashMap<String, TreeSet<Integer>>();
        HashMap<String, TreeSet<Integer>> domainTierTypes = new HashMap<String, TreeSet<Integer>>();
        HashMap<String, TreeSet<Integer>> domainTierParticipants = new HashMap<String, TreeSet<Integer>>();
        HashMap<String, TreeSet<Integer>> domainTierAnnotators = new HashMap<String, TreeSet<Integer>>();
        TreeSet<Integer> allTiers = new TreeSet<Integer>();
        ResultSet rs = null;
        Statement ps = null;
        try {
            String queryString = "SELECT tier_id, tier_name, tier_type, participant, annotator FROM " + this.schemaName + ".tiers WHERE node_id = ?";
            ps = con.prepareStatement(queryString);
            if (ps.getMaxRows() == 0 || ps.getMaxRows() > 500) {
                ps.setFetchSize(500);
            } else {
                ps.setFetchSize(ps.getMaxRows() - 1);
            }
            ps.setString(1, currentNodeId);
            rs = ps.executeQuery();
            while (rs.next()) {
                String tierAnnotator;
                String tierParticipant;
                String tierType;
                int domainTierId = rs.getInt(1);
                allTiers.add(domainTierId);
                String tierName = rs.getString(2);
                if (tierName != null) {
                    TreeSet<Integer> tnSet = (TreeSet<Integer>)domainTierNames.get(tierName = tierName.trim());
                    if (tnSet == null) {
                        tnSet = new TreeSet<Integer>();
                    }
                    tnSet.add(domainTierId);
                    domainTierNames.put(tierName, tnSet);
                }
                if ((tierType = rs.getString(3)) != null) {
                    TreeSet<Integer> ttSet = (TreeSet<Integer>)domainTierTypes.get(tierType = tierType.trim());
                    if (ttSet == null) {
                        ttSet = new TreeSet<Integer>();
                    }
                    ttSet.add(domainTierId);
                    domainTierTypes.put(tierType, ttSet);
                }
                if ((tierParticipant = rs.getString(4)) != null) {
                    TreeSet<Integer> tpSet = (TreeSet<Integer>)domainTierParticipants.get(tierParticipant = tierParticipant.trim());
                    if (tpSet == null) {
                        tpSet = new TreeSet<Integer>();
                    }
                    tpSet.add(domainTierId);
                    domainTierParticipants.put(tierParticipant, tpSet);
                }
                if ((tierAnnotator = rs.getString(5)) == null) continue;
                TreeSet<Integer> taSet = (TreeSet<Integer>)domainTierAnnotators.get(tierAnnotator = tierAnnotator.trim());
                if (taSet == null) {
                    taSet = new TreeSet<Integer>();
                }
                taSet.add(domainTierId);
                domainTierAnnotators.put(tierAnnotator, taSet);
            }
            rs.close();
            rs = null;
            ps.close();
            ps = null;
        }
        catch (SQLException sqle) {
            _logger.error((Object)("setTierDomainForLayers: SQLException: " + sqle), (Throwable)sqle);
            boolean domainTierId = true;
            return domainTierId;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e2) {
                    _logger.error((Object)("setTierDomainForLayers: Error closing ResultSet: " + e2));
                }
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e2) {
                    _logger.error((Object)("setTierDomainForLayers: Error closing PreparedStatement: " + e2));
                }
            }
        }
        String allTierDomain = this.makeInTierQuery(allTiers);
        if (allTiers.isEmpty()) {
            _logger.info((Object)("setTierDomainForLayers: allTiers.isEmpty() for node " + currentNodeId));
            this.fullTranscriptionTierDomain = " AND false ";
            this.thereIsALayerWithAnEmptyTierDomain = true;
        } else {
            this.fullTranscriptionTierDomain = defineFullTranscriptionTierDomain ? allTierDomain : "";
        }
        for (int l = 0; l < this.nLayers; ++l) {
            if (this.searchLayers[l].isEmpty()) continue;
            TreeSet<Integer> layerTiers = new TreeSet<Integer>();
            boolean searchInAllTiers = false;
            ArrayList<String> tierConstraints = this.searchLayers[l].getTierConstraints();
            StringBuilder constraintExplain = new StringBuilder();
            for (int c = 0; c < tierConstraints.size(); ++c) {
                String constraint = tierConstraints.get(c);
                if (c > 0) {
                    constraintExplain.append(", ");
                }
                if (constraint.startsWith(" All Tiers ")) {
                    searchInAllTiers = true;
                    break;
                }
                if (constraint.equals(" Must be in same file") || constraint.equals(" Must be parent and child") || constraint.equals(" Must have same parent")) continue;
                if (constraint.startsWith(" Tier Name: ")) {
                    constraint = constraint.substring(" Tier Name: ".length());
                    constraintExplain.append("name='").append(constraint).append('\'');
                    if (domainTierNames.get(constraint) == null) continue;
                    layerTiers.addAll((Collection)domainTierNames.get(constraint));
                    continue;
                }
                if (constraint.startsWith(" Tier Type: ")) {
                    constraint = constraint.substring(" Tier Type: ".length());
                    constraintExplain.append("type='").append(constraint).append('\'');
                    if (domainTierTypes.get(constraint) == null) continue;
                    layerTiers.addAll((Collection)domainTierTypes.get(constraint));
                    continue;
                }
                if (constraint.startsWith(" Participant: ")) {
                    constraint = constraint.substring(" Participant: ".length());
                    constraintExplain.append("participant='").append(constraint).append('\'');
                    if (domainTierParticipants.get(constraint) == null) continue;
                    layerTiers.addAll((Collection)domainTierParticipants.get(constraint));
                    continue;
                }
                if (constraint.startsWith(" Annotator: ")) {
                    constraint = constraint.substring(" Annotator: ".length());
                    constraintExplain.append("annotator='").append(constraint).append('\'');
                    if (domainTierAnnotators.get(constraint) == null) continue;
                    layerTiers.addAll((Collection)domainTierAnnotators.get(constraint));
                    continue;
                }
                _logger.warn((Object)("setTierDomainForLayers: Cannot parse constraint: '" + constraint + "'"));
            }
            if (searchInAllTiers) {
                this.searchLayers[l].setTierIdsInLayerDomain(this.fullTranscriptionTierDomain);
                continue;
            }
            if (layerTiers.isEmpty()) {
                this.searchLayers[l].setTierIdsInLayerDomain(" AND false ");
                _logger.debug((Object)("No tier satisfies constraints for node " + currentNodeId + ", query layer " + l + ": " + constraintExplain.toString()));
                this.thereIsALayerWithAnEmptyTierDomain = true;
                continue;
            }
            String foundDomain = this.makeInTierQuery(layerTiers);
            if (!allTierDomain.equals(foundDomain)) {
                this.searchLayers[l].setTierIdsInLayerDomain(foundDomain);
                continue;
            }
            this.searchLayers[l].setTierIdsInLayerDomain(this.fullTranscriptionTierDomain);
        }
        return this.thereIsALayerWithAnEmptyTierDomain;
    }

    private String makeInTierQuery(TreeSet<Integer> tiers) {
        if (tiers == null || tiers.isEmpty()) {
            return " AND false ";
        }
        if (tiers.size() == 1) {
            return " AND ( ann_tier_id = " + tiers.first() + " ) ";
        }
        StringBuilder inSet = new StringBuilder(" AND ann_tier_id IN ( " + tiers.first());
        Iterator<Integer> iter = tiers.iterator();
        iter.next();
        while (iter.hasNext()) {
            inSet.append(", ").append(iter.next());
        }
        inSet.append(" ) ");
        return inSet.toString();
    }

    protected ComplexHitData constructComplexHitResultString(Connection con, Statement st, int[][] annIds, boolean addPositionAndTime) {
        int offs;
        String first;
        long complexPatternEndTime;
        long complexPatternBeginTime;
        StringBuilder hitString;
        block15: {
            hitString = new StringBuilder();
            complexPatternBeginTime = Long.MAX_VALUE;
            complexPatternEndTime = 0L;
            ResultSet rs = null;
            first = null;
            offs = 0;
            try {
                if (con != null && this._prepStatComplexHitResultData == null) {
                    String queryString = "SELECT annotation, ann_position, begin_time, end_time  FROM " + this.schemaName + ".annotations WHERE ann_id = ?";
                    this._prepStatComplexHitResultData = con.prepareStatement(queryString, 1004, 1007);
                }
                for (int i = 0; i < this.nLayers; ++i) {
                    hitString.append("xxxLAYER_SPLITTERxxx").append(i + 1);
                    for (int j = 0; j < this.nPatternsPerLayer; ++j) {
                        if (annIds[i][j] < 0) {
                            hitString.append("xxxSAFE_SPLITTERxxx").append("||");
                            continue;
                        }
                        rs = null;
                        if (con != null) {
                            this._prepStatComplexHitResultData.setInt(1, annIds[i][j]);
                            rs = this._prepStatComplexHitResultData.executeQuery();
                        } else {
                            String queryString = "SELECT annotation, ann_position, begin_time, end_time  FROM " + this.schemaName + ".annotations WHERE ann_id = " + annIds[i][j];
                            rs = st.executeQuery(queryString);
                        }
                        rs.next();
                        String annotation = rs.getString(1);
                        int position = rs.getInt(2);
                        long beginTime = SearchQuery.getValue(rs, 3);
                        long endTime = SearchQuery.getValue(rs, 4);
                        rs.close();
                        rs = null;
                        if (annotation.contains("xxxNUMBER_SPLITTERxxx") || annotation.contains("xxxLAYER_SPLITTERxxx") || annotation.contains("xxxSAFE_SPLITTERxxx")) {
                            annotation = "[UNPRINTABLE]";
                        }
                        if (annotation.startsWith("|")) {
                            annotation = " " + annotation;
                        }
                        hitString.append("xxxSAFE_SPLITTERxxx").append("|");
                        if (first == null) {
                            first = annotation;
                            offs = hitString.length();
                        }
                        hitString.append(annotation).append("|");
                        if (addPositionAndTime) {
                            hitString.append("xxxNUMBER_SPLITTERxxx").append(position);
                            hitString.append("xxxNUMBER_SPLITTERxxx").append(beginTime);
                            hitString.append("xxxNUMBER_SPLITTERxxx").append(endTime);
                        }
                        if (beginTime < complexPatternBeginTime) {
                            complexPatternBeginTime = beginTime;
                        }
                        if (endTime <= complexPatternEndTime) continue;
                        complexPatternEndTime = endTime;
                    }
                }
            }
            catch (SQLException sqle) {
                _logger.error((Object)("constructComplexHitResultString: SQLException: " + sqle), (Throwable)sqle);
                if (rs == null) break block15;
                try {
                    rs.close();
                }
                catch (SQLException sqle2) {
                    // empty catch block
                }
            }
        }
        ComplexHitData result = new ComplexHitData();
        result.hitString = hitString.toString();
        result.firstFieldText = first == null ? "null" : first;
        result.firstFieldOffset = offs;
        result.beginTime = complexPatternBeginTime;
        result.endTime = complexPatternEndTime;
        return result;
    }

    protected String[] constructNGramsWithinAnnotation(String annotation, String nGramPattern, String[] queryModes) {
        int nResults;
        String nGram;
        Matcher matcher;
        String[] result = null;
        String[] annotationParts = annotation.split(" +");
        String LongestNonWildcardPart = SearchQuery.getLongestNonWildcardPart(nGramPattern);
        boolean notMode = false;
        while (SearchLayer.isNOTPattern(LongestNonWildcardPart)) {
            notMode = !notMode;
            LongestNonWildcardPart = SearchLayer.stripNOTPattern(LongestNonWildcardPart);
        }
        ArrayList<String> resultList = new ArrayList<String>();
        if (queryModes[1].equals(" case sensitive")) {
            if (queryModes[2].equals(" exact match")) {
                for (int i = 0; i < annotationParts.length; ++i) {
                    String nGram2;
                    if (notMode == annotationParts[i].equals(LongestNonWildcardPart) || (nGram2 = this.constructNGram(nGramPattern, annotationParts, i, queryModes)) == null) continue;
                    resultList.add(nGram2);
                }
            } else if (queryModes[2].equals(" substring match")) {
                for (int i = 0; i < annotationParts.length; ++i) {
                    String nGram3;
                    if (notMode == annotationParts[i].contains(LongestNonWildcardPart) || (nGram3 = this.constructNGram(nGramPattern, annotationParts, i, queryModes)) == null) continue;
                    resultList.add(nGram3);
                }
            } else if (queryModes[2].equals(" regular expression")) {
                Pattern regExpPattern = Pattern.compile(LongestNonWildcardPart);
                for (int i = 0; i < annotationParts.length; ++i) {
                    matcher = regExpPattern.matcher(annotationParts[i]);
                    if (notMode == matcher.find() || (nGram = this.constructNGram(nGramPattern, annotationParts, i, queryModes)) == null) continue;
                    resultList.add(nGram);
                }
            }
        } else if (queryModes[2].equals(" exact match")) {
            for (int i = 0; i < annotationParts.length; ++i) {
                String nGram4;
                if (notMode == annotationParts[i].toLowerCase().equals(LongestNonWildcardPart.toLowerCase()) || (nGram4 = this.constructNGram(nGramPattern, annotationParts, i, queryModes)) == null) continue;
                resultList.add(nGram4);
            }
        } else if (queryModes[2].equals(" substring match")) {
            for (int i = 0; i < annotationParts.length; ++i) {
                String nGram5;
                if (notMode == annotationParts[i].toLowerCase().contains(LongestNonWildcardPart.toLowerCase()) || (nGram5 = this.constructNGram(nGramPattern, annotationParts, i, queryModes)) == null) continue;
                resultList.add(nGram5);
            }
        } else if (queryModes[2].equals(" regular expression")) {
            Pattern regExpPattern = Pattern.compile(LongestNonWildcardPart, 2);
            for (int i = 0; i < annotationParts.length; ++i) {
                matcher = regExpPattern.matcher(annotationParts[i].toLowerCase());
                if (notMode == matcher.find() || (nGram = this.constructNGram(nGramPattern, annotationParts, i, queryModes)) == null) continue;
                resultList.add(nGram);
            }
        }
        if ((nResults = resultList.size()) > 0) {
            result = new String[nResults];
            for (int i = 0; i < nResults; ++i) {
                result[i] = ((String)resultList.get(i)).trim();
            }
            return result;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String[] constructNGrams(int annId, Statement st, Integer queryIdInt, String nGramPattern, String[] queryModes) {
        String[] result = null;
        ResultSet rs = null;
        String schemaName = "search" + (queryIdInt == null ? "" : queryIdInt.toString());
        try {
            String[] stringArray;
            if (queryModes[0].equals(" N-gram within annotation")) {
                String queryString = "SELECT annotation FROM " + schemaName + ".annotations WHERE ann_id = " + annId;
                rs = st.executeQuery(queryString);
                rs.next();
                String annotation = rs.getString(1);
                rs.close();
                rs = null;
                String[] stringArray2 = this.constructNGramsWithinAnnotation(annotation, nGramPattern, queryModes);
                return stringArray2;
            }
            String queryString = "SELECT ann_position, ann_tier_id FROM " + schemaName + ".annotations WHERE ann_id = " + annId;
            rs = st.executeQuery(queryString);
            rs.next();
            int annPosition = rs.getInt(1);
            int annTierId = rs.getInt(2);
            rs.close();
            rs = null;
            int firstPos = annPosition - SearchQuery.getLongestNonWildcardPartPosition(nGramPattern);
            if (firstPos < 0) {
                String[] stringArray3 = null;
                return stringArray3;
            }
            int lastPos = firstPos + this.getNGramLength(nGramPattern);
            queryString = "SELECT annotation, ann_position FROM " + schemaName + ".annotations WHERE ann_tier_id = " + annTierId + " AND ann_position >= " + firstPos + " AND ann_position < " + lastPos + " ORDER BY ann_position";
            rs = st.executeQuery(queryString);
            StringBuilder nGram = new StringBuilder("");
            int nParts = 0;
            while (rs.next()) {
                ++nParts;
                String nGramWord = rs.getString(1);
                if (nGramWord.contains("xxxSAFE_SPLITTERxxx")) {
                    nGramWord = "[UNPRINTABLE]";
                }
                nGram.append(nGramWord);
                nGram.append("xxxSAFE_SPLITTERxxx");
            }
            rs.close();
            rs = null;
            if (nParts != lastPos - firstPos) {
                stringArray = null;
                return stringArray;
            }
            result = new String[]{nGram.toString()};
            stringArray = result;
            return stringArray;
        }
        catch (SQLException sqle) {
            _logger.error((Object)("constructNGrams: SQLException: " + sqle), (Throwable)sqle);
            String[] stringArray = null;
            return stringArray;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sqle2) {
                    _logger.error((Object)("constructNGrams: Finally close ResultSet failed: " + sqle2));
                }
            }
        }
    }

    private String constructNGram(String nGramPattern, String[] annotationParts, int hitIndex, String[] queryModes) {
        int firstPos = hitIndex - SearchQuery.getLongestNonWildcardPartPosition(nGramPattern);
        if (firstPos < 0) {
            return null;
        }
        int nGramLength = this.getNGramLength(nGramPattern);
        int lastPos = firstPos + nGramLength;
        if (lastPos > annotationParts.length) {
            return null;
        }
        StringBuilder nGram = new StringBuilder("");
        for (int i = 0; i < nGramLength; ++i) {
            int j = firstPos + i;
            if ("xxxSAFE_SPLITTERxxx".equals(annotationParts[j])) {
                annotationParts[j] = "[UNPRINTABLE]";
            }
            if (queryModes[0].equals(" N-gram over annotations")) {
                nGram.append(annotationParts[j]);
                if (j == lastPos - 1) continue;
                nGram.append("xxxSAFE_SPLITTERxxx");
                continue;
            }
            nGram.append(annotationParts[j]);
            if (j == lastPos - 1) continue;
            nGram.append(' ');
        }
        return nGram.toString();
    }

    protected boolean isNGramMatch(String nGram, String nGramPattern, String[] queryModes) {
        String[] nGramPatternParts;
        String[] nGramParts = null;
        nGramParts = queryModes[0].equals(" N-gram over annotations") ? nGram.split("xxxSAFE_SPLITTERxxx") : nGram.split(" +");
        if (nGramParts.length != (nGramPatternParts = nGramPattern.split(" +")).length) {
            return false;
        }
        for (int i = 0; i < nGramParts.length; ++i) {
            Pattern regExpPattern;
            Matcher matcher;
            String patternPart = nGramPatternParts[i];
            if (patternPart.equals("#")) continue;
            boolean notMode = false;
            while (SearchLayer.isNOTPattern(patternPart)) {
                notMode = !notMode;
                patternPart = SearchLayer.stripNOTPattern(patternPart);
            }
            if (!(queryModes[1].equals(" case sensitive") ? (queryModes[2].equals(" exact match") ? notMode == nGramParts[i].equals(patternPart) : (queryModes[2].equals(" substring match") ? notMode == nGramParts[i].contains(patternPart) : queryModes[2].equals(" regular expression") && notMode == (matcher = (regExpPattern = Pattern.compile(patternPart)).matcher(nGramParts[i])).find())) : (queryModes[2].equals(" exact match") ? notMode == nGramParts[i].toLowerCase().equals(patternPart.toLowerCase()) : (queryModes[2].equals(" substring match") ? notMode == nGramParts[i].toLowerCase().contains(patternPart.toLowerCase()) : queryModes[2].equals(" regular expression") && notMode == (matcher = (regExpPattern = Pattern.compile(patternPart, 2)).matcher(nGramParts[i].toLowerCase())).find())))) continue;
            return false;
        }
        return true;
    }

    public static String getLongestNonWildcardPart(String nGramPattern) {
        String[] nGramPatternParts = nGramPattern.split(" +");
        int position = SearchQuery.getLongestNonWildcardPartPosition(nGramPattern);
        return nGramPatternParts[position];
    }

    public static int getLongestNonWildcardPartPosition(String nGramPattern) {
        String part;
        int i;
        String[] nGramPatternParts = nGramPattern.split(" +");
        int position = -1;
        int maxLength = 0;
        for (i = 0; i < nGramPatternParts.length; ++i) {
            part = nGramPatternParts[i];
            if (part.equals("#") || SearchLayer.isNOTPattern(part) || part.length() <= maxLength) continue;
            maxLength = part.length();
            position = i;
        }
        if (position >= 0) {
            return position;
        }
        for (i = 0; i < nGramPatternParts.length; ++i) {
            part = nGramPatternParts[i];
            if (part.equals("#")) continue;
            return i;
        }
        return 0;
    }

    protected int getNGramLength(String nGramPattern) {
        return nGramPattern.split(" +").length;
    }

    protected int countHitsInAnnotation(String annotation, String[] queryModes, String pattern, Pattern regExpPattern, boolean patternNOTMode) {
        int nHits = 0;
        int patternLength = pattern.length();
        if (patternNOTMode) {
            nHits = 1;
        } else if (queryModes[0].equals(" Annotation")) {
            if (queryModes[1].equals(" case sensitive")) {
                if (queryModes[2].equals(" substring match")) {
                    int p = annotation.indexOf(pattern);
                    while (p >= 0) {
                        ++nHits;
                        p = annotation.indexOf(pattern, p + patternLength);
                    }
                } else if (queryModes[2].equals(" regular expression")) {
                    Matcher matcher = regExpPattern.matcher(annotation);
                    if (matcher.find()) {
                        ++nHits;
                        while (matcher.find()) {
                            ++nHits;
                        }
                    }
                } else {
                    nHits = 1;
                }
            } else if (queryModes[2].equals(" substring match")) {
                pattern = pattern.toLowerCase();
                annotation = annotation.toLowerCase();
                int p = annotation.indexOf(pattern);
                while (p >= 0) {
                    ++nHits;
                    p = annotation.indexOf(pattern, p + patternLength);
                }
            } else if (queryModes[2].equals(" regular expression")) {
                Matcher matcher = regExpPattern.matcher(annotation.toLowerCase());
                if (matcher.find()) {
                    ++nHits;
                    while (matcher.find()) {
                        ++nHits;
                    }
                }
            } else {
                nHits = 1;
            }
        } else {
            nHits = 1;
        }
        return nHits;
    }

    protected int getHitPosition(String annotation, int nthHit, String[] queryModes, String pattern, Pattern regExpPattern, boolean patternNOTMode) {
        Matcher matcher;
        if (patternNOTMode) {
            return 0;
        }
        if (queryModes[0].equals(" N-gram over annotations")) {
            pattern = SearchQuery.getLongestNonWildcardPart(pattern);
            regExpPattern = queryModes[1].equals(" case sensitive") ? Pattern.compile(pattern) : Pattern.compile(pattern, 2);
        }
        int position = 0;
        if (queryModes[0].equals(" N-gram within annotation")) {
            int hitNumber = nthHit;
            String[] nGrams = this.constructNGramsWithinAnnotation(annotation, pattern, queryModes);
            if (nGrams == null) {
                return 0;
            }
            for (int i = 0; i < nGrams.length; ++i) {
                if (!this.isNGramMatch(nGrams[i], pattern, queryModes) || --hitNumber > 0) continue;
                String singleSpaceAnnotation = annotation.replaceAll(" +", " ");
                position = singleSpaceAnnotation.indexOf(nGrams[i]);
                int nSame = 0;
                for (int j = 0; j < i; ++j) {
                    if (!nGrams[i].equals(nGrams[j])) continue;
                    ++nSame;
                }
                while (nSame > 0) {
                    position = singleSpaceAnnotation.indexOf(nGrams[i], position + 1);
                    --nSame;
                }
                break;
            }
            return position;
        }
        if (!queryModes[1].equals(" case sensitive")) {
            pattern = pattern.toLowerCase();
            annotation = annotation.toLowerCase();
        }
        if (queryModes[2].equals(" substring match") || queryModes[2].equals(" exact match")) {
            int patternLength = pattern.length();
            int p = annotation.indexOf(pattern);
            --nthHit;
            while (nthHit > 0) {
                p = annotation.indexOf(pattern, p + patternLength);
                --nthHit;
            }
            position = p;
        } else if (queryModes[2].equals(" regular expression") && (matcher = regExpPattern.matcher(annotation)).find()) {
            --nthHit;
            while (nthHit > 0) {
                matcher.find();
                --nthHit;
            }
            position = matcher.start();
        }
        return position;
    }

    private int getTokenNumberForPosition(String annotation, int p) {
        int pos = 0;
        int tokenNr = 0;
        while (pos < p) {
            pos = annotation.indexOf(32, pos) + 1;
            ++tokenNr;
        }
        return tokenNr;
    }

    protected int getHitLength(String annotation, int nthHit, String[] queryModes, String pattern, Pattern regExpPattern, boolean patternNOTMode) {
        if (queryModes[0].equals(" N-gram over annotations")) {
            pattern = SearchQuery.getLongestNonWildcardPart(pattern);
            regExpPattern = queryModes[1].equals(" case sensitive") ? Pattern.compile(pattern) : Pattern.compile(pattern, 2);
        }
        int length = pattern.length();
        if (patternNOTMode) {
            length = annotation.length();
        } else if (queryModes[0].equals(" N-gram within annotation")) {
            String[] nGrams = this.constructNGramsWithinAnnotation(annotation, pattern, queryModes);
            for (int i = 0; i < nGrams.length; ++i) {
                if (!this.isNGramMatch(nGrams[i], pattern, queryModes) || --nthHit > 0) continue;
                length = nGrams[i].length();
                break;
            }
        } else if (queryModes[2].equals(" regular expression")) {
            Matcher matcher = null;
            matcher = queryModes[1].equals(" case sensitive") ? regExpPattern.matcher(annotation) : regExpPattern.matcher(annotation.toLowerCase());
            if (matcher.find()) {
                --nthHit;
                while (nthHit > 0) {
                    matcher.find();
                    --nthHit;
                }
                length = matcher.end() - matcher.start();
            }
        }
        return length;
    }

    protected String createGlobalTimeConstraintPart() {
        String queryPart = "";
        if (this._beginAfter > 0L) {
            queryPart = " AND begin_time > " + this._beginAfter;
        }
        if (this._endBefore > 0L) {
            queryPart = queryPart + " AND end_time < " + this._endBefore;
        }
        return queryPart;
    }

    protected boolean isDurationInRange(long duration) {
        boolean retval = true;
        if (this._minimalDuration > 0L && duration < this._minimalDuration) {
            retval = false;
        }
        if (this._maximalDuration > 0L && duration > this._maximalDuration) {
            retval = false;
        }
        return retval;
    }

    protected long getGlobalHitDuration() {
        long smallestBeginTime = Long.MAX_VALUE;
        long biggestEndTime = Long.MIN_VALUE;
        for (int i = 0; i < this.nLayers; ++i) {
            for (int j = 0; j < this.nPatternsPerLayer; ++j) {
                long endTime;
                if (this.globalHitAnnId[i][j] == -1) continue;
                long beginTime = this.globalHitBeginTime[i][j];
                if (beginTime < smallestBeginTime) {
                    smallestBeginTime = beginTime;
                }
                if ((endTime = this.globalHitEndTime[i][j]) <= biggestEndTime) continue;
                biggestEndTime = endTime;
            }
        }
        if (smallestBeginTime == Long.MAX_VALUE || biggestEndTime == Long.MIN_VALUE) {
            return 0L;
        }
        return biggestEndTime - smallestBeginTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearHitData(int fileId) {
        int[][] nArray = this.globalHitAnnId;
        synchronized (this.globalHitAnnId) {
            this.globalHitFileId = fileId;
            for (int i = 0; i < this.nLayers; ++i) {
                for (int j = 0; j < this.nPatternsPerLayer; ++j) {
                    this.globalHitAnnId[i][j] = -1;
                    this.globalHitTierId[i][j] = -1;
                }
            }
            this._prepStatCheckValidDuration = null;
            this._prepStatCheckValidDuration = null;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    protected static class ComplexHitData {
        String hitString;
        String firstFieldText;
        int firstFieldOffset;
        long beginTime;
        long endTime;

        protected ComplexHitData() {
        }
    }
}

