/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.annot.search.lib;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import nl.mpi.annot.search.lib.SearchClient;
import nl.mpi.annot.tools.data.AnnexFileTypes;
import nl.mpi.annot.tools.data.CorpusStructDB;
import nl.mpi.annot.tools.util.CountHash;
import nl.mpi.corpusstructure.ArchiveObjectsDB;
import nl.mpi.corpusstructure.CorpusNode;
import nl.mpi.corpusstructure.CorpusStructureDB;
import nl.mpi.corpusstructure.NodeIdUtils;
import nl.mpi.corpusstructure.UnknownNodeException;
import org.apache.log4j.Logger;

public final class TierCollection
extends Thread
implements Serializable {
    private static Logger _logger = Logger.getLogger((String)"Searchlib.TierCollection");
    private static final long serialVersionUID = 42424242L * (long)"filter,info,nodes,types,names,participants,annotators,tiercounts,annocounts,user,topnodes".hashCode();
    private static final boolean _logThreads = false;
    private static final String _adminUser = "Special:Admin";
    private String _sqlFilterClause = null;
    private HashMap<Integer, String> _typeInfo = new HashMap();
    private HashMap<Integer, HashSet<String>> _typeNodes = new HashMap();
    private HashMap<Integer, CountHash<String>> _typeTypes = new HashMap();
    private HashMap<Integer, CountHash<String>> _typeNames = new HashMap();
    private HashMap<Integer, CountHash<String>> _typeParticipants = new HashMap();
    private HashMap<Integer, CountHash<String>> _typeAnnotators = new HashMap();
    private HashMap<Integer, Integer> _typeTierCounts = new HashMap();
    private HashMap<Integer, Integer> _typeAnnoCounts = new HashMap();
    private final String _userId;
    private final List<String> _topNodes;
    private final transient SearchClient _searchClient;
    private int _fileType;

    public TierCollection(int maxThreads, SearchClient searchClient, String userId, List<String> topNodes) {
        this._searchClient = null;
        this._userId = null;
        this._topNodes = topNodes;
        this._fileType = -42;
        TierCollection[] threads = new TierCollection[maxThreads];
        int[] threadTypes = new int[maxThreads];
        int i = AnnexFileTypes.getFileTypeCount() - 1;
        boolean busy = true;
        String normalUserId = TierCollection.normalizeUserId(userId);
        _logger.debug((Object)("TierCollection: Start with " + maxThreads + " threads for user=" + normalUserId + " topNodes=" + topNodes));
        while (busy) {
            int j;
            busy = false;
            for (j = 0; j < maxThreads; ++j) {
                if (threads[j] != null && !threads[j].isAlive()) {
                    try {
                        threads[j].join();
                    }
                    catch (InterruptedException ie) {
                        _logger.warn((Object)("Failed to join() finished thread in TierCollection, type " + threadTypes[j]));
                    }
                    threads[j] = null;
                }
                if (threads[j] != null && (threads[j].threadBusy() >= 0 || threads[j].isAlive())) {
                    busy = true;
                }
                if (threads[j] == null || threads[j].threadBusy() >= 0 || threadTypes[j] < 0) continue;
                int fileType = threadTypes[j];
                this._typeInfo.put(fileType, threads[j].getInfoForType(fileType));
                this._typeNodes.put(fileType, threads[j].getNodesForType(fileType));
                this._typeNames.put(fileType, threads[j].getTierNamesForType(fileType));
                this._typeTypes.put(fileType, threads[j].getTierTypesForType(fileType));
                this._typeParticipants.put(fileType, threads[j].getParticipantsForType(fileType));
                this._typeAnnotators.put(fileType, threads[j].getAnnotatorsForType(fileType));
                this._typeTierCounts.put(fileType, threads[j].getTierCountForType(fileType));
                this._typeAnnoCounts.put(fileType, threads[j].getAnnoCountForType(fileType));
                threads[j].stopThread();
                int n = j;
                threadTypes[n] = threadTypes[n] - 1000;
            }
            for (j = 0; j < maxThreads; ++j) {
                if (threads[j] != null || i < 0) continue;
                SearchClient newSearchClient = null;
                try {
                    newSearchClient = searchClient.getNewSearchClient();
                }
                catch (SQLException sqle) {
                    _logger.error((Object)("Cannot create all SearchClient instances for TierCollection init: " + sqle));
                    i = -42;
                    throw new RuntimeException("TierCollection: SQL problem: " + sqle);
                }
                threads[j] = new TierCollection(newSearchClient, normalUserId, topNodes, i);
                threadTypes[j] = i--;
                threads[j].start();
                busy = true;
                break;
            }
            if (!busy && i < 0) break;
            try {
                TierCollection.sleep(10L);
            }
            catch (InterruptedException ie) {}
        }
        this._sqlFilterClause = TierCollection.getDomainSQL(topNodes, normalUserId);
        int globalSize = 0;
        for (i = 0; i < AnnexFileTypes.getFileTypeCount(); ++i) {
            globalSize += this.getNodeCountForType(i);
        }
        if (globalSize == 0) {
            this._sqlFilterClause = "( " + this._sqlFilterClause + " ) AND FALSE";
        }
        _logger.debug((Object)("getDomainSQL(" + topNodes + ") = " + this._sqlFilterClause + " -- node count: " + globalSize));
    }

    protected TierCollection(SearchClient searchClient, String userId, List<String> topNodes, int fileType) {
        this._searchClient = searchClient;
        this._userId = userId;
        this._topNodes = topNodes;
        this._fileType = fileType;
    }

    public int threadBusy() {
        return this._fileType;
    }

    public void stopThread() {
        if (this._fileType == -1) {
            this._fileType = -2;
        }
        if (this._fileType < 0) {
            this._searchClient.close();
        } else {
            _logger.warn((Object)("stopThread ignored, still busy with type: " + this._fileType));
        }
    }

    @Override
    public void run() {
        this._sqlFilterClause = TierCollection.getDomainSQL(this._topNodes, this._userId);
        this.gatherTierInfo(this._searchClient, this._fileType);
        this._fileType = -1;
        while (this._fileType == -1) {
            try {
                TierCollection.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public TierCollection(SearchClient searchClient, String userId, List<String> topNodes) {
        this._searchClient = null;
        this._userId = null;
        this._topNodes = topNodes;
        this._fileType = -42;
        String normalUserId = TierCollection.normalizeUserId(userId);
        this._sqlFilterClause = TierCollection.getDomainSQL(topNodes, normalUserId);
        _logger.debug((Object)("getDomainSQL(" + topNodes + ") = " + this._sqlFilterClause));
        for (int fileType = 0; fileType < AnnexFileTypes.getFileTypeCount(); ++fileType) {
            this.gatherTierInfo(searchClient, fileType);
        }
    }

    public String getRawSQLFilter(List<Integer> fileTypes) {
        if (fileTypes == null) {
            return this._sqlFilterClause;
        }
        if (fileTypes.size() == 1) {
            return this._sqlFilterClause + " AND transcription_type = " + fileTypes.get(0);
        }
        StringBuilder typeFilterClause = new StringBuilder(" AND transcription_type IN ( ");
        for (int i = 0; i < fileTypes.size(); ++i) {
            if (i > 0) {
                typeFilterClause.append(", ");
            }
            typeFilterClause.append("").append(fileTypes.get(i));
        }
        typeFilterClause.append(" )");
        return this._sqlFilterClause + typeFilterClause.toString();
    }

    public int getAnnoCountForType(int type) {
        if (type < 0 || type >= AnnexFileTypes.getFileTypeCount()) {
            return 0;
        }
        return this._typeAnnoCounts.get(type);
    }

    public int getTierCountForType(int type) {
        if (type < 0 || type >= AnnexFileTypes.getFileTypeCount()) {
            return 0;
        }
        return this._typeTierCounts.get(type);
    }

    public String getInfoForType(int type) {
        if (type < 0 || type >= AnnexFileTypes.getFileTypeCount()) {
            return null;
        }
        return this._typeInfo.get(type);
    }

    public HashSet<String> getNodesForType(int type) {
        if (type < 0 || type >= AnnexFileTypes.getFileTypeCount()) {
            return null;
        }
        return this._typeNodes.get(type);
    }

    public int getNodeCountForType(int type) {
        if (type < 0 || type >= AnnexFileTypes.getFileTypeCount() || !this._typeNodes.containsKey(type)) {
            return 0;
        }
        return this._typeNodes.get(type).size();
    }

    public CountHash<String> getTierNamesForType(int type) {
        if (type < 0 || type >= AnnexFileTypes.getFileTypeCount()) {
            return null;
        }
        return this._typeNames.get(type);
    }

    public CountHash<String> getTierTypesForType(int type) {
        if (type < 0 || type >= AnnexFileTypes.getFileTypeCount()) {
            return null;
        }
        return this._typeTypes.get(type);
    }

    public CountHash<String> getParticipantsForType(int type) {
        if (type < 0 || type >= AnnexFileTypes.getFileTypeCount()) {
            return null;
        }
        return this._typeParticipants.get(type);
    }

    public CountHash<String> getAnnotatorsForType(int type) {
        if (type < 0 || type >= AnnexFileTypes.getFileTypeCount()) {
            return null;
        }
        return this._typeAnnotators.get(type);
    }

    protected static String getDomainSQL(List<String> topNodes, String userId) {
        StringBuilder sqlnodes = new StringBuilder();
        StringBuilder sqlpaths = new StringBuilder();
        String aclFilter = "";
        if (userId == null || "anonymous".equals(userId) || userId.trim().length() == 0 || userId.equals("everybody")) {
            aclFilter = " AND free_for_all = TRUE";
            userId = "everybody";
        }
        CorpusStructureDB csdb = CorpusStructDB.getCorpusStructureDB();
        ArchiveObjectsDB aodb = CorpusStructDB.getArchiveObjectsDB();
        if (userId.equals("anyAuthenticatedUser")) {
            aclFilter = " AND ( free_for_all = TRUE OR free_all_users = TRUE )";
        } else if (!userId.equals("everybody") && !userId.equals(_adminUser)) {
            if (!userId.matches("^[A-Za-z0-9_.@ -]+$")) {
                throw new RuntimeException("Invalid user ID rejected for SQL: '" + userId + "'");
            }
            aclFilter = " AND ( free_for_all = TRUE OR free_all_users = TRUE OR group_id IN ( SELECT group_id FROM search.users WHERE user_id = '" + userId + "' ) )";
        }
        for (int i = 0; i < topNodes.size(); ++i) {
            String nodeId = topNodes.get(i);
            if (nodeId == null || !nodeId.matches("^[A-Za-z0-9#_.-]+$") || !NodeIdUtils.isNodeId((String)nodeId)) {
                _logger.warn((Object)("Skipped node ID with bad syntax: " + nodeId));
                continue;
            }
            if (csdb == null || aodb == null) {
                if (sqlpaths.length() > 0) {
                    sqlpaths.append(" OR ");
                }
                sqlpaths.append(" vpath LIKE '%/");
                sqlpaths.append(nodeId);
                sqlpaths.append("%'");
                if (sqlnodes.length() == 0) {
                    sqlnodes.append("node_id IN ( ");
                } else {
                    sqlnodes.append(", ");
                }
                sqlnodes.append('\'').append(nodeId).append('\'');
                continue;
            }
            int nodeType = -1;
            CorpusNode cn = null;
            boolean hasAccess = false;
            try {
                cn = csdb.getCorpusNode(nodeId);
                nodeType = cn.getNodeType();
                hasAccess = userId.equals(_adminUser) || aodb.hasReadAccess(nodeId, userId);
            }
            catch (UnknownNodeException une) {
                _logger.warn((Object)("Skipped unlinked top node: " + nodeId));
                continue;
            }
            catch (RuntimeException re) {
                _logger.warn((Object)("Skipped top node with invalid id: " + nodeId));
                continue;
            }
            if (!hasAccess) {
                _logger.debug((Object)("Skipped non-accessible top node for user: " + userId + ", node id: " + nodeId));
                continue;
            }
            String cvPath = cn.getCanonicalVPath();
            if (cvPath == null || !cvPath.matches("^[A-Za-z0-9#_./-]*$")) {
                _logger.warn((Object)("Skipped node with syntactically invalid canonical tree path: '" + nodeId + "' has path: " + cvPath));
                continue;
            }
            if (nodeType == 8) {
                if (sqlnodes.length() == 0) {
                    sqlnodes.append("node_id IN ( ");
                } else {
                    sqlnodes.append(", ");
                }
                sqlnodes.append('\'').append(nodeId).append('\'');
                continue;
            }
            if (nodeType == 1) {
                if (sqlpaths.length() > 0) {
                    sqlpaths.append(" OR ");
                }
                sqlpaths.append("vpath = '");
                sqlpaths.append(cvPath);
                sqlpaths.append('/').append(nodeId);
                sqlpaths.append('\'');
                continue;
            }
            if (nodeType == 2) {
                if (sqlpaths.length() > 0) {
                    sqlpaths.append(" OR ");
                }
                sqlpaths.append("vpath BETWEEN '");
                sqlpaths.append(cvPath);
                sqlpaths.append('/').append(nodeId);
                sqlpaths.append("' AND '");
                sqlpaths.append(cvPath);
                sqlpaths.append('/').append(nodeId);
                sqlpaths.append("/ZZZ'");
                continue;
            }
            _logger.warn((Object)("Ignored type " + nodeType + " element in top node list: " + nodeId));
        }
        String pathPart = null;
        if (sqlpaths.length() > 0) {
            pathPart = "node_id IN ( SELECT node_id FROM search.vpaths WHERE " + sqlpaths.toString() + aclFilter + " )";
            if (sqlnodes.length() == 0) {
                return pathPart;
            }
        } else if (sqlnodes.length() == 0) {
            return "FALSE";
        }
        sqlnodes.append(" ) ");
        if (!(csdb != null && aodb != null || "".equals(aclFilter))) {
            return "( node_id IN ( SELECT node_id FROM search.vpaths WHERE " + sqlnodes.toString() + aclFilter + " )" + (pathPart != null ? " OR " + pathPart : "") + " )";
        }
        if (pathPart != null) {
            return "( " + sqlnodes.toString() + " OR " + pathPart + " )";
        }
        return sqlnodes.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void gatherTierInfo(SearchClient searchClient, int fileType) {
        HashSet<String> oneTypeNodes = new HashSet<String>();
        CountHash tierNames = new CountHash();
        CountHash tierTypes = new CountHash();
        CountHash participants = new CountHash();
        CountHash annotators = new CountHash();
        int sumAnnotations = 0;
        int nTiers = 0;
        ResultSet rs = null;
        try {
            PreparedStatement ps = searchClient.getPreparedStatement("SELECT node_id, tier_name, tier_type, participant, annotator, n_annotations FROM search.tiers WHERE transcription_type = " + fileType + " AND " + this._sqlFilterClause);
            if (ps.getMaxRows() == 0 || ps.getMaxRows() > 1000) {
                ps.setFetchSize(1000);
            } else {
                ps.setFetchSize(ps.getMaxRows() - 1);
            }
            rs = ps.executeQuery();
            while (rs.next()) {
                String annotator;
                String participant;
                String tierType;
                String tierName;
                String nodeId = rs.getString(1);
                if (!oneTypeNodes.contains(nodeId)) {
                    oneTypeNodes.add(nodeId);
                }
                if ((tierName = rs.getString(2)) != null && tierName.length() > 0) {
                    tierNames.put((Object)tierName, 1);
                }
                if ((tierType = rs.getString(3)) != null && tierType.length() > 0) {
                    tierTypes.put((Object)tierType, 1);
                }
                if ((participant = rs.getString(4)) != null && participant.length() > 0) {
                    participants.put((Object)participant, 1);
                }
                if ((annotator = rs.getString(5)) != null && annotator.length() > 0) {
                    annotators.put((Object)annotator, 1);
                }
                sumAnnotations += rs.getInt(6);
                ++nTiers;
            }
            rs.close();
            rs = null;
            ps.close();
        }
        catch (RuntimeException re) {
            _logger.error((Object)("TierCollection: RuntimeException: " + re), (Throwable)re);
        }
        catch (SQLException sqle) {
            _logger.error((Object)("TierCollection: SQLException: " + sqle), (Throwable)sqle);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sqle) {}
            }
        }
        int nNames = tierNames.size();
        int nTypes = tierTypes.size();
        int nParticipants = participants.size();
        int nAnnotators = annotators.size();
        this._typeTierCounts.put(fileType, nTiers);
        this._typeAnnoCounts.put(fileType, sumAnnotations);
        if (sumAnnotations + nNames + nTypes + nParticipants + nAnnotators > 0) {
            this._typeInfo.put(fileType, "" + oneTypeNodes.size() + " nodes, " + sumAnnotations + " annotations, " + nParticipants + " participants, " + nNames + " tier names, " + nTypes + " tier types, " + nAnnotators + " tier annotators");
        } else {
            this._typeInfo.put(fileType, "No data!");
        }
        if (nNames > 400) {
            tierNames.clear();
        }
        if (nTypes > 400) {
            tierTypes.clear();
        }
        if (nParticipants > 200) {
            participants.clear();
        }
        if (nAnnotators > 100) {
            annotators.clear();
        }
        this._typeNodes.put(fileType, oneTypeNodes);
        this._typeNames.put(fileType, (CountHash<String>)tierNames);
        this._typeTypes.put(fileType, (CountHash<String>)tierTypes);
        this._typeParticipants.put(fileType, (CountHash<String>)participants);
        this._typeAnnotators.put(fileType, (CountHash<String>)annotators);
    }

    private static String normalizeUserId(String userId) {
        if (userId == null || userId.trim().length() == 0 || "anonymous".equals(userId) || userId.equals("everybody")) {
            return "everybody";
        }
        if (userId.equals(_adminUser)) {
            return userId;
        }
        return userId;
    }
}

