/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.annot.search.lib;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import nl.mpi.annot.tools.data.AnnexAnnotation;
import nl.mpi.annot.tools.data.AnnexFileTypes;
import nl.mpi.annot.tools.data.AnnexTier;
import nl.mpi.annot.tools.data.AnnexTranscription;
import nl.mpi.annot.tools.data.CorpusStructDB;
import nl.mpi.annot.tools.util.UTF8Validator;
import nl.mpi.corpusstructure.NodeIdUtils;
import org.apache.log4j.Logger;

public class WritePostgreSQL
extends Thread {
    private static Logger _log = Logger.getLogger((String)"Searchlib.WritePostgreSQL");
    private static final boolean _storeLongTimes = false;
    private static final int BATCHSIZE = 1000;
    private Stats _writerStats = null;
    private BlockingQueue<AnnexTranscription> _ingestQueue = null;
    private Connection _con = null;
    private boolean _simulate = false;
    private static Map<String, Integer> _aclGroups = Collections.synchronizedMap(new HashMap());

    public WritePostgreSQL(Connection dbcon) {
        _log.debug((Object)"WritePostgreSQL Connection constructor");
        this._writerStats = new Stats();
        this._ingestQueue = new ArrayBlockingQueue<AnnexTranscription>(42, true);
        this._con = dbcon;
        if (this._con == null) {
            this._simulate = true;
        }
    }

    public WritePostgreSQL(String url, String usr, String pwd) throws SQLException {
        if (url == null) {
            _log.error((Object)"SearchCorpusDB Constructor recieved null strings as parameter JDBC url, using simulation mode.");
            this._simulate = true;
        }
        boolean bl = this._simulate = this._simulate || "simulate".equals(usr);
        if (!this._simulate) {
            this._con = DriverManager.getConnection(url, usr, pwd);
        }
    }

    @Override
    public void run() {
        while (true) {
            AnnexTranscription transcription = null;
            try {
                transcription = (AnnexTranscription)this._ingestQueue.poll();
                if (transcription == null) {
                    WritePostgreSQL.sleep(5L);
                }
            }
            catch (InterruptedException ie) {}
            continue;
            if (transcription.getType() == 42) {
                _log.debug((Object)("writer thread: EOF encountered: " + transcription.getNodeId()));
                int itemsPastEof = this._ingestQueue.size();
                if (itemsPastEof > 0) {
                    _log.error((Object)("Internal error: Dropped " + itemsPastEof + " items after the EOF marker"));
                }
                break;
            }
            Stats st = this.ingest(transcription, false);
            if (st == null) {
                String filePath = CorpusStructDB.getFilePathFor((String)transcription.getNodeId());
                _log.error((Object)("Database problem with: " + filePath));
                ++this._writerStats.nDBProblems;
                continue;
            }
            if (st.nEmpty > 0) {
                ++this._writerStats.nEmpty;
                continue;
            }
            this._writerStats.nTiers += st.nTiers;
            this._writerStats.nAnnotations += st.nAnnotations;
            this._writerStats.annotationsSize += st.annotationsSize;
        }
        this._ingestQueue.clear();
        this._ingestQueue = null;
        _log.debug((Object)"writer thread: waiting for getStats to be called");
        while (this._writerStats != null) {
            try {
                WritePostgreSQL.sleep(5L);
            }
            catch (InterruptedException ie) {
                _log.debug((Object)"(still waiting for getStats...)");
            }
        }
        _log.debug((Object)"writer thread: done.");
    }

    public Stats getStats(Stats input) {
        if (this._ingestQueue != null) {
            _log.debug((Object)"writer thread waiting for final stats to become available");
        }
        while (this._ingestQueue != null) {
            try {
                WritePostgreSQL.sleep(5L);
            }
            catch (InterruptedException ie) {
                _log.debug((Object)"(still waiting for final stats...)");
            }
        }
        _log.debug((Object)"writer thread: queue empty");
        input.nFiles += this._writerStats.nFiles;
        input.nExist += this._writerStats.nExist;
        input.nPermissionDenied += this._writerStats.nPermissionDenied;
        input.nNotParsable += this._writerStats.nNotParsable;
        input.nDBProblems += this._writerStats.nDBProblems;
        input.nEmpty += this._writerStats.nEmpty;
        input.nTiers += this._writerStats.nTiers;
        input.nAnnotations += this._writerStats.nAnnotations;
        input.annotationsSize += this._writerStats.annotationsSize;
        this._writerStats = null;
        return input;
    }

    public void sendFileToDb(AnnexTranscription transcription) {
        while (true) {
            try {
                this._ingestQueue.put(transcription);
                return;
            }
            catch (InterruptedException ie) {
                _log.debug((Object)"(ingestQueue put needs retry)");
                continue;
            }
            break;
        }
    }

    public void close() {
        if (!this._simulate) {
            try {
                this._con.close();
            }
            catch (SQLException e) {
                _log.warn((Object)("Connection close failed: " + e));
            }
        }
    }

    protected static void initTables(Statement st) throws SQLException {
        try {
            st.executeUpdate("CREATE SCHEMA search");
        }
        catch (SQLException e) {
            _log.debug((Object)"Schema 'search' already exists in this database, fine");
        }
        st.executeUpdate("DROP TABLE IF EXISTS search.new_annotations CASCADE");
        st.executeUpdate("DROP TABLE IF EXISTS search.new_tiers CASCADE");
        st.executeUpdate("DROP TABLE IF EXISTS search.new_fingerprints CASCADE");
        st.executeUpdate("DROP TABLE IF EXISTS search.new_vpaths CASCADE");
        st.executeUpdate("DROP TABLE IF EXISTS search.new_users CASCADE");
        st.executeUpdate("DROP TABLE IF EXISTS search.new_nodes CASCADE");
        st.executeUpdate("CREATE TABLE search.new_vpaths (free_for_all BOOLEAN NOT NULL, free_all_users BOOLEAN NOT NULL, group_id INTEGER NOT NULL, node_id TEXT NOT NULL, vpath TEXT NOT NULL )");
        st.executeUpdate("CREATE TABLE search.new_users ( group_id INTEGER NOT NULL, user_id TEXT NOT NULL )");
        st.executeUpdate("CREATE TABLE search.new_nodes ( node_id TEXT NOT NULL PRIMARY KEY,  url TEXT NOT NULL,  name_path TEXT NOT NULL )");
        st.executeUpdate("CREATE TABLE search.new_fingerprints ( tier_id INTEGER NOT NULL PRIMARY KEY, fourgram_bits BIT(" + UTF8Validator.stringifyBits((int[])UTF8Validator.fingerprint4grams((String)"bogus")).length() + "), trigram_bits BIT(" + UTF8Validator.stringifyBits((int[])UTF8Validator.fingerprintTrigrams((String)"bogus")).length() + "), bigram_bits BIT(" + UTF8Validator.stringifyBits((int[])UTF8Validator.fingerprintBigrams((String)"bogus")).length() + ") )");
        st.executeUpdate("CREATE TABLE search.new_tiers ( tier_id INTEGER NOT NULL, n_annotations INTEGER NOT NULL, ref_tier_id INTEGER NOT NULL, transcription_type INTEGER NOT NULL, aligned_annotations INTEGER NOT NULL, language_bits INTEGER NOT NULL, length_bits BIGINT NOT NULL, unigram_bits INTEGER NOT NULL, node_id TEXT NOT NULL, tier_name TEXT NOT NULL, tier_type TEXT NOT NULL, default_locale TEXT, annotator TEXT, participant TEXT NOT NULL )");
        st.executeUpdate("CREATE TABLE search.new_annotations ( ann_id SERIAL PRIMARY KEY, ann_position INTEGER NOT NULL, begin_time INTEGER NOT NULL, end_time INTEGER NOT NULL, ann_tier_id INTEGER NOT NULL, annotation TEXT NOT NULL )");
    }

    protected static void createIndexes(Statement st) throws SQLException {
        long stm = WritePostgreSQL.start_stopwatch();
        _log.debug((Object)"creating annotation tier id index...");
        st.executeUpdate("CREATE INDEX new_ann_tier_id_index ON search.new_annotations( ann_tier_id )");
        WritePostgreSQL.stop_stopwatch("anno tier id index", stm);
        _log.debug((Object)"creating tier indexes...");
        stm = WritePostgreSQL.start_stopwatch();
        st.executeUpdate("CREATE INDEX new_node_id_index ON search.new_tiers( node_id )");
        st.executeUpdate("CREATE INDEX new_tier_id_index ON search.new_tiers( tier_id )");
        st.executeUpdate("CREATE INDEX new_tier_name_index ON search.new_tiers( tier_name )");
        st.executeUpdate("CREATE INDEX new_tier_type_index ON search.new_tiers( tier_type )");
        st.executeUpdate("CREATE INDEX new_default_locale_index ON search.new_tiers( default_locale )");
        st.executeUpdate("CREATE INDEX new_participant_index ON search.new_tiers( participant )");
        st.executeUpdate("CREATE INDEX new_ref_tier_id_index ON search.new_tiers( ref_tier_id )");
        st.executeUpdate("CREATE INDEX new_transcription_type_index ON search.new_tiers( transcription_type )");
        WritePostgreSQL.stop_stopwatch("tier indexes", stm);
        stm = WritePostgreSQL.start_stopwatch();
        _log.debug((Object)"creating fingerprint indexes...");
        st.executeUpdate("CREATE INDEX new_unigram_bits_index ON search.new_tiers( unigram_bits )");
        st.executeUpdate("CREATE INDEX new_language_bits_index ON search.new_tiers( language_bits )");
        st.executeUpdate("CREATE INDEX new_length_bits_index ON search.new_tiers( length_bits )");
        WritePostgreSQL.stop_stopwatch("fingerprint indexes", stm);
        stm = WritePostgreSQL.start_stopwatch();
        _log.debug((Object)"creating node vpath indexes...");
        st.executeUpdate("CREATE INDEX new_vpaths_node_index ON search.new_vpaths( node_id )");
        st.executeUpdate("CREATE INDEX new_vpaths_vpath_index ON search.new_vpaths( vpath )");
        WritePostgreSQL.stop_stopwatch("node vpath indexes", stm);
        st.executeUpdate("CREATE INDEX new_users_user_index ON search.new_users( user_id )");
        st.executeUpdate("CREATE INDEX new_users_group_index ON search.new_users( group_id )");
    }

    protected static void dropOldData(Statement st) throws SQLException {
        _log.info((Object)"Dropping old data...");
        st.executeUpdate("DROP TABLE IF EXISTS search.annotations CASCADE");
        st.executeUpdate("DROP TABLE IF EXISTS search.tiers CASCADE");
        st.executeUpdate("DROP TABLE IF EXISTS search.fingerprints CASCADE");
        st.executeUpdate("DROP TABLE IF EXISTS search.nodes CASCADE");
        st.executeUpdate("DROP TABLE IF EXISTS search.vpaths CASCADE");
        st.executeUpdate("DROP TABLE IF EXISTS search.users CASCADE");
    }

    protected static void renameTables(Statement st) throws SQLException {
        st.executeUpdate("ALTER TABLE search.new_annotations RENAME TO annotations");
        st.executeUpdate("ALTER INDEX search.new_ann_tier_id_index RENAME TO ann_tier_id_index");
        st.executeUpdate("ALTER TABLE search.new_tiers RENAME TO tiers");
        st.executeUpdate("ALTER INDEX search.new_node_id_index RENAME TO node_id_index");
        st.executeUpdate("ALTER INDEX search.new_tier_id_index RENAME TO tier_id_index");
        st.executeUpdate("ALTER INDEX search.new_tier_name_index RENAME TO tier_name_index");
        st.executeUpdate("ALTER INDEX search.new_tier_type_index RENAME TO tier_type_index");
        st.executeUpdate("ALTER INDEX search.new_default_locale_index RENAME TO default_locale_index");
        st.executeUpdate("ALTER INDEX search.new_participant_index RENAME TO participant_index");
        st.executeUpdate("ALTER INDEX search.new_ref_tier_id_index RENAME TO ref_tier_id_index");
        st.executeUpdate("ALTER INDEX search.new_transcription_type_index RENAME TO transcription_type_index");
        st.executeUpdate("ALTER INDEX search.new_unigram_bits_index RENAME TO unigram_bits_index");
        st.executeUpdate("ALTER INDEX search.new_language_bits_index RENAME TO language_bits_index");
        st.executeUpdate("ALTER INDEX search.new_length_bits_index RENAME TO length_bits_index");
        st.executeUpdate("ALTER TABLE search.new_fingerprints RENAME TO fingerprints");
        st.executeUpdate("ALTER TABLE search.new_nodes RENAME TO nodes");
        st.executeUpdate("ALTER TABLE search.new_vpaths RENAME TO vpaths");
        st.executeUpdate("ALTER INDEX search.new_vpaths_node_index RENAME TO vpaths_node_index");
        st.executeUpdate("ALTER INDEX search.new_vpaths_vpath_index RENAME TO vpaths_vpath_index");
        st.executeUpdate("ALTER TABLE search.new_users RENAME TO users");
        st.executeUpdate("ALTER INDEX search.new_users_user_index RENAME TO users_user_index");
        st.executeUpdate("ALTER INDEX search.new_users_group_index RENAME TO users_group_index");
        Properties props = new Properties(System.getProperties());
        String grantedUser = props.getProperty("nl.mpi.annot.search.read_grant_user", "annexreader").trim();
        if (grantedUser.length() == 0) {
            _log.warn((Object)"You should let this tool grant SQL read access to a special user, see docs!");
        } else {
            try {
                st.executeUpdate("GRANT USAGE ON SCHEMA search TO " + grantedUser);
                st.executeUpdate("GRANT SELECT ON TABLE search.tiers, search.annotations, search.vpaths, search.users, search.nodes, search.fingerprints TO " + grantedUser);
            }
            catch (SQLException sqle) {
                _log.warn((Object)("Cannot grant read-only access to '" + grantedUser + "', maybe user not created yet?"));
                _log.info((Object)("To create user, as 'postgres', run: createuser -D -E -e -P -R -S " + grantedUser));
                _log.debug((Object)("Add to pg_hba.conf: host annex " + grantedUser + " 0.0.0.0/0 md5"));
                _log.debug((Object)"Reload pg_hba.conf as 'postgres', using: pg_ctl reload -D /your/data/dir");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Stats ingest(AnnexTranscription transcription, boolean inCurrent) {
        Stats stats = new Stats();
        HashMap<AnnexTier, Integer> ids = new HashMap<AnnexTier, Integer>();
        boolean acm = false;
        String filePath = CorpusStructDB.getFilePathFor((String)transcription.getNodeId());
        int nodeId = NodeIdUtils.TOINT((String)transcription.getNodeId());
        if (nodeId >= 0x800000) {
            _log.error((Object)("Node ID must not be 2^23 or above: " + transcription.getNodeId() + " for: " + filePath));
            ++stats.nDBProblems;
            return stats;
        }
        int nTiers = transcription.getTiers().size();
        if (nTiers == 0) {
            ++stats.nEmpty;
            return stats;
        }
        if (nTiers > 256) {
            _log.error((Object)("File must not have more than 256 tiers: " + nTiers + " for: " + filePath));
            ++stats.nDBProblems;
            return stats;
        }
        PreparedStatement stVPaths = null;
        Statement stAnnotation = null;
        Statement stTier = null;
        PreparedStatement stTierFingerprints = null;
        PreparedStatement stNodes = null;
        PreparedStatement stUsers = null;
        try {
            int i;
            Statement st = null;
            Object rs = null;
            int tierId = -1;
            if (!this._simulate) {
                acm = this._con.getAutoCommit();
                this._con.setAutoCommit(false);
                st = this._con.createStatement();
                tierId = nodeId * 256;
                stAnnotation = this._con.prepareStatement("INSERT INTO " + (inCurrent ? "search.annotations" : "search.new_annotations") + " ( ann_position, begin_time, end_time, ann_tier_id, annotation )" + " VALUES ( ?, ?, ?, ?, ? )");
                stTier = this._con.prepareStatement("INSERT INTO " + (inCurrent ? "search.tiers" : "search.new_tiers") + " ( tier_id, tier_name, tier_type, default_locale, annotator, participant, n_annotations," + " ref_tier_id, transcription_type, node_id, aligned_annotations," + " unigram_bits, language_bits, length_bits )" + " VALUES ( ?, ?, ?, ?, ?, ?, ?,   ?, ?, ?, ?,   ?, ?, ? )");
                stTierFingerprints = this._con.prepareStatement("INSERT INTO " + (inCurrent ? "search.fingerprints" : "search.new_fingerprints") + " ( tier_id, bigram_bits, trigram_bits, fourgram_bits )" + " VALUES ( ?, ?::bit(" + UTF8Validator.stringifyBits((int[])UTF8Validator.fingerprintBigrams((String)"bogus")).length() + "), ?::bit(" + UTF8Validator.stringifyBits((int[])UTF8Validator.fingerprintTrigrams((String)"bogus")).length() + "), ?::bit(" + UTF8Validator.stringifyBits((int[])UTF8Validator.fingerprint4grams((String)"bogus")).length() + ") )");
                stVPaths = this._con.prepareStatement("INSERT INTO " + (inCurrent ? "search.vpaths" : "search.new_vpaths") + " ( node_id, free_for_all, free_all_users, group_id, vpath ) VALUES ( ?, ?, ?, ?, ? )");
                stNodes = this._con.prepareStatement("INSERT INTO " + (inCurrent ? "search.nodes" : "search.new_nodes") + " ( node_id, url, name_path ) VALUES ( ?, ?, ? )");
                stUsers = this._con.prepareStatement("INSERT INTO " + (inCurrent ? "search.users" : "search.new_users") + " ( user_id, group_id ) VALUES ( ?, ? )");
            }
            String[] vpaths = CorpusStructDB.getCorpusStructureDB().getCorpusNode(transcription.getNodeId()).getVPaths();
            String url = CorpusStructDB.getURLFor((String)transcription.getNodeId()).toString();
            String namePath = CorpusStructDB.getNamePathFor((String)transcription.getNodeId());
            boolean freeForAnonymous = CorpusStructDB.getArchiveObjectsDB().hasReadAccess(transcription.getNodeId(), "everybody");
            boolean freeForUsers = CorpusStructDB.getArchiveObjectsDB().hasReadAccess(transcription.getNodeId(), "anyAuthenticatedUser");
            List aclDetails = CorpusStructDB.getAccessRightsFor((String)transcription.getNodeId());
            Integer aclGroupId = null;
            Map<String, Integer> map = _aclGroups;
            synchronized (map) {
                aclGroupId = _aclGroups.get(aclDetails.get(0));
                if (aclGroupId == null) {
                    aclGroupId = _aclGroups.size();
                    _aclGroups.put((String)aclDetails.get(0), aclGroupId);
                    _log.info((Object)("New ACL group " + aclGroupId + ", " + (aclDetails.size() - 1) + " items for: '" + (String)aclDetails.get(0) + "'"));
                    for (int i2 = 0; i2 < aclDetails.size(); ++i2) {
                        if (i2 == 0 && aclDetails.size() > 1) continue;
                        if (!this._simulate) {
                            stUsers.clearParameters();
                            stUsers.setString(1, (String)aclDetails.get(i2));
                            stUsers.setInt(2, aclGroupId);
                            stUsers.executeUpdate();
                            continue;
                        }
                        _log.debug((Object)("ACL group " + aclGroupId + " includes user: '" + (String)aclDetails.get(i2) + "'"));
                    }
                }
            }
            for (i = 0; i < vpaths.length; ++i) {
                if (this._simulate) continue;
                stVPaths.clearParameters();
                stVPaths.setString(1, transcription.getNodeId());
                stVPaths.setBoolean(2, freeForAnonymous);
                stVPaths.setBoolean(3, freeForUsers);
                stVPaths.setInt(4, aclGroupId);
                stVPaths.setString(5, vpaths[i]);
                stVPaths.executeUpdate();
            }
            if (!this._simulate) {
                stNodes.clearParameters();
                stNodes.setString(1, transcription.getNodeId());
                stNodes.setString(2, url);
                stNodes.setString(3, namePath);
                stNodes.executeUpdate();
            }
            stats.nTiers = nTiers;
            for (i = 0; i < nTiers; ++i) {
                AnnexTier tier = (AnnexTier)transcription.getTiers().get(i);
                ids.put(tier, tierId + i);
            }
            for (i = 0; i < nTiers; ++i) {
                AnnexAnnotation annotation;
                int j;
                AnnexTier tier = (AnnexTier)transcription.getTiers().get(i);
                int ref_tier_id = -1;
                if (tier.parentTier != null) {
                    if (ids.get(tier.parentTier) != null) {
                        ref_tier_id = (Integer)ids.get(tier.parentTier);
                    } else {
                        _log.warn((Object)("Ignored bad parent tier reference: " + tier.name + " ==> " + tier.parentTier.name + " in: " + filePath));
                    }
                }
                int nAnnotations = tier.annotations.size();
                int unigram_bits = 0;
                int language_bits = 0;
                long length_bits = 0L;
                int[] bigram_bits = UTF8Validator.fingerprintBigrams((String)"bogus");
                for (int j2 = 0; j2 < bigram_bits.length; ++j2) {
                    bigram_bits[j2] = 0;
                }
                int[] trigram_bits = UTF8Validator.fingerprintTrigrams((String)"bogus");
                for (int j3 = 0; j3 < trigram_bits.length; ++j3) {
                    trigram_bits[j3] = 0;
                }
                int[] fourgram_bits = UTF8Validator.fingerprint4grams((String)"bogus");
                for (int j4 = 0; j4 < fourgram_bits.length; ++j4) {
                    fourgram_bits[j4] = 0;
                }
                stats.nAnnotations += (long)nAnnotations;
                int nAlignedAnnotations = 0;
                for (j = 0; j < nAnnotations; ++j) {
                    annotation = (AnnexAnnotation)tier.annotations.get(j);
                    if (annotation != null && annotation.isTimeAligned) {
                        ++nAlignedAnnotations;
                    }
                    stats.annotationsSize += (long)annotation.value.length();
                    unigram_bits |= UTF8Validator.fingerprintChars((String)annotation.value);
                    language_bits |= UTF8Validator.fingerprintLanguages((String)annotation.value);
                    length_bits |= 1L << UTF8Validator.binLength((int)annotation.value.length());
                    int[] bigram_bits_anno = UTF8Validator.fingerprintBigrams((String)annotation.value);
                    for (int k = 0; k < bigram_bits.length; ++k) {
                        int n = k;
                        bigram_bits[n] = bigram_bits[n] | bigram_bits_anno[k];
                    }
                    int[] trigram_bits_anno = UTF8Validator.fingerprintTrigrams((String)annotation.value);
                    for (int k = 0; k < trigram_bits.length; ++k) {
                        int n = k;
                        trigram_bits[n] = trigram_bits[n] | trigram_bits_anno[k];
                    }
                    int[] fourgram_bits_anno = UTF8Validator.fingerprint4grams((String)annotation.value);
                    for (int k = 0; k < fourgram_bits.length; ++k) {
                        int n = k;
                        fourgram_bits[n] = fourgram_bits[n] | fourgram_bits_anno[k];
                    }
                }
                if (tier.type == null) {
                    _log.error((Object)("Tier without type in: " + filePath));
                    tier.type = "unknown";
                }
                if (tier.participant == null) {
                    _log.error((Object)("Tier without participant info in: " + filePath));
                    tier.participant = "unknown";
                }
                if (nAnnotations == 0 || nAnnotations == 1 && ((AnnexAnnotation)tier.annotations.get((int)0)).value.trim().length() == 0) {
                    _log.debug((Object)("Empty tier: " + tier.name + " in: " + filePath));
                }
                for (j = 0; j < nAnnotations; ++j) {
                    int endTime;
                    annotation = (AnnexAnnotation)tier.annotations.get(j);
                    if (annotation.value.length() > 2600) {
                        _log.warn((Object)("Annotation longer than 2600 characters, length " + annotation.value.length() + " in " + nAnnotations + "-annotation tier '" + tier.name + "'[" + j + "] in: " + filePath));
                    }
                    if (this._simulate) continue;
                    stAnnotation.clearParameters();
                    stAnnotation.setInt(1, j);
                    int startTime = annotation.beginTime < Integer.MIN_VALUE ? Integer.MIN_VALUE : Integer.MAX_VALUE;
                    int n = endTime = annotation.endTime < Integer.MIN_VALUE ? Integer.MIN_VALUE : Integer.MAX_VALUE;
                    if (annotation.beginTime >= Integer.MIN_VALUE && annotation.beginTime <= Integer.MAX_VALUE) {
                        startTime = (int)annotation.beginTime;
                    } else {
                        _log.error((Object)("Bad annotation start time, not in int32 range: " + annotation + " in " + filePath));
                    }
                    if (annotation.endTime >= Integer.MIN_VALUE && annotation.endTime <= Integer.MAX_VALUE) {
                        endTime = (int)annotation.endTime;
                    } else {
                        _log.error((Object)("Bad annotation end time, not in int32 range: " + annotation + " in " + filePath));
                    }
                    stAnnotation.setInt(2, startTime);
                    stAnnotation.setInt(3, endTime);
                    stAnnotation.setInt(4, tierId);
                    stAnnotation.setString(5, annotation.value);
                    if (annotation.beginTime > annotation.endTime) {
                        _log.error((Object)("Bad annotation, end before start, skipped: " + annotation + " in " + filePath));
                    } else {
                        stAnnotation.addBatch();
                    }
                    if (j % 1000 != 0 && j != nAnnotations - 1) continue;
                    stAnnotation.executeBatch();
                    stAnnotation.clearBatch();
                }
                String bigramBitString = UTF8Validator.stringifyBits((int[])bigram_bits);
                String trigramBitString = UTF8Validator.stringifyBits((int[])trigram_bits);
                String fourgramBitString = UTF8Validator.stringifyBits((int[])fourgram_bits);
                if (!this._simulate) {
                    stTier.clearParameters();
                    stTier.setInt(1, tierId);
                    stTier.setString(2, tier.name);
                    stTier.setString(3, tier.type);
                    stTier.setString(4, tier.defaultLocale);
                    stTier.setString(5, tier.annotator);
                    stTier.setString(6, tier.participant);
                    stTier.setInt(7, nAnnotations);
                    stTier.setInt(8, ref_tier_id);
                    stTier.setInt(9, transcription.getType());
                    stTier.setString(10, transcription.getNodeId());
                    stTier.setInt(11, nAlignedAnnotations);
                    stTier.setInt(12, unigram_bits);
                    stTier.setInt(13, language_bits);
                    stTier.setLong(14, length_bits);
                    stTier.executeUpdate();
                    stTierFingerprints.clearParameters();
                    stTierFingerprints.setInt(1, tierId);
                    if (bigramBitString.indexOf(49) == -1) {
                        stTierFingerprints.setNull(2, 12);
                    } else {
                        stTierFingerprints.setString(2, bigramBitString);
                    }
                    if (trigramBitString.indexOf(49) == -1) {
                        stTierFingerprints.setNull(3, 12);
                    } else {
                        stTierFingerprints.setString(3, trigramBitString);
                    }
                    if (fourgramBitString.indexOf(49) == -1) {
                        stTierFingerprints.setNull(4, 12);
                    } else {
                        stTierFingerprints.setString(4, fourgramBitString);
                    }
                    stTierFingerprints.executeUpdate();
                }
                ++tierId;
            }
            if (!this._simulate) {
                this._con.commit();
                this._con.setAutoCommit(acm);
            }
        }
        catch (SQLException e) {
            _log.error((Object)("ingest SQLException: " + e + "in: " + filePath), (Throwable)e);
            try {
                this._con.rollback();
                this._con.setAutoCommit(acm);
            }
            catch (SQLException ex) {
                _log.error((Object)("ingest: failed rollback: " + ex.toString()));
                _log.error((Object)"Not making new database tables active: Missed rollbacks!");
                _log.error((Object)"Old database still active. Please fix problem and retry.");
                throw new Error("Failed rollback in ingest: " + ex.toString());
            }
            Stats ex = null;
            return ex;
        }
        catch (RuntimeException re) {
            _log.error((Object)("ingest RuntimeException:" + re + "in: " + filePath), (Throwable)re);
            try {
                this._con.rollback();
                this._con.setAutoCommit(acm);
            }
            catch (SQLException ex) {
                _log.error((Object)("ingest: failed rollback: " + ex.toString()));
                _log.error((Object)"Not making new database tables active: Missed rollbacks!");
                _log.error((Object)"Old database still active. Please fix problem and retry.");
                throw new Error("Failed rollback in ingest: " + ex.toString());
            }
            Stats stats2 = null;
            return stats2;
        }
        finally {
            if (stTier != null) {
                try {
                    stTier.close();
                }
                catch (SQLException e) {
                    _log.warn((Object)("Failed to close tier statement in ingest finally block: " + e));
                }
            }
            if (stAnnotation != null) {
                try {
                    stAnnotation.close();
                }
                catch (SQLException e) {
                    _log.warn((Object)("Failed to close annotation statement in ingest finally block: " + e));
                }
            }
        }
        return stats;
    }

    public static long start_stopwatch() {
        return System.currentTimeMillis();
    }

    public static void stop_stopwatch(String what, long startTime) {
        long millis = System.currentTimeMillis() + 499L - startTime;
        long hours = millis / 3600000L;
        long minutes = (millis -= hours * 3600000L) / 60000L;
        long seconds = (millis -= minutes * 60000L) / 1000L;
        _log.info((Object)("Done: " + what + ", duration: " + hours + ":" + (minutes < 10L ? "0" : "") + minutes + ":" + (seconds < 10L ? "0" : "") + seconds + " \tWall time: " + new Date()));
    }

    protected PreparedStatement getPreparedStatement(String statement) throws SQLException {
        return this._con.prepareStatement(statement);
    }

    protected Statement createStatement() throws SQLException {
        return this._con.createStatement();
    }

    protected Connection getConnection() {
        return this._con;
    }

    protected boolean isSimulation() {
        return this._simulate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addNode(String nodeId) throws SQLException {
        if (this._simulate) {
            return;
        }
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.getPreparedStatement("SELECT node_id FROM search.tiers WHERE node_id = ?");
            ps.setString(1, nodeId);
            rs = ps.executeQuery();
            if (rs.next()) {
                throw new SQLException("Already in DB, remove before re-adding: " + nodeId);
            }
        }
        finally {
            if (ps != null) {
                ps.close();
            }
            if (rs != null) {
                rs.close();
            }
        }
        String filePath = CorpusStructDB.getFilePathFor((String)nodeId);
        File file = new File(filePath);
        if (!file.exists()) {
            throw new SQLException("File does not exist for nodeID: " + nodeId + " => " + filePath);
        }
        int type = AnnexFileTypes.getTypeFor((String)CorpusStructDB.getMimeTypeFor((String)nodeId));
        AnnexTranscription transcription = new AnnexTranscription(nodeId, type, file);
        if (!transcription.isValid()) {
            throw new SQLException("Invalid transcription for nodeID: " + nodeId + " => " + filePath);
        }
        Stats stats = this.ingest(transcription, true);
        if (stats == null) {
            throw new SQLException("Database problem for nodeID: " + nodeId + " => " + filePath);
        }
    }

    protected void removeNode(String nodeId) throws SQLException {
        if (this._simulate) {
            return;
        }
        boolean acm = this._con.getAutoCommit();
        this._con.setAutoCommit(false);
        PreparedStatement ps = null;
        try {
            ps = this.getPreparedStatement("DELETE FROM search.annotations WHERE ann_tier_id BETWEEN ? AND ?");
            ps.setInt(1, NodeIdUtils.TOINT((String)nodeId) * 256);
            ps.setInt(1, NodeIdUtils.TOINT((String)nodeId) * 256 + 256 - 1);
            ps.executeUpdate();
            ps.close();
            ps = this.getPreparedStatement("DELETE FROM search.fingerprints WHERE ann_tier_id BETWEEN ? AND ?");
            ps.setInt(1, NodeIdUtils.TOINT((String)nodeId) * 256);
            ps.setInt(1, NodeIdUtils.TOINT((String)nodeId) * 256 + 256 - 1);
            ps.executeUpdate();
            ps.close();
            ps = this.getPreparedStatement("DELETE FROM search.tiers WHERE node_id = ?");
            ps.setString(1, nodeId);
            ps.executeUpdate();
            ps.close();
            ps = this.getPreparedStatement("DELETE FROM search.nodes WHERE node_id = ?");
            ps.setString(1, nodeId);
            ps.executeUpdate();
            ps.close();
            ps = this.getPreparedStatement("DELETE FROM search.vpaths WHERE node_id = ?");
            ps.setString(1, nodeId);
            ps.executeUpdate();
            this._con.commit();
        }
        catch (SQLException e) {
            this._con.rollback();
            throw e;
        }
        finally {
            if (ps != null) {
                ps.close();
            }
            this._con.setAutoCommit(acm);
        }
    }

    static {
        try {
            Class.forName("org.postgresql.Driver");
        }
        catch (ClassNotFoundException e) {
            System.out.println("org.postgresql.Driver not found - provide JARs, see Class-Path header if running via -jar");
            Logger.getLogger((String)"Searchlib.WritePostgreSQL").error((Object)"org.postgresql.Driver not found - provide JARs, see Class-Path header if running via -jar");
        }
    }

    public static class Stats {
        public int nFiles;
        public int nExist;
        public int nPermissionDenied;
        public int nNotParsable;
        public int nDBProblems;
        public int nEmpty;
        public int nTiers;
        public long nAnnotations;
        public long annotationsSize;
    }
}

