/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.annot.search.lib;

import nl.mpi.annot.search.lib.FrequencyInfo;
import nl.mpi.annot.search.lib.SearchHit;
import nl.mpi.annot.tools.util.XmlUtil;

public class XmlHelpers {
    public static String getFreqInfoAsXML(FrequencyInfo info) {
        StringBuilder xml = new StringBuilder(256);
        xml.append("<hit>");
        xml.append(XmlUtil.xmlifyNameValuePair((String)"annotation", (String)info.annotation));
        xml.append(XmlUtil.xmlifyNameValuePair((String)"occurences", (long)info.nOccurences));
        xml.append(XmlUtil.xmlifyNameValuePair((String)"numberOfHits", (long)info.numberOfHits));
        xml.append(XmlUtil.xmlifyNameValuePair((String)"hitPositionInAnnotation", (long)info.hitPositionInAnnotation));
        xml.append(XmlUtil.xmlifyNameValuePair((String)"hitLength", (long)info.hitLength));
        xml.append(XmlUtil.xmlifyNameValuePair((String)"annId", (long)info.annId));
        xml.append(XmlUtil.xmlifyNameValuePair((String)"fileIndex", (long)info.fileIndex));
        return xml.append("</hit>\n").toString();
    }

    public static String getHitAsXML(SearchHit hit) {
        int i;
        StringBuilder xml = new StringBuilder(512);
        xml.append("\n<hit>");
        xml.append(XmlUtil.xmlifyNameValuePair((String)"annotation", (String)hit.annotation));
        xml.append(XmlUtil.xmlifyNameValuePair((String)"aligned", (boolean)hit.aligned));
        xml.append(XmlUtil.xmlifyNameValuePair((String)"beginTime", (long)hit.beginTime));
        xml.append(XmlUtil.xmlifyNameValuePair((String)"endTime", (long)hit.endTime));
        xml.append(XmlUtil.xmlifyNameValuePair((String)"hitLength", (long)hit.hitLength));
        xml.append(XmlUtil.xmlifyNameValuePair((String)"hitNumberInAnnotation", (long)hit.hitNumberInAnnotation));
        xml.append(XmlUtil.xmlifyNameValuePair((String)"hitPositionInAnnotation", (long)hit.hitPositionInAnnotation));
        xml.append(XmlUtil.xmlifyNameValuePair((String)"positionInTier", (long)hit.positionInTier));
        xml.append(XmlUtil.xmlifyNameValuePair((String)"tierName", (String)hit.tierName));
        xml.append(XmlUtil.xmlifyNameValuePair((String)"tierType", (String)hit.tierType));
        xml.append(XmlUtil.xmlifyNameValuePair((String)"participant", (String)hit.participant));
        xml.append(XmlUtil.xmlifyNameValuePair((String)"annotator", (String)(hit.annotator == null ? "" : hit.annotator)));
        xml.append(XmlUtil.xmlifyNameValuePair((String)"complex", (boolean)hit.complex));
        xml.append(XmlUtil.xmlifyNameValuePair((String)"transcriptionNodeId", (String)hit.transcriptionNodeId));
        xml.append(XmlUtil.xmlifyNameValuePair((String)"transcriptionName", (String)hit.transcriptionName));
        xml.append(XmlUtil.xmlifyNameValuePair((String)"transcriptionURL", (String)hit.transcriptionURL));
        String beforeString = "";
        for (i = 0; i < hit.leftContext.size(); ++i) {
            beforeString = hit.leftContext.get(i) + "  " + beforeString;
        }
        xml.append(XmlUtil.xmlifyNameValuePair((String)"leftContext", (String)beforeString.trim()));
        xml.append("<rightContext>");
        for (i = 0; i < hit.rightContext.size(); ++i) {
            xml.append(XmlUtil.escapeXML((String)hit.rightContext.get(i))).append(" ");
        }
        xml.append("</rightContext>\n");
        xml.append("</hit>\n");
        return xml.toString();
    }
}

