/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.annot.tools.data;

import java.io.Serializable;
import nl.mpi.annot.tools.util.UnicodeNormalizer;

public class AnnexAnnotation
implements Serializable {
    public final String value;
    public final long beginTime;
    public final long endTime;
    public final boolean isTimeAligned;
    public final String id;
    public boolean interpolatedTime;
    public AnnexAnnotation refAnnotation;

    public AnnexAnnotation(String value, long beginTime, long endTime, boolean isTimeAligned, String id) {
        if (value == null) {
            throw new NullPointerException("Value must not be null");
        }
        if (value.indexOf(0) != -1) {
            throw new IllegalArgumentException("Value must not contain NUL chars: " + value.replace('\u0000', '\ufffd'));
        }
        if (beginTime > endTime) {
            throw new IllegalArgumentException("Begin time must not be after end time: " + beginTime + " > " + endTime + " '" + value + "'");
        }
        String normalized = UnicodeNormalizer.normalizeAnnotationToNFC(value, beginTime, endTime);
        String denormal = UnicodeNormalizer.checkNFC(normalized);
        if (denormal != null) {
            throw new IllegalArgumentException("Annotation cannot be normalized to NFC: " + denormal);
        }
        if (normalized.equals(" ")) {
            normalized = "";
        }
        this.value = normalized;
        this.beginTime = beginTime;
        this.endTime = endTime;
        this.isTimeAligned = isTimeAligned;
        this.id = id;
        this.interpolatedTime = false;
        this.refAnnotation = null;
    }

    public AnnexAnnotation cloneWithNewTimes(long updatedBeginTime, long updatedEndTime) {
        AnnexAnnotation aa = new AnnexAnnotation(this.value, updatedBeginTime, updatedEndTime, this.isTimeAligned, this.id);
        aa.interpolatedTime = this.interpolatedTime;
        aa.refAnnotation = this.refAnnotation;
        return aa;
    }

    public String toString() {
        return "AnnexAnnotation[" + this.id + ":" + this.beginTime + "-" + this.endTime + "] " + (this.isTimeAligned ? "aligned " : "") + (this.interpolatedTime ? "interpolated " : "") + (this.refAnnotation == null ? "" : "{Ref:" + this.refAnnotation + "} ") + "'" + this.value + "'";
    }
}

