/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.annot.tools.data;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import nl.mpi.corpusstructure.AccessInfo;
import nl.mpi.corpusstructure.ArchiveAccessContext;
import nl.mpi.corpusstructure.ArchiveObjectsDB;
import nl.mpi.corpusstructure.CorpusStructureDB;
import nl.mpi.corpusstructure.CorpusStructureDBImpl;
import nl.mpi.corpusstructure.StreamingPreparation;
import nl.mpi.corpusstructure.UnknownNodeException;
import org.apache.log4j.Logger;

public class CorpusStructDB {
    private static Logger logger = Logger.getLogger(CorpusStructDB.class);
    private static String _corpusDbURL;
    private static String _corpusDbUser;
    private static String _corpusDbPassword;
    private static CorpusStructureDB csdb;
    private static ArchiveObjectsDB aodb;

    public static void setCorpusDB(String jdbc, String user, String pass) {
        _corpusDbURL = jdbc;
        _corpusDbUser = user;
        _corpusDbPassword = pass;
    }

    public static void setCorpusDB(String jdbc) {
        CorpusStructDB.setCorpusDB(jdbc, null, null);
    }

    public static StreamingPreparation getStreamingPreparation(String anonymizerHost, int anonymizerPort) {
        if (_corpusDbURL == null || "none".equals(_corpusDbURL)) {
            return null;
        }
        return new StreamingPreparation(_corpusDbURL, _corpusDbUser, _corpusDbPassword, anonymizerHost, anonymizerPort);
    }

    public static StreamingPreparation getStreamingPreparation() {
        if (_corpusDbURL == null || "none".equals(_corpusDbURL)) {
            return null;
        }
        return new StreamingPreparation(_corpusDbURL, _corpusDbUser, _corpusDbPassword);
    }

    public static boolean hasAccessTo(String user, String nodeId) {
        boolean b;
        if (CorpusStructDB.getArchiveObjectsDB() == null) {
            return false;
        }
        AccessInfo ai = CorpusStructDB.getArchiveObjectsDB().getObjectAccessInfo(nodeId);
        if (user == null || "anonymous".equals(user) || user.trim().length() == 0) {
            user = "everybody";
        }
        if (!(b = ai.hasReadAccess(user))) {
            logger.warn((Object)("hasAccessTo: false for: " + user + " ai: " + ai + " in: " + nodeId));
        }
        return b;
    }

    public static boolean canRequestAccess(String nodeId) {
        if (CorpusStructDB.getArchiveObjectsDB() == null) {
            return false;
        }
        AccessInfo ai = CorpusStructDB.getArchiveObjectsDB().getObjectAccessInfo(nodeId);
        int level = ai.getAccessLevel();
        return level != -1 && level <= 3;
    }

    public static URL getURLFor(String nodeId) {
        if (CorpusStructDB.getArchiveObjectsDB() == null) {
            try {
                return new URL("http://UNKNOWN/" + nodeId);
            }
            catch (MalformedURLException mfe) {
                return null;
            }
        }
        return CorpusStructDB.getArchiveObjectsDB().getObjectURL(nodeId, 3).toURL();
    }

    public static String getNodeIdFor(String handle) {
        if (CorpusStructDB.getArchiveObjectsDB() == null) {
            return null;
        }
        return CorpusStructDB.getArchiveObjectsDB().getObjectForPID(handle);
    }

    public static String getFilePathFor(String nodeId) {
        if (nodeId == null) {
            return null;
        }
        if (CorpusStructDB.getArchiveObjectsDB() == null) {
            return "/UNKNOWN_FILE_PATH/" + nodeId;
        }
        return CorpusStructDB.getArchiveObjectsDB().getObjectURL(nodeId, ArchiveAccessContext.getFileUrlContext()).getPath();
    }

    public static ArrayList<String> getPossibleMediaFor(String nodeId) {
        ArrayList<String> media = new ArrayList<String>();
        if (CorpusStructDB.getCorpusStructureDB() == null) {
            return media;
        }
        try {
            if (CorpusStructDB.getCorpusStructureDB().getNode(nodeId).getNodeType() != 8) {
                return media;
            }
            String[] parentNodeIds = CorpusStructDB.getCorpusStructureDB().getParentNodes(nodeId);
            if (parentNodeIds == null) {
                return media;
            }
            String[] mediaNodeIds = CorpusStructDB.getCorpusStructureDB().getDescendants(parentNodeIds[0], 16, (String)null);
            for (int i = 0; i < mediaNodeIds.length; ++i) {
                media.add(CorpusStructDB.getCorpusStructureDB().getNode(mediaNodeIds[i]).getName());
            }
        }
        catch (UnknownNodeException une) {
            logger.error((Object)("getPossibleMediaFor: UnknownNodeException: " + (Object)((Object)une)), (Throwable)une);
        }
        return media;
    }

    public static String getMimeTypeFor(String nodeId) {
        if (nodeId == null || CorpusStructDB.getCorpusStructureDB() == null) {
            return "Unknown";
        }
        return CorpusStructDB.getCorpusStructureDB().getNode(nodeId).getFormat();
    }

    public static List<String> getAccessRightsFor(String nodeId) {
        ArrayList<String> list = new ArrayList<String>(1);
        if (nodeId == null || CorpusStructDB.getCorpusStructureDB() == null) {
            list.add("everybody");
            return list;
        }
        String acl = CorpusStructDB.getArchiveObjectsDB().getObjectAccessInfo(nodeId).getReadRights();
        if ("everybody".equals(acl)) {
            list.add("everybody");
            return list;
        }
        if ("nobody".equals(acl) || "cleared".equals(acl)) {
            list.add("everybody");
            return list;
        }
        if ("anyAuthenticatedUser".equals(acl)) {
            list.add("anyAuthenticatedUser");
            return list;
        }
        list.add(acl);
        String[] users = acl.split(" ");
        list.ensureCapacity(users.length + 1);
        for (int i = 0; i < users.length; ++i) {
            if (users[i].length() <= 0) continue;
            list.add(users[i]);
        }
        return list;
    }

    public static String getNameFor(String nodeId) {
        if (nodeId == null) {
            return null;
        }
        if (CorpusStructDB.getCorpusStructureDB() == null) {
            return "UNKNOWN:" + nodeId;
        }
        try {
            return CorpusStructDB.getCorpusStructureDB().getNode(nodeId).getName();
        }
        catch (UnknownNodeException une) {
            logger.warn((Object)("getNameFor: Node " + nodeId + " not known"));
            return "UNKNOWN";
        }
    }

    public static String getNamePathFor(String nodeId) {
        if (nodeId == null) {
            return null;
        }
        if (CorpusStructDB.getCorpusStructureDB() == null) {
            return "/UNKNOWN_NAME_PATH/" + nodeId;
        }
        return CorpusStructDB.getCorpusStructureDB().getNamePath(nodeId);
    }

    private static void initCorpusStructureDBImpl() {
        if (csdb != null && aodb != null) {
            return;
        }
        if (_corpusDbURL == null || "none".equals(_corpusDbURL)) {
            csdb = null;
            aodb = null;
            return;
        }
        CorpusStructureDBImpl csdbimpl = new CorpusStructureDBImpl(_corpusDbURL, false, _corpusDbUser, _corpusDbPassword);
        csdb = csdbimpl;
        aodb = csdbimpl;
    }

    public static CorpusStructureDB getNewCorpusStructureDB() {
        if (_corpusDbURL == null || "none".equals(_corpusDbURL)) {
            return null;
        }
        return new CorpusStructureDBImpl(_corpusDbURL, false, _corpusDbUser, _corpusDbPassword);
    }

    public static CorpusStructureDB getCorpusStructureDB() {
        if (csdb == null) {
            CorpusStructDB.initCorpusStructureDBImpl();
        }
        return csdb;
    }

    public static ArchiveObjectsDB getArchiveObjectsDB() {
        if (aodb == null) {
            CorpusStructDB.initCorpusStructureDBImpl();
        }
        return aodb;
    }

    public static void closeCorpusStructureDBImpl() {
        if (csdb != null) {
            csdb.close();
            csdb = null;
        }
        if (aodb != null) {
            aodb.close();
            aodb = null;
        }
    }
}

