/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.annot.tools.data;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.CharBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.MalformedInputException;
import java.util.ArrayList;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.xml.sax.InputSource;

public class DataUtil {
    private static Logger _logger = Logger.getLogger((String)DataUtil.class.getName());

    public static ArrayList<File> getUniqueEAFFilesIn(ArrayList<String> dirsAndPaths) {
        ArrayList<String> dirs = new ArrayList<String>();
        ArrayList<String> paths = new ArrayList<String>();
        for (int i = 0; i < dirsAndPaths.size(); ++i) {
            File f = new File(dirsAndPaths.get(i));
            if (f.isDirectory()) {
                dirs.add(dirsAndPaths.get(i));
                continue;
            }
            paths.add(dirsAndPaths.get(i));
        }
        return DataUtil.getUniqueEAFFilesIn(dirs, paths);
    }

    public static ArrayList<File> getUniqueEAFFilesIn(ArrayList<String> dirs, ArrayList<String> paths) {
        int i;
        TreeSet<File> sortedUniqueFiles = new TreeSet<File>();
        for (i = 0; i < dirs.size(); ++i) {
            File dir = new File(dirs.get(i));
            if (!dir.exists() || !dir.isDirectory() || !dir.canRead()) continue;
            sortedUniqueFiles.addAll(DataUtil.getAllEafFilesUnder(dir));
        }
        for (i = 0; i < paths.size(); ++i) {
            File file;
            String path = paths.get(i);
            if (!path.toLowerCase().endsWith(".eaf") || !(file = new File(path)).exists() || !file.canRead()) continue;
            sortedUniqueFiles.add(file);
        }
        ArrayList<File> result = new ArrayList<File>();
        result.addAll(sortedUniqueFiles);
        return result;
    }

    public static ArrayList<File> getAllEafFilesUnder(File directory) {
        ArrayList<File> eafFiles = new ArrayList<File>();
        File[] filesAndDirs = directory.listFiles();
        for (int i = 0; i < filesAndDirs.length; ++i) {
            File fileOrDir = filesAndDirs[i];
            if (fileOrDir.isFile() && fileOrDir.canRead()) {
                if (!fileOrDir.getName().toLowerCase().endsWith(".eaf")) continue;
                eafFiles.add(fileOrDir);
                continue;
            }
            if (!fileOrDir.isDirectory() || !fileOrDir.canRead()) continue;
            eafFiles.addAll(DataUtil.getAllEafFilesUnder(fileOrDir));
        }
        return eafFiles;
    }

    public static String expandTabs(String in, int tabsize) {
        StringBuilder sb = new StringBuilder(in.length() + 3 * tabsize);
        if (tabsize < 1) {
            tabsize = 1;
        }
        int len = 0;
        for (int i = 0; i < in.length(); ++i) {
            char ch = in.charAt(i);
            if (ch != '\t') {
                sb.append(ch);
                ++len;
                continue;
            }
            do {
                sb.append(' ');
            } while (++len % tabsize != 0);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCharsetName(File file) {
        String string;
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(file);
            byte[] buf = new byte[3];
            int nRead = stream.read(buf);
            stream.close();
            stream = null;
            if (nRead < 3) {
                if (nRead > -1) {
                    _logger.warn((Object)("getCharsetName: File is only " + nRead + " bytes, no BOM possible: " + file));
                }
                String string2 = null;
                return string2;
            }
            string = DataUtil.getCharsetName(buf);
        }
        catch (IOException e) {
            _logger.error((Object)("getCharsetName: IOException: " + e + " for: " + file));
            String string3 = null;
            return string3;
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {}
            }
        }
        return string;
    }

    public static String getCharsetName(InputSource inputSource) {
        try {
            InputStream stream = inputSource.getByteStream();
            byte[] buf = new byte[3];
            int nRead = stream.read(buf);
            stream.close();
            if (nRead < 3) {
                _logger.warn((Object)("getCharsetName: InputSource stream has only " + nRead + " bytes, no BOM possible: " + inputSource));
                return null;
            }
            return DataUtil.getCharsetName(buf);
        }
        catch (IOException e) {
            _logger.error((Object)("getCharsetName: IOException: " + e + " for InputSource: " + inputSource));
            return null;
        }
    }

    public static String getCharsetName(byte[] firstBytes) {
        if ((firstBytes[0] & 0xFF) == 239 && (firstBytes[1] & 0xFF) == 187 && (firstBytes[2] & 0xFF) == 191) {
            return "UTF-8";
        }
        if ((firstBytes[0] & 0xFF) == 254 && (firstBytes[1] & 0xFF) == 255) {
            return "UTF-16BE";
        }
        if ((firstBytes[0] & 0xFF) == 255 && (firstBytes[1] & 0xFF) == 254) {
            return "UTF-16LE";
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] readLines(File file, String charSetName) throws IOException {
        int retry = 0;
        boolean okay = false;
        String[] lines = new String[]{""};
        if (file == null) {
            return lines;
        }
        if (charSetName == null) {
            charSetName = DataUtil.getCharsetName(file);
        }
        Charset charset = Charset.forName("UTF-8");
        if (charSetName != null) {
            charset = Charset.forName(charSetName);
        }
        String txt = null;
        while (!okay && retry < 2) {
            FileInputStream fis = null;
            AbstractInterruptibleChannel fc = null;
            try {
                fis = new FileInputStream(file);
                fc = fis.getChannel();
                int size = (int)((FileChannel)fc).size();
                if (size == 0) {
                    _logger.warn((Object)("File is empty: " + file));
                    fc.close();
                    fc = null;
                    fis.close();
                    fis = null;
                    String[] stringArray = lines;
                    return stringArray;
                }
                MappedByteBuffer byteBuffer = ((FileChannel)fc).map(FileChannel.MapMode.READ_ONLY, 0L, size);
                try {
                    CharsetDecoder decoder = charset.newDecoder();
                    decoder.reset();
                    CharBuffer charBuffer = decoder.decode(byteBuffer);
                    decoder.flush(charBuffer);
                    txt = charBuffer.toString();
                    decoder.reset();
                    okay = true;
                }
                catch (MalformedInputException mie) {
                    ++retry;
                    if (charSetName != null) {
                        _logger.warn((Object)("Invalid " + charSetName + " file, reloading as ISO-8859-1: " + file));
                    } else {
                        _logger.info((Object)("File is not UTF-8, reloading as ISO-8859-1: " + file));
                    }
                    charset = Charset.forName("ISO-8859-1");
                }
            }
            finally {
                try {
                    if (fc != null) {
                        fc.close();
                    }
                }
                catch (IOException ioe) {
                    _logger.error((Object)("readLines: Failed to close FileChannel: " + ioe));
                }
                try {
                    if (fis == null) continue;
                    fis.close();
                }
                catch (IOException ioe) {
                    _logger.error((Object)("readLines: Failed to close FileInputStream: " + ioe));
                }
            }
        }
        lines = txt.split("\r?\n");
        return lines;
    }

    public static String[] readLines(InputSource inputSource, String charSetName) throws IOException {
        if (charSetName != null) {
            inputSource.setEncoding(charSetName);
        }
        ArrayList<String> lines = new ArrayList<String>();
        InputStream inStream = inputSource.getByteStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(inStream));
        String line = reader.readLine();
        while (line != null) {
            lines.add(line);
            line = reader.readLine();
        }
        reader.close();
        String[] lineArray = new String[lines.size()];
        for (int i = 0; i < lines.size(); ++i) {
            lineArray[i] = (String)lines.get(i);
        }
        return lineArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getAnnotationType(File file) {
        String text = "";
        FileInputStream fis = null;
        try {
            byte[] header = new byte[512];
            fis = new FileInputStream(file);
            int size = fis.read(header);
            fis.close();
            fis = null;
            if (size > 4) {
                text = new String(header, 0, size, "ISO-8859-1");
            }
        }
        catch (IOException e) {
            _logger.debug((Object)("getAnnotationType: IOException: " + e + " for: " + file));
            int n = -1;
            return n;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {}
            }
        }
        if (text.contains("<ANNOTATION_DOCUMENT")) {
            return 0;
        }
        if (text.contains("\\_sh")) {
            return 2;
        }
        if (text.contains("@Begin")) {
            return 1;
        }
        return -1;
    }

    public static String getMediaTypeFromName(String filename) {
        if (filename.endsWith(".wav")) {
            return "audio/x-wav";
        }
        if (filename.endsWith(".mpg")) {
            return "video/x-mpeg1";
        }
        if (filename.endsWith(".mov")) {
            return "video/quicktime";
        }
        if (filename.endsWith(".mpeg")) {
            return "video/x-mpeg2";
        }
        if (filename.endsWith(".m4a") || filename.endsWith(".mp4")) {
            if (filename.endsWith(".m4a")) {
                return "audio/mp4";
            }
            return "video/mp4";
        }
        if (filename.endsWith(".WAV")) {
            return "audio/x-wav";
        }
        _logger.info((Object)("No mimetype known for: " + filename));
        return "Unknown";
    }

    public static void main(String[] args) {
        System.out.println("Usage: Give file/dir names to get heuristic info");
        ArrayList<String> filenames = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            File f = new File(args[i]);
            if (!f.isDirectory()) {
                String charSetName = DataUtil.getCharsetName(f);
                if ("ISO-8859-1".equals(charSetName) || charSetName == null) {
                    charSetName = "(no BOM)";
                }
                int at = DataUtil.getAnnotationType(f);
                String annoType = "(Unknown)";
                if (at == 0) {
                    annoType = "EAF";
                } else if (at == 1) {
                    annoType = "CHAT";
                } else if (at == 2) {
                    annoType = "?BOX";
                }
                System.out.println(charSetName + " annotation type " + annoType + " media type: " + (at == -1 ? DataUtil.getMediaTypeFromName(args[i]) : "(Annotation)") + " file: " + args[i]);
            }
            filenames.add(args[i]);
        }
        ArrayList<File> files = DataUtil.getUniqueEAFFilesIn(filenames);
        for (int i = 0; i < files.size(); ++i) {
            System.out.println("EAF: " + files.get(i));
        }
    }
}

