/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.annot.tools.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.TreeSet;
import nl.mpi.annot.tools.util.CountHash;

public class ShoeboxTiers {
    private HashMap<String, Tier> _byName;
    private TreeSet<Tier> _byOrder;
    private CountHash<String> _timeEvidence = new CountHash();
    private boolean _hasElanTimes = false;

    public ShoeboxTiers() {
        this._byOrder = new TreeSet();
        this._byName = new HashMap();
    }

    public void put(String name, TierType type) {
        Tier tier = this._byName.get(name);
        if (tier == null) {
            if ("EUDICOt0".equals(name) || "EUDICOt1".equals(name) || "ELANBegin".equals(name) || "ELANEnd".equals(name)) {
                if (type == TierType.UNKNOWN) {
                    type = TierType.TIME;
                }
                this._hasElanTimes = true;
                this.addTimeEvidence(name, 5);
            } else if ("EUDICOp".equals(name) || "ELANParticipant".equals(name)) {
                this.addTimeEvidence(name, -5);
            } else {
                this.addTimeEvidence(name, 1);
            }
            tier = new Tier(name, this._byOrder.size(), type);
            this._byOrder.add(tier);
            this._byName.put(name, tier);
        } else {
            tier.setType(type);
        }
    }

    public int addTimeEvidence(String name, int change) {
        if (!(this._hasElanTimes || this._byName.get("ELANBegin") == null && this._byName.get("ELANEnd") == null && this._byName.get("EUDICOt0") == null && this._byName.get("EUDICOt1") == null)) {
            this._hasElanTimes = true;
        }
        if (change != 0) {
            if (change != 1 || name.startsWith("EUDICOt") || name.startsWith("ELAN")) {
                this._timeEvidence.put(name, change);
            } else if (!this._hasElanTimes) {
                this._timeEvidence.put(name, change);
            }
        }
        return this._timeEvidence.getCount(name);
    }

    public boolean usesElanTime() {
        return this._hasElanTimes;
    }

    public TierType getType(String name) {
        if (this._byName.get(name) == null) {
            return null;
        }
        return this._byName.get(name).getType();
    }

    public Collection<String> names(boolean includeTime) {
        ArrayList<String> result = new ArrayList<String>();
        for (Tier next : this._byOrder) {
            if (!includeTime && next.getType() == TierType.TIME) continue;
            result.add(next.getName());
        }
        return result;
    }

    public String getParent(String name) {
        if (this._byName.get(name) == null) {
            return null;
        }
        return this._byName.get(name).getParent();
    }

    public void setParent(String child, String parent) {
        if (this._byName.get(child) == null) {
            throw new IllegalArgumentException("unknown tier name: " + child);
        }
        this._byName.get(child).setParent(parent);
    }

    public int size() {
        return this._byName.size();
    }

    public String toString() {
        return this._byOrder.toString();
    }

    private static class Tier
    implements Comparable<Tier> {
        private final String _name;
        private final int _order;
        private TierType _type;
        private String _parent;

        protected Tier(String name, int order, TierType type) {
            this._name = name;
            this._order = order;
            this._type = type;
            this._parent = "ref".equals(name) ? null : "ref";
        }

        public int getOrder() {
            return this._order;
        }

        public String getName() {
            return this._name;
        }

        public String getParent() {
            return this._parent;
        }

        public void setParent(String parent) {
            this._parent = parent;
        }

        public TierType getType() {
            return this._type;
        }

        public void setType(TierType type) {
            this._type = type;
        }

        @Override
        public int compareTo(Tier t) {
            if (this._order < t.getOrder()) {
                return -1;
            }
            if (this._order > t.getOrder()) {
                return 1;
            }
            return 0;
        }

        public boolean equals(Object o) {
            return o instanceof Tier && this._order == ((Tier)o).getOrder();
        }

        public int hashCode() {
            return this._order;
        }

        public String toString() {
            return this._name + "/" + (Object)((Object)this._type);
        }
    }

    public static enum TierType {
        TIME,
        ALIGNED,
        BLOCK,
        REF,
        UNKNOWN;

    }
}

