/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.annot.tools.data;

import java.io.File;
import java.io.IOException;
import nl.mpi.annot.tools.data.AnnexAnnotation;
import nl.mpi.annot.tools.data.AnnexTier;
import nl.mpi.annot.tools.data.AnnexTranscription;
import nl.mpi.annot.tools.data.DataUtil;
import org.apache.log4j.Logger;

public class TextgridParser {
    private static final boolean _includeEmpty = false;
    private static Logger _logger = Logger.getLogger((String)TextgridParser.class.getName());

    public static void parseTextGrid(String[] lines, AnnexTranscription transcription) throws IOException {
        if (lines.length < 7) {
            throw new IOException("Too short to be Praat TextGrid, only " + lines.length + " lines");
        }
        if (!lines[0].trim().equals("File type = \"ooTextFile\"")) {
            _logger.warn((Object)("First line should be 'File type = \"ooTextFile\"' but is: " + lines[0].trim()));
            throw new IOException("ooTextFile / TextGrid header missing");
        }
        if (!lines[1].trim().equals("Object class = \"TextGrid\"")) {
            _logger.warn((Object)("Second line should be 'Object class = \"TextGrid\"' but is: " + lines[1].trim()));
            throw new IOException("ooTextFile / TextGrid header missing");
        }
        AnnexTier tier = null;
        String tierName = "Unknown";
        String text = null;
        String id = null;
        String oldId = null;
        long start = 0L;
        long end = 0L;
        long globalEnd = 0L;
        int count = 0;
        boolean pointTier = false;
        for (int i = 2; i < lines.length; ++i) {
            String line = lines[i];
            if (line.trim().length() == 0) continue;
            if (line.startsWith("xmin")) {
                start = TextgridParser.parseTime(line);
                continue;
            }
            if (line.startsWith("xmax")) {
                globalEnd = end = TextgridParser.parseTime(line);
                continue;
            }
            if (line.startsWith("tiers?")) continue;
            if (line.startsWith("size")) {
                count = TextgridParser.parseNumber(line);
                transcription.setInfo("TextGrid from " + start + " to " + end + " milliseconds, " + count + " tiers.");
                continue;
            }
            if (line.trim().equals("item []:")) continue;
            if (!line.startsWith(" ") && !line.startsWith("\t")) {
                _logger.warn((Object)("Unexpected TextGrid content in line " + (i + 1) + ": '" + line.trim() + "'"));
                throw new IOException("Unknown header keyword: " + line.trim());
            }
            if ((line = line.trim()).startsWith("item [")) {
                if (text != null && tier != null && text.length() > 0) {
                    tier.annotations.add(new AnnexAnnotation(text, end, globalEnd, true, id));
                }
                tier = null;
                text = null;
                start = 0L;
                end = 0L;
                continue;
            }
            if (line.startsWith("xmin")) {
                start = TextgridParser.parseTime(line);
                continue;
            }
            if (line.startsWith("time")) {
                start = end;
                end = TextgridParser.parseTime(line);
                continue;
            }
            if (line.startsWith("xmax")) {
                end = TextgridParser.parseTime(line);
                continue;
            }
            if (line.startsWith("name")) {
                tierName = TextgridParser.parseText(line);
                continue;
            }
            if (line.startsWith("class")) {
                pointTier = !line.contains("IntervalTier");
                continue;
            }
            if (line.startsWith("intervals: size") || line.startsWith("points: size")) {
                count = TextgridParser.parseNumber(line);
                tier = new AnnexTier(tierName, "text");
                tier.participant = "unknown";
                tier.hasVirtualTime = false;
                transcription.getTiers().add(tier);
                transcription.setInfo(transcription.getInfo() + "\nTier '" + tierName + "' from " + start + " to " + end + ", " + count + " time" + (pointTier ? "point" : "span") + "s.");
                continue;
            }
            if (line.startsWith("intervals [") || line.startsWith("points [")) {
                oldId = id;
                id = tierName + "_" + (i + 1);
                continue;
            }
            if (line.startsWith("text")) {
                if (tier == null) {
                    throw new IOException("Text line outside timespan annotation at line " + (i + 1) + ": '" + line + "'");
                }
                String value = TextgridParser.parseText(line);
                if (value.length() <= 0) continue;
                tier.annotations.add(new AnnexAnnotation(value, start, end, true, id));
                continue;
            }
            if (line.startsWith("mark")) {
                if (tier == null) {
                    throw new IOException("Text line outside timepoint annotation at line " + (i + 1) + ": '" + line + "'");
                }
                if (text != null && text.length() > 0) {
                    tier.annotations.add(new AnnexAnnotation(text, start, end, true, oldId));
                }
                text = TextgridParser.parseText(line);
                continue;
            }
            throw new IOException("Unexpected content in TextGrid file at line " + (i + 1) + ": '" + line + "'");
        }
        if (text != null && tier != null && text.length() > 0) {
            tier.annotations.add(new AnnexAnnotation(text, end, globalEnd, true, id));
        }
    }

    public static String parseText(String line) throws IOException {
        int sign = line.indexOf(61);
        if (sign == -1) {
            throw new IOException("No = sign in line: '" + line + "'");
        }
        String value = line.substring(sign + 1).trim();
        if (value.startsWith("\"") && value.endsWith("\"") && !value.equals("\"")) {
            return value.substring(1, value.length() - 1);
        }
        return value;
    }

    public static int parseNumber(String line) throws IOException {
        try {
            return Integer.parseInt(TextgridParser.parseText(line));
        }
        catch (NumberFormatException nfe) {
            throw new IOException("Expected integer but found: '" + TextgridParser.parseText(line) + "'");
        }
    }

    public static long parseTime(String line) throws IOException {
        String value = TextgridParser.parseText(line);
        try {
            if (value.indexOf(46) == -1) {
                return 1000L * (long)Integer.parseInt(value);
            }
            int dot = value.indexOf(46);
            String whole = value.substring(0, dot);
            String fraction = (value + "000").substring(dot + 1);
            fraction = fraction.substring(0, 3);
            return 1000L * (long)Integer.parseInt(whole) + (long)Integer.parseInt(fraction);
        }
        catch (NumberFormatException nfe) {
            throw new IOException("Expected seconds.fraction timestamp but found: '" + value + "'");
        }
    }

    public static void main(String[] args) throws IOException {
        File file = new File(args[0]);
        String id = args[0].substring(args[0].lastIndexOf(47) + 1);
        DataUtil.readLines(file, DataUtil.getCharsetName(file));
        new AnnexTranscription(id, 9, file);
    }
}

