/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.media.codec.audio;

import com.ibm.media.codec.audio.AudioCodec;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.format.AudioFormat;

public class PCMToPCM
extends AudioCodec {
    private Format lastInputFormat = null;
    private Format lastOutputFormat = null;
    private int bias = 0;
    private int signMask = 0;
    private int inputSampleSize = 8;
    private int outputSampleSize = 8;
    private int numberOfInputChannels = 1;
    private int numberOfOutputChannels = 1;
    private boolean channels2To1 = false;
    private boolean channels1To2 = false;
    private boolean channels2To2 = false;
    private int inputLsbOffset;
    private int inputMsbOffset;
    private int outputLsbOffset;
    private int outputMsbOffset;

    public PCMToPCM() {
        this.supportedInputFormats = new AudioFormat[]{new AudioFormat("LINEAR", -1.0, 16, 1, -1, -1), new AudioFormat("LINEAR", -1.0, 16, 2, -1, -1), new AudioFormat("LINEAR", -1.0, 8, 1, -1, -1), new AudioFormat("LINEAR", -1.0, 8, 2, -1, -1)};
        this.defaultOutputFormats = new AudioFormat[]{new AudioFormat("LINEAR")};
        this.PLUGIN_NAME = "PCM to PCM converter";
    }

    private int calculateOutputSize(int n2) {
        int n3 = n2;
        if (this.inputSampleSize == 8 && this.outputSampleSize == 16) {
            n3 *= 2;
        }
        if (this.inputSampleSize == 16 && this.outputSampleSize == 8) {
            n3 /= 2;
        }
        if (this.numberOfInputChannels == 1 && this.numberOfOutputChannels == 2) {
            n3 *= 2;
        }
        if (this.numberOfInputChannels == 2 && this.numberOfOutputChannels == 1) {
            n3 /= 2;
        }
        return n3;
    }

    private void convert(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) {
        int n5 = 0;
        int n6 = 0;
        n4 += this.outputMsbOffset;
        int n7 = n2 + this.inputMsbOffset;
        while (n7 < n3 + n2) {
            if (this.inputSampleSize == 8) {
                n5 = byArray[n7++] << 8;
                if (this.numberOfInputChannels == 2) {
                    n6 = byArray[n7++] << 8;
                }
            } else {
                n5 = (byArray[n7] << 8) + (0xFF & byArray[n7 + this.inputLsbOffset]);
                n7 += 2;
                if (this.numberOfInputChannels == 2) {
                    n6 = (byArray[n7] << 8) + (0xFF & byArray[n7 + this.inputLsbOffset]);
                    n7 += 2;
                }
            }
            if (this.channels2To1) {
                n5 = (n5 & this.signMask) + (n6 & this.signMask) >> 1;
            }
            n5 = (short)(n5 + this.bias);
            if (this.channels2To2) {
                n6 = (short)(n6 + this.bias);
            }
            if (this.channels1To2) {
                n6 = n5;
            }
            if (this.outputSampleSize == 8) {
                byArray2[n4++] = (byte)(n5 >> 8);
                if (this.numberOfOutputChannels != 2) continue;
                byArray2[n4++] = (byte)(n6 >> 8);
                continue;
            }
            byArray2[n4 + this.outputLsbOffset] = (byte)n5;
            byArray2[n4] = (byte)(n5 >> 8);
            n4 += 2;
            if (this.numberOfOutputChannels != 2) continue;
            byArray2[n4 + this.outputLsbOffset] = (byte)n6;
            byArray2[n4] = (byte)(n6 >> 8);
            n4 += 2;
        }
    }

    protected Format[] getMatchingOutputFormats(Format format) {
        AudioFormat audioFormat = (AudioFormat)format;
        int n2 = audioFormat.getChannels() == 1 ? 2 : 1;
        this.supportedOutputFormats = new AudioFormat[]{new AudioFormat("LINEAR", audioFormat.getSampleRate(), 16, audioFormat.getChannels(), 0, 1, 16 * audioFormat.getChannels(), audioFormat.getFrameRate(), audioFormat.getDataType()), new AudioFormat("LINEAR", audioFormat.getSampleRate(), 16, n2, 0, 1, 16 * n2, audioFormat.getFrameRate(), audioFormat.getDataType()), new AudioFormat("LINEAR", audioFormat.getSampleRate(), 16, audioFormat.getChannels(), 1, 1, 16 * audioFormat.getChannels(), audioFormat.getFrameRate(), audioFormat.getDataType()), new AudioFormat("LINEAR", audioFormat.getSampleRate(), 16, n2, 1, 1, 16 * n2, audioFormat.getFrameRate(), audioFormat.getDataType()), new AudioFormat("LINEAR", audioFormat.getSampleRate(), 16, audioFormat.getChannels(), 0, 0, 16 * audioFormat.getChannels(), audioFormat.getFrameRate(), audioFormat.getDataType()), new AudioFormat("LINEAR", audioFormat.getSampleRate(), 16, n2, 0, 0, 16 * n2, audioFormat.getFrameRate(), audioFormat.getDataType()), new AudioFormat("LINEAR", audioFormat.getSampleRate(), 16, audioFormat.getChannels(), 1, 0, 16 * audioFormat.getChannels(), audioFormat.getFrameRate(), audioFormat.getDataType()), new AudioFormat("LINEAR", audioFormat.getSampleRate(), 16, n2, 1, 0, 16 * n2, audioFormat.getFrameRate(), audioFormat.getDataType()), new AudioFormat("LINEAR", audioFormat.getSampleRate(), 8, audioFormat.getChannels(), -1, 1, 8 * audioFormat.getChannels(), audioFormat.getFrameRate(), audioFormat.getDataType()), new AudioFormat("LINEAR", audioFormat.getSampleRate(), 8, n2, -1, 1, 8 * n2, audioFormat.getFrameRate(), audioFormat.getDataType()), new AudioFormat("LINEAR", audioFormat.getSampleRate(), 8, audioFormat.getChannels(), -1, 0, 8 * audioFormat.getChannels(), audioFormat.getFrameRate(), audioFormat.getDataType()), new AudioFormat("LINEAR", audioFormat.getSampleRate(), 8, n2, -1, 0, 8 * n2, audioFormat.getFrameRate(), audioFormat.getDataType())};
        return this.supportedOutputFormats;
    }

    private void initConverter(AudioFormat audioFormat, AudioFormat audioFormat2) {
        this.lastInputFormat = audioFormat;
        this.lastOutputFormat = audioFormat2;
        this.numberOfInputChannels = audioFormat.getChannels();
        this.numberOfOutputChannels = audioFormat2.getChannels();
        this.inputSampleSize = audioFormat.getSampleSizeInBits();
        this.outputSampleSize = audioFormat2.getSampleSizeInBits();
        if (audioFormat.getEndian() == 1 || this.inputSampleSize == 8) {
            this.inputLsbOffset = 1;
            this.inputMsbOffset = 0;
        } else {
            this.inputLsbOffset = -1;
            this.inputMsbOffset = 1;
        }
        int n2 = audioFormat2.getEndian();
        if (n2 == -1) {
            n2 = audioFormat.getEndian();
        }
        if (n2 == 1 || this.outputSampleSize == 8) {
            this.outputLsbOffset = 1;
            this.outputMsbOffset = 0;
        } else {
            this.outputLsbOffset = -1;
            this.outputMsbOffset = 1;
        }
        this.signMask = audioFormat.getSigned() == 1 ? -1 : 65535;
        this.bias = audioFormat.getSigned() == audioFormat2.getSigned() || audioFormat2.getSigned() == -1 ? 0 : 32768;
        this.channels2To1 = this.numberOfInputChannels == 2 && this.numberOfOutputChannels == 1;
        this.channels1To2 = this.numberOfInputChannels == 1 && this.numberOfOutputChannels == 2;
        this.channels2To2 = this.numberOfInputChannels == 2 && this.numberOfOutputChannels == 2;
    }

    public int process(Buffer buffer, Buffer buffer2) {
        if (!this.checkInputBuffer(buffer)) {
            return 1;
        }
        if (this.isEOM(buffer)) {
            this.propagateEOM(buffer2);
            return 0;
        }
        if (this.lastInputFormat != this.inputFormat || this.lastOutputFormat != this.outputFormat) {
            this.initConverter(this.inputFormat, this.outputFormat);
        }
        int n2 = buffer.getLength();
        int n3 = this.calculateOutputSize(buffer.getLength());
        byte[] byArray = (byte[])buffer.getData();
        byte[] byArray2 = this.validateByteArraySize(buffer2, n3);
        this.convert(byArray, buffer.getOffset(), n2, byArray2, buffer2.getOffset());
        this.updateOutput(buffer2, this.outputFormat, n3, buffer2.getOffset());
        return 0;
    }
}

