/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.codec.video.colorspace;

import com.sun.media.BasicCodec;
import com.sun.media.JMFSecurityManager;
import com.sun.media.util.Arch;
import java.awt.Dimension;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.RGBFormat;

public class NativeRGBToRGB
extends BasicCodec {
    private static boolean loaded = false;
    protected int rm1;
    protected int rm2;
    protected int gm1;
    protected int gm2;
    protected int bm1;
    protected int bm2;
    protected int rMask;
    protected int gMask;
    protected int bMask;
    protected int rShift;
    protected int gShift;
    protected int bShift;
    protected int conversionFun = 0;

    private native boolean convert(Object var1, int var2, int var3, Object var4, int var5, int var6, int var7, int var8);

    public String getName() {
        return "RGB To RGB Converter";
    }

    public Format[] getSupportedInputFormats() {
        Format[] formatArray = new RGBFormat[]{new RGBFormat(null, -1, Format.byteArray, -1.0f, 24, 3, 2, 1, 3, -1, 0, -1), new RGBFormat(null, -1, Format.byteArray, -1.0f, 16, 63488, 2016, 31, 2, -1, 0, -1)};
        return formatArray;
    }

    public Format[] getSupportedOutputFormats(Format format) {
        if (!this.supportedRGB(format)) {
            return new RGBFormat[]{new RGBFormat()};
        }
        RGBFormat rGBFormat = (RGBFormat)format;
        Dimension dimension = rGBFormat.getSize();
        if (dimension == null) {
            dimension = new Dimension(320, 240);
        }
        Format[] formatArray = new RGBFormat[]{new RGBFormat(dimension, dimension.width * dimension.height, Format.intArray, rGBFormat.getFrameRate(), 32, 0xFF0000, 65280, 255, 1, dimension.width, rGBFormat.getFlipped(), rGBFormat.getEndian()), new RGBFormat(dimension, dimension.width * dimension.height * 4, Format.byteArray, rGBFormat.getFrameRate(), 32, 2, 3, 4, 4, dimension.width * 4, rGBFormat.getFlipped(), rGBFormat.getEndian()), new RGBFormat(dimension, dimension.width * dimension.height * 3, Format.byteArray, rGBFormat.getFrameRate(), 24, 1, 2, 3, 3, dimension.width * 3, rGBFormat.getFlipped(), rGBFormat.getEndian()), new RGBFormat(dimension, dimension.width * dimension.height, Format.shortArray, rGBFormat.getFrameRate(), 16, 63488, 2016, 31, 1, dimension.width, rGBFormat.getFlipped(), rGBFormat.getEndian()), new RGBFormat(dimension, dimension.width * dimension.height, Format.byteArray, rGBFormat.getFrameRate(), 16, 63488, 2016, 31, 2, dimension.width * 2, rGBFormat.getFlipped(), rGBFormat.getEndian()), new RGBFormat(dimension, dimension.width * dimension.height, Format.shortArray, rGBFormat.getFrameRate(), 16, 31744, 992, 31, 1, dimension.width, rGBFormat.getFlipped(), rGBFormat.getEndian())};
        return formatArray;
    }

    private native void initConverter(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8);

    protected void initialize() {
        RGBFormat rGBFormat = (RGBFormat)this.inputFormat;
        RGBFormat rGBFormat2 = (RGBFormat)this.outputFormat;
        this.rm1 = rGBFormat.getRedMask();
        this.gm1 = rGBFormat.getGreenMask();
        this.bm1 = rGBFormat.getBlueMask();
        this.rm2 = rGBFormat2.getRedMask();
        this.gm2 = rGBFormat2.getGreenMask();
        this.bm2 = rGBFormat2.getBlueMask();
        boolean bl = rGBFormat.getDataType() != Format.byteArray;
        boolean bl2 = rGBFormat2.getDataType() != Format.byteArray;
        int n2 = rGBFormat.getBitsPerPixel();
        int n3 = rGBFormat2.getBitsPerPixel();
        n2 = n2 == 15 ? 2 : (n2 /= 8);
        n3 = n3 == 15 ? 2 : (n3 /= 8);
        switch (n2) {
            case 3: {
                if (Arch.isBigEndian()) {
                    this.rm1 = 255 << (3 - this.rm1) * 8;
                    this.gm1 = 255 << (3 - this.gm1) * 8;
                    this.bm1 = 255 << (3 - this.bm1) * 8;
                    break;
                }
                this.rm1 = 255 << this.rm1 * 8;
                this.gm1 = 255 << this.gm1 * 8;
                this.bm1 = 255 << this.bm1 * 8;
                break;
            }
            case 4: {
                if (bl) break;
                if (Arch.isBigEndian()) {
                    this.rm1 = 255 << (4 - this.rm1) * 8;
                    this.gm1 = 255 << (4 - this.gm1) * 8;
                    this.bm1 = 255 << (4 - this.bm1) * 8;
                    break;
                }
                this.rm1 = 255 << (this.rm1 - 1) * 8;
                this.gm1 = 255 << (this.gm1 - 1) * 8;
                this.bm1 = 255 << (this.bm1 - 1) * 8;
            }
        }
        switch (n3) {
            case 3: {
                if (Arch.isBigEndian()) {
                    this.rm2 = 255 << (3 - this.rm2) * 8;
                    this.gm2 = 255 << (3 - this.gm2) * 8;
                    this.bm2 = 255 << (3 - this.bm2) * 8;
                    break;
                }
                this.rm2 = 255 << this.rm2 * 8;
                this.gm2 = 255 << this.gm2 * 8;
                this.bm2 = 255 << this.bm2 * 8;
                break;
            }
            case 4: {
                if (bl2) break;
                if (Arch.isBigEndian()) {
                    this.rm2 = 255 << (4 - this.rm2) * 8;
                    this.gm2 = 255 << (4 - this.gm2) * 8;
                    this.bm2 = 255 << (4 - this.bm2) * 8;
                    break;
                }
                this.rm2 = 255 << (this.rm1 - 1) * 8;
                this.gm2 = 255 << (this.gm1 - 1) * 8;
                this.bm2 = 255 << (this.bm1 - 1) * 8;
            }
        }
        this.initConverter(this.rm1, this.gm1, this.bm1, n2, this.rm2, this.gm2, this.bm2, n3);
    }

    public void open() throws ResourceUnavailableException {
        if (!loaded) {
            try {
                JMFSecurityManager.loadLibrary("jmutil");
                loaded = true;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                throw new ResourceUnavailableException(unsatisfiedLinkError.getMessage());
            }
        }
        if (!this.supportedRGB(this.inputFormat) || !this.supportedRGB(this.outputFormat)) {
            throw new ResourceUnavailableException("Invalid Formats");
        }
    }

    public int process(Buffer buffer, Buffer buffer2) {
        if (!loaded) {
            return 1;
        }
        if (this.isEOM(buffer)) {
            this.propagateEOM(buffer2);
            return 0;
        }
        if (this.conversionFun == 0) {
            this.initialize();
        }
        if (this.conversionFun == 0) {
            return 1;
        }
        RGBFormat rGBFormat = (RGBFormat)buffer.getFormat();
        RGBFormat rGBFormat2 = (RGBFormat)buffer2.getFormat();
        if (rGBFormat2 == null) {
            rGBFormat2 = (RGBFormat)this.outputFormat;
            buffer2.setFormat(rGBFormat2);
        }
        int n2 = this.getArrayElementSize(rGBFormat.getDataType());
        int n3 = this.getArrayElementSize(rGBFormat2.getDataType());
        Object object = buffer.getData();
        Object object2 = buffer2.getData();
        if (object2 == null) {
            int n4 = rGBFormat2.getMaxDataLength();
            switch (n3) {
                case 2: {
                    object2 = new short[n4];
                    break;
                }
                case 4: {
                    object2 = new int[n4];
                    break;
                }
                case 1: {
                    object2 = new byte[n4];
                    break;
                }
                default: {
                    return 1;
                }
            }
            buffer2.setData(object2);
        }
        Dimension dimension = rGBFormat.getSize();
        this.convert(object, n2, rGBFormat.getLineStride() / rGBFormat.getPixelStride(), object2, n3, rGBFormat2.getLineStride() / rGBFormat2.getPixelStride(), dimension.width, dimension.height);
        buffer2.setLength(rGBFormat2.getLineStride() * dimension.height);
        return 0;
    }

    protected boolean supportedRGB(Format format) {
        if (!(format instanceof RGBFormat)) {
            return false;
        }
        RGBFormat rGBFormat = (RGBFormat)format;
        int n2 = rGBFormat.getBitsPerPixel();
        int n3 = rGBFormat.getPixelStride();
        int n4 = rGBFormat.getLineStride();
        int n5 = rGBFormat.getRedMask();
        int n6 = rGBFormat.getGreenMask();
        int n7 = rGBFormat.getBlueMask();
        Dimension dimension = rGBFormat.getSize();
        Class clazz = rGBFormat.getDataType();
        int n8 = 1;
        switch (n2) {
            case 15: 
            case 16: {
                if (clazz != Format.byteArray && clazz != Format.shortArray) {
                    return false;
                }
                if (clazz != Format.byteArray) break;
                n8 = 2;
                break;
            }
            case 24: {
                if (clazz != Format.byteArray) {
                    return false;
                }
                n8 = 3;
                break;
            }
            case 32: {
                if (clazz != Format.byteArray) break;
                n8 = 4;
            }
        }
        if (dimension != null) {
            if (n4 < dimension.width * n8) {
                return false;
            }
            if (n3 < n8) {
                return false;
            }
        }
        return true;
    }
}

