/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.codec.video.vcm;

import com.sun.media.BasicCodec;
import com.sun.media.BasicPlugIn;
import com.sun.media.JMFSecurityManager;
import com.sun.media.NBA;
import com.sun.media.format.AviVideoFormat;
import com.sun.media.util.DynamicPlugIn;
import com.sun.media.vfw.BitMapInfo;
import com.sun.media.vfw.ICInfo;
import com.sun.media.vfw.VCM;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Vector;
import javax.media.Buffer;
import javax.media.Control;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.control.FrameProcessingControl;
import javax.media.control.QualityControl;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;

public class NativeDecoder
extends BasicCodec
implements DynamicPlugIn {
    private static boolean loaded = false;
    static Integer processLock;
    protected VideoFormat inputFormat = null;
    protected VideoFormat outputFormat = null;
    private static String[] supportedEncodings;
    private int vcmHandle = 0;
    private boolean debug = false;
    private BitMapInfo biIn = null;
    private BitMapInfo biOut = null;
    private boolean dropFrame = false;
    private boolean keepOutputRef = false;
    private NBA outputRef = null;
    private Control[] controls = null;
    private DC dc = null;
    static /* synthetic */ Class array$B;

    static {
        JMFSecurityManager.loadLibrary("jmvcm");
        loaded = true;
        processLock = new Integer(1);
        supportedEncodings = null;
    }

    public NativeDecoder() {
        if (!loaded) {
            throw new UnsatisfiedLinkError("Cannot load native libraries");
        }
        this.inputFormats = new VideoFormat[1];
        this.inputFormats[0] = new VideoFormat(null);
        this.outputFormats = new VideoFormat[1];
        this.outputFormats[0] = new RGBFormat();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void close() {
        if (this.vcmHandle != 0) {
            VCM.icClose(this.vcmHandle);
        }
        this.vcmHandle = 0;
        super.close();
    }

    void dropNextFrame(boolean bl) {
        this.dropFrame = bl;
    }

    public Format[] getBaseInputFormats() {
        Format[] formatArray = new Format[]{new VideoFormat(null)};
        return formatArray;
    }

    public Format[] getBaseOutputFormats() {
        Format[] formatArray = new Format[]{new RGBFormat()};
        return formatArray;
    }

    public Object[] getControls() {
        if (this.dc == null) {
            this.dc = new DC();
            this.controls = new Control[1];
            this.controls[0] = this.dc;
        }
        return this.controls;
    }

    protected Format getInputFormat() {
        return this.inputFormat;
    }

    public String getName() {
        return "VCM Decoder";
    }

    protected Format getOutputFormat() {
        return this.outputFormat;
    }

    public Format[] getSupportedInputFormats() {
        if (supportedEncodings == null) {
            NativeDecoder.querySupportedEncodings();
        }
        this.inputFormats = new VideoFormat[supportedEncodings.length];
        int n2 = 0;
        while (n2 < supportedEncodings.length) {
            this.inputFormats[n2] = new VideoFormat(supportedEncodings[n2]);
            ++n2;
        }
        return this.inputFormats;
    }

    public Format[] getSupportedOutputFormats(Format format) {
        if (format == null) {
            return this.outputFormats;
        }
        if (BasicPlugIn.matches(format, this.inputFormats) == null) {
            return new Format[0];
        }
        VideoFormat videoFormat = (VideoFormat)format;
        Dimension dimension = videoFormat.getSize();
        if (dimension == null) {
            dimension = new Dimension(320, 240);
        }
        RGBFormat[] rGBFormatArray = new RGBFormat[]{new RGBFormat(dimension, dimension.width * dimension.height * 3, Format.byteArray, videoFormat.getFrameRate(), 24, 3, 2, 1, 3, dimension.width * 3, 1, -1), new RGBFormat(dimension, dimension.width * dimension.height * 3, Format.byteArray, videoFormat.getFrameRate(), 24, 3, 2, 1, 3, dimension.width * 3, 0, -1), new RGBFormat(dimension, dimension.width * dimension.height, Format.shortArray, videoFormat.getFrameRate(), 16, 31744, 992, 31, 1, dimension.width, 0, -1), new RGBFormat(dimension, dimension.width * dimension.height, Format.shortArray, videoFormat.getFrameRate(), 16, 31744, 992, 31, 1, dimension.width, 1, -1)};
        if (this.debug) {
            System.err.println("Input format = " + new BitMapInfo(videoFormat));
        }
        Vector<RGBFormat> vector = new Vector<RGBFormat>();
        int n2 = VCM.icLocate("vidc", "RGB", new BitMapInfo(videoFormat), null, 2);
        if (n2 != 0) {
            int n3 = 0;
            while (n3 < rGBFormatArray.length) {
                if (VCM.icDecompressBegin(n2, new BitMapInfo(videoFormat), new BitMapInfo(rGBFormatArray[n3]))) {
                    vector.addElement(rGBFormatArray[n3]);
                    if (this.debug) {
                        System.err.println("VCM " + videoFormat.getEncoding() + " supports " + rGBFormatArray[n3]);
                    }
                    VCM.icDecompressEnd(n2);
                }
                ++n3;
            }
            VCM.icClose(n2);
        }
        Format[] formatArray = new Format[vector.size()];
        int n4 = 0;
        while (n4 < formatArray.length) {
            formatArray[n4] = (Format)vector.elementAt(n4);
            ++n4;
        }
        return formatArray;
    }

    public void open() throws ResourceUnavailableException {
        if (this.inputFormat == null || this.outputFormat == null) {
            throw new ResourceUnavailableException("Formats not set!");
        }
        Dimension dimension = this.inputFormat.getSize();
        BitMapInfo bitMapInfo = null;
        String string = this.inputFormat.getEncoding();
        this.biOut = new BitMapInfo();
        if (this.inputFormat instanceof AviVideoFormat) {
            bitMapInfo = new BitMapInfo(this.inputFormat);
            if (this.debug) {
                System.err.println("VCM.open, BMI = " + bitMapInfo);
            }
        }
        this.biIn = bitMapInfo != null && bitMapInfo instanceof BitMapInfo ? bitMapInfo : new BitMapInfo(string, dimension.width, dimension.height);
        String string2 = string;
        if (string2.equalsIgnoreCase("cram")) {
            string2 = "msvc";
        }
        this.vcmHandle = VCM.icLocate("vidc", "RGB", this.biIn, null, 2);
        if (this.debug) {
            System.err.println("open.vcmHandle for " + string + " = " + this.vcmHandle);
        }
        if (this.vcmHandle == 0) {
            throw new ResourceUnavailableException("Could not open VCM driver");
        }
        BitMapInfo bitMapInfo2 = new BitMapInfo();
        if (this.debug) {
            System.err.println("open.preferred out = " + bitMapInfo2);
        }
        this.biOut = new BitMapInfo(this.outputFormat);
        if (this.debug) {
            System.err.println("open.requested out = " + this.biOut);
        }
        boolean bl = true;
        boolean bl2 = VCM.icDecompressBegin(this.vcmHandle, this.biIn, this.biOut);
        if (!bl2) {
            if (this.debug) {
                System.err.println("VCM.open : Could not set i/o format");
            }
            this.close();
            throw new ResourceUnavailableException("Formats not supported");
        }
        if (this.debug) {
            System.err.println("VCM.open success!");
        }
        super.open();
    }

    public int process(Buffer buffer, Buffer buffer2) {
        int n2;
        if (this.isEOM(buffer)) {
            this.propagateEOM(buffer2);
            return 0;
        }
        Format format = buffer2.getFormat();
        buffer2.setFormat(this.outputFormat);
        Object object = this.validateData(buffer2, 0, true);
        int n3 = 1;
        if (this.outputFormat.getDataType() == Format.shortArray) {
            n3 = 2;
        }
        Object object2 = this.getInputData(buffer);
        long l2 = 0L;
        int n4 = buffer.getLength();
        if (n4 < 2) {
            return 1;
        }
        Object object3 = buffer.getHeader();
        if (object3 != null && object3 instanceof Integer) {
            l2 = ((Integer)object3).intValue();
        }
        if (this.dropFrame) {
            l2 |= 0x20000000L;
        }
        this.biIn.biSizeImage = n4;
        Integer n5 = processLock;
        synchronized (n5) {
            long l3 = this.getNativeData(object);
            long l4 = this.getNativeData(object2);
            if (!this.keepOutputRef) {
                n2 = VCM.icDecompress(this.vcmHandle, l2, this.biIn, object2, l4, this.biOut, object, l3, n3);
            } else {
                if (this.outputRef == null) {
                    this.outputRef = new NBA(array$B != null ? array$B : (array$B = NativeDecoder.class$("[B")), this.outputFormat.getMaxDataLength());
                }
                n2 = VCM.icDecompress(this.vcmHandle, l2, this.biIn, object2, l4, this.biOut, null, this.outputRef.data, n3);
                if (l3 != 0L) {
                    this.outputRef.copyTo((NBA)object);
                } else {
                    this.outputRef.copyTo((byte[])object);
                }
            }
        }
        if (this.dropFrame) {
            buffer2.setDiscard(true);
        } else {
            buffer2.setLength(this.outputFormat.getMaxDataLength());
        }
        if (n2 < 0) {
            return 1;
        }
        return 0;
    }

    private static synchronized void querySupportedEncodings() {
        boolean bl;
        int n2;
        ICInfo iCInfo = new ICInfo();
        BitMapInfo bitMapInfo = new BitMapInfo();
        Vector<String> vector = new Vector<String>();
        for (n2 = 0; (bl = VCM.icInfoEnum("vidc", n2, iCInfo = new ICInfo())) && n2 <= 30; ++n2) {
            int n3;
            if (iCInfo.fccHandler == null || iCInfo.fccHandler.equalsIgnoreCase("mjpg") || iCInfo.fccHandler.equalsIgnoreCase("cvid") || (n3 = VCM.icOpen("vidc", iCInfo.fccHandler, 2)) == 0) continue;
            if (iCInfo.fccHandler.equalsIgnoreCase("ir41")) {
                iCInfo.fccHandler = "IV41";
            }
            if (iCInfo.fccHandler.equalsIgnoreCase("ir50")) {
                iCInfo.fccHandler = "IV50";
            }
            if (iCInfo.fccHandler.equalsIgnoreCase("ir32")) {
                iCInfo.fccHandler = "IV32";
            }
            vector.addElement(iCInfo.fccHandler.toUpperCase());
            VCM.icClose(n3);
        }
        vector.addElement("YVU9");
        supportedEncodings = new String[vector.size()];
        n2 = 0;
        while (n2 < supportedEncodings.length) {
            NativeDecoder.supportedEncodings[n2] = (String)vector.elementAt(n2);
            ++n2;
        }
    }

    public void reset() {
        if (this.vcmHandle != 0) {
            VCM.icDecompressEnd(this.vcmHandle);
            VCM.icDecompressBegin(this.vcmHandle, this.biIn, this.biOut);
        }
    }

    public Format setInputFormat(Format format) {
        String string;
        if (supportedEncodings == null) {
            NativeDecoder.querySupportedEncodings();
        }
        if ((string = format.getEncoding()).equalsIgnoreCase("cvid") || string.equalsIgnoreCase("mjpg") || string.equalsIgnoreCase("RGB")) {
            return null;
        }
        this.keepOutputRef = string.equalsIgnoreCase("mpg4") || string.equalsIgnoreCase("mp42") || string.equalsIgnoreCase("mp43") || string.equalsIgnoreCase("iv32");
        if (format instanceof VideoFormat && BasicPlugIn.matches(format, this.inputFormats) != null) {
            this.inputFormat = (VideoFormat)format;
            if (this.opened) {
                try {
                    this.close();
                    Format[] formatArray = this.getSupportedOutputFormats(this.inputFormat);
                    if (formatArray.length < 1) {
                        return null;
                    }
                    if (formatArray.length == 1) {
                        this.outputFormat = (RGBFormat)formatArray[0];
                    } else {
                        int n2 = 0;
                        while (n2 < formatArray.length) {
                            if (((RGBFormat)this.outputFormat).getBitsPerPixel() == ((RGBFormat)formatArray[n2]).getBitsPerPixel() && ((RGBFormat)this.outputFormat).getFlipped() == ((RGBFormat)formatArray[n2]).getFlipped()) {
                                this.outputFormat = (VideoFormat)formatArray[n2];
                                break;
                            }
                            ++n2;
                        }
                    }
                    this.open();
                }
                catch (Exception exception) {
                    return null;
                }
            }
            return format;
        }
        return null;
    }

    public Format setOutputFormat(Format format) {
        if (format instanceof RGBFormat) {
            this.outputFormat = (RGBFormat)format;
            if (this.debug) {
                System.err.println("VCM.setOutputFormat : " + this.outputFormat);
            }
            return format;
        }
        return null;
    }

    class DC
    implements FrameProcessingControl,
    QualityControl {
        DC() {
        }

        public Component getControlComponent() {
            return null;
        }

        public int getFramesDropped() {
            return 0;
        }

        public float getPreferredQuality() {
            return 1.0f;
        }

        public float getQuality() {
            return 1.0f;
        }

        public boolean isTemporalSpatialTradeoffSupported() {
            return true;
        }

        public void setFramesBehind(float f2) {
            if (f2 > 0.0f) {
                NativeDecoder.this.dropNextFrame(true);
            } else {
                NativeDecoder.this.dropNextFrame(false);
            }
        }

        public boolean setMinimalProcessing(boolean bl) {
            NativeDecoder.this.dropNextFrame(true);
            return true;
        }

        public float setQuality(float f2) {
            return 1.0f;
        }
    }
}

