/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.parser.video;

import com.sun.media.format.WavAudioFormat;
import com.sun.media.parser.BasicPullParser;
import com.sun.media.vfw.BitMapInfo;
import java.io.IOException;
import javax.media.BadHeaderException;
import javax.media.Buffer;
import javax.media.Duration;
import javax.media.Format;
import javax.media.IncompatibleSourceException;
import javax.media.Time;
import javax.media.Track;
import javax.media.TrackListener;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.CachedStream;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.protocol.PullSourceStream;
import javax.media.protocol.Seekable;
import javax.media.protocol.SourceStream;

public class AviParser
extends BasicPullParser {
    private static ContentDescriptor[] supportedFormat = new ContentDescriptor[]{new ContentDescriptor("video.x_msvideo")};
    private PullSourceStream stream = null;
    private CachedStream cacheStream;
    private Track[] tracks;
    private Seekable seekableStream;
    private int numSupportedTracks = 0;
    private int length;
    private int audioTrack = -1;
    private int videoTrack = -1;
    private int keyFrameTrack = -1;
    private static final int SIZE_OF_AVI_INDEX = 16;
    private static final int AVIH_HEADER_LENGTH = 56;
    private static final int STRH_HEADER_LENGTH = 56;
    private static final int STRF_VIDEO_HEADER_LENGTH = 40;
    private static final int STRF_AUDIO_HEADER_LENGTH = 16;
    static final int AVIF_HASINDEX = 16;
    static final int AVIF_MUSTUSEINDEX = 32;
    static final int AVIF_ISINTERLEAVED = 256;
    static final int AVIF_WASCAPTUREFILE = 65536;
    static final int AVIF_COPYRIGHTED = 131072;
    static final int AVIF_KEYFRAME = 16;
    static final String AUDIO = "auds";
    static final String VIDEO = "vids";
    static final String LISTRECORDCHUNK = "rec ";
    static final String VIDEO_MAGIC = "dc";
    static final String VIDEO_MAGIC_JPEG = "db";
    static final String VIDEO_MAGIC_IV32a = "iv";
    static final String VIDEO_MAGIC_IV32b = "32";
    static final String VIDEO_MAGIC_IV31 = "31";
    static final String VIDEO_MAGIC_CVID = "id";
    static final String AUDIO_MAGIC = "wb";
    private int usecPerFrame = 0;
    private long nanoSecPerFrame = 0L;
    private int maxBytesPerSecond;
    private int paddingGranularity;
    private int flags;
    private int totalFrames = 0;
    private int initialFrames;
    private int numTracks = 0;
    private int suggestedBufferSize;
    private int width;
    private int height;
    private TrakList[] trakList;
    private int idx1MinimumChunkOffset;
    private int moviOffset = 0;
    private Time duration = Duration.DURATION_UNKNOWN;
    private boolean moviChunkSeen = false;
    private boolean idx1ChunkSeen = false;
    private int maxAudioChunkIndex = 0;
    private int maxVideoChunkIndex = 0;
    private int extraHeaderLength = 0;
    private byte[] codecSpecificHeader = null;
    private Object seekSync = new Object();

    private int[] buildIndexToKeyFrameIndexTable(int[] nArray, int n2, int n3) {
        int n4;
        int n5;
        int[] nArray2 = new int[n3];
        int n6 = 0;
        if (nArray[0] != 0) {
            nArray2[0] = 0;
            n5 = 0;
        } else {
            nArray2[0] = 0;
            n5 = 0;
            ++n6;
        }
        while (n6 < n2) {
            n4 = nArray[n6];
            int n7 = n5 + 1;
            while (n7 < n4) {
                nArray2[n7] = n5;
                ++n7;
            }
            nArray2[n4] = n4;
            n5 = n4;
            ++n6;
        }
        n4 = nArray[n2 - 1];
        n6 = n4 + 1;
        while (n6 < n3) {
            nArray2[n6] = n4;
            ++n6;
        }
        return nArray2;
    }

    public Time getDuration() {
        return this.duration;
    }

    private long getLocation() {
        return this.getLocation(this.stream);
    }

    public Time getMediaTime() {
        return null;
    }

    public String getName() {
        return "Parser for avi file format";
    }

    public ContentDescriptor[] getSupportedInputContentDescriptors() {
        return supportedFormat;
    }

    public Track[] getTracks() throws IOException, BadHeaderException {
        if (this.tracks != null) {
            return this.tracks;
        }
        if (this.seekableStream == null) {
            return new Track[0];
        }
        this.readHeader();
        if (!this.moviChunkSeen) {
            throw new BadHeaderException("No movi chunk");
        }
        if (!this.idx1ChunkSeen) {
            throw new BadHeaderException("Currently files with no idx1 chunk are not supported");
        }
        if (this.numTracks <= 0) {
            throw new BadHeaderException("Error parsing header");
        }
        this.tracks = new Track[this.numTracks];
        int n2 = 0;
        while (n2 < this.tracks.length) {
            TrakList trakList = this.trakList[n2];
            if (trakList.trackType.equals(AUDIO)) {
                this.tracks[n2] = new AudioTrack(trakList);
            } else if (trakList.trackType.equals(VIDEO)) {
                this.tracks[n2] = new VideoTrack(trakList);
            }
            ++n2;
        }
        return this.tracks;
    }

    private boolean isSupported(String string) {
        return string.equals(VIDEO) || string.equals(AUDIO);
    }

    private void parseAVIH(int n2) throws BadHeaderException {
        try {
            if (n2 < 56) {
                throw new BadHeaderException("avih: header size is not 56");
            }
            this.usecPerFrame = this.readInt(this.stream, false);
            this.nanoSecPerFrame = this.usecPerFrame * 1000;
            this.maxBytesPerSecond = this.readInt(this.stream, false);
            this.paddingGranularity = this.readInt(this.stream, false);
            this.flags = this.readInt(this.stream, false);
            this.totalFrames = this.readInt(this.stream, false);
            this.initialFrames = this.readInt(this.stream, false);
            this.numTracks = this.readInt(this.stream, false);
            this.suggestedBufferSize = this.readInt(this.stream, false);
            this.width = this.readInt(this.stream, false);
            this.height = this.readInt(this.stream, false);
            this.skip(this.stream, 16);
            if (n2 - 56 > 0) {
                this.skip(this.stream, n2 - 56);
            }
        }
        catch (IOException iOException) {
            throw new BadHeaderException("IOException when parsing hdrl");
        }
    }

    private void parseHDRL() throws BadHeaderException {
        try {
            String string = this.readString(this.stream);
            if (!string.equals("avih")) {
                throw new BadHeaderException("AVI Parser: expected string AVIH, got " + string);
            }
            int n2 = this.readInt(this.stream, false);
            this.parseAVIH(n2);
            this.trakList = new TrakList[this.numTracks];
        }
        catch (IOException iOException) {
            throw new BadHeaderException("IOException when parsing hdrl");
        }
    }

    private void parseIDX1(int n2) throws BadHeaderException {
        try {
            int n3;
            int n4;
            if (!this.moviChunkSeen) {
                throw new BadHeaderException("idx1 chunk appears before movi chunk");
            }
            int n5 = n2 / 16;
            int n6 = 0;
            while (n6 < this.numTracks) {
                if (this.trakList[n6] == null) {
                    throw new BadHeaderException("Bad file format");
                }
                this.trakList[n6].chunkInfo = new AVIIndexEntry[n5];
                if (this.trakList[n6].trackType.equals(VIDEO)) {
                    this.trakList[n6].keyFrames = new int[n5];
                }
                ++n6;
            }
            this.idx1MinimumChunkOffset = Integer.MAX_VALUE;
            int n7 = 0;
            while (n7 < n5) {
                block20: {
                    String string = this.readString(this.stream);
                    if (string.equals(LISTRECORDCHUNK)) {
                        this.readInt(this.stream, false);
                        this.readInt(this.stream, false);
                        this.readInt(this.stream, false);
                    } else {
                        int n8;
                        try {
                            n4 = Integer.parseInt(string.substring(0, 2));
                        }
                        catch (NumberFormatException numberFormatException) {
                            this.readInt(this.stream, false);
                            this.readInt(this.stream, false);
                            this.readInt(this.stream, false);
                            break block20;
                        }
                        if (n4 < 0 || n4 >= this.numTracks) {
                            throw new BadHeaderException("index chunk has illegal stream # " + n4);
                        }
                        int n9 = this.readInt(this.stream, false);
                        int n10 = this.readInt(this.stream, false);
                        int n11 = this.readInt(this.stream, false);
                        AVIIndexEntry[] aVIIndexEntryArray = this.trakList[n4].chunkInfo;
                        n3 = this.trakList[n4].maxChunkIndex;
                        aVIIndexEntryArray[n3] = new AVIIndexEntry();
                        aVIIndexEntryArray[n3].id = string;
                        aVIIndexEntryArray[n3].flag = n9;
                        aVIIndexEntryArray[n3].chunkOffset = n10;
                        aVIIndexEntryArray[n3].chunkLength = n11;
                        if (this.trakList[n4].trackType.equals(AUDIO)) {
                            aVIIndexEntryArray[n3].cumulativeChunkLength = n8 = (this.trakList[n4].tmpCumulativeChunkLength += n11);
                        }
                        if (this.trakList[n4].trackType.equals(VIDEO) && (n9 & 0x10) > 0) {
                            n8 = this.trakList[n4].numKeyFrames++;
                            this.trakList[n4].keyFrames[n8] = n3;
                        }
                        ++this.trakList[n4].maxChunkIndex;
                        if (n10 < this.idx1MinimumChunkOffset) {
                            this.idx1MinimumChunkOffset = n10;
                        }
                    }
                }
                ++n7;
            }
            n4 = 0;
            while (n4 < this.numTracks) {
                if (this.trakList[n4].trackType.equals(VIDEO)) {
                    int n12 = this.trakList[n4].numKeyFrames;
                    if (n12 > 0) {
                        this.keyFrameTrack = n4;
                    }
                    n3 = this.trakList[n4].maxChunkIndex;
                    if (n12 > 0 && n12 < n3) {
                        this.trakList[n4].indexToKeyframeIndex = this.buildIndexToKeyFrameIndexTable(this.trakList[n4].keyFrames, n12, n3);
                    }
                    this.trakList[n4].keyFrames = null;
                }
                ++n4;
            }
            if (this.idx1MinimumChunkOffset >= this.moviOffset) {
                this.moviOffset = 0;
            }
            this.moviOffset += 8;
        }
        catch (IOException iOException) {
            throw new BadHeaderException("IOException when parsing IDX1");
        }
        this.idx1ChunkSeen = true;
    }

    private void parseMOVI(int n2) throws BadHeaderException {
        try {
            this.moviChunkSeen = true;
            if ((this.flags & 0x10) > 0) {
                this.moviOffset = (int)this.getLocation(this.stream) - 4;
                this.skip(this.stream, n2);
            }
        }
        catch (IOException iOException) {
            throw new BadHeaderException("IOException when parsing movi");
        }
    }

    private void parseSTRF(int n2, int n3) throws BadHeaderException {
        block19: {
            try {
                String string = this.trakList[n3].trackType;
                if (string.equals(VIDEO)) {
                    Video video = new Video();
                    video.size = this.readInt(this.stream, false);
                    video.width = this.readInt(this.stream, false);
                    video.height = this.readInt(this.stream, false);
                    video.planes = this.readShort(this.stream, false);
                    video.depth = this.readShort(this.stream, false);
                    byte[] byArray = new byte[4];
                    this.readBytes(this.stream, byArray, 4);
                    if (byArray[0] > 32) {
                        video.compressor = new String(byArray);
                    } else {
                        switch (byArray[0]) {
                            case 0: {
                                video.compressor = "rgb";
                                break;
                            }
                            case 1: {
                                video.compressor = "rle8";
                                break;
                            }
                            case 2: {
                                video.compressor = "rle4";
                                break;
                            }
                            case 3: {
                                video.compressor = "rgb";
                                break;
                            }
                        }
                    }
                    BitMapInfo bitMapInfo = new BitMapInfo();
                    bitMapInfo.biWidth = video.width;
                    bitMapInfo.biHeight = video.height;
                    bitMapInfo.biPlanes = video.planes;
                    bitMapInfo.biBitCount = video.depth;
                    bitMapInfo.fourcc = new String(video.compressor);
                    video.bitMapInfo = bitMapInfo;
                    bitMapInfo.biSizeImage = this.readInt(this.stream, false);
                    bitMapInfo.biXPelsPerMeter = this.readInt(this.stream, false);
                    bitMapInfo.biYPelsPerMeter = this.readInt(this.stream, false);
                    bitMapInfo.biClrUsed = this.readInt(this.stream, false);
                    bitMapInfo.biClrImportant = this.readInt(this.stream, false);
                    if (n2 - 40 > 0) {
                        bitMapInfo.extraSize = n2 - 40;
                        bitMapInfo.extraBytes = new byte[bitMapInfo.extraSize];
                        this.readBytes(this.stream, bitMapInfo.extraBytes, bitMapInfo.extraSize);
                    }
                    this.trakList[n3].media = video;
                    this.trakList[n3].media.maxSampleSize = this.trakList[n3].suggestedBufferSize;
                    this.videoTrack = n3;
                    break block19;
                }
                if (string.equals(AUDIO)) {
                    Audio audio = new Audio();
                    audio.formatTag = this.readShort(this.stream, false);
                    audio.channels = this.readShort(this.stream, false);
                    audio.sampleRate = this.readInt(this.stream, false);
                    audio.avgBytesPerSec = this.readInt(this.stream, false);
                    audio.blockAlign = this.readShort(this.stream, false);
                    audio.bitsPerSample = this.readShort(this.stream, false);
                    int n4 = n2 - 16;
                    this.codecSpecificHeader = null;
                    short s = 0;
                    if (n4 >= 2) {
                        s = this.readShort(this.stream, false);
                        n4 -= 2;
                        if (s > 0) {
                            this.codecSpecificHeader = new byte[s];
                            this.readBytes(this.stream, this.codecSpecificHeader, this.codecSpecificHeader.length);
                            n4 -= s;
                        }
                        if (audio.formatTag == 2 || audio.formatTag == 17 || audio.formatTag == 49) {
                            if (s < 2) {
                                throw new BadHeaderException("samplesPerBlock field not available for encoding" + audio.formatTag);
                            }
                            audio.samplesPerBlock = BasicPullParser.parseShortFromArray(this.codecSpecificHeader, false);
                        }
                    }
                    if (n4 < 0) {
                        throw new BadHeaderException("Avi Parser: incorrect headersize in the STRF");
                    }
                    if (n4 > 0) {
                        this.skip(this.stream, n2 - 16);
                    }
                    this.trakList[n3].media = audio;
                    this.audioTrack = n3;
                    break block19;
                }
                throw new BadHeaderException("strf: unsupported stream type " + string);
            }
            catch (IOException iOException) {
                throw new BadHeaderException("IOException when parsing hdrl");
            }
        }
    }

    private void parseSTRH(int n2, int n3) throws BadHeaderException {
        try {
            if (n2 < 56) {
                throw new BadHeaderException("strh: header length should be atleast 56 but is " + n2);
            }
            this.trakList[n3] = new TrakList();
            this.trakList[n3].trackType = this.readString(this.stream);
            this.trakList[n3].streamHandler = this.readString(this.stream);
            this.trakList[n3].flags = this.readInt(this.stream, false);
            this.trakList[n3].priority = this.readInt(this.stream, false);
            this.trakList[n3].initialFrames = this.readInt(this.stream, false);
            this.trakList[n3].scale = this.readInt(this.stream, false);
            this.trakList[n3].rate = this.readInt(this.stream, false);
            this.trakList[n3].start = this.readInt(this.stream, false);
            this.trakList[n3].length = this.readInt(this.stream, false);
            this.trakList[n3].suggestedBufferSize = this.readInt(this.stream, false);
            this.trakList[n3].quality = this.readInt(this.stream, false);
            this.trakList[n3].sampleSize = this.readInt(this.stream, false);
            this.skip(this.stream, 8);
            if (n2 - 56 > 0) {
                this.skip(this.stream, n2 - 56);
            }
        }
        catch (IOException iOException) {
            throw new BadHeaderException("IOException when parsing hdrl");
        }
    }

    private void parseSTRL(int n2, int n3) throws BadHeaderException {
        try {
            if (n3 >= this.trakList.length) {
                throw new BadHeaderException("inconsistent number of strl atoms");
            }
            n2 -= 12;
            while (n2 >= 12) {
                String string = this.readString(this.stream);
                int n4 = this.readInt(this.stream, false);
                if (string.equals("strh")) {
                    this.parseSTRH(n4, n3);
                } else if (string.equals("strf")) {
                    if (this.trakList[n3] == null) {
                        throw new BadHeaderException("strf doesn't have a strh atom preceding it");
                    }
                    this.parseSTRF(n4, n3);
                } else {
                    if ((n4 & 1) > 0) {
                        ++n4;
                    }
                    this.skip(this.stream, n4);
                }
                n2 -= n4 + 4;
            }
        }
        catch (IOException iOException) {
            throw new BadHeaderException("IOException when parsing hdrl");
        }
    }

    private void readHeader() throws IOException, BadHeaderException {
        String string = this.readString(this.stream);
        if (!string.equals("RIFF")) {
            throw new BadHeaderException("AVI Parser: expected string RIFF, got " + string);
        }
        this.length = this.readInt(this.stream, false);
        this.length += 8;
        String string2 = this.readString(this.stream);
        if (!string2.equals("AVI ")) {
            throw new BadHeaderException("AVI Parser: expected string AVI, got " + string2);
        }
        int n2 = 0;
        while (this.getLocation(this.stream) <= (long)(this.length - 12)) {
            String string3 = this.readString(this.stream);
            int n3 = this.readInt(this.stream, false);
            if (string3.equals("LIST")) {
                String string4 = this.readString(this.stream);
                if (string4.equals("hdrl")) {
                    this.parseHDRL();
                    continue;
                }
                if (string4.equals("strl")) {
                    this.parseSTRL(n3, n2);
                    ++n2;
                    continue;
                }
                if (string4.equals("movi")) {
                    this.parseMOVI(n3 - 4);
                    continue;
                }
                this.skip(this.stream, n3 - 4);
                continue;
            }
            if (string3.equals("idx1")) {
                this.parseIDX1(n3);
                continue;
            }
            this.skip(this.stream, n3);
            if ((n3 & 1) <= 0) continue;
            this.skip(this.stream, 1);
        }
        if (this.totalFrames != 0 && this.usecPerFrame != 0) {
            this.duration = new Time((long)this.usecPerFrame * (long)this.totalFrames * 1000L);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Time setPosition(Time time, int n2) {
        int n3;
        int n4 = -1;
        if (this.keyFrameTrack != -1 && this.tracks[this.keyFrameTrack].isEnabled()) {
            TrakList trakList = this.trakList[this.keyFrameTrack];
            Track track = this.tracks[this.keyFrameTrack];
            n4 = n3 = track.mapTimeToFrame(time);
            if (trakList.indexToKeyframeIndex.length > n3) {
                n4 = trakList.indexToKeyframeIndex[n3];
            }
            if (n4 != n3) {
                time = track.mapFrameToTime(n4);
            }
        }
        int n5 = 0;
        while (true) {
            block17: {
                if (n5 >= this.numTracks) {
                    return time;
                }
                if (this.tracks[n5].isEnabled()) {
                    Object var8_9;
                    int n6;
                    block18: {
                        block21: {
                            block20: {
                                block19: {
                                    n6 = 0;
                                    n3 = 0;
                                    try {
                                        int n7;
                                        if (n5 == this.keyFrameTrack) {
                                            n6 = n4;
                                            var8_9 = null;
                                            ((MediaTrack)this.tracks[n5]).setChunkNumberAndOffset(n6, n3);
                                            break block17;
                                        }
                                        TrakList trakList = this.trakList[n5];
                                        if (trakList.trackType.equals(VIDEO)) {
                                            if (this.usecPerFrame == 0) break block18;
                                            n6 = (int)(time.getNanoseconds() / this.nanoSecPerFrame);
                                            if (n6 < 0) {
                                                n6 = 0;
                                                break block18;
                                            }
                                            if (n6 < trakList.maxChunkIndex) break block18;
                                            break block19;
                                        }
                                        if (!trakList.trackType.equals(AUDIO)) break block18;
                                        int n8 = (int)(time.getSeconds() * (double)((Audio)trakList.media).avgBytesPerSec);
                                        if (n8 < 0) {
                                            n8 = 0;
                                        }
                                        if (trakList.maxChunkIndex == 1) {
                                            if (n8 >= trakList.chunkInfo[0].chunkLength) {
                                                n6 = trakList.maxChunkIndex;
                                                break block20;
                                            }
                                            n6 = 0;
                                            n3 = n8;
                                        } else {
                                            n6 = trakList.getChunkNumber(n8);
                                            if (n6 >= trakList.maxChunkIndex) {
                                                break block21;
                                            }
                                            n7 = trakList.chunkInfo[n6].cumulativeChunkLength - trakList.chunkInfo[n6].chunkLength;
                                            n3 = n8 - n7;
                                        }
                                        if ((n3 & 1) > 0) {
                                            --n3;
                                        }
                                        if ((n7 = ((Audio)trakList.media).blockAlign) == 0) break block18;
                                        n3 -= n3 % n7;
                                        break block18;
                                    }
                                    catch (Throwable throwable) {
                                        var8_9 = null;
                                        ((MediaTrack)this.tracks[n5]).setChunkNumberAndOffset(n6, n3);
                                        throw throwable;
                                    }
                                }
                                var8_9 = null;
                                ((MediaTrack)this.tracks[n5]).setChunkNumberAndOffset(n6, n3);
                                break block17;
                            }
                            var8_9 = null;
                            ((MediaTrack)this.tracks[n5]).setChunkNumberAndOffset(n6, n3);
                            break block17;
                        }
                        var8_9 = null;
                        ((MediaTrack)this.tracks[n5]).setChunkNumberAndOffset(n6, n3);
                        break block17;
                    }
                    var8_9 = null;
                    ((MediaTrack)this.tracks[n5]).setChunkNumberAndOffset(n6, n3);
                }
            }
            ++n5;
        }
    }

    public void setSource(DataSource dataSource) throws IOException, IncompatibleSourceException {
        super.setSource(dataSource);
        this.stream = (PullSourceStream)this.streams[0];
        this.seekableStream = (Seekable)((Object)this.streams[0]);
    }

    protected boolean supports(SourceStream[] sourceStreamArray) {
        return this.seekable;
    }

    private abstract class Media {
        int maxSampleSize;

        Media() {
        }

        abstract Format createFormat();
    }

    private class Audio
    extends Media {
        int formatTag;
        int channels;
        int sampleRate;
        int avgBytesPerSec;
        int blockAlign;
        int bitsPerSample;
        int samplesPerBlock;
        AudioFormat format = null;

        Audio() {
        }

        Format createFormat() {
            if (this.format != null) {
                return this.format;
            }
            String string = (String)WavAudioFormat.formatMapper.get(new Integer(this.formatTag));
            if (string == null) {
                string = "unknown";
            }
            boolean bl = this.bitsPerSample > 8;
            this.format = new WavAudioFormat(string, this.sampleRate, this.bitsPerSample, this.channels, this.blockAlign * 8, this.avgBytesPerSec, 0, bl ? 1 : 0, -1.0f, Format.byteArray, AviParser.this.codecSpecificHeader);
            return this.format;
        }

        public String toString() {
            System.out.println("Audio Media: " + this.format);
            System.out.println("Number of channels " + this.channels);
            System.out.println("average bytes per second " + this.avgBytesPerSec);
            System.out.println("sampleRate " + this.sampleRate);
            System.out.println("blockAlign " + this.blockAlign);
            System.out.println("bitsPerSample " + this.bitsPerSample);
            System.out.println("formatTag " + this.formatTag);
            return super.toString();
        }
    }

    private class Video
    extends Media {
        int size;
        int width;
        int height;
        int planes;
        int depth;
        String compressor;
        VideoFormat format = null;
        BitMapInfo bitMapInfo = null;

        Video() {
        }

        Format createFormat() {
            if (this.format != null) {
                return this.format;
            }
            this.format = AviParser.this.usecPerFrame != 0 ? this.bitMapInfo.createVideoFormat(Format.byteArray, (float)(1.0 / (double)AviParser.this.usecPerFrame * 1000000.0)) : this.bitMapInfo.createVideoFormat(Format.byteArray);
            return this.format;
        }

        public String toString() {
            System.out.println("size is " + this.size);
            System.out.println("width is " + this.width);
            System.out.println("height is " + this.height);
            System.out.println("planes is " + this.planes);
            System.out.println("depth is " + this.depth);
            System.out.println("compressor is " + this.compressor);
            return super.toString();
        }
    }

    private class TrakList {
        Time duration = Duration.DURATION_UNKNOWN;
        String trackType;
        String streamHandler;
        int flags;
        int priority;
        int initialFrames;
        int scale;
        int rate;
        int start;
        int length;
        int suggestedBufferSize;
        int quality;
        int sampleSize;
        Media media;
        boolean supported = true;
        AVIIndexEntry[] chunkInfo = new AVIIndexEntry[0];
        int maxChunkIndex = 0;
        int[] indexToKeyframeIndex = new int[0];
        int[] keyFrames = new int[0];
        int numKeyFrames = 0;
        int tmpCumulativeChunkLength = 0;

        TrakList() {
        }

        int getChunkNumber(int n2) {
            int n3 = 0;
            while (n3 < this.maxChunkIndex) {
                if (n2 < this.chunkInfo[n3].cumulativeChunkLength) {
                    return n3;
                }
                ++n3;
            }
            return this.maxChunkIndex;
        }
    }

    private abstract class MediaTrack
    implements Track {
        protected TrakList trakInfo;
        private boolean enabled = true;
        private int numBuffers = 4;
        private Format format;
        private long sequenceNumber = 0L;
        private int chunkNumber = 0;
        protected int useChunkNumber = 0;
        protected int offsetWithinChunk = -1;
        protected int useOffsetWithinChunk = 0;
        private AviParser parser = AviParser.this;
        private AVIIndexEntry indexEntry;
        private Object header = null;
        private TrackListener listener;

        MediaTrack(TrakList trakList) {
            this.trakInfo = trakList;
            this.format = trakList.media.createFormat();
        }

        abstract void doReadFrame(Buffer var1);

        public Time getDuration() {
            return this.trakInfo.duration;
        }

        public Format getFormat() {
            return this.format;
        }

        public Time getStartTime() {
            return new Time(0L);
        }

        abstract long getTimeStamp();

        public boolean isEnabled() {
            return this.enabled;
        }

        public Time mapFrameToTime(int n2) {
            return Track.TIME_UNKNOWN;
        }

        public int mapTimeToFrame(Time time) {
            return Integer.MAX_VALUE;
        }

        public void readFrame(Buffer buffer) {
            byte[] byArray;
            if (buffer == null) {
                return;
            }
            if (!this.enabled) {
                buffer.setDiscard(true);
                return;
            }
            MediaTrack mediaTrack = this;
            synchronized (mediaTrack) {
                if (this.offsetWithinChunk == -1) {
                    this.useOffsetWithinChunk = 0;
                } else {
                    this.useOffsetWithinChunk = this.offsetWithinChunk;
                    this.offsetWithinChunk = -1;
                }
                this.useChunkNumber = this.chunkNumber;
            }
            if (this.useChunkNumber >= this.trakInfo.maxChunkIndex || this.useChunkNumber < 0) {
                buffer.setLength(0);
                buffer.setEOM(true);
                return;
            }
            buffer.setFormat(this.format);
            this.indexEntry = this.trakInfo.chunkInfo[this.useChunkNumber];
            int n2 = this.indexEntry.chunkLength;
            Object object = buffer.getData();
            buffer.setHeader(new Integer(this.indexEntry.flag));
            if (object == null || !(object instanceof byte[]) || ((byte[])object).length < n2) {
                byArray = new byte[n2];
                buffer.setData(byArray);
            } else {
                byArray = (byte[])object;
            }
            try {
                int n3;
                Object object2 = AviParser.this.seekSync;
                synchronized (object2) {
                    AviParser.this.seekableStream.seek(this.indexEntry.chunkOffset + AviParser.this.moviOffset + this.useOffsetWithinChunk);
                    n3 = this.parser.readBytes(AviParser.this.stream, byArray, n2 - this.useOffsetWithinChunk);
                    this.offsetWithinChunk = 0;
                    buffer.setTimeStamp(this.getTimeStamp());
                }
                buffer.setLength(n3);
                long l2 = -1L;
                if (this.trakInfo.trackType.equals(AviParser.VIDEO)) {
                    if (AviParser.this.nanoSecPerFrame > 0L) {
                        l2 = AviParser.this.nanoSecPerFrame;
                    }
                    if (this.trakInfo.indexToKeyframeIndex.length == 0 || this.useChunkNumber == this.trakInfo.indexToKeyframeIndex[this.useChunkNumber]) {
                        buffer.setFlags(buffer.getFlags() | 0x10);
                    }
                }
                buffer.setDuration(l2);
                buffer.setSequenceNumber(++this.sequenceNumber);
            }
            catch (IOException iOException) {
                buffer.setLength(0);
                buffer.setEOM(true);
            }
            MediaTrack mediaTrack2 = this;
            synchronized (mediaTrack2) {
                if (this.chunkNumber == this.useChunkNumber) {
                    ++this.chunkNumber;
                }
            }
        }

        synchronized void setChunkNumberAndOffset(int n2, int n3) {
            this.chunkNumber = n2;
            this.offsetWithinChunk = n3;
        }

        public void setEnabled(boolean bl) {
            this.enabled = bl;
        }

        public void setTrackListener(TrackListener trackListener) {
            this.listener = trackListener;
        }
    }

    private class AudioTrack
    extends MediaTrack {
        int channels;
        int avgBytesPerSec;
        AVIIndexEntry[] chunkInfo;

        AudioTrack(TrakList trakList) {
            super(trakList);
            this.channels = ((Audio)trakList.media).channels;
            this.avgBytesPerSec = ((Audio)trakList.media).avgBytesPerSec;
            this.chunkInfo = trakList.chunkInfo;
        }

        void doReadFrame(Buffer buffer) {
        }

        long getTimeStamp() {
            if (this.avgBytesPerSec > 0) {
                long l2 = this.useOffsetWithinChunk;
                if (this.useChunkNumber > 0) {
                    l2 += (long)this.chunkInfo[this.useChunkNumber - 1].cumulativeChunkLength;
                }
                return (long)((double)((float)l2 / (float)this.avgBytesPerSec) * 1.0E9);
            }
            return 0L;
        }
    }

    private class VideoTrack
    extends MediaTrack {
        int needBufferSize;
        boolean variableSampleSize = true;

        VideoTrack(TrakList trakList) {
            super(trakList);
        }

        void doReadFrame(Buffer buffer) {
        }

        long getTimeStamp() {
            return (long)(this.useChunkNumber * AviParser.this.usecPerFrame) * 1000L;
        }

        public Time mapFrameToTime(int n2) {
            if (n2 < 0 || n2 >= this.trakInfo.maxChunkIndex) {
                return Track.TIME_UNKNOWN;
            }
            long l2 = (long)n2 * AviParser.this.nanoSecPerFrame;
            return new Time(l2);
        }

        public int mapTimeToFrame(Time time) {
            if (AviParser.this.nanoSecPerFrame <= 0L) {
                return Integer.MAX_VALUE;
            }
            if (time.getNanoseconds() < 0L) {
                return Integer.MAX_VALUE;
            }
            int n2 = (int)(time.getNanoseconds() / AviParser.this.nanoSecPerFrame);
            if (n2 >= this.trakInfo.maxChunkIndex) {
                return this.trakInfo.maxChunkIndex - 1;
            }
            return n2;
        }
    }

    private class AVIIndexEntry {
        public String id;
        public int flag;
        public int chunkOffset;
        public int chunkLength;
        public int cumulativeChunkLength = 0;

        AVIIndexEntry() {
        }
    }
}

