/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.protocol;

import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import com.sun.media.JMFSecurity;
import com.sun.media.JMFSecurityManager;
import com.sun.media.util.JMFI18N;
import com.sun.media.util.jdk12;
import com.sun.media.util.jdk12ConnectionAction;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLConnection;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.PullSourceStream;
import javax.media.protocol.Seekable;

public class BasicPullSourceStream
implements PullSourceStream,
Seekable {
    protected InputStream stream;
    protected long location;
    protected boolean eofReached;
    protected long contentLength;
    protected URL url;
    protected URLConnection urlC;
    private boolean needConnectPermission;
    private static JMFSecurity jmfSecurity = null;
    private static boolean securityPrivelege = false;
    private Method[] m = new Method[1];
    private Class[] cl = new Class[1];
    private Object[][] args = new Object[1][0];

    static {
        try {
            jmfSecurity = JMFSecurityManager.getJMFSecurity();
            securityPrivelege = true;
        }
        catch (SecurityException securityException) {}
    }

    public BasicPullSourceStream(URL uRL, InputStream inputStream, long l2, boolean bl) throws IOException {
        this.needConnectPermission = bl;
        if (inputStream != null) {
            this.stream = inputStream;
            this.contentLength = l2;
        } else {
            try {
                this.urlC = uRL.openConnection();
                this.contentLength = this.urlC.getContentLength();
                this.stream = this.urlC.getInputStream();
                if (this.stream == null) {
                    throw new IOException("Got null input stream from url connection");
                }
            }
            catch (IOException iOException) {
                throw new IOException("error in connection");
            }
        }
        this.location = 0L;
        this.eofReached = false;
        this.url = uRL;
    }

    public void close() {
        try {
            this.stream.close();
            this.stream = null;
        }
        catch (Exception exception) {
            System.out.println("BasicPullSourceStream close - IOException");
        }
    }

    public boolean endOfStream() {
        return this.eofReached;
    }

    public ContentDescriptor getContentDescriptor() {
        return null;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public Object getControl(String string) {
        return null;
    }

    public Object[] getControls() {
        Object[] objectArray = new Object[]{};
        return objectArray;
    }

    public boolean isRandomAccess() {
        return true;
    }

    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        int n5 = n3;
        int n6 = n2;
        do {
            if ((n4 = this.stream.read(byArray, n6, n5)) == -1) {
                this.eofReached = true;
                int n7 = n3 - n5;
                return n7 > 0 ? n7 : -1;
            }
            this.location += (long)n4;
            n6 += n4;
        } while ((n5 -= n4) != 0);
        return n3;
    }

    void reopenStream() {
        try {
            if (this.stream != null) {
                this.stream.close();
            }
            if (this.needConnectPermission && jmfSecurity != null) {
                try {
                    if (jmfSecurity.getName().startsWith("jmf-security")) {
                        jmfSecurity.requestPermission(this.m, this.cl, this.args, 128);
                        this.m[0].invoke((Object)this.cl[0], this.args[0]);
                    } else if (jmfSecurity.getName().startsWith("internet")) {
                        PolicyEngine.checkPermission((PermissionID)PermissionID.NETIO);
                        PolicyEngine.assertPermission((PermissionID)PermissionID.NETIO);
                    }
                }
                catch (Throwable throwable) {
                    securityPrivelege = false;
                    throw new IOException(String.valueOf(JMFI18N.getResource("error.connectionerror")) + throwable.getMessage());
                }
            }
            this.urlC = this.url.openConnection();
            try {
                if (jmfSecurity != null && jmfSecurity.getName().startsWith("jdk12")) {
                    Constructor constructor = jdk12ConnectionAction.cons;
                    this.stream = (InputStream)jdk12.doPrivM.invoke((Object)jdk12.ac, constructor.newInstance(this.urlC));
                } else {
                    this.stream = this.urlC.getInputStream();
                }
            }
            catch (Exception exception) {
                System.err.println("Unable to re-open a URL connection " + exception);
                throw new IOException(String.valueOf(JMFI18N.getResource("error.connectionerror")) + exception.getMessage());
            }
        }
        catch (IOException iOException) {}
    }

    public long seek(long l2) {
        long l3 = this.location;
        this.location = l2;
        try {
            if (l2 < l3) {
                this.reopenStream();
                this.eofReached = false;
                return this.skip(this.stream, l2);
            }
            return this.skip(this.stream, l2 - l3);
        }
        catch (IOException iOException) {
            return 0L;
        }
    }

    private long skip(InputStream inputStream, long l2) throws IOException {
        long l3 = l2;
        while (l3 > 0L) {
            long l4 = inputStream.skip(l3);
            l3 -= l4;
        }
        return l2;
    }

    public long tell() {
        return this.location;
    }

    public boolean willReadBlock() {
        try {
            return this.stream.available() == 0;
        }
        catch (IOException iOException) {
            System.err.println("Exception PullSourceStream::willReadBlock " + iOException.toString());
            return true;
        }
    }
}

