/*
 * Decompiled with CFR 0.152.
 */
package jmapps.rtp;

import com.sun.media.util.JMFI18N;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.List;
import java.util.Vector;
import javax.media.rtp.Participant;
import javax.media.rtp.SessionManager;
import jmapps.ui.JMPanel;

public class ViewParticipantList
extends JMPanel {
    public static final String PARTICIPANTS = JMFI18N.getResource("jmstudio.rtpsessionctrl.partcipants");
    public static final String NONE = JMFI18N.getResource("jmstudio.rtpsessionctrl.partcipants.none");
    public static final String REMOTE = JMFI18N.getResource("jmstudio.rtpsessionctrl.partcipants.remote");
    public static final String LOCAL = JMFI18N.getResource("jmstudio.rtpsessionctrl.partcipants.local");
    public static final String PASSIVE = JMFI18N.getResource("jmstudio.rtpsessionctrl.partcipants.passive");
    public static final String ACTIVE = JMFI18N.getResource("jmstudio.rtpsessionctrl.partcipants.active");
    private SessionManager mngrSession;
    private List listParticipantsRemote;
    private List listParticipantsLocal;
    private List listParticipantsActive;
    private List listParticipantsPassive;
    private Vector lastRemoteList = new Vector();
    private Vector lastLocalList = new Vector();
    private Vector lastActiveList = new Vector();
    private Vector lastPassiveList = new Vector();
    long lastCheckTime = -1L;

    public ViewParticipantList(SessionManager sessionManager) {
        this.mngrSession = sessionManager;
        try {
            this.init();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    boolean compare(Vector vector, Vector vector2) {
        if (vector.size() != vector2.size()) {
            return false;
        }
        int n2 = 0;
        while (n2 < vector.size()) {
            if (!vector2.contains(vector.elementAt(n2))) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static Vector getParticipants(SessionManager sessionManager, String string) {
        Vector vector = null;
        if (string.equals(REMOTE)) {
            vector = sessionManager.getRemoteParticipants();
        } else if (string.equals(LOCAL)) {
            vector = new Vector();
            vector.addElement(sessionManager.getLocalParticipant());
        } else if (string.equals(PASSIVE)) {
            vector = sessionManager.getPassiveParticipants();
        } else if (string.equals(ACTIVE)) {
            vector = sessionManager.getActiveParticipants();
        }
        return vector;
    }

    private void init() throws Exception {
        this.setLayout(new GridLayout(0, 1, 6, 6));
        JMPanel jMPanel = new JMPanel(new BorderLayout());
        this.add(jMPanel);
        Label label = new Label(String.valueOf(REMOTE) + ":");
        jMPanel.add((Component)label, "North");
        this.listParticipantsRemote = new List();
        jMPanel.add((Component)this.listParticipantsRemote, "Center");
        jMPanel = new JMPanel(new BorderLayout());
        this.add(jMPanel);
        label = new Label(String.valueOf(LOCAL) + ":");
        jMPanel.add((Component)label, "North");
        this.listParticipantsLocal = new List();
        jMPanel.add((Component)this.listParticipantsLocal, "Center");
        jMPanel = new JMPanel(new BorderLayout());
        this.add(jMPanel);
        label = new Label(String.valueOf(ACTIVE) + ":");
        jMPanel.add((Component)label, "North");
        this.listParticipantsActive = new List();
        jMPanel.add((Component)this.listParticipantsActive, "Center");
        jMPanel = new JMPanel(new BorderLayout());
        this.add(jMPanel);
        label = new Label(String.valueOf(PASSIVE) + ":");
        jMPanel.add((Component)label, "North");
        this.listParticipantsPassive = new List();
        jMPanel.add((Component)this.listParticipantsPassive, "Center");
        this.updateFields();
    }

    public void updateFields() {
        int n2;
        Object e2;
        int n3;
        int n4;
        long l2 = System.currentTimeMillis();
        if (l2 - this.lastCheckTime < 3000L) {
            return;
        }
        this.lastCheckTime = l2;
        Vector vector = ViewParticipantList.getParticipants(this.mngrSession, REMOTE);
        if (!this.compare(this.lastRemoteList, vector)) {
            if (this.listParticipantsRemote.getItemCount() > 0) {
                this.listParticipantsRemote.removeAll();
            }
            n4 = vector.size();
            n3 = 0;
            while (n3 < n4) {
                e2 = vector.elementAt(n3);
                if (e2 != null && e2 instanceof Participant) {
                    this.listParticipantsRemote.add(((Participant)e2).getCNAME());
                }
                ++n3;
            }
            if (n4 < 1) {
                this.listParticipantsRemote.add(NONE);
            }
            this.lastRemoteList.removeAllElements();
            n2 = 0;
            while (n2 < vector.size()) {
                this.lastRemoteList.addElement(vector.elementAt(n2));
                ++n2;
            }
        }
        if (!this.compare(this.lastLocalList, vector = ViewParticipantList.getParticipants(this.mngrSession, LOCAL))) {
            if (this.listParticipantsLocal.getItemCount() > 0) {
                this.listParticipantsLocal.removeAll();
            }
            n4 = vector.size();
            n3 = 0;
            while (n3 < n4) {
                e2 = vector.elementAt(n3);
                if (e2 != null && e2 instanceof Participant) {
                    this.listParticipantsLocal.add(((Participant)e2).getCNAME());
                }
                ++n3;
            }
            if (n4 < 1) {
                this.listParticipantsLocal.add(NONE);
            }
            this.lastLocalList.removeAllElements();
            n2 = 0;
            while (n2 < vector.size()) {
                this.lastLocalList.addElement(vector.elementAt(n2));
                ++n2;
            }
        }
        if (!this.compare(this.lastActiveList, vector = ViewParticipantList.getParticipants(this.mngrSession, ACTIVE))) {
            if (this.listParticipantsActive.getItemCount() > 0) {
                this.listParticipantsActive.removeAll();
            }
            n4 = vector.size();
            n3 = 0;
            while (n3 < n4) {
                e2 = vector.elementAt(n3);
                if (e2 != null && e2 instanceof Participant) {
                    this.listParticipantsActive.add(((Participant)e2).getCNAME());
                }
                ++n3;
            }
            if (n4 < 1) {
                this.listParticipantsActive.add(NONE);
            }
            this.lastActiveList.removeAllElements();
            n2 = 0;
            while (n2 < vector.size()) {
                this.lastActiveList.addElement(vector.elementAt(n2));
                ++n2;
            }
        }
        if (!this.compare(this.lastPassiveList, vector = ViewParticipantList.getParticipants(this.mngrSession, PASSIVE))) {
            if (this.listParticipantsPassive.getItemCount() > 0) {
                this.listParticipantsPassive.removeAll();
            }
            n4 = vector.size();
            n3 = 0;
            while (n3 < n4) {
                e2 = vector.elementAt(n3);
                if (e2 != null && e2 instanceof Participant) {
                    this.listParticipantsPassive.add(((Participant)e2).getCNAME());
                }
                ++n3;
            }
            if (n4 < 1) {
                this.listParticipantsPassive.add(NONE);
            }
            this.lastPassiveList.removeAllElements();
            n2 = 0;
            while (n2 < vector.size()) {
                this.lastPassiveList.addElement(vector.elementAt(n2));
                ++n2;
            }
        }
    }
}

