package mpi.eudico.client.annotator.commands;

import mpi.eudico.client.annotator.gui.DocumentInfoDialog;
import mpi.eudico.server.corpora.clom.Transcription;

/**
 * A command to display a dialog to show document properties
 * 
 * @author Allan van Hulst
 *
 */
public class DocumentInfoCommand implements Command {
	private String name;
	private Transcription transcription;
	
	/**
	 * Constructor.
	 * 
	 * @param name the name
	 */
	public DocumentInfoCommand(String name) {
		this.name = name;
	}
 
	/**
	 * @param receiver the transcription
	 * @param arguments null
	 */
	@Override
	public void execute(Object receiver, Object[] arguments) {
		if (receiver instanceof Transcription) {
			transcription = (Transcription) receiver;
		}
		
		if (transcription == null) {
			return;
		}

		new DocumentInfoDialog (ELANCommandFactory.getRootFrame (transcription), transcription);
	}

	/**
	 * Returns the name of the command.
	 * @return the name
	 */
	@Override
	public String getName() {
		return name;
	}

}
