package mpi.eudico.server.corpora.lexicon;

import java.util.ArrayList;

import javax.swing.tree.TreeModel;


/**
 * Interface for a Lexicon Service Client that is generated by 
 * a factory from an Lexicon Service extension
 * @author Micha Hulsbosch
 *
 */
public interface LexiconServiceClient {
	
	public String getType();
	
	public String getDescription();
	
	public void setUrl(String lexiconWebserviceUrl);
	
	public String getUrl();

	public void setUsername(String username);
	
	public String getUsername();

	public void setPassword(String password);

	public String getPassword();
	
	public ArrayList<LexiconIdentification> getLexiconIdentifications() throws LexiconServiceClientException;
	
	public Lexicon getLexicon(LexiconIdentification lexId) throws LexiconServiceClientException;
	
	public ArrayList<LexicalEntryFieldIdentification> getLexicalEntryFieldIdentifications(LexiconIdentification lexId)  throws LexiconServiceClientException;
	
	public TreeModel getLexicalEntryStructure(LexiconIdentification lexId) throws LexiconServiceClientException;
	
	public ArrayList<String> getSearchConstraints();
	
	public Lexicon search(LexiconIdentification lexId, LexicalEntryFieldIdentification fldId, String constraint, String searchString) throws LexiconServiceClientException;
}
