package mpi.eudico.server.corpora.util;

/**
 * An interface for a process report. Will contain messages generated by the
 * process.
 *
 * @author Han Sloetjes
 * @version 1.0, Nov 2008
 */
public interface ProcessReport {
    /**
     * Returns the contents of the report (all messages) as a String.
     *
     * @return the report as a String
     */
    public String getReportAsString();

    /**
     * Appends a message to the report.
     *
     * @param message the message
     */
    public void append(String message);

    /**
     * Clears the messages that have been added.
     */
    public void clearReport();

    /**
     * Sets the name of the report.
     *
     * @param name the name
     */
    public void setName(String name);

    /**
     * Returns the name.
     *
     * @return the name
     */
    public String getName();
}
