/*
 * Decompiled with CFR 0.152.
 */
package mpi.dcr;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import mpi.dcr.isocat.Profile;

public class DCSmall {
    private String id;
    private Integer idAsInteger;
    private String identifier;
    private HashMap<String, String> nameMap;
    private HashMap<String, String> descMap;
    private DCSmall broaderDC;
    private String broaderDCId;
    private Profile[] profiles;
    private boolean loaded = false;
    public static final String EN = "en";
    private List<String> languages;
    private long lastUpdated = 0L;

    public DCSmall(Profile profile, String id, String identifier) {
        this.profiles = new Profile[]{profile};
        this.id = id;
        this.identifier = identifier;
        this.createIdAsInt(id);
        this.nameMap = new HashMap();
        this.descMap = new HashMap();
        this.languages = new ArrayList<String>();
    }

    public DCSmall(String id, String identifier) {
        this.profiles = new Profile[0];
        this.id = id;
        this.identifier = identifier;
        this.createIdAsInt(id);
        this.nameMap = new HashMap();
        this.descMap = new HashMap();
        this.languages = new ArrayList<String>();
    }

    public String toString() {
        return this.identifier;
    }

    private void createIdAsInt(String id) {
        if (id == null) {
            this.idAsInteger = -1;
        }
        try {
            this.idAsInteger = id.startsWith("http://www.isocat.org/datcat/DC-") ? Integer.valueOf(id.substring("http://www.isocat.org/datcat/DC-".length())) : Integer.valueOf(id);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public DCSmall getBroaderDC() {
        return this.broaderDC;
    }

    public void setBroaderDC(DCSmall broaderDC) {
        this.broaderDC = broaderDC;
    }

    public String getBroaderDCId() {
        return this.broaderDCId;
    }

    public void setBroaderDCId(String broaderDCId) {
        this.broaderDCId = broaderDCId;
    }

    public List<String> getAvailableLanguages() {
        ArrayList<String> langList = new ArrayList<String>();
        Iterator<String> it = this.descMap.keySet().iterator();
        while (it.hasNext()) {
            langList.add(it.next());
        }
        return langList;
    }

    public String getDesc() {
        return this.descMap.get(EN);
    }

    public void setDesc(String desc) {
        this.setDesc(EN, desc);
    }

    public String getDesc(String lang) {
        return this.descMap.get(lang);
    }

    public void setDesc(String lang, String desc) {
        this.descMap.put(lang, desc);
        if (!this.languages.contains(lang)) {
            this.languages.add(lang);
        }
    }

    public void setDescMap(HashMap<String, String> map) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.descMap.put(entry.getKey(), entry.getValue());
            if (this.languages.contains(entry.getKey())) continue;
            this.languages.add(entry.getKey());
        }
    }

    public void setNameMap(HashMap<String, String> map) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.nameMap.put(entry.getKey(), entry.getValue());
            if (this.languages.contains(entry.getKey())) continue;
            this.languages.add(entry.getKey());
        }
    }

    public List<String> getLanguages() {
        return this.languages;
    }

    public String getName() {
        return this.nameMap.get(EN);
    }

    public void setName(String name) {
        this.setName(EN, name);
    }

    public String getName(String lang) {
        return this.nameMap.get(lang);
    }

    public void setName(String lang, String name) {
        this.nameMap.put(lang, name);
        if (!this.languages.contains(lang)) {
            this.languages.add(lang);
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
        this.createIdAsInt(id);
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public Profile[] getProfiles() {
        return this.profiles;
    }

    public void setProfiles(Profile[] profiles) {
        this.profiles = profiles;
    }

    public Integer getIdAsInteger() {
        return this.idAsInteger;
    }

    public void setIdAsInteger(Integer idAsInteger) {
        this.idAsInteger = idAsInteger;
        if (idAsInteger != null) {
            this.id = idAsInteger.toString();
        }
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void setLoaded(boolean loaded) {
        this.loaded = loaded;
    }

    public void setLastUpdate(long lastUpdate) {
        this.lastUpdated = lastUpdate;
    }

    public long getLastUpdated() {
        return this.lastUpdated;
    }

    public int compareTo(DCSmall dc) {
        return String.CASE_INSENSITIVE_ORDER.compare(this.identifier, dc.identifier);
    }
}

