/*
 * Decompiled with CFR 0.152.
 */
package mpi.dcr;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import mpi.dcr.DCRConnectorException;
import mpi.dcr.ILATDCRConnector;
import mpi.dcr.isocat.Profile;
import mpi.dcr.isocat.RestDCRConnector;

public class ProfileSelectPanel
extends JPanel {
    private ILATDCRConnector connector = null;
    private JScrollPane scrollPane;
    private List<Profile> selectedProfs;
    private JList allProfs;
    private ResourceBundle resBundle;

    public ProfileSelectPanel() {
        this.initComponents();
    }

    public ProfileSelectPanel(ILATDCRConnector connector) {
        if (connector instanceof RestDCRConnector) {
            this.connector = (RestDCRConnector)connector;
        }
        this.initComponents();
    }

    public ProfileSelectPanel(ILATDCRConnector connector, ResourceBundle resBundle) {
        if (connector instanceof RestDCRConnector) {
            this.connector = (RestDCRConnector)connector;
        }
        this.resBundle = resBundle;
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        this.scrollPane = new JScrollPane();
        Dimension dim = new Dimension(200, 300);
        this.scrollPane.setMinimumSize(dim);
        this.scrollPane.setPreferredSize(dim);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(2, 6, 2, 6);
        this.add((Component)this.scrollPane, gbc);
        this.selectedProfs = new ArrayList<Profile>(8);
        this.initList();
        if (this.resBundle != null) {
            this.setBorder(new TitledBorder(this.resBundle.getString("DCR.Label.SelectProfiles")));
        } else {
            this.setBorder(new TitledBorder("Select Profiles"));
        }
    }

    private void initList() {
        if (this.connector == null) {
            this.connector = new RestDCRConnector();
        }
        try {
            ArrayList profiles = (ArrayList)this.connector.getProfiles();
            this.allProfs = new JList<Profile>(profiles.toArray(new Profile[0]));
            this.allProfs.getSelectionModel().setSelectionMode(2);
        }
        catch (DCRConnectorException dce) {
            System.out.println(dce.getMessage());
            dce.printStackTrace();
            this.allProfs = new JList();
        }
        if (this.allProfs != null) {
            this.scrollPane.setViewportView(this.allProfs);
        }
    }

    public List<Profile> getSelectedProfiles() {
        this.selectedProfs.clear();
        Object[] selObj = this.allProfs.getSelectedValues();
        for (int i = 0; i < selObj.length; ++i) {
            this.selectedProfs.add((Profile)selObj[i]);
        }
        return this.selectedProfs;
    }
}

