/*
 * Decompiled with CFR 0.152.
 */
package mpi.dcr;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import mpi.dcr.AbstractDCSelectPanel2;
import mpi.dcr.DCRConnectorException;
import mpi.dcr.DCSmall;
import mpi.dcr.ILATDCRConnector;
import mpi.dcr.isocat.Profile;
import mpi.dcr.isocat.RestDCRConnector;

public class RemoteDCSelectPanel
extends AbstractDCSelectPanel2
implements ActionListener {
    private JPanel profPanel;
    private JList profList;
    private JLabel errorLabel;
    protected DefaultListModel profModel;

    public RemoteDCSelectPanel(ILATDCRConnector connector) {
        super(connector);
        if (connector instanceof RestDCRConnector) {
            this.connector = (RestDCRConnector)connector;
        }
        this.initComponents();
    }

    public RemoteDCSelectPanel(ILATDCRConnector connector, ResourceBundle resBundle) {
        super(connector, resBundle);
        if (connector instanceof RestDCRConnector) {
            this.connector = (RestDCRConnector)connector;
        }
        this.initialize();
    }

    public RemoteDCSelectPanel() {
        this.initialize();
    }

    @Override
    protected void initComponents() {
        this.setLayout(new GridBagLayout());
        this.profPanel = new JPanel(new GridBagLayout());
        this.profModel = new DefaultListModel();
        this.profList = new JList(this.profModel);
        this.errorLabel = new JLabel();
        this.errorLabel.setVisible(false);
        this.profPanel.setMinimumSize(this.dim);
        this.profPanel.setPreferredSize(this.dim);
        this.profList.getSelectionModel().setSelectionMode(0);
        this.profList.addListSelectionListener(this);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.insets = this.globalInsets;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.profPanel.add((Component)new JScrollPane(this.profList), gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 11;
        gbc.insets = this.globalInsets;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 3;
        this.add((Component)this.errorLabel, gbc);
        gbc.anchor = 18;
        gbc.fill = 3;
        gbc.insets = this.globalInsets;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        this.add((Component)this.profPanel, gbc);
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        this.add((Component)this.catPanel, gbc);
        gbc.gridx = 2;
        gbc.weightx = 0.0;
        gbc.fill = 3;
        this.add((Component)this.descPanel, gbc);
        this.updateLocale();
        if (this.connector != null) {
            try {
                ArrayList profiles = (ArrayList)this.connector.getProfiles();
                this.addProfiles(profiles);
            }
            catch (DCRConnectorException dce) {
                dce.printStackTrace();
                Object errorMessage = this.resBundle != null ? this.resBundle.getString("DCR.Message.NoConnection") : "Could not connect to the registry: ";
                errorMessage = (String)errorMessage + " " + dce.getMessage();
                this.errorLabel.setText((String)errorMessage);
                this.errorLabel.setVisible(true);
                this.errorLabel.setForeground(Color.RED);
            }
        }
    }

    @Override
    protected void updateLocale() {
        super.updateLocale();
        String selProf = "Select Profile";
        String selCats = "Select Categories";
        if (this.resBundle != null) {
            try {
                selProf = this.resBundle.getString("DCR.Label.SelectProfile");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                selCats = this.resBundle.getString("DCR.Label.SelectCategories");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.profPanel.setBorder(new TitledBorder(selProf));
        this.catPanel.setBorder(new TitledBorder(selCats));
    }

    public void addProfiles(List<Profile> profiles) {
        if (profiles != null) {
            block0: for (int i = 0; i < profiles.size(); ++i) {
                Profile profile = profiles.get(i);
                if (profile == null) continue;
                for (int j = 0; j < this.profList.getModel().getSize(); ++j) {
                    if (profile.getId().equals(((Profile)this.profList.getModel().getElementAt(j)).getId())) continue block0;
                }
                ((DefaultListModel)this.profList.getModel()).addElement(profile);
            }
            if (this.profList.getModel().getSize() == 1) {
                this.profList.setSelectedIndex(0);
            }
        }
    }

    protected List<DCSmall> getDataCategories(Profile profile) {
        List<DCSmall> datCats = null;
        try {
            datCats = this.connector.getDCSmallList(profile.getId(), null);
            if (datCats.size() == 0) {
                String message = this.resBundle != null ? this.resBundle.getString("DCR.Message.NoCategories") : "No categories available in this profile";
                JOptionPane.showMessageDialog(this, message, "", 1);
            }
        }
        catch (DCRConnectorException dce) {
            String message = this.resBundle != null ? this.resBundle.getString("DCR.Message.NoConnection") : "Could not connect to the registry: ";
            JOptionPane.showMessageDialog(this, message + " " + dce.getMessage(), "", 0);
        }
        catch (IllegalArgumentException iae) {
            String message = this.resBundle != null ? this.resBundle.getString("DCR.Message.NoConnection") : "Could not connect to the registry: ";
            JOptionPane.showMessageDialog(this, message + " " + iae.getMessage(), "", 0);
        }
        return datCats;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getSource() == this.profList) {
            if (!e.getValueIsAdjusting()) {
                this.langCombo.removeActionListener(this);
                this.langCombo.removeAllItems();
                this.langCombo.addItem("-");
                this.langCombo.addActionListener(this);
                this.nameValueLabel.setText("-");
                this.descArea.setText("");
                if (this.profList.getSelectedIndex() > -1) {
                    Profile profile = (Profile)this.profList.getSelectedValue();
                    this.setCursor(this.BUSY_CURSOR);
                    this.updateCategories(this.getDataCategories(profile));
                    this.setCursor(this.DEFAULT_CURSOR);
                } else {
                    this.updateCategories(new ArrayList<DCSmall>());
                }
            }
        } else {
            super.valueChanged(e);
        }
    }
}

