/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator;

import java.awt.EventQueue;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import mpi.eudico.client.annotator.ElanFrame2;
import mpi.eudico.client.annotator.commands.global.NewMA;
import mpi.eudico.client.annotator.commands.global.OpenMA;
import mpi.eudico.client.annotator.turnsandscenemode.TaSFrame;
import mpi.eudico.client.annotator.turnsandscenemode.commands.NewTaSMA;
import mpi.eudico.client.annotator.turnsandscenemode.commands.OpenTaSMA;
import mpi.eudico.client.annotator.util.ClientLogger;

public class ELANDropTargetListener
implements DropTargetListener {
    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        if (!dtde.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            dtde.rejectDrag();
        } else {
            dtde.acceptDrag(0x40000000);
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        if (dtde.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            for (DataFlavor df : dtde.getCurrentDataFlavors()) {
                if (!df.isFlavorJavaFileListType()) continue;
                dtde.acceptDrop(0x40000000);
                try {
                    Transferable transferable = dtde.getTransferable();
                    List allFiles = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                    File eafFile = null;
                    for (File f : allFiles) {
                        if (!f.getName().toLowerCase().endsWith(".eaf")) continue;
                        eafFile = f;
                        break;
                    }
                    Window frame = SwingUtilities.getWindowAncestor(((DropTarget)dtde.getSource()).getComponent());
                    if (eafFile != null) {
                        if (frame instanceof TaSFrame) {
                            OpenTaSMA openTasAction = new OpenTaSMA("Open TaS Frame", (TaSFrame)frame);
                            this.openFrameLater(openTasAction, eafFile.getAbsolutePath());
                        } else if (frame instanceof ElanFrame2) {
                            OpenMA openTransAction = new OpenMA("Open ElanFrame", (ElanFrame2)frame);
                            this.openFrameLater(openTransAction, eafFile.getAbsolutePath());
                        }
                        dtde.dropComplete(true);
                        return;
                    }
                    ArrayList<String> fileNames = new ArrayList<String>(allFiles.size());
                    for (File f : allFiles) {
                        fileNames.add(f.getAbsolutePath());
                    }
                    if (frame instanceof TaSFrame) {
                        NewTaSMA tasAction = new NewTaSMA("New TaS Frame", (TaSFrame)frame);
                        this.createNewFrameLater(tasAction, fileNames);
                    } else if (frame instanceof ElanFrame2) {
                        NewMA nextTransAction = new NewMA("New ElanFrame", (ElanFrame2)frame);
                        this.createNewFrameLater(nextTransAction, fileNames);
                    }
                    dtde.dropComplete(true);
                }
                catch (UnsupportedFlavorException ufe) {
                    ClientLogger.LOG.warning("Unable to handle the dropped data: " + ufe.getMessage());
                    dtde.dropComplete(false);
                }
                catch (IOException ioe) {
                    ClientLogger.LOG.warning("Unable to handle the dropped data: " + ioe.getMessage());
                    dtde.dropComplete(false);
                }
                catch (Throwable t) {
                    ClientLogger.LOG.warning("Unable to handle the dropped data: " + t.getMessage());
                    dtde.dropComplete(false);
                }
            }
        }
    }

    private void createNewFrameLater(final NewMA createAction, final List<String> mediaFiles) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                createAction.createNewFile(mediaFiles);
            }
        });
    }

    private void openFrameLater(final OpenMA openAction, final String filePath) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                openAction.createFrameForPath(filePath);
            }
        });
    }
}

