/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanFrame2;
import mpi.eudico.client.annotator.FrameManager;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.client.annotator.util.SystemReporting;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import nl.mpi.util.FileUtility;

public class ELANPL {
    public static int major = 3;
    public static int minor = 9;
    public static int micro = 1;

    private ELANPL() {
    }

    public static void main(String[] args) {
        List<File> files;
        ClientLogger.LOG.info("ELAN Playlist Player" + ELANPL.getVersionString());
        ClientLogger.LOG.info("Java version: " + System.getProperty("java.version"));
        ClientLogger.LOG.info("Runtime version: " + System.getProperty("java.runtime.version"));
        ClientLogger.LOG.info("OS name: " + System.getProperty("os.name"));
        ClientLogger.LOG.info("OS version: " + System.getProperty("os.version"));
        ClientLogger.LOG.info("User language: " + System.getProperty("user.language"));
        ClientLogger.LOG.info("User home: " + System.getProperty("user.home"));
        ClientLogger.LOG.info("User dir: " + System.getProperty("user.dir"));
        ClientLogger.LOG.info("Classpath: " + System.getProperty("java.class.path"));
        try {
            Object val;
            if (System.getProperty("os.name").indexOf("Mac OS") > -1) {
                boolean macLF;
                File dataFolder = new File(Constants.ELAN_DATA_DIR);
                if (!dataFolder.exists()) {
                    dataFolder.mkdir();
                    File oldDataFolder = new File(Constants.USERHOME + Constants.FILESEPARATOR + ".elan_data");
                    if (oldDataFolder.exists()) {
                        File[] files2 = oldDataFolder.listFiles();
                        File inFile = null;
                        File outFile = null;
                        for (int i = 0; i < files2.length; ++i) {
                            inFile = files2[i];
                            if (!inFile.isFile()) continue;
                            outFile = new File(dataFolder.getAbsolutePath() + Constants.FILESEPARATOR + inFile.getName());
                            FileUtility.copyToFile(inFile, outFile);
                        }
                    }
                }
                boolean screenBar = false;
                Object val2 = Preferences.get("OS.Mac.useScreenMenuBar", null);
                if (val2 instanceof Boolean) {
                    screenBar = (Boolean)val2;
                    System.setProperty("apple.laf.useScreenMenuBar", String.valueOf(screenBar));
                }
                if (!screenBar && (val2 = Preferences.get("UseMacLF", null)) instanceof Boolean && !(macLF = ((Boolean)val2).booleanValue())) {
                    try {
                        UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
                        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (System.getProperty("PreferredMediaFramework") == null && (val2 = Preferences.get("Mac.PrefMediaFramework", null)) instanceof String) {
                    System.setProperty("PreferredMediaFramework", (String)val2);
                }
            } else if (SystemReporting.isWindows() && System.getProperty("PreferredMediaFramework") == null && (val = Preferences.get("Windows.PrefMediaFramework", null)) instanceof String) {
                System.setProperty("PreferredMediaFramework", (String)val);
            }
            File dataDir = new File(Constants.ELAN_DATA_DIR);
            if (!dataDir.exists()) {
                dataDir.mkdir();
            }
            File oldCrap = new File(Constants.STRPROPERTIESFILE);
            oldCrap.delete();
            oldCrap = new File(Constants.USERHOME + Constants.FILESEPARATOR + ".elan.pfs");
            oldCrap.delete();
        }
        catch (Exception ex) {
            ClientLogger.LOG.warning("Could not create ELAN's data directory: " + ex.getMessage());
        }
        FrameManager.getInstance().setExitAllowed(true);
        Object plFileName = System.getProperty("user.dir") + File.separator + "ELAN_Playlist.txt";
        if (args != null && args.length > 0 && args[0].length() != 0) {
            plFileName = args[0];
        }
        if ((files = ELANPL.loadPlaylist((String)plFileName)) == null || files.size() == 0) {
            ClientLogger.LOG.severe("No playlist or no files in the playlist, exiting");
            System.exit(1);
        }
        ELANPL.startLoop(files);
        ClientLogger.LOG.info("Ended play loop, exiting...");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<File> loadPlaylist(String file) {
        if (file == null) {
            return null;
        }
        ArrayList<File> files = new ArrayList<File>(10);
        BufferedReader bufRead = null;
        try {
            File pl = new File(file);
            if (pl.exists() && pl.isFile() && pl.canRead()) {
                bufRead = new BufferedReader(new FileReader(pl));
                String line = null;
                while ((line = bufRead.readLine()) != null) {
                    if (line.length() <= 0 || line.startsWith("#")) continue;
                    try {
                        File f = new File(line);
                        if (f.exists() && f.canRead()) {
                            files.add(f);
                            continue;
                        }
                        ClientLogger.LOG.warning("The eaf file does not exist or cannot be read: " + line);
                    }
                    catch (Exception ee) {
                        ClientLogger.LOG.warning("Could not find or load eaf file: " + line);
                    }
                }
            } else {
                ClientLogger.LOG.severe("Could not find or load the playlist file: " + file);
            }
        }
        catch (Exception ioe) {
            ClientLogger.LOG.severe("Could not find or load the playlist file: " + file);
        }
        finally {
            try {
                bufRead.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return files;
    }

    private static void startLoop(List<File> files) {
        if (files == null || files.size() == 0) {
            return;
        }
        int index = 0;
        ElanFrame2 oldActive = null;
        ElanFrame2 curActive = null;
        while (true) {
            File cur = files.get(index);
            TranscriptionImpl curTranscription = new TranscriptionImpl(cur.getAbsolutePath());
            curTranscription.setUnchanged();
            curActive = new ElanFrame2(cur.getAbsolutePath());
            if (oldActive != null) {
                if (oldActive.getViewerManager().getTranscription() != null) {
                    oldActive.getViewerManager().getTranscription().setUnchanged();
                }
                oldActive.doClose(false);
            }
            while (!curActive.isFullyInitialized()) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
            curActive.getViewerManager().getMasterMediaPlayer().start();
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            while (curActive.getViewerManager().getMasterMediaPlayer().isPlaying() || curActive.getViewerManager().getMasterMediaPlayer().getMediaDuration() - curActive.getViewerManager().getMasterMediaPlayer().getMediaTime() > 500L) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (++index == files.size()) {
                index = 0;
            }
            oldActive = curActive;
        }
    }

    public static String getVersionString() {
        return major + "." + minor + "." + micro;
    }
}

