/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ELAN;
import mpi.eudico.client.annotator.ELANDropTargetListener;
import mpi.eudico.client.annotator.ElanLayoutManager;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.ElanLocaleListener;
import mpi.eudico.client.annotator.FrameManager;
import mpi.eudico.client.annotator.PlayerViewerMenuManager;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.PreferencesUser;
import mpi.eudico.client.annotator.SaveAs27Preferences;
import mpi.eudico.client.annotator.ViewerManager2;
import mpi.eudico.client.annotator.WaveFormViewerMenuManager;
import mpi.eudico.client.annotator.commands.BackupCA;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.commands.PlayAroundSelectionCA;
import mpi.eudico.client.annotator.commands.PlaybackRateToggleCA;
import mpi.eudico.client.annotator.commands.PlaybackVolumeToggleCA;
import mpi.eudico.client.annotator.commands.RedoCA;
import mpi.eudico.client.annotator.commands.ShortcutsUtil;
import mpi.eudico.client.annotator.commands.StoreCommand;
import mpi.eudico.client.annotator.commands.UndoCA;
import mpi.eudico.client.annotator.commands.global.AboutMA;
import mpi.eudico.client.annotator.commands.global.ActivityMonitoringMA;
import mpi.eudico.client.annotator.commands.global.AnnotatorCompareMA;
import mpi.eudico.client.annotator.commands.global.ClipMediaMultiMA;
import mpi.eudico.client.annotator.commands.global.CreateSignalViewerMA;
import mpi.eudico.client.annotator.commands.global.CreateViewerMA;
import mpi.eudico.client.annotator.commands.global.EditLanguagesMA;
import mpi.eudico.client.annotator.commands.global.EditPreferencesMA;
import mpi.eudico.client.annotator.commands.global.EditShortcutsMA;
import mpi.eudico.client.annotator.commands.global.EditSpellCheckerMA;
import mpi.eudico.client.annotator.commands.global.EditTierSetMA;
import mpi.eudico.client.annotator.commands.global.ExitMA;
import mpi.eudico.client.annotator.commands.global.ExportAnnotationsMultiMA;
import mpi.eudico.client.annotator.commands.global.ExportFlexMultiMA;
import mpi.eudico.client.annotator.commands.global.ExportOverlapsMultiMA;
import mpi.eudico.client.annotator.commands.global.ExportPraatMultiMA;
import mpi.eudico.client.annotator.commands.global.ExportTabMultiMA;
import mpi.eudico.client.annotator.commands.global.ExportThemeMultiMA;
import mpi.eudico.client.annotator.commands.global.ExportTiersMA;
import mpi.eudico.client.annotator.commands.global.ExportToolBoxMultiMA;
import mpi.eudico.client.annotator.commands.global.ExportWordsMultiMA;
import mpi.eudico.client.annotator.commands.global.FASTSearchMA;
import mpi.eudico.client.annotator.commands.global.FontBrowserMA;
import mpi.eudico.client.annotator.commands.global.HelpMA;
import mpi.eudico.client.annotator.commands.global.ImportCHATMA;
import mpi.eudico.client.annotator.commands.global.ImportDelimitedTextMA;
import mpi.eudico.client.annotator.commands.global.ImportFlexMA;
import mpi.eudico.client.annotator.commands.global.ImportFlexMultiMA;
import mpi.eudico.client.annotator.commands.global.ImportJSONMA;
import mpi.eudico.client.annotator.commands.global.ImportPraatMA;
import mpi.eudico.client.annotator.commands.global.ImportPraatMultiMA;
import mpi.eudico.client.annotator.commands.global.ImportRecognizerTiersMA;
import mpi.eudico.client.annotator.commands.global.ImportShoeboxMA;
import mpi.eudico.client.annotator.commands.global.ImportSubtitleTextMA;
import mpi.eudico.client.annotator.commands.global.ImportToolboxMA;
import mpi.eudico.client.annotator.commands.global.ImportToolboxMultiMA;
import mpi.eudico.client.annotator.commands.global.ImportTranscriberMA;
import mpi.eudico.client.annotator.commands.global.MenuAction;
import mpi.eudico.client.annotator.commands.global.MergeTranscriptionsMA;
import mpi.eudico.client.annotator.commands.global.MultiEAFCreationMA;
import mpi.eudico.client.annotator.commands.global.MultiEAFScrubberMA;
import mpi.eudico.client.annotator.commands.global.MultiFileAnnotationsFromOverlapsMA;
import mpi.eudico.client.annotator.commands.global.MultiFileAnnotationsFromSubtractionMA;
import mpi.eudico.client.annotator.commands.global.MultiFindReplaceMA;
import mpi.eudico.client.annotator.commands.global.MultipleFileMergeTiersMA;
import mpi.eudico.client.annotator.commands.global.MultipleFileUpdateWithTemplateMA;
import mpi.eudico.client.annotator.commands.global.MultipleFilesEditMA;
import mpi.eudico.client.annotator.commands.global.NewMA;
import mpi.eudico.client.annotator.commands.global.NextWindowMA;
import mpi.eudico.client.annotator.commands.global.NgramStatisticsMA;
import mpi.eudico.client.annotator.commands.global.OpenMA;
import mpi.eudico.client.annotator.commands.global.OpenRemoteMA;
import mpi.eudico.client.annotator.commands.global.PrevWindowMA;
import mpi.eudico.client.annotator.commands.global.SearchMultipleMA;
import mpi.eudico.client.annotator.commands.global.SetLocaleMA;
import mpi.eudico.client.annotator.commands.global.SetPlayAroundSelectionMA;
import mpi.eudico.client.annotator.commands.global.SetPlaybackToggleMA;
import mpi.eudico.client.annotator.commands.global.ShortcutsMA;
import mpi.eudico.client.annotator.commands.global.ShowLogMA;
import mpi.eudico.client.annotator.commands.global.StatisticsMultipleFilesMA;
import mpi.eudico.client.annotator.commands.global.StructuredSearchMultipleMA;
import mpi.eudico.client.annotator.commands.global.UpdateElanMA;
import mpi.eudico.client.annotator.commands.global.UpdateMultiForECVMA;
import mpi.eudico.client.annotator.commands.global.ValidateEAFMA;
import mpi.eudico.client.annotator.commands.global.WebMA;
import mpi.eudico.client.annotator.gui.ElanMenuItem;
import mpi.eudico.client.annotator.gui.FileChooser;
import mpi.eudico.client.annotator.linkedmedia.LinkedFileDescriptorUtil;
import mpi.eudico.client.annotator.linkedmedia.MediaDescriptorUtil;
import mpi.eudico.client.annotator.prefs.gui.RecentLanguagesMenuItem;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.client.annotator.util.FrameConstants;
import mpi.eudico.client.annotator.util.MonitoringLogger;
import mpi.eudico.client.annotator.util.SystemReporting;
import mpi.eudico.client.util.TranscriptionECVLoader;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clom.TranscriptionStore;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.dobes.ACMTranscriptionStore;
import mpi.eudico.server.corpora.clomimpl.util.MediaDescriptorUtility;
import mpi.eudico.util.CVEntry;
import mpi.eudico.util.ControlledVocabulary;
import nl.mpi.util.FileExtension;
import nl.mpi.util.FileUtility;

public class ElanFrame2
extends JFrame
implements ActionListener,
ElanLocaleListener,
FrameConstants,
PreferencesUser {
    protected Map<String, MenuAction> menuActions = new HashMap<String, MenuAction>();
    protected Map<Object, Action> registeredActions = new HashMap<Object, Action>();
    protected boolean initialized = false;
    public final int WINDOW_POS_MARGIN = 30;
    protected String applicationName = "ELAN " + ELAN.getVersionString();
    protected Transcription transcriptionForThisFrame;
    protected JMenuBar menuBar;
    protected JMenu menuFile;
    protected JMenuItem menuItemFileNew;
    protected JMenuItem menuItemFileOpen;
    protected JMenu menuRecentFiles;
    protected JMenuItem menuItemFileExit;
    protected JMenu menuBackup;
    protected JMenu menuImport;
    protected JMenu menuExport;
    protected JMenu menuExportSMIL;
    protected JMenuItem menuItemShoeboxImport;
    protected JMenuItem menuItemCHATImport;
    protected JMenuItem menuItemTranscriberImport;
    protected JMenu menuEdit;
    private JMenu menuPreferences;
    private ElanMenuItem setAuthorMI;
    private ElanMenuItem setDocumentPropertiesMI;
    private ElanMenuItem viewDocumentInfoMI;
    private ElanMenuItem viewAnnotationDensityPlotMI;
    private ElanMenuItem viewAudioSpectrogramMI;
    private JMenu menuAnnotation;
    private JMenu menuTier;
    private JMenu menuType;
    private JMenu menuWindow;
    private ButtonGroup windowsGroup;
    private ButtonGroup waveFormGroup;
    private JMenu menuSearch;
    private JMenu menuView;
    private JMenu menuViewer;
    private JMenu menuOptions;
    private JCheckBoxMenuItem menuItemNativeMedia;
    private JRadioButtonMenuItem menuItemAnnoMode;
    private JRadioButtonMenuItem menuItemSyncMode;
    private JRadioButtonMenuItem menuItemTranscMode;
    private JRadioButtonMenuItem menuItemSegmentMode;
    private JRadioButtonMenuItem menuItemInterLinearMode;
    private JCheckBoxMenuItem menuItemKioskMode;
    private JMenuItem menuItemPlayAround;
    private JMenuItem menuItemRateVol;
    protected JMenu menuHelp;
    private JMenu menuFrameLength;
    private JMenu menuAppLanguage;
    private ButtonGroup languageBG;
    private JMenu menuChangeTimePropMode;
    private JMenuItem menuItemScrubTrans;
    private JMenu menuMediaPlayer;
    private JMenu menuWaveform;
    protected ElanLayoutManager layoutManager;
    protected ViewerManager2 viewerManager;
    private PlayerViewerMenuManager pvMenuManager;
    private WaveFormViewerMenuManager wfvMenuManager;
    protected boolean fullyInitialized = false;
    protected ElanMenuItem closeMI;
    protected ElanMenuItem saveMI;
    protected ElanMenuItem saveAsMI;
    private ElanMenuItem saveAsTemplateMI;
    private ElanMenuItem saveSelEafMI;
    private ElanMenuItem saveAs2_7MI;
    private ElanMenuItem mergeTransMI;
    private ElanMenuItem pageSetUpMI;
    private ElanMenuItem printPreviewMI;
    private ElanMenuItem printMI;
    protected ElanMenuItem undoMI;
    protected ElanMenuItem redoMI;
    private ElanMenuItem editCVMI;
    private ElanMenuItem editLangListMI;
    private ElanMenuItem editTierSetMI;
    private ElanMenuItem linkedFilesMI;
    private ElanMenuItem importPrefsMI;
    private ElanMenuItem exportPrefsMI;
    private ElanMenuItem searchMI;
    private ElanMenuItem goToMI;
    private ElanMenuItem tierDependenciesMI;
    private ElanMenuItem spreadsheetMI;
    private ElanMenuItem statisticsMI;
    private ElanMenuItem importPraatMI;
    private ElanMenuItem importDelimitedTextMI;
    private ElanMenuItem importSubtitleTextMI;
    private ElanMenuItem importRecogTiersMI;
    private ElanMenuItem editLexiconServiceMI;
    private ElanMenuItem copyCurrentTimeCodeMI;
    private ElanMenuItem compareAnnotatorsMI;
    private JCheckBoxMenuItem menuItemGridViewer;
    private JCheckBoxMenuItem menuItemTextViewer;
    private JCheckBoxMenuItem menuItemSubtitleViewer;
    private JCheckBoxMenuItem menuItemLexiconViewer;
    private JCheckBoxMenuItem menuItemCommentViewer;
    private JCheckBoxMenuItem menuItemRecognizer;
    private JCheckBoxMenuItem menuItemMetaDataViewer;
    private JCheckBoxMenuItem menuItemSignalViewer;
    private JCheckBoxMenuItem menuItemSpectrogramViewer;
    private JCheckBoxMenuItem menuItemInterLinearViewer;
    private JCheckBoxMenuItem menuItemTimeSeriesViewer;
    private JMenu menuWebservices;
    private RecentLanguagesMenuItem recentLanguagesMenuItem;

    public ElanFrame2() {
        this.setTitle(this.applicationName);
        this.setFrameIcon();
        this.initFrame();
        this.createDnDTarget();
    }

    public ElanFrame2(final String path) {
        this();
        if (path != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ElanFrame2.this.openEAF(path);
                }
            });
        }
    }

    public ElanFrame2(final String eafPath, final List<String> mediaFiles) {
        this();
        if (eafPath != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ElanFrame2.this.openEAF(eafPath, mediaFiles);
                }
            });
        }
    }

    public ElanFrame2(Transcription transcription) {
        this();
        this.transcriptionForThisFrame = transcription;
        if (this.transcriptionForThisFrame != null) {
            try {
                this.initElan();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private boolean isMediaFile(String file) {
        for (String element : FileExtension.MISC_VIDEO_EXT) {
            if (!file.endsWith(element)) continue;
            return true;
        }
        for (String element : FileExtension.MPEG_EXT) {
            if (!file.endsWith(element)) continue;
            return true;
        }
        for (String element : FileExtension.WAV_EXT) {
            if (!file.endsWith(element)) continue;
            return true;
        }
        for (String element : FileExtension.MISC_AUDIO_EXT) {
            if (!file.endsWith(element)) continue;
            return true;
        }
        return false;
    }

    void openEAF(String fullPath, List<String> mediaFiles) {
        Object strMessage;
        boolean isRemote = FileUtility.isRemoteFile(fullPath);
        String lowerPath = null;
        File fileTemp = null;
        if (!isRemote) {
            fileTemp = new File(fullPath);
            if (!fileTemp.exists() || fileTemp.isDirectory()) {
                Object strMessage2 = ElanLocale.getString("Menu.Dialog.Message1");
                strMessage2 = (String)strMessage2 + fullPath;
                strMessage2 = (String)strMessage2 + ElanLocale.getString("Menu.Dialog.Message2");
                String strError = ElanLocale.getString("Message.Error");
                JOptionPane.showMessageDialog(this, strMessage2, strError, 0);
                return;
            }
            lowerPath = fileTemp.toString().toLowerCase();
        } else {
            lowerPath = fullPath.toLowerCase();
        }
        if (this.isMediaFile(lowerPath)) {
            String strWarning;
            strMessage = fullPath;
            int i = JOptionPane.showOptionDialog(this, strMessage = (String)strMessage + ElanLocale.getString("Menu.Dialog.Message4"), strWarning = ElanLocale.getString("Message.Warning"), 0, 2, null, null, null);
            if (i == 0) {
                if (this.menuItemFileNew.getAction() instanceof NewMA) {
                    ArrayList<String> v = new ArrayList<String>();
                    v.add(fullPath);
                    ((NewMA)this.menuItemFileNew.getAction()).createNewFile(v);
                }
                return;
            }
        }
        if (!lowerPath.endsWith(".eaf") && !lowerPath.endsWith(".etf")) {
            strMessage = ElanLocale.getString("Menu.Dialog.Message1");
            strMessage = (String)strMessage + fullPath;
            strMessage = (String)strMessage + ElanLocale.getString("Menu.Dialog.Message3");
            String strError = ElanLocale.getString("Message.Error");
            JOptionPane.showMessageDialog(this, strMessage, strError, 0);
            return;
        }
        try {
            String pref;
            TranscriptionImpl transcription = null;
            String path = null;
            if (!isRemote) {
                path = fileTemp.getAbsolutePath();
                path = path.replace('\\', '/');
                transcription = new TranscriptionImpl(new File(path).getAbsolutePath());
            } else {
                transcription = new TranscriptionImpl(fullPath);
                path = fullPath;
            }
            transcription.setUnchanged();
            SaveAs27Preferences.adjustPreferencesAfterLoadingFormat(transcription);
            if (lowerPath.endsWith(".etf")) {
                transcription.setName("aishug294879ryshfda9763afo8947a5gf");
                transcription.setPathName("aishug294879ryshfda9763afo8947a5gf");
                transcription.setChanged();
                if (!isRemote) {
                    String prefPath = path.substring(0, path.length() - 3) + "pfsx";
                    try {
                        File pFile = new File(prefPath);
                        if (pFile.exists()) {
                            Preferences.importPreferences((Transcription)transcription, prefPath);
                        }
                    }
                    catch (Exception pFile) {
                        // empty catch block
                    }
                }
            }
            if ((pref = Preferences.getString("DefaultControlledVocabularyLanguage", null)) != null) {
                transcription.updateCVLanguage(pref, false);
            }
            if (transcription.getControlledVocabularies().size() > 0) {
                new TranscriptionECVLoader().loadExternalCVs(transcription, this);
            }
            if (mediaFiles != null) {
                List<MediaDescriptor> descriptors = MediaDescriptorUtility.createMediaDescriptors(mediaFiles);
                transcription.setMediaDescriptors(descriptors);
                transcription.setChanged();
            }
            String eafPath = FileUtility.directoryFromPath(path);
            boolean validMedia = this.checkMedia(transcription, eafPath);
            if (this.transcriptionForThisFrame != null) {
                FrameManager.getInstance().createFrame(transcription);
            } else {
                this.transcriptionForThisFrame = transcription;
                this.initElan();
                FrameManager.getInstance().updateFrameTitle(this, transcription.getPathName());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void openEAF(String fullPath) {
        this.openEAF(fullPath, null);
    }

    protected void setTranscription(Transcription transcription) {
        if (this.transcriptionForThisFrame != null || !(transcription instanceof TranscriptionImpl)) {
            return;
        }
        this.transcriptionForThisFrame = transcription;
        this.initElan();
    }

    public ViewerManager2 getViewerManager() {
        return this.viewerManager;
    }

    public ElanLayoutManager getLayoutManager() {
        return this.layoutManager;
    }

    private void setProxyIcon() {
        if (SystemReporting.isMacOS()) {
            File f = null;
            String fileName = this.transcriptionForThisFrame.getFullPath();
            if (fileName != null && !"aishug294879ryshfda9763afo8947a5gf".equals(this.transcriptionForThisFrame.getName())) {
                fileName = FileUtility.urlToAbsPath(fileName);
                f = new File(fileName);
            }
            this.getRootPane().putClientProperty("Window.documentFile", f);
        }
    }

    protected void setFrameIcon() {
        ImageIcon icon = new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/ELAN16.png"));
        this.setIconImage(icon.getImage());
    }

    public boolean checkMedia(Transcription transcription, String eafFolderPath) {
        boolean validMedia = true;
        boolean saveChangedMedia = true;
        Boolean boolPref = Preferences.getBool("MediaLocation.AltLocationSetsChanged", null);
        if (boolPref != null) {
            saveChangedMedia = boolPref;
        }
        String fullEAFURL = FileUtility.pathToURLString(transcription.getFullPath());
        try {
            List<MediaDescriptor> mediaDescriptors = transcription.getMediaDescriptors();
            block2: for (int i = 0; i < mediaDescriptors.size(); ++i) {
                String absolutePath;
                String[] mainExt;
                MediaDescriptor md = mediaDescriptors.get(i);
                if (FileUtility.isRemoteFile(md.mediaURL)) continue;
                int colonPos = md.mediaURL.indexOf(58);
                String fileName = md.mediaURL.substring(colonPos + 1);
                File file = new File(fileName = fileName.replace('\\', '/'));
                if (file.exists()) continue;
                String localFileName = FileUtility.fileNameFromPath(fileName);
                file = new File(eafFolderPath + "/" + localFileName);
                if (file.exists()) {
                    this.adjustMediaDescriptors(mediaDescriptors, i, file.getAbsolutePath());
                    ClientLogger.LOG.info("Updated file location from: \"" + fileName + "\" to: \"" + file.getAbsolutePath() + "\", in same directory as transcription file");
                    if (!saveChangedMedia) continue;
                    transcription.setChanged();
                    continue;
                }
                if (md.relativeMediaURL != null) {
                    String absPath;
                    String relUrl = md.relativeMediaURL;
                    if (relUrl.startsWith("file:/")) {
                        relUrl = relUrl.substring(6);
                    }
                    if ((absPath = FileUtility.getAbsolutePath(fullEAFURL, relUrl)) != null && (file = new File(absPath)).exists()) {
                        this.adjustMediaDescriptors(mediaDescriptors, i, file.getAbsolutePath());
                        ClientLogger.LOG.info("Updated file location from: \"" + fileName + "\" to: \"" + file.getAbsolutePath() + "\", by resolving relative path");
                        if (!saveChangedMedia) continue;
                        transcription.setChanged();
                        continue;
                    }
                }
                if ((file = new File(eafFolderPath + "/../Media/" + localFileName)).exists()) {
                    this.adjustMediaDescriptors(mediaDescriptors, i, file.getAbsolutePath());
                    ClientLogger.LOG.info("Updated file location from: \"" + fileName + "\" to: \"" + file.getAbsolutePath() + "\", in Media subdirectory");
                    if (!saveChangedMedia) continue;
                    transcription.setChanged();
                    continue;
                }
                file = new File(eafFolderPath + "/../media/" + localFileName);
                if (file.exists()) {
                    this.adjustMediaDescriptors(mediaDescriptors, i, file.getAbsolutePath());
                    ClientLogger.LOG.info("Updated file location from: \"" + fileName + "\" to: \"" + file.getAbsolutePath() + "\", in media subdirectory");
                    if (!saveChangedMedia) continue;
                    transcription.setChanged();
                    continue;
                }
                String stringPref = Preferences.getString("DefaultMediaLocation", null);
                if (stringPref != null && (file = new File(FileUtility.urlToAbsPath(stringPref) + "/" + localFileName)).exists()) {
                    this.adjustMediaDescriptors(mediaDescriptors, i, file.getAbsolutePath());
                    ClientLogger.LOG.info("Updated file location from: \"" + fileName + "\" to: \"" + file.getAbsolutePath() + "\", in preferred media location");
                    if (!saveChangedMedia) continue;
                    transcription.setChanged();
                    continue;
                }
                String lastUsedDir = Preferences.getString("MediaDir", null);
                if (lastUsedDir != null && (file = new File(lastUsedDir + "/" + localFileName)).exists()) {
                    this.adjustMediaDescriptors(mediaDescriptors, i, file.getAbsolutePath());
                    ClientLogger.LOG.info("Updated file location from: \"" + fileName + "\" to: \"" + file.getAbsolutePath() + "\", in last used media location");
                    if (!saveChangedMedia) continue;
                    transcription.setChanged();
                    continue;
                }
                if (FileUtility.isRemoteFile(fullEAFURL)) {
                    String mediaUrl;
                    if (md.relativeMediaURL != null) {
                        String absPath;
                        String relUrl = md.relativeMediaURL;
                        if (relUrl.startsWith("file:/")) {
                            relUrl = relUrl.substring(6);
                        }
                        if (FileUtility.remoteFileExists(absPath = FileUtility.getAbsolutePath(fullEAFURL, relUrl))) {
                            this.adjustMediaDescriptors(mediaDescriptors, i, absPath);
                            ClientLogger.LOG.info("Updated file location from: \"" + fileName + "\" to: \"" + absPath + "\", in last used media location");
                            if (!saveChangedMedia) continue;
                            transcription.setChanged();
                            continue;
                        }
                    }
                    if (FileUtility.remoteFileExists(mediaUrl = eafFolderPath + "/" + localFileName)) {
                        this.adjustMediaDescriptors(mediaDescriptors, i, mediaUrl);
                        ClientLogger.LOG.info("Updated file location from: \"" + fileName + "\" to: \"" + mediaUrl + "\", in last used media location");
                        if (!saveChangedMedia) continue;
                        transcription.setChanged();
                        continue;
                    }
                }
                FileChooser chooser = new FileChooser(this);
                ArrayList<String[]> extensions = new ArrayList<String[]>();
                if (md.mimeType.equals("audio/x-wav")) {
                    mainExt = FileExtension.WAV_EXT;
                } else if (md.mimeType.equals("video/mpeg")) {
                    mainExt = FileExtension.MPEG_EXT;
                } else if (md.mimeType.equals("video/mp4")) {
                    mainExt = FileExtension.MPEG4_EXT;
                } else if (md.mimeType.equals("video/quicktime")) {
                    mainExt = FileExtension.QT_EXT;
                } else {
                    extensions.add(FileExtension.MEDIA_EXT);
                    extensions.add(FileExtension.MPEG_EXT);
                    extensions.add(FileExtension.WAV_EXT);
                    extensions.add(FileExtension.MPEG4_EXT);
                    extensions.add(FileExtension.QT_EXT);
                    mainExt = null;
                }
                do {
                    chooser.createAndShowFileDialog(ElanLocale.getString("Frame.ElanFrame.LocateMedia") + ": " + localFileName, 0, null, extensions, mainExt, true, "MediaDir", 0, file.getName());
                    if (chooser.getSelectedFile() != null) continue;
                    md.isValid = false;
                    validMedia = false;
                    continue block2;
                } while (this.linkingTheSameMediaTwice(mediaDescriptors, absolutePath = chooser.getSelectedFile().getAbsolutePath()) || !this.plausiblyTheSameFile(localFileName, absolutePath));
                this.adjustMediaDescriptors(mediaDescriptors, i, absolutePath);
                transcription.setChanged();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return validMedia;
    }

    private boolean linkingTheSameMediaTwice(List<MediaDescriptor> mediaDescriptors, String absolutePath) {
        String newURL = FileUtility.pathToURLString(absolutePath);
        for (MediaDescriptor md : mediaDescriptors) {
            if (!md.mediaURL.equals(newURL)) continue;
            JOptionPane.showMessageDialog(this, ElanLocale.getString("LinkedFilesDialog.Message.AlreadyLinked"), ElanLocale.getString("Message.Warning"), 0);
            return true;
        }
        return false;
    }

    private boolean plausiblyTheSameFile(String original, String replacement) {
        String e2;
        String e1;
        String fn2;
        String fn1 = FileUtility.fileNameFromPath(original);
        if (!FileUtility.sameNameIgnoreExtension(fn1, fn2 = FileUtility.fileNameFromPath(replacement))) {
            String fmt = ElanLocale.getString("Frame.ElanFrame.FileNamesDiffer");
            String text = String.format(fmt, fn1, fn2);
            boolean ok = this.showConfirmDialog(text);
            if (!ok) {
                return false;
            }
        }
        if (!(e1 = FileUtility.getExtension(fn1, "")).equals(e2 = FileUtility.getExtension(fn2, ""))) {
            String fmt = ElanLocale.getString("Frame.ElanFrame.FileExtensionsDiffer");
            String text = String.format(fmt, e1, e2);
            boolean ok = this.showConfirmDialog(text);
            return ok;
        }
        return true;
    }

    private boolean showConfirmDialog(String question) {
        int answer = JOptionPane.showConfirmDialog(this, question, ElanLocale.getString("Frame.ElanFrame.IncompleteMediaAvailable"), 0);
        return answer == 0;
    }

    private void adjustMediaDescriptors(List<MediaDescriptor> mediaDescriptors, int index, String newPath) {
        String oldURL = mediaDescriptors.get((int)index).mediaURL;
        String newURL = FileUtility.pathToURLString(newPath);
        String newExt = null;
        if (newURL.indexOf(46) > -1) {
            newExt = newURL.substring(newURL.lastIndexOf(46) + 1);
        }
        mediaDescriptors.get((int)index).mediaURL = newURL;
        mediaDescriptors.get((int)index).mimeType = MediaDescriptorUtility.mimeTypeForExtension(newExt);
        for (int i = 0; i < mediaDescriptors.size(); ++i) {
            String extractedFrom = mediaDescriptors.get((int)i).extractedFrom;
            if (!oldURL.equals(extractedFrom)) continue;
            mediaDescriptors.get((int)i).extractedFrom = newURL;
        }
    }

    protected void initElan() {
        if (MonitoringLogger.isInitiated()) {
            MonitoringLogger.getLogger(null).log(MonitoringLogger.OPEN_FILE, this.transcriptionForThisFrame.getName());
            MonitoringLogger.getLogger(this.transcriptionForThisFrame).log(MonitoringLogger.OPEN_FILE, new String[0]);
        }
        this.setTitle("Initializing....");
        this.loadCVPreferences();
        this.viewerManager = new ViewerManager2((TranscriptionImpl)this.transcriptionForThisFrame);
        this.layoutManager = new ElanLayoutManager(this, this.viewerManager);
        ELANCommandFactory.addDocument(this, this.viewerManager, this.layoutManager);
        this.pvMenuManager = new PlayerViewerMenuManager(this, this.transcriptionForThisFrame);
        MediaDescriptorUtil.createMediaPlayers((TranscriptionImpl)this.transcriptionForThisFrame, this.pvMenuManager.getStoredVisiblePlayers());
        this.wfvMenuManager = new WaveFormViewerMenuManager(this, this.transcriptionForThisFrame);
        ArrayList<String> audioPaths = new ArrayList<String>(4);
        if (this.layoutManager.getSignalViewer() != null) {
            audioPaths.add(this.layoutManager.getSignalViewer().getMediaPath());
        }
        if (!this.menuItemSignalViewer.isSelected()) {
            if (this.layoutManager.getSignalViewer() != null) {
                this.layoutManager.remove(this.layoutManager.getSignalViewer());
            }
            this.menuWaveform.setEnabled(false);
        }
        ArrayList<String> videoPaths = new ArrayList<String>(6);
        for (MediaDescriptor md : this.transcriptionForThisFrame.getMediaDescriptors()) {
            String path = md.mediaURL;
            path = FileUtility.urlToAbsPath(path);
            if (md.mimeType.equals("audio/*") || md.mimeType.equals("audio/x-wav")) {
                if (audioPaths.contains(path)) continue;
                audioPaths.add(path);
                continue;
            }
            if (videoPaths.contains(path)) continue;
            videoPaths.add(path);
        }
        this.viewerManager.setAudioPaths(audioPaths);
        this.viewerManager.setVideoPaths(videoPaths);
        if (this.transcriptionForThisFrame.getLinkedFileDescriptors().size() > 0) {
            LinkedFileDescriptorUtil.initLinkedFiles((TranscriptionImpl)this.transcriptionForThisFrame);
        }
        ElanLocale.addElanLocaleListener(this.transcriptionForThisFrame, this);
        this.setFrameTitle();
        this.initMenusAndCommands();
        this.pvMenuManager.initPlayerMenu();
        this.wfvMenuManager.initWaveFormViewerMenu();
        if (this.viewerManager.getMasterMediaPlayer().isFrameRateAutoDetected()) {
            this.setMenuEnabled(740, false);
        }
        int mode = 1;
        Integer lastMode = Preferences.getInt("LayoutManager.CurrentMode", this.viewerManager.getTranscription());
        if (lastMode != null && mode != lastMode) {
            this.layoutManager.changeMode(lastMode);
            if (lastMode.intValue() == this.layoutManager.getMode()) {
                this.setMenuSelected(this.layoutManager.getModeConstant(lastMode), 700);
                mode = lastMode;
            }
        }
        if (mode == 1) {
            this.layoutManager.changeMode(mode);
        }
        Preferences.addPreferencesListener(this.transcriptionForThisFrame, this.layoutManager);
        Preferences.addPreferencesListener(this.transcriptionForThisFrame, this);
        Preferences.notifyListeners(this.transcriptionForThisFrame);
        this.loadPreferences();
        this.layoutManager.doLayout();
        this.initialized = true;
    }

    public void setFrameTitle() {
        try {
            if (this.transcriptionForThisFrame != null) {
                if (this.transcriptionForThisFrame.getName().equals("aishug294879ryshfda9763afo8947a5gf")) {
                    this.setTitle(this.applicationName + " - " + ElanLocale.getString("Frame.ElanFrame.UndefinedFileName"));
                } else {
                    this.setTitle(this.applicationName + " - " + this.transcriptionForThisFrame.getName());
                }
                this.setProxyIcon();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void initFrame() {
        Locale savedLocale;
        Boolean boolPref = Preferences.getBool("ActivityMonitoring.AlwaysStartMonitoring", null);
        if (boolPref != null && boolPref.booleanValue()) {
            MonitoringLogger.startMonitoring(true);
        }
        if ((savedLocale = (Locale)Preferences.get("Locale", null)) != null) {
            ElanLocale.setLocale(savedLocale);
        }
        this.initMenuBar();
        ElanFrameWindowListener windowList = new ElanFrameWindowListener();
        this.addWindowListener(windowList);
        this.addComponentListener(windowList);
        this.setDefaultCloseOperation(0);
        this.pack();
        this.updateShortcutMap(null);
        Dimension d = Preferences.getDimension("FrameSize", this.transcriptionForThisFrame);
        if (d == null) {
            d = Preferences.getDimension("FrameSize", null);
        }
        Rectangle wRect = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        if (d != null) {
            if (d.width > wRect.width) {
                d.setSize(wRect.width, d.height);
            }
            if ((double)d.height > wRect.getHeight()) {
                d.setSize(d.width, wRect.height);
            }
            this.setSize(d);
        } else {
            this.setSize(800, 600);
        }
        Point p = Preferences.getPoint("FrameLocation", this.transcriptionForThisFrame);
        if (p == null) {
            p = Preferences.getPoint("FrameLocation", null);
        }
        if (p != null) {
            if (p.x < wRect.x) {
                p.x = wRect.x;
            } else if (p.x > wRect.width - 30) {
                p.x = wRect.width - 30;
            }
            if (p.y < wRect.y) {
                p.y = wRect.y;
            } else if (p.y > wRect.height - 30) {
                p.y = wRect.height - 30;
            }
            this.setLocation(p);
        } else {
            this.setLocation((int)(wRect.getWidth() / 2.0 - (double)(this.getWidth() / 2)), (int)(wRect.getHeight() / 2.0 - (double)(this.getHeight() / 2)));
        }
        this.setVisible(true);
    }

    protected void createDnDTarget() {
        DropTarget dropTarget = new DropTarget(this.getContentPane(), new ELANDropTargetListener());
        dropTarget.setDefaultActions(0x40000000);
    }

    protected void initMenuBar() {
        this.menuBar = new JMenuBar();
        this.setJMenuBar(this.menuBar);
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        MenuAction ma = new MenuAction("Menu.File");
        this.menuFile = new JMenu(ma);
        this.menuActions.put("Menu.File", ma);
        this.menuBar.add(this.menuFile);
        ma = new NewMA("Menu.File.New", this);
        this.menuActions.put("Menu.File.New", ma);
        this.menuItemFileNew = new JMenuItem(ma);
        this.menuFile.add(this.menuItemFileNew);
        ma = new OpenMA("Menu.File.Open", this);
        this.menuActions.put("Menu.File.Open", ma);
        this.menuItemFileOpen = new JMenuItem(ma);
        this.menuFile.add(this.menuItemFileOpen);
        ma = new OpenRemoteMA("Menu.File.OpenRemote", this);
        this.menuActions.put("Menu.File.OpenRemote", ma);
        this.menuFile.add(new JMenuItem(ma));
        ma = new MenuAction("Menu.File.OpenRecent");
        this.menuActions.put("Menu.File.OpenRecent", ma);
        this.menuRecentFiles = new JMenu(ma);
        this.menuFile.add(this.menuRecentFiles);
        ma = new MenuAction("Menu.File.Close");
        this.closeMI = new ElanMenuItem(ma, false);
        this.menuActions.put("Menu.File.Close", ma);
        this.menuFile.add(this.closeMI);
        this.menuFile.addSeparator();
        ma = new MenuAction("Menu.File.Save");
        this.saveMI = new ElanMenuItem(ma, false);
        this.menuActions.put("Menu.File.Save", ma);
        this.menuFile.add(this.saveMI);
        ma = new MenuAction("Menu.File.SaveAs");
        this.saveAsMI = new ElanMenuItem(ma, false);
        this.menuActions.put("Menu.File.SaveAs", ma);
        this.menuFile.add(this.saveAsMI);
        ma = new MenuAction("Menu.File.SaveAsTemplate");
        this.saveAsTemplateMI = new ElanMenuItem(ma, false);
        this.menuActions.put("Menu.File.SaveAsTemplate", ma);
        this.menuFile.add(this.saveAsTemplateMI);
        ma = new MenuAction("Menu.File.SaveSelectionAsEAF");
        this.saveSelEafMI = new ElanMenuItem(ma, false);
        this.menuActions.put("Menu.File.SaveSelectionAsEAF", ma);
        this.menuFile.add(this.saveSelEafMI);
        ma = new MenuAction("Menu.File.Export.EAF2.7");
        this.saveAs2_7MI = new ElanMenuItem(ma, false);
        this.menuActions.put("Menu.File.Export.EAF2.7", ma);
        this.menuFile.add(this.saveAs2_7MI);
        this.menuFile.addSeparator();
        ma = new ValidateEAFMA("Menu.File.Validate", this);
        this.menuActions.put("Menu.File.Validate", ma);
        JMenuItem menuItemValidateFile = new JMenuItem(ma);
        this.menuFile.add(menuItemValidateFile);
        ma = new MergeTranscriptionsMA("Menu.File.MergeTranscriptions", this);
        this.menuActions.put("Menu.File.MergeTranscriptions", ma);
        this.mergeTransMI = new ElanMenuItem(ma);
        this.menuFile.add(this.mergeTransMI);
        ma = new MenuAction("Menu.File.Backup.Auto");
        this.menuActions.put("Menu.File.Backup.Auto", ma);
        this.menuBackup = new JMenu(ma);
        this.menuBackup.setEnabled(false);
        this.menuFile.add(this.menuBackup);
        this.menuFile.addSeparator();
        ma = new MenuAction("Menu.File.PageSetup");
        this.menuActions.put("Menu.File.PageSetup", ma);
        this.pageSetUpMI = new ElanMenuItem(ma, false);
        this.menuFile.add(this.pageSetUpMI);
        ma = new MenuAction("Menu.File.PrintPreview");
        this.printPreviewMI = new ElanMenuItem(ma, false);
        this.menuActions.put("Menu.File.PrintPreview", ma);
        this.menuFile.add(this.printPreviewMI);
        ma = new MenuAction("Menu.File.Print");
        this.printMI = new ElanMenuItem(ma, false);
        this.menuActions.put("Menu.File.Print", ma);
        this.menuFile.add(this.printMI);
        this.menuFile.addSeparator();
        ma = new MenuAction("Menu.File.ProcessMulti");
        this.menuActions.put("Menu.File.ProcessMulti", ma);
        JMenu mfProcessMenu = new JMenu(ma);
        this.menuFile.add(mfProcessMenu);
        ma = new MultiEAFCreationMA("Menu.File.MultiEAFCreation", this);
        this.menuActions.put("Menu.File.MultiEAFCreation", ma);
        mfProcessMenu.add(new JMenuItem(ma));
        ma = new MultipleFilesEditMA("Menu.File.Process.EditMF", this);
        this.menuActions.put("Menu.File.Process.EditMF", ma);
        mfProcessMenu.add(new JMenuItem(ma));
        ma = new MultiEAFScrubberMA("Menu.File.ScrubTranscriptions", this);
        this.menuActions.put("Menu.File.ScrubTranscriptions", ma);
        this.menuItemScrubTrans = new JMenuItem(ma);
        mfProcessMenu.add(this.menuItemScrubTrans);
        ma = new UpdateMultiForECVMA("Menu.File.MultiEAFECVUpdater", this);
        this.menuActions.put("Menu.File.MultiEAFECVUpdater", ma);
        mfProcessMenu.add(new JMenuItem(ma));
        ma = new MultipleFileUpdateWithTemplateMA("Menu.File.MultipleFileUpdateWithTemplate", this);
        this.menuActions.put("Menu.File.MultipleFileUpdateWithTemplate", ma);
        mfProcessMenu.add(new JMenuItem(ma));
        ma = new ClipMediaMultiMA("Menu.File.MultipleMediaClips", this);
        this.menuActions.put("Menu.File.MultipleMediaClips", ma);
        mfProcessMenu.add(new JMenuItem(ma));
        mfProcessMenu.addSeparator();
        ma = new MultiFileAnnotationsFromOverlapsMA("Menu.File.MultipleFileAnnotationFromOverlaps", this);
        this.menuActions.put("Menu.File.MultipleFileAnnotationFromOverlaps", ma);
        JMenuItem menuItemMultipleFileAnnotationsFromOverlaps = new JMenuItem(ma);
        mfProcessMenu.add(menuItemMultipleFileAnnotationsFromOverlaps);
        ma = new MultiFileAnnotationsFromSubtractionMA("Menu.File.MultipleFileAnnotationFromSubtraction", this);
        this.menuActions.put("Menu.File.MultipleFileAnnotationFromSubtraction", ma);
        mfProcessMenu.add(new JMenuItem(ma));
        ma = new MultipleFileMergeTiersMA("Menu.File.MultipleFileMergeTiers", this);
        this.menuActions.put("Menu.File.MultipleFileMergeTiers", ma);
        mfProcessMenu.add(new JMenuItem(ma));
        mfProcessMenu.addSeparator();
        ma = new AnnotatorCompareMA("Menu.File.MultipleFileCompareAnnotators", this);
        this.menuActions.put("Menu.File.MultipleFileCompareAnnotators", ma);
        this.compareAnnotatorsMI = new ElanMenuItem(ma);
        mfProcessMenu.add(this.compareAnnotatorsMI);
        ma = new StatisticsMultipleFilesMA("Menu.File.MultiFileStatistics", this);
        this.menuActions.put("Menu.File.MultiFileStatistics", ma);
        mfProcessMenu.add(new JMenuItem(ma));
        ma = new NgramStatisticsMA("Menu.File.MultiFileNgramStats", this);
        this.menuActions.put("Menu.File.MultiFileNgramStats", ma);
        mfProcessMenu.add(new JMenuItem(ma));
        this.menuFile.addSeparator();
        ma = new MenuAction("Menu.File.Export");
        this.menuActions.put("Menu.File.Export", ma);
        this.menuExport = new JMenu(ma);
        this.menuExport.setEnabled(false);
        this.menuFile.add(this.menuExport);
        ma = new MenuAction("Menu.File.Export.MultipleFiles");
        this.menuActions.put("Menu.File.Export.MultipleFiles", ma);
        JMenu exportMenuMulti = new JMenu(ma);
        this.menuFile.add(exportMenuMulti);
        ma = new ExportToolBoxMultiMA("Menu.File.MultipleExport.Toolbox", this);
        this.menuActions.put("Menu.File.MultipleExport.Toolbox", ma);
        exportMenuMulti.add(new JMenuItem(ma));
        ma = new ExportFlexMultiMA("Menu.File.MultipleExport.Flex", this);
        this.menuActions.put("Menu.File.MultipleExport.Flex", ma);
        exportMenuMulti.add(new JMenuItem(ma));
        ma = new ExportPraatMultiMA("Menu.File.MultipleExport.Praat", this);
        this.menuActions.put("Menu.File.MultipleExport.Praat", ma);
        exportMenuMulti.add(new JMenuItem(ma));
        ma = new ExportTabMultiMA("Menu.File.MultipleExport.Tab", this);
        this.menuActions.put("Menu.File.MultipleExport.Tab", ma);
        exportMenuMulti.add(new JMenuItem(ma));
        ma = new ExportAnnotationsMultiMA("Menu.File.Export.AnnotationListMulti", this);
        this.menuActions.put("Menu.File.Export.AnnotationListMulti", ma);
        exportMenuMulti.add(new JMenuItem(ma));
        ma = new ExportWordsMultiMA("Menu.File.MultipleExport.WordList", this);
        this.menuActions.put("Menu.File.MultipleExport.WordList", ma);
        exportMenuMulti.add(new JMenuItem(ma));
        ma = new ExportTiersMA("Menu.File.Export.Tiers", this);
        this.menuActions.put("Menu.File.Export.Tiers", ma);
        exportMenuMulti.add(new JMenuItem(ma));
        ma = new ExportOverlapsMultiMA("Menu.File.Export.OverlapsMulti", this);
        this.menuActions.put("Menu.File.Export.OverlapsMulti", ma);
        exportMenuMulti.add(new JMenuItem(ma));
        ma = new ExportThemeMultiMA("Menu.File.MultipleExport.Theme", this);
        this.menuActions.put("Menu.File.MultipleExport.Theme", ma);
        exportMenuMulti.add(new JMenuItem(ma));
        ma = new MenuAction("Menu.File.Import");
        this.menuActions.put("Menu.File.Import", ma);
        this.menuImport = new JMenu(ma);
        this.menuFile.add(this.menuImport);
        ma = new ImportToolboxMA("Menu.File.Import.Toolbox", this);
        this.menuActions.put("Menu.File.Import.Toolbox", ma);
        JMenuItem toolboxImportMI = new JMenuItem(ma);
        this.menuImport.add(toolboxImportMI);
        ma = new ImportFlexMA("Menu.File.Import.FLEx", this);
        this.menuActions.put("Menu.File.Import.FLEx", ma);
        JMenuItem flexImportMI = new JMenuItem(ma);
        this.menuImport.add(flexImportMI);
        ma = new ImportCHATMA("Menu.File.Import.CHAT", this);
        this.menuActions.put("Menu.File.Import.CHAT", ma);
        this.menuItemCHATImport = new JMenuItem(ma);
        this.menuImport.add(this.menuItemCHATImport);
        ma = new ImportTranscriberMA("Menu.File.Import.Transcriber", this);
        this.menuActions.put("Menu.File.Import.Transcriber", ma);
        this.menuItemTranscriberImport = new JMenuItem(ma);
        this.menuImport.add(this.menuItemTranscriberImport);
        ma = new ImportDelimitedTextMA("Menu.File.Import.Delimited", this);
        this.menuActions.put("Menu.File.Import.Delimited", ma);
        this.importDelimitedTextMI = new ElanMenuItem(ma);
        this.menuImport.add(this.importDelimitedTextMI);
        ma = new ImportSubtitleTextMA("Menu.File.Import.Subtitle", this);
        this.menuActions.put("Menu.File.Import.Subtitle", ma);
        this.importSubtitleTextMI = new ElanMenuItem(ma);
        this.menuImport.add(this.importSubtitleTextMI);
        ma = new ImportPraatMA("Menu.File.Import.PraatTiers", this);
        this.importPraatMI = new ElanMenuItem(ma);
        this.menuActions.put("Menu.File.Import.PraatTiers", ma);
        this.menuImport.add(this.importPraatMI);
        ma = new ImportJSONMA("Menu.File.Import.JSON.WA", this);
        this.menuActions.put("Menu.File.Import.JSON.WA", ma);
        this.menuImport.add(new ElanMenuItem(ma));
        ma = new ImportRecognizerTiersMA("Menu.File.Import.RecognizerTiers", this);
        this.importRecogTiersMI = new ElanMenuItem(ma);
        this.menuActions.put("Menu.File.Import.RecognizerTiers", ma);
        this.menuImport.add(this.importRecogTiersMI);
        ma = new ImportShoeboxMA("Menu.File.Import.Shoebox", this);
        this.menuActions.put("Menu.File.Import.Shoebox", ma);
        this.menuItemShoeboxImport = new JMenuItem(ma);
        this.menuImport.add(this.menuItemShoeboxImport);
        ma = new MenuAction("Menu.File.Import.MultipleFiles");
        this.menuActions.put("Menu.File.Import.MultipleFiles", ma);
        JMenu importMenuMulti = new JMenu(ma);
        this.menuFile.add(importMenuMulti);
        ma = new ImportToolboxMultiMA("Menu.File.MultipleImport.Toolbox", this);
        this.menuActions.put("Menu.File.MultipleImport.Toolbox", ma);
        importMenuMulti.add(new JMenuItem(ma));
        ma = new ImportPraatMultiMA("Menu.File.MultipleImport.PraatTiers", this);
        this.menuActions.put("Menu.File.MultipleImport.PraatTiers", ma);
        importMenuMulti.add(new JMenuItem(ma));
        ma = new ImportFlexMultiMA("Menu.File.MultipleImport.FLEx", this);
        this.menuActions.put("Menu.File.MultipleImport.FLEx", ma);
        importMenuMulti.add(new JMenuItem(ma));
        this.menuFile.addSeparator();
        ma = new ExitMA("Menu.File.Exit");
        this.menuActions.put("Menu.File.Exit", ma);
        this.menuItemFileExit = new JMenuItem(ma);
        this.menuFile.add(this.menuItemFileExit);
        ma = new MenuAction("Menu.Edit");
        this.menuActions.put("Menu.Edit", ma);
        this.menuEdit = new JMenu(ma);
        this.menuBar.add(this.menuEdit);
        ma = new MenuAction("Menu.Edit.Undo");
        this.undoMI = new ElanMenuItem(ma, false);
        this.menuActions.put("Menu.Edit.Undo", ma);
        this.menuEdit.add(this.undoMI);
        ma = new MenuAction("Menu.Edit.Redo");
        this.redoMI = new ElanMenuItem(ma, false);
        this.menuActions.put("Menu.Edit.Redo", ma);
        this.menuEdit.add(this.redoMI);
        this.menuEdit.addSeparator();
        ma = new MenuAction("CommandActions.CopyCurrentTime");
        this.copyCurrentTimeCodeMI = new ElanMenuItem(ma, false);
        this.menuActions.put("CommandActions.CopyCurrentTime", ma);
        this.menuEdit.add(this.copyCurrentTimeCodeMI);
        ma = new MenuAction("Menu.Edit.EditCV");
        this.editCVMI = new ElanMenuItem(ma, false);
        this.menuActions.put("Menu.Edit.EditCV", ma);
        this.menuEdit.add(this.editCVMI);
        ma = new MenuAction("Menu.Edit.Author");
        this.setAuthorMI = new ElanMenuItem(ma, false);
        this.menuActions.put("Menu.Edit.Author", ma);
        this.menuEdit.add(this.setAuthorMI);
        ma = new MenuAction("Menu.Edit.DocumentProperties");
        this.setDocumentPropertiesMI = new ElanMenuItem(ma, false);
        this.menuActions.put("Menu.Edit.DocumentProperties", ma);
        this.menuEdit.add(this.setDocumentPropertiesMI);
        this.menuEdit.addSeparator();
        ma = new MenuAction("Menu.Edit.LinkedFiles");
        this.linkedFilesMI = new ElanMenuItem(ma, false);
        this.menuActions.put("Menu.Edit.LinkedFiles", ma);
        this.menuEdit.add(this.linkedFilesMI);
        this.menuEdit.addSeparator();
        ma = new MenuAction("Menu.Edit.EditLexSrvc");
        this.editLexiconServiceMI = new ElanMenuItem(ma, false);
        this.menuActions.put("Menu.Edit.EditLexSrvc", ma);
        this.menuEdit.add(this.editLexiconServiceMI);
        ma = new EditLanguagesMA("Menu.Edit.LanguagesList");
        this.editLangListMI = new ElanMenuItem(ma, true);
        this.menuActions.put("Menu.Edit.LanguagesList", ma);
        this.menuEdit.add(this.editLangListMI);
        ma = new EditTierSetMA("Menu.Edit.TierSet", this);
        this.editTierSetMI = new ElanMenuItem(ma, true);
        this.menuActions.put("Menu.Edit.TierSet", ma);
        this.menuEdit.add(this.editTierSetMI);
        ma = new EditSpellCheckerMA("Menu.Edit.EditSpellChecker", this);
        this.menuActions.put("Menu.Edit.EditSpellChecker", ma);
        this.menuEdit.add(new JMenuItem(ma));
        this.menuEdit.addSeparator();
        ma = new MenuAction("Menu.Edit.Preferences");
        this.menuActions.put("Menu.Edit.Preferences", ma);
        this.menuPreferences = new JMenu(ma);
        this.menuEdit.add(this.menuPreferences);
        ma = new EditPreferencesMA("Menu.Edit.Preferences.Edit", this);
        this.menuActions.put("Menu.Edit.Preferences.Edit", ma);
        this.menuPreferences.add(new JMenuItem(ma));
        ma = new EditShortcutsMA("Menu.Edit.Preferences.Shortcut", this);
        this.menuActions.put("Menu.Edit.Preferences.Shortcut", ma);
        this.menuPreferences.add(new JMenuItem(ma));
        this.menuPreferences.addSeparator();
        ma = new MenuAction("Menu.Edit.Preferences.Import");
        this.importPrefsMI = new ElanMenuItem(ma, false);
        this.menuActions.put("Menu.Edit.Preferences.Import", ma);
        this.menuPreferences.add(this.importPrefsMI);
        ma = new MenuAction("Menu.Edit.Preferences.Export");
        this.exportPrefsMI = new ElanMenuItem(ma, false);
        this.menuActions.put("Menu.Edit.Preferences.Export", ma);
        this.menuPreferences.add(this.exportPrefsMI);
        ma = new MenuAction("Menu.Annotation");
        this.menuActions.put("Menu.Annotation", ma);
        this.menuAnnotation = new JMenu(ma);
        this.menuBar.add(this.menuAnnotation);
        this.menuAnnotation.setEnabled(SystemReporting.isMacOS());
        ma = new MenuAction("Menu.Tier");
        this.menuActions.put("Menu.Tier", ma);
        this.menuTier = new JMenu(ma);
        this.menuBar.add(this.menuTier);
        this.menuTier.setEnabled(SystemReporting.isMacOS());
        ma = new MenuAction("Menu.Type");
        this.menuActions.put("Menu.Type", ma);
        this.menuType = new JMenu(ma);
        this.menuBar.add(this.menuType);
        this.menuType.setEnabled(SystemReporting.isMacOS());
        ma = new MenuAction("Menu.Search");
        this.menuActions.put("Menu.Search", ma);
        this.menuSearch = new JMenu(ma);
        this.menuBar.add(this.menuSearch);
        ma = new MenuAction("Menu.Search.Find");
        this.searchMI = new ElanMenuItem(ma, false);
        this.menuActions.put("Menu.Search.Find", ma);
        this.menuSearch.add(this.searchMI);
        ma = new MultiFindReplaceMA("Menu.Search.FindReplaceMulti", this);
        this.menuActions.put("Menu.Search.FindReplaceMulti", ma);
        this.menuSearch.add(ma);
        ma = new SearchMultipleMA("Menu.Search.Multiple", this);
        this.menuActions.put("Menu.Search.Multiple", ma);
        this.menuSearch.add(ma);
        ma = new FASTSearchMA("Menu.Search.FASTSearch", this);
        this.menuActions.put("Menu.Search.FASTSearch", ma);
        this.menuSearch.add(ma);
        ma = new StructuredSearchMultipleMA("Menu.Search.StructuredMultiple", this);
        this.menuActions.put("Menu.Search.StructuredMultiple", ma);
        this.menuSearch.add(ma);
        ma = new MenuAction("Menu.Search.GoTo");
        this.goToMI = new ElanMenuItem(ma, false);
        this.menuActions.put("Menu.Search.GoTo", ma);
        this.menuSearch.add(this.goToMI);
        ma = new MenuAction("Menu.View");
        this.menuActions.put("Menu.View", ma);
        this.menuView = new JMenu(ma);
        this.menuBar.add(this.menuView);
        ma = new MenuAction("Menu.View.MediaPlayer");
        this.menuActions.put("Menu.View.MediaPlayer", ma);
        this.menuMediaPlayer = new JMenu(ma);
        this.menuView.add(this.menuMediaPlayer);
        ma = new MenuAction("Menu.View.Waveform");
        this.menuActions.put("Menu.View.Waveform", ma);
        this.menuWaveform = new JMenu(ma);
        this.waveFormGroup = new ButtonGroup();
        this.menuView.add(this.menuWaveform);
        ma = new MenuAction("Menu.View.Viewers");
        this.menuActions.put("Menu.View.Viewers", ma);
        this.menuViewer = new JMenu(ma);
        this.menuView.add(this.menuViewer);
        this.menuView.addSeparator();
        this.menuItemGridViewer = new JCheckBoxMenuItem(new CreateViewerMA("Menu.View.Viewers.Grid", this));
        this.menuItemGridViewer.setSelected(true);
        this.menuViewer.add(this.menuItemGridViewer);
        this.menuItemTextViewer = new JCheckBoxMenuItem(new CreateViewerMA("Menu.View.Viewers.Text", this));
        this.menuItemTextViewer.setSelected(true);
        this.menuViewer.add(this.menuItemTextViewer);
        this.menuItemSubtitleViewer = new JCheckBoxMenuItem(new CreateViewerMA("Menu.View.Viewers.Subtitles", this));
        this.menuItemSubtitleViewer.setSelected(true);
        this.menuViewer.add(this.menuItemSubtitleViewer);
        this.menuItemLexiconViewer = new JCheckBoxMenuItem(new CreateViewerMA("LexiconEntryViewer.Lexicon", this));
        this.menuItemLexiconViewer.setSelected(true);
        this.menuViewer.add(this.menuItemLexiconViewer);
        this.menuItemCommentViewer = new JCheckBoxMenuItem(new CreateViewerMA("CommentViewer.Comment", this));
        this.menuItemCommentViewer.setSelected(true);
        this.menuViewer.add(this.menuItemCommentViewer);
        this.menuItemRecognizer = new JCheckBoxMenuItem(new CreateViewerMA("Menu.View.Viewers.Recognizer", this));
        this.menuItemRecognizer.setSelected(true);
        this.menuViewer.add(this.menuItemRecognizer);
        this.menuItemMetaDataViewer = new JCheckBoxMenuItem(new CreateViewerMA("Menu.View.Viewers.MetaData", this));
        this.menuItemMetaDataViewer.setSelected(true);
        this.menuViewer.add(this.menuItemMetaDataViewer);
        this.menuItemSignalViewer = new JCheckBoxMenuItem(new CreateSignalViewerMA("Menu.View.Viewers.Signal", this));
        this.menuItemSignalViewer.setSelected(true);
        this.menuViewer.add(this.menuItemSignalViewer);
        this.menuItemSpectrogramViewer = new JCheckBoxMenuItem(new CreateViewerMA("Menu.View.Viewers.Spectrogram", this));
        this.menuItemSpectrogramViewer.setSelected(true);
        this.menuViewer.add(this.menuItemSpectrogramViewer);
        this.menuItemInterLinearViewer = new JCheckBoxMenuItem(new CreateViewerMA("Menu.View.Viewers.InterLinear", this));
        this.menuItemInterLinearViewer.setSelected(true);
        this.menuViewer.add(this.menuItemInterLinearViewer);
        this.menuItemTimeSeriesViewer = new JCheckBoxMenuItem(new CreateViewerMA("Menu.View.Viewers.TimeSeries", this));
        this.menuItemTimeSeriesViewer.setSelected(true);
        this.menuViewer.add(this.menuItemTimeSeriesViewer);
        this.loadViewerPreferences();
        ma = new MenuAction("Menu.View.DocumentInfo");
        this.viewDocumentInfoMI = new ElanMenuItem(ma, false);
        this.menuView.add(this.viewDocumentInfoMI);
        ma = new MenuAction("Menu.View.Dependencies");
        this.tierDependenciesMI = new ElanMenuItem(ma, false);
        this.menuActions.put("Menu.View.Dependencies", ma);
        this.menuView.add(this.tierDependenciesMI);
        ma = new ShortcutsMA("Menu.View.Shortcuts", this);
        this.menuActions.put("Menu.View.Shortcuts", ma);
        this.menuView.add(ma);
        ma = new FontBrowserMA("Menu.View.FontBrowser", this);
        this.menuActions.put("Menu.View.FontBrowser", ma);
        this.menuView.add(ma);
        ma = new ShowLogMA("Menu.View.LogView", this);
        this.menuActions.put("Menu.View.LogView", ma);
        this.menuView.add(ma);
        this.menuView.addSeparator();
        ma = new MenuAction("Menu.View.SpreadSheet");
        this.spreadsheetMI = new ElanMenuItem(ma, false);
        this.menuActions.put("Menu.View.SpreadSheet", ma);
        this.menuView.add(this.spreadsheetMI);
        ma = new MenuAction("Menu.View.Statistics");
        this.statisticsMI = new ElanMenuItem(ma, false);
        this.menuActions.put("Menu.View.Statistics", ma);
        this.menuView.add(this.statisticsMI);
        ma = new MenuAction("Menu.View.AnnotationDensityPlot");
        this.viewAnnotationDensityPlotMI = new ElanMenuItem(ma, false);
        this.menuView.add(this.viewAnnotationDensityPlotMI);
        ma = new MenuAction("Menu.View.AudioSpectrogram");
        this.viewAudioSpectrogramMI = new ElanMenuItem(ma, false);
        ma = new MenuAction("Menu.Options");
        this.menuActions.put("Menu.Options", ma);
        this.menuOptions = new JMenu(ma);
        this.menuBar.add(this.menuOptions);
        ma = new MenuAction("Menu.Options.TimeChangePropagationMode");
        this.menuActions.put("Menu.Options.TimeChangePropagationMode", ma);
        this.menuChangeTimePropMode = new JMenu(ma);
        this.menuChangeTimePropMode.setEnabled(false);
        this.menuOptions.add(this.menuChangeTimePropMode);
        this.menuOptions.addSeparator();
        ma = new MenuAction("Menu.Options.AnnotationMode");
        this.menuItemAnnoMode = new JRadioButtonMenuItem(ma);
        this.menuActions.put("Menu.Options.AnnotationMode", ma);
        this.menuItemAnnoMode.setEnabled(false);
        this.menuItemAnnoMode.setSelected(true);
        this.menuOptions.add(this.menuItemAnnoMode);
        ma = new MenuAction("Menu.Options.SyncMode");
        this.menuItemSyncMode = new JRadioButtonMenuItem(ma);
        this.menuActions.put("Menu.Options.SyncMode", ma);
        this.menuItemSyncMode.setEnabled(false);
        this.menuOptions.add(this.menuItemSyncMode);
        ma = new MenuAction("Menu.Options.TranscriptionMode");
        this.menuItemTranscMode = new JRadioButtonMenuItem(ma);
        this.menuActions.put("Menu.Options.TranscriptionMode", ma);
        this.menuItemTranscMode.setEnabled(false);
        this.menuOptions.add(this.menuItemTranscMode);
        ma = new MenuAction("Menu.Options.SegmentationMode");
        this.menuItemSegmentMode = new JRadioButtonMenuItem(ma);
        this.menuActions.put("Menu.Options.SegmentationMode", ma);
        this.menuItemSegmentMode.setEnabled(false);
        this.menuOptions.add(this.menuItemSegmentMode);
        ma = new MenuAction("Menu.Options.InterlinearizationMode");
        this.menuItemInterLinearMode = new JRadioButtonMenuItem(ma);
        this.menuActions.put("Menu.Options.InterlinearizationMode", ma);
        this.menuItemInterLinearMode.setEnabled(false);
        this.menuOptions.add(this.menuItemInterLinearMode);
        this.menuOptions.addSeparator();
        ma = new ActivityMonitoringMA("Menu.Options.ActivityMonitoring", this);
        this.menuActions.put("Menu.Options.ActivityMonitoring", ma);
        this.menuOptions.add(new JMenuItem(ma));
        this.menuOptions.addSeparator();
        ma = new MenuAction("Menu.Options.WebServices");
        this.menuWebservices = new JMenu(ma);
        this.menuWebservices.setEnabled(false);
        this.menuOptions.add(this.menuWebservices);
        this.menuOptions.addSeparator();
        ma = new SetPlayAroundSelectionMA("Menu.Options.PlayAroundSelectionDialog", this);
        this.menuActions.put("Menu.Options.PlayAroundSelectionDialog", ma);
        this.menuOptions.add(new JMenuItem(ma));
        ma = new SetPlaybackToggleMA("Menu.Options.PlaybackToggleDialog", this);
        this.menuActions.put("Menu.Options.PlaybackToggleDialog", ma);
        this.menuOptions.add(new JMenuItem(ma));
        this.menuOptions.addSeparator();
        ma = new MenuAction("Menu.Options.FrameLength");
        this.menuActions.put("Menu.Options.FrameLength", ma);
        this.menuFrameLength = new JMenu(ma);
        this.menuFrameLength.setEnabled(false);
        this.menuOptions.add(this.menuFrameLength);
        this.menuOptions.addSeparator();
        ma = new MenuAction("Menu.Options.Language");
        this.menuActions.put("Menu.Options.Language", ma);
        this.menuAppLanguage = new JMenu(ma);
        this.languageBG = new ButtonGroup();
        ma = new SetLocaleMA("Catal\u00e0", this, ElanLocale.CATALAN);
        JRadioButtonMenuItem langRBMI = new JRadioButtonMenuItem(ma);
        this.languageBG.add(langRBMI);
        this.menuAppLanguage.add(langRBMI);
        ma = new SetLocaleMA("\ufeff\u7b80\u4f53\u4e2d\u6587", this, ElanLocale.CHINESE_SIMP);
        langRBMI = new JRadioButtonMenuItem(ma);
        this.languageBG.add(langRBMI);
        this.menuAppLanguage.add(langRBMI);
        ma = new SetLocaleMA("Deutsch", this, ElanLocale.GERMAN);
        langRBMI = new JRadioButtonMenuItem(ma);
        this.languageBG.add(langRBMI);
        this.menuAppLanguage.add(langRBMI);
        ma = new SetLocaleMA("English", this, ElanLocale.ENGLISH);
        langRBMI = new JRadioButtonMenuItem(ma);
        this.languageBG.add(langRBMI);
        this.menuAppLanguage.add(langRBMI);
        ma = new SetLocaleMA("Espa\u00f1ol", this, ElanLocale.SPANISH);
        langRBMI = new JRadioButtonMenuItem(ma);
        this.languageBG.add(langRBMI);
        this.menuAppLanguage.add(langRBMI);
        ma = new SetLocaleMA("Fran\u00e7ais", this, ElanLocale.FRENCH);
        langRBMI = new JRadioButtonMenuItem(ma);
        this.languageBG.add(langRBMI);
        this.menuAppLanguage.add(langRBMI);
        ma = new SetLocaleMA("\u65e5\u672c\u8a9e", this, ElanLocale.JAPANESE);
        langRBMI = new JRadioButtonMenuItem(ma);
        this.languageBG.add(langRBMI);
        this.menuAppLanguage.add(langRBMI);
        ma = new SetLocaleMA("\ud55c\uad6d\uc5b4", this, ElanLocale.KOREAN);
        langRBMI = new JRadioButtonMenuItem(ma);
        this.languageBG.add(langRBMI);
        this.menuAppLanguage.add(langRBMI);
        ma = new SetLocaleMA("Nederlands", this, ElanLocale.DUTCH);
        langRBMI = new JRadioButtonMenuItem(ma);
        this.languageBG.add(langRBMI);
        this.menuAppLanguage.add(langRBMI);
        ma = new SetLocaleMA("Portugu\u00eas", this, ElanLocale.PORTUGUESE);
        langRBMI = new JRadioButtonMenuItem(ma);
        this.languageBG.add(langRBMI);
        this.menuAppLanguage.add(langRBMI);
        ma = new SetLocaleMA("Portugu\u00eas Brasileiro", this, ElanLocale.BRAZILIAN_PORTUGUESE);
        langRBMI = new JRadioButtonMenuItem(ma);
        this.languageBG.add(langRBMI);
        this.menuAppLanguage.add(langRBMI);
        ma = new SetLocaleMA("\u0420\u0443\u0441\u0441\u043a\u0438\u0439", this, ElanLocale.RUSSIAN);
        langRBMI = new JRadioButtonMenuItem(ma);
        this.languageBG.add(langRBMI);
        this.menuAppLanguage.add(langRBMI);
        ma = new SetLocaleMA("Svenska", this, ElanLocale.SWEDISH);
        langRBMI = new JRadioButtonMenuItem(ma);
        this.languageBG.add(langRBMI);
        this.menuAppLanguage.add(langRBMI);
        ma = new SetLocaleMA("Menu.Options.Language.Custom", this, ElanLocale.CUSTOM);
        langRBMI = new JRadioButtonMenuItem(ma);
        this.languageBG.add(langRBMI);
        this.menuAppLanguage.add(langRBMI);
        this.menuOptions.add(this.menuAppLanguage);
        this.recentLanguagesMenuItem = new RecentLanguagesMenuItem();
        this.menuOptions.add(this.recentLanguagesMenuItem);
        ma = new MenuAction("Menu.Window");
        this.menuActions.put("Menu.Window", ma);
        this.menuWindow = new JMenu(ma);
        this.windowsGroup = new ButtonGroup();
        this.menuBar.add(this.menuWindow);
        ma = new MenuAction("Menu.Help");
        this.menuActions.put("Menu.Help", ma);
        this.menuHelp = new JMenu(ma);
        this.menuBar.add(this.menuHelp);
        ma = new HelpMA("Menu.Help.Contents", this);
        this.menuActions.put("Menu.Help.Contents", ma);
        this.menuHelp.add(new JMenuItem(ma));
        this.menuHelp.addSeparator();
        ma = new UpdateElanMA("Menu.Options.CheckForUpdate", this);
        this.menuActions.put("Menu.Options.CheckForUpdate", ma);
        this.menuHelp.add(new JMenuItem(ma));
        ma = new MenuAction("Menu.Help.Website");
        this.menuActions.put("Menu.Help.Website", ma);
        JMenu websiteMenu = new JMenu(ma);
        this.menuHelp.add(websiteMenu);
        ma = new WebMA("Menu.Help.Website.ReleaseNotes", this, "https://archive.mpi.nl/tla/elan/release-notes");
        this.menuActions.put("Menu.Help.Website.ReleaseNotes", ma);
        websiteMenu.add(new JMenuItem(ma));
        ma = new WebMA("Menu.Help.Website.Download", this, "https://archive.mpi.nl/tla/elan/download");
        this.menuActions.put("Menu.Help.Website.Download", ma);
        websiteMenu.add(new JMenuItem(ma));
        ma = new WebMA("Menu.Help.Website.Forum", this, "https://archive.mpi.nl/forums/");
        this.menuActions.put("Menu.Help.Website.Forum", ma);
        websiteMenu.add(new JMenuItem(ma));
        websiteMenu.addSeparator();
        ma = new WebMA("Menu.Help.Website.Subscribe", this, "mailto:elanlist-request@mpi.nl?subject=subscribe");
        this.menuActions.put("Menu.Help.Website.Subscribe", ma);
        websiteMenu.add(new JMenuItem(ma));
        ma = new AboutMA("Menu.Help.About", this);
        this.menuActions.put("Menu.Help.About", ma);
        this.menuHelp.add(new JMenuItem(ma));
        this.updateLocale();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals("Use Native Media Platform")) {
            boolean useNativeMedia = this.menuItemNativeMedia.getState();
            if (useNativeMedia) {
                System.out.println("Setting preferred media framework to Native");
                System.setProperty("PreferredMediaFramework", "NativeWindows");
            } else {
                System.out.println("Setting preferred media framework to JMF");
                System.setProperty("PreferredMediaFramework", "JMF");
            }
        }
    }

    public void clearShortcutsMap(String modeConstant) {
        if (this.getViewerManager() == null || this.getViewerManager().getTranscription() == null) {
            return;
        }
        for (Map.Entry<String, KeyStroke> pairs : ShortcutsUtil.getInstance().getCurrentShortcuts(modeConstant).entrySet()) {
            String actionName = pairs.getKey();
            Action ca = ELANCommandFactory.getCommandAction(this.getViewerManager().getTranscription(), actionName);
            if (ca != null) {
                ca.putValue("AcceleratorKey", null);
                String ksDescription = ShortcutsUtil.getInstance().getDescriptionForKeyStroke(pairs.getValue());
                if (ksDescription == null || ksDescription.trim().length() <= 0) continue;
                ca.putValue("ShortDescription", ElanLocale.getString(actionName + "ToolTip"));
                continue;
            }
            ca = this.menuActions.get(actionName);
            if (ca == null) continue;
            ca.putValue("AcceleratorKey", null);
        }
    }

    public void updateShortcutMap(String modeConstant) {
        if (modeConstant == null) {
            return;
        }
        if (this.getViewerManager() == null || this.getViewerManager().getTranscription() == null) {
            return;
        }
        ActionMap actionMap = this.getRootPane().getActionMap();
        InputMap inputMap = this.getRootPane().getInputMap(2);
        inputMap.clear();
        actionMap.clear();
        if (inputMap != null) {
            String nextId;
            KeyStroke ks;
            Action act;
            String id = "Act-";
            int index = 0;
            Map<String, KeyStroke> shortMap = ShortcutsUtil.getInstance().getCurrentShortcuts(modeConstant);
            Iterator<Map.Entry<String, KeyStroke>> it = shortMap.entrySet().iterator();
            while (it.hasNext()) {
                act = null;
                Map.Entry<String, KeyStroke> pairs = it.next();
                String actionName = pairs.getKey();
                ks = pairs.getValue();
                String ksDescription = ShortcutsUtil.getInstance().getDescriptionForKeyStroke(ks);
                if (modeConstant != null) {
                    act = ELANCommandFactory.getCommandAction(this.getViewerManager().getTranscription(), actionName);
                }
                if (act != null) {
                    String shortValue;
                    act.putValue("AcceleratorKey", ks);
                    nextId = id + index++;
                    if (ks != null) {
                        inputMap.put(ks, nextId);
                        actionMap.put(nextId, act);
                    }
                    if (ksDescription == null || ksDescription.trim().length() <= 0 || (shortValue = (String)act.getValue("ShortDescription")) == null) continue;
                    act.putValue("ShortDescription", shortValue + " (" + ksDescription + ")");
                    continue;
                }
                act = this.menuActions.get(actionName);
                if (act != null) {
                    act.putValue("AcceleratorKey", ks);
                    nextId = id + index++;
                    if (ks == null) continue;
                    inputMap.put(ks, nextId);
                    actionMap.put(nextId, act);
                    continue;
                }
                if (actionName.equals("Menu.Edit.Undo")) {
                    act = this.undoMI.getAction();
                    if (act == null) continue;
                    act.putValue("AcceleratorKey", ks);
                    nextId = id + index++;
                    if (ks == null) continue;
                    inputMap.put(ks, nextId);
                    actionMap.put(nextId, act);
                    continue;
                }
                if (!actionName.equals("Menu.Edit.Redo") || (act = this.redoMI.getAction()) == null) continue;
                act.putValue("AcceleratorKey", ks);
                nextId = id + index++;
                if (ks == null) continue;
                inputMap.put(ks, nextId);
                actionMap.put(nextId, act);
            }
            act = new NextWindowMA("Menu.Window.Next");
            ks = (KeyStroke)act.getValue("AcceleratorKey");
            nextId = id + index++;
            inputMap.put(ks, nextId);
            actionMap.put(nextId, act);
            act = new PrevWindowMA("Menu.Window.Previous");
            ks = (KeyStroke)act.getValue("AcceleratorKey");
            nextId = id + index++;
            inputMap.put(ks, nextId);
            actionMap.put(nextId, act);
        }
    }

    protected void initMenusAndCommands() {
        this.menuActions.remove("Menu.File.Close");
        this.closeMI.setAction(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.File.Close"), true);
        this.menuActions.remove("Menu.File.Save");
        this.saveMI.setAction(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.File.Save"), true);
        this.menuActions.remove("Menu.File.SaveAs");
        this.saveAsMI.setAction(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.File.SaveAs"), true);
        this.menuActions.remove("Menu.File.SaveAsTemplate");
        this.saveAsTemplateMI.setAction(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.File.SaveAsTemplate"), true);
        this.menuActions.remove("Menu.File.SaveSelectionAsEAF");
        this.saveSelEafMI.setAction(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.File.SaveSelectionAsEAF"), true);
        this.menuActions.remove("Menu.File.Export.EAF2.7");
        this.saveAs2_7MI.setAction(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.File.Export.EAF2.7"), true);
        this.menuActions.remove("Menu.File.MergeTranscriptions");
        this.mergeTransMI.setAction(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.File.MergeTranscriptions"), true);
        this.menuBackup.setEnabled(true);
        ButtonGroup backupGroup = new ButtonGroup();
        Integer buDelay = Preferences.getInt("BackUpDelay", null);
        JRadioButtonMenuItem neverMI = new JRadioButtonMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.File.Backup.Never"));
        if (buDelay == null || buDelay.compareTo(Constants.BACKUP_NEVER) == 0) {
            neverMI.setSelected(true);
        }
        JRadioButtonMenuItem backup1MI = new JRadioButtonMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.File.Backup.1"));
        if (buDelay != null && buDelay.compareTo(Constants.BACKUP_1) == 0) {
            backup1MI.setSelected(true);
        }
        JRadioButtonMenuItem backup5MI = new JRadioButtonMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.File.Backup.5"));
        if (buDelay != null && buDelay.compareTo(Constants.BACKUP_5) == 0) {
            backup5MI.setSelected(true);
        }
        JRadioButtonMenuItem backup10MI = new JRadioButtonMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.File.Backup.10"));
        if (buDelay != null && buDelay.compareTo(Constants.BACKUP_10) == 0) {
            backup10MI.setSelected(true);
        }
        JRadioButtonMenuItem backup20MI = new JRadioButtonMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.File.Backup.20"));
        if (buDelay != null && buDelay.compareTo(Constants.BACKUP_20) == 0) {
            backup20MI.setSelected(true);
        }
        JRadioButtonMenuItem backup30MI = new JRadioButtonMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.File.Backup.30"));
        if (buDelay != null && buDelay.compareTo(Constants.BACKUP_30) == 0) {
            backup30MI.setSelected(true);
        }
        backupGroup.add(neverMI);
        backupGroup.add(backup1MI);
        backupGroup.add(backup5MI);
        backupGroup.add(backup10MI);
        backupGroup.add(backup20MI);
        backupGroup.add(backup30MI);
        this.menuBackup.add(neverMI);
        this.menuBackup.add(backup1MI);
        this.menuBackup.add(backup5MI);
        this.menuBackup.add(backup10MI);
        this.menuBackup.add(backup20MI);
        this.menuBackup.add(backup30MI);
        this.menuActions.remove("Menu.File.PageSetup");
        this.pageSetUpMI.setAction(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.File.PageSetup"), true);
        this.menuActions.remove("Menu.File.PrintPreview");
        this.printPreviewMI.setAction(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.File.PrintPreview"), true);
        this.menuActions.remove("Menu.File.Print");
        this.printMI.setAction(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.File.Print"), true);
        this.menuActions.remove("Menu.File.MultipleFileCompareAnnotators");
        this.compareAnnotatorsMI.setAction(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.File.MultipleFileCompareAnnotators"), true);
        this.menuExport.setEnabled(true);
        this.menuExport.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.File.Export.Toolbox")));
        this.menuExport.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.File.Export.Flex")));
        this.menuExport.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.File.Export.CHAT")));
        this.menuExport.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.File.Export.Tab")));
        this.menuExport.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.File.Export.Tiger")));
        this.menuExport.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.File.Export.Interlinear")));
        this.menuExport.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.File.Export.HTML")));
        this.menuExport.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.File.Export.TraditionalTranscript")));
        this.menuExport.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.File.Export.TimeAlignedInterlinear")));
        this.menuExport.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.File.Export.Praat")));
        this.menuExport.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.File.Export.JSON")));
        this.menuExport.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.File.Export.WordList")));
        MenuAction ma = new MenuAction("Menu.File.Export.Smil");
        this.menuActions.put("Menu.File.Export.Smil", ma);
        this.menuExportSMIL = new JMenu(ma);
        this.menuExport.add(this.menuExportSMIL);
        this.menuExportSMIL.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.File.Export.Smil.RealPlayer")));
        this.menuExportSMIL.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.File.Export.Smil.QuickTime")));
        this.menuExport.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.File.Export.QtSub")));
        this.menuExport.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.File.Export.Subtitles")));
        this.menuExport.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.File.Export.RecognizerTiers")));
        this.menuExport.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.File.Export.MediaWithScript")));
        this.menuExport.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.File.Export.ImageFromWindow")));
        this.menuExport.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.File.Export.FilmStrip")));
        this.menuExport.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.File.Export.Shoebox")));
        this.menuActions.remove("Menu.File.Import.PraatTiers");
        this.importPraatMI.setAction(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.File.Import.PraatTiers"), true);
        this.menuActions.remove("Menu.File.Import.Delimited");
        this.importDelimitedTextMI.setAction(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.File.Import.Delimited"), true);
        this.menuActions.remove("Menu.File.Import.Subtitle");
        this.importSubtitleTextMI.setAction(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.File.Import.Subtitle"), true);
        this.menuActions.remove("Menu.File.Import.RecognizerTiers");
        this.importRecogTiersMI.setAction(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.File.Import.RecognizerTiers"), true);
        this.menuActions.remove("Menu.Edit.Undo");
        UndoCA undoCA = ELANCommandFactory.getUndoCA(this.transcriptionForThisFrame);
        this.undoMI.setAction(undoCA);
        this.menuActions.remove("Menu.Edit.Redo");
        RedoCA redoCA = ELANCommandFactory.getRedoCA(this.transcriptionForThisFrame);
        this.redoMI.setAction(redoCA);
        this.menuActions.remove("CommandActions.CopyCurrentTime");
        this.copyCurrentTimeCodeMI.setAction(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "CommandActions.CopyCurrentTime"), true);
        this.menuActions.remove("Menu.Edit.EditCV");
        this.editCVMI.setAction(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Edit.EditCV"), true);
        this.menuActions.remove("Menu.Edit.EditLexSrvc");
        this.editLexiconServiceMI.setAction(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Edit.EditLexSrvc"), true);
        this.menuActions.remove("Menu.Edit.Author");
        this.setAuthorMI.setAction(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Edit.Author"), true);
        this.menuActions.remove("Menu.Edit.DocumentProperties");
        this.setDocumentPropertiesMI.setAction(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Edit.DocumentProperties"), true);
        this.menuActions.remove("Menu.View.DocumentInfo");
        this.viewDocumentInfoMI.setAction(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.View.DocumentInfo"), true);
        this.menuActions.remove("Menu.View.AnnotationDensityPlot");
        this.viewAnnotationDensityPlotMI.setAction(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.View.AnnotationDensityPlot"), true);
        this.menuActions.remove("Menu.View.AudioSpectrogram");
        this.viewAudioSpectrogramMI.setAction(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.View.AudioSpectrogram"), true);
        this.menuActions.remove("Menu.Edit.LinkedFiles");
        this.linkedFilesMI.setAction(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Edit.LinkedFiles"), true);
        this.menuActions.remove("Menu.Edit.Preferences.Import");
        this.importPrefsMI.setAction(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Edit.Preferences.Import"), true);
        this.menuActions.remove("Menu.Edit.Preferences.Export");
        this.exportPrefsMI.setAction(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Edit.Preferences.Export"), true);
        this.menuAnnotation.setEnabled(true);
        this.menuAnnotation.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Annotation.NewAnnotation")));
        this.menuAnnotation.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Annotation.NewAnnotationBefore")));
        this.menuAnnotation.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Annotation.NewAnnotationAfter")));
        this.menuAnnotation.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Annotation.NewAnnotationFromBeginEndTimeDialog")));
        this.menuAnnotation.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Annotation.CreateDependingAnnotations")));
        this.menuAnnotation.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Annotation.ModifyAnnotation")));
        this.menuAnnotation.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Annotation.ModifyAnnotationTimeDialog")));
        this.menuAnnotation.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Annotation.ModifyAnnotationDatCat")));
        this.menuAnnotation.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Annotation.MergeWithNext")));
        this.menuAnnotation.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Annotation.MergeWithBefore")));
        this.menuAnnotation.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Annotation.RemoveAnnotationValue")));
        this.menuAnnotation.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Annotation.SplitAnnotation")));
        this.menuAnnotation.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Annotation.DeleteAnnotation")));
        ma = new MenuAction("Menu.Annotation.Delete");
        this.menuActions.put("Menu.Annotation.Delete", ma);
        JMenu delMenu = new JMenu(ma);
        this.menuAnnotation.add(delMenu);
        delMenu.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Annotation.DeleteAnnotationsInSelection")));
        delMenu.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Annotation.DeleteAnnotationsLeftOf")));
        delMenu.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Annotation.DeleteAnnotationsRightOf")));
        delMenu.addSeparator();
        delMenu.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Annotation.DeleteAllLeftOf")));
        delMenu.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Annotation.DeleteAllRightOf")));
        this.menuAnnotation.addSeparator();
        this.menuAnnotation.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Annotation.CopyAnnotation")));
        this.menuAnnotation.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Annotation.CopyAnnotationTree")));
        this.menuAnnotation.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Annotation.DuplicateAnnotation")));
        this.menuAnnotation.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Annotation.PasteAnnotation")));
        this.menuAnnotation.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Annotation.PasteAnnotationTree")));
        this.menuAnnotation.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Annotation.PasteAnnotationHere")));
        this.menuAnnotation.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Annotation.PasteAnnotationTreeHere")));
        this.menuAnnotation.addSeparator();
        ma = new MenuAction("Menu.Annotation.Shift");
        this.menuActions.put("Menu.Annotation.Shift", ma);
        JMenu shiftMenu = new JMenu(ma);
        this.menuAnnotation.add(shiftMenu);
        shiftMenu.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Annotation.ShiftActiveAnnotation")));
        shiftMenu.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Annotation.ShiftAnnotationsInSelection")));
        shiftMenu.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Annotation.ShiftAnnotationsLeftOf")));
        shiftMenu.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Annotation.ShiftAnnotationsRightOf")));
        shiftMenu.addSeparator();
        shiftMenu.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Annotation.ShiftAllLeftOf")));
        shiftMenu.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Annotation.ShiftAllRightOf")));
        this.menuAnnotation.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Annotation.ShiftAll")));
        this.menuTier.setEnabled(true);
        this.menuTier.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Tier.AddNewTier")));
        this.menuTier.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Tier.ChangeTier")));
        this.menuTier.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Tier.ReparentTier")));
        this.menuTier.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Tier.DeleteTier")));
        this.menuTier.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Tier.ImportTiers")));
        this.menuTier.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Tier.AddParticipant")));
        this.menuTier.addSeparator();
        this.menuTier.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Tier.Tokenize")));
        this.menuTier.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Tier.FilterTierDlg")));
        this.menuTier.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Tier.CopyTierDialog")));
        this.menuTier.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Tier.CopyAnnotationsOfTier")));
        this.menuTier.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Tier.MergeTiers")));
        this.menuTier.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Tier.MergeTiersClassic")));
        this.menuTier.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Tier.MergeTierGroup")));
        this.menuTier.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Tier.AnnotationsOnDependentTiers")));
        this.menuTier.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Tier.AnnotationsFromOverlaps")));
        this.menuTier.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Tier.AnnotationsFromOverlapsClas")));
        this.menuTier.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Tier.AnnotationsFromSubtraction")));
        this.menuTier.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Tier.AnnotationsFromGaps")));
        this.menuTier.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Tier.RegularAnnotation")));
        this.menuTier.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Tier.RemoveAnnotationsOrValues")));
        this.menuTier.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Tier.AnnotationValuesToTiers")));
        this.menuTier.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Tier.LabelAndNumber")));
        this.menuTier.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Tier.ChangeCase")));
        this.menuType.setEnabled(true);
        this.menuType.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Type.AddNewType")));
        this.menuType.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Type.ChangeType")));
        this.menuType.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Type.DeleteType")));
        this.menuType.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Type.ImportTypes")));
        this.menuActions.remove("Menu.Search.Find");
        this.searchMI.setAction(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Search.Find"), true);
        this.menuActions.remove("Menu.Search.GoTo");
        this.goToMI.setAction(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Search.GoTo"), true);
        this.menuActions.remove("Menu.View.Dependencies");
        this.tierDependenciesMI.setAction(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.View.Dependencies"), true);
        this.menuActions.remove("Menu.View.SpreadSheet");
        this.spreadsheetMI.setAction(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.View.SpreadSheet"), true);
        this.menuActions.remove("Menu.View.Statistics");
        this.statisticsMI.setAction(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.View.Statistics"), true);
        this.menuChangeTimePropMode.setEnabled(true);
        ButtonGroup timePropGroup = new ButtonGroup();
        JRadioButtonMenuItem normalModeMI = new JRadioButtonMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Options.NormalPropagationMode"));
        JRadioButtonMenuItem bulldozerModeMI = new JRadioButtonMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Options.BulldozerMode"));
        JRadioButtonMenuItem shiftModeMI = new JRadioButtonMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Options.ShiftMode"));
        timePropGroup.add(normalModeMI);
        normalModeMI.setSelected(true);
        timePropGroup.add(bulldozerModeMI);
        timePropGroup.add(shiftModeMI);
        this.menuChangeTimePropMode.add(normalModeMI);
        this.menuChangeTimePropMode.add(bulldozerModeMI);
        this.menuChangeTimePropMode.add(shiftModeMI);
        ButtonGroup modeGroup = new ButtonGroup();
        this.menuActions.remove("Menu.Options.AnnotationMode");
        this.menuItemAnnoMode.setAction(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Options.AnnotationMode"));
        this.menuItemAnnoMode.setEnabled(true);
        this.menuActions.remove("Menu.Options.SyncMode");
        this.menuItemSyncMode.setAction(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Options.SyncMode"));
        this.menuItemSyncMode.setEnabled(true);
        this.menuActions.remove("Menu.Options.TranscriptionMode");
        this.menuItemTranscMode.setAction(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Options.TranscriptionMode"));
        this.menuItemTranscMode.setEnabled(true);
        this.menuActions.remove("Menu.Options.SegmentationMode");
        this.menuItemSegmentMode.setAction(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Options.SegmentationMode"));
        this.menuItemSegmentMode.setEnabled(true);
        this.menuActions.remove("Menu.Options.InterlinearizationMode");
        this.menuItemInterLinearMode.setAction(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Options.InterlinearizationMode"));
        this.menuItemInterLinearMode.setEnabled(true);
        modeGroup.add(this.menuItemAnnoMode);
        modeGroup.add(this.menuItemSyncMode);
        modeGroup.add(this.menuItemTranscMode);
        modeGroup.add(this.menuItemSegmentMode);
        modeGroup.add(this.menuItemInterLinearMode);
        this.menuWebservices.setEnabled(true);
        this.menuWebservices.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "WebServicesDialog.WebService.WebLicht")));
        this.menuWebservices.add(new ElanMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "WebServicesDialog.WebService.TypeCraft")));
        this.menuFrameLength.setEnabled(true);
        ButtonGroup videoGroup = new ButtonGroup();
        JRadioButtonMenuItem palMI = new JRadioButtonMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Options.FrameLength.PAL"));
        JRadioButtonMenuItem pal50MI = new JRadioButtonMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Options.FrameLength.PAL50"));
        JRadioButtonMenuItem ntscMI = new JRadioButtonMenuItem(ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "Menu.Options.FrameLength.NTSC"));
        videoGroup.add(palMI);
        palMI.setSelected(true);
        videoGroup.add(pal50MI);
        videoGroup.add(ntscMI);
        this.menuFrameLength.add(palMI);
        this.menuFrameLength.add(pal50MI);
        this.menuFrameLength.add(ntscMI);
        this.updateLocale();
    }

    @Override
    public void updateLocale() {
        this.setFrameTitle();
        if (this.languageBG != null && this.languageBG.getButtonCount() > 0) {
            Enumeration<AbstractButton> en = this.languageBG.getElements();
            while (en.hasMoreElements()) {
                JRadioButtonMenuItem rbItem;
                AbstractButton item = en.nextElement();
                if (!(item instanceof JRadioButtonMenuItem) || !((rbItem = (JRadioButtonMenuItem)item).getAction() instanceof SetLocaleMA) || !((SetLocaleMA)rbItem.getAction()).getLocale().equals(ElanLocale.getLocale())) continue;
                rbItem.setSelected(true);
                break;
            }
        }
        for (MenuAction ma : this.menuActions.values()) {
            if (ma == null) continue;
            ma.updateLocale();
        }
    }

    protected void savePreferences() {
        if (this.viewerManager != null) {
            Preferences.set("MediaTime", this.viewerManager.getMasterMediaPlayer().getMediaTime(), this.transcriptionForThisFrame, false, false);
            Preferences.set("SelectionBeginTime", this.viewerManager.getSelection().getBeginTime(), this.transcriptionForThisFrame, false, false);
            Preferences.set("SelectionEndTime", this.viewerManager.getSelection().getEndTime(), this.transcriptionForThisFrame, false, false);
            Preferences.set("TimeScaleBeginTime", this.viewerManager.getTimeScale().getBeginTime(), this.transcriptionForThisFrame, false, true);
        }
        this.setPreference("Locale", ElanLocale.getLocale(), null);
        this.setPreference("FrameSize", this.getSize(), this.transcriptionForThisFrame);
        Preferences.set("FrameLocation", this.getLocation(), this.transcriptionForThisFrame, false, true);
    }

    public WaveFormViewerMenuManager getWaveFormViewerMenuManager() {
        return this.wfvMenuManager;
    }

    private void loadViewerPreferences() {
        Boolean boolPref = Preferences.getBool("Menu.View.Viewers.Grid", null);
        if (boolPref != null) {
            this.menuItemGridViewer.setSelected(boolPref);
        }
        if ((boolPref = Preferences.getBool("Menu.View.Viewers.Text", null)) != null) {
            this.menuItemTextViewer.setSelected(boolPref);
        }
        if ((boolPref = Preferences.getBool("Menu.View.Viewers.Subtitles", null)) != null) {
            this.menuItemSubtitleViewer.setSelected(boolPref);
        }
        if ((boolPref = Preferences.getBool("LexiconEntryViewer.Lexicon", null)) != null) {
            this.menuItemLexiconViewer.setSelected(boolPref);
        }
        if ((boolPref = Preferences.getBool("CommentViewer.Comment", null)) != null) {
            this.menuItemCommentViewer.setSelected(boolPref);
        }
        if ((boolPref = Preferences.getBool("Menu.View.Viewers.Recognizer", null)) != null) {
            this.menuItemRecognizer.setSelected(boolPref);
        }
        if ((boolPref = Preferences.getBool("Menu.View.Viewers.MetaData", null)) != null) {
            this.menuItemMetaDataViewer.setSelected(boolPref);
        }
        if ((boolPref = Preferences.getBool("Menu.View.Viewers.Signal", null)) != null) {
            this.menuItemSignalViewer.setSelected(boolPref);
        }
        if ((boolPref = Preferences.getBool("Menu.View.Viewers.Spectrogram", null)) != null) {
            this.menuItemSpectrogramViewer.setSelected(boolPref);
        }
        if ((boolPref = Preferences.getBool("Menu.View.Viewers.InterLinear", null)) != null) {
            this.menuItemInterLinearViewer.setSelected(boolPref);
        }
        if ((boolPref = Preferences.getBool("Menu.View.Viewers.TimeSeries", null)) != null) {
            this.menuItemTimeSeriesViewer.setSelected(boolPref);
        }
    }

    protected void loadPreferences() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Integer backupDelay;
                Boolean val;
                Long timeScaleBeginTime;
                Long mediaTime;
                Long beginTime = Preferences.getLong("SelectionBeginTime", ElanFrame2.this.transcriptionForThisFrame);
                Long endTime = Preferences.getLong("SelectionEndTime", ElanFrame2.this.transcriptionForThisFrame);
                if (beginTime != null && endTime != null) {
                    ElanFrame2.this.viewerManager.getSelection().setSelection(beginTime, endTime);
                }
                if ((mediaTime = Preferences.getLong("MediaTime", ElanFrame2.this.transcriptionForThisFrame)) != null) {
                    ElanFrame2.this.viewerManager.getMasterMediaPlayer().setMediaTime(mediaTime);
                }
                if ((timeScaleBeginTime = Preferences.getLong("TimeScaleBeginTime", ElanFrame2.this.transcriptionForThisFrame)) != null) {
                    ElanFrame2.this.viewerManager.getTimeScale().setBeginTime(timeScaleBeginTime);
                }
                if ((val = Preferences.getBool("MediaNavigation.FrameStepToFrameBegin", null)) != null) {
                    ElanFrame2.this.viewerManager.setFrameStepsToBeginOfFrame(val);
                }
                if ((backupDelay = Preferences.getInt("BackUpDelay", null)) != null && backupDelay > 0) {
                    Command c = ELANCommandFactory.createCommand(ElanFrame2.this.transcriptionForThisFrame, "CommandActions.Backup");
                    c.execute(ELANCommandFactory.getCommandAction(ElanFrame2.this.transcriptionForThisFrame, "CommandActions.Backup"), new Object[]{backupDelay});
                }
                ElanFrame2.this.fullyInitialized = true;
                if (ElanFrame2.this.layoutManager != null) {
                    ElanFrame2.this.layoutManager.doLayout();
                }
                Toolkit.getDefaultToolkit().sync();
            }
        });
    }

    private void loadCVPreferences() {
        if (this.transcriptionForThisFrame == null) {
            return;
        }
        Map<String, ?> cvPrefMap = Preferences.getMap("CV.ML.Prefs", this.transcriptionForThisFrame);
        if (cvPrefMap != null) {
            List<ControlledVocabulary> allCV = ((TranscriptionImpl)this.transcriptionForThisFrame).getControlledVocabularies();
            if (allCV == null) {
                return;
            }
            String color = "Color";
            String keyCode = "KeyCode";
            for (ControlledVocabulary cv : allCV) {
                Object cvMapObj = cvPrefMap.get(cv.getName());
                if (!(cvMapObj instanceof Map)) continue;
                Map cvMap = (Map)cvMapObj;
                for (CVEntry cve : cv) {
                    String id = cve.getId();
                    if (!cvMap.containsKey(id)) continue;
                    Map cveMap = (Map)cvMap.get(id);
                    if (cveMap.containsKey(color)) {
                        cve.setPrefColor((Color)cveMap.get(color));
                    }
                    if (!cveMap.containsKey(keyCode)) continue;
                    cve.setShortcutKeyCode((Integer)cveMap.get(keyCode));
                }
            }
        }
    }

    @Override
    public void setPreference(String key, Object value, Object document) {
        if (document instanceof Transcription) {
            Preferences.set(key, value, (Transcription)document, false, false);
        } else {
            Preferences.set(key, value, null, false, false);
        }
    }

    @Override
    public void preferencesChanged() {
        Float floatPref;
        Integer intPref;
        Boolean val;
        Locale savedLocale;
        Point p;
        Dimension d = Preferences.getDimension("FrameSize", this.transcriptionForThisFrame);
        if (d == null) {
            d = Preferences.getDimension("FrameSize", null);
        }
        Rectangle wRect = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        if (d != null) {
            if (d.width > wRect.width) {
                d.setSize(wRect.width, d.height);
            }
            if ((double)d.height > wRect.getHeight()) {
                d.setSize(d.width, wRect.height);
            }
            this.setSize(d);
        }
        if ((p = Preferences.getPoint("FrameLocation", this.transcriptionForThisFrame)) == null) {
            p = Preferences.getPoint("FrameLocation", null);
        }
        if (p != null) {
            if (p.x < wRect.x) {
                p.x = wRect.x;
            } else if (p.x > wRect.width - 30) {
                p.x = wRect.width - 30;
            }
            if (p.y < wRect.y) {
                p.y = wRect.y;
            } else if (p.y > wRect.height - 30) {
                p.y = wRect.height - 30;
            }
            this.setLocation(p);
        }
        if ((savedLocale = (Locale)Preferences.get("Locale", null)) != null) {
            ElanLocale.setLocale(savedLocale);
        }
        if (this.viewerManager != null && (val = Preferences.getBool("MediaNavigation.FrameStepToFrameBegin", null)) != null) {
            this.viewerManager.setFrameStepsToBeginOfFrame(val);
        }
        String stringPref = Preferences.getString("PlayAroundSelection.Mode", null);
        boolean msMode = true;
        if (stringPref != null && "frames".equals(stringPref)) {
            msMode = false;
        }
        if ((intPref = Preferences.getInt("PlayAroundSelection.Value", null)) != null && this.transcriptionForThisFrame != null) {
            int playaroundVal = intPref;
            if (!msMode) {
                playaroundVal = (int)((double)playaroundVal * this.viewerManager.getMasterMediaPlayer().getMilliSecondsPerSample());
                ((PlayAroundSelectionCA)ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "CommandActions.PlayAroundSelection")).setPlayAroundSelectionValue(playaroundVal);
            }
        }
        if ((floatPref = Preferences.getFloat("PlaybackRateToggleValue", null)) != null && this.transcriptionForThisFrame != null) {
            float rate = floatPref.floatValue();
            ((PlaybackRateToggleCA)ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "CommandActions.PlaybackRateToggle")).setToggleValue(rate);
        }
        if ((floatPref = Preferences.getFloat("PlaybackVolumeToggleValue", null)) != null && this.transcriptionForThisFrame != null) {
            float vol = floatPref.floatValue();
            ((PlaybackVolumeToggleCA)ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "CommandActions.PlaybackVolumeToggle")).setToggleValue(vol);
        }
        if ((intPref = Preferences.getInt("NumberOfBackUpFiles", null)) != null && this.transcriptionForThisFrame != null) {
            int nf = intPref;
            ((BackupCA)ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "CommandActions.Backup")).setNumBuFiles(nf);
        }
    }

    public void checkSaveAndClose() {
        if (this.transcriptionForThisFrame != null) {
            this.layoutManager.isClosing();
            if (this.transcriptionForThisFrame.isChanged()) {
                int response = JOptionPane.showConfirmDialog(null, ElanLocale.getString("Frame.ElanFrame.UnsavedData"), ElanLocale.getString("Message.Warning"), 1);
                if (response == 0) {
                    this.saveAndClose(true);
                } else {
                    if (response == 2 || response == -1) {
                        return;
                    }
                    this.doClose(true);
                }
            } else {
                this.doClose(true);
            }
        }
    }

    public void saveAndClose(boolean unregister) {
        if (unregister) {
            FrameManager.getInstance().closeFrame(this);
        }
        if (this.transcriptionForThisFrame != null && this.transcriptionForThisFrame.isChanged()) {
            boolean saveNewCopy = false;
            if (this.transcriptionForThisFrame.getName().equals("aishug294879ryshfda9763afo8947a5gf")) {
                saveNewCopy = true;
            }
            TranscriptionStore ets = ACMTranscriptionStore.getCurrentTranscriptionStore();
            StoreCommand storeComm = new StoreCommand("Commands.Store");
            if (this.viewerManager.getMultiTierControlPanel() != null) {
                storeComm.execute(this.transcriptionForThisFrame, new Object[]{ets, Boolean.FALSE, saveNewCopy, this.viewerManager.getMultiTierControlPanel().getVisibleTiers(), 0});
            } else {
                storeComm.execute(this.transcriptionForThisFrame, new Object[]{ets, Boolean.FALSE, saveNewCopy, new ArrayList(0)});
            }
            if (this.transcriptionForThisFrame.isChanged()) {
                System.out.println("Save (as) cancelled");
                return;
            }
        }
        this.doClose(unregister);
    }

    public void doClose(boolean unregister) {
        FrameManager.getInstance().fireWindowClosing(this, 0);
        if (this.transcriptionForThisFrame != null) {
            this.layoutManager.isClosing();
        }
        if (unregister) {
            FrameManager.getInstance().closeFrame(this);
        }
        if (MonitoringLogger.isInitiated() && this.viewerManager != null && this.viewerManager.getTranscription() != null) {
            MonitoringLogger.getLogger(this.viewerManager.getTranscription()).log(MonitoringLogger.CLOSE_FILE, new String[0]);
        }
        this.savePreferences();
        if (this.transcriptionForThisFrame != null) {
            BackupCA ca = (BackupCA)ELANCommandFactory.getCommandAction(this.transcriptionForThisFrame, "CommandActions.Backup");
            if (ca != null) {
                ca.stopBackUp();
            }
            if (this.viewerManager != null) {
                this.viewerManager.cleanUpOnClose();
            }
            if (this.layoutManager != null) {
                this.layoutManager.cleanUpOnClose();
            }
            ELANCommandFactory.removeDocument(this.viewerManager);
            Preferences.removeDocument(this.transcriptionForThisFrame);
            ElanLocale.removeElanLocaleListener(this.transcriptionForThisFrame);
            this.transcriptionForThisFrame = null;
            this.viewerManager = null;
            this.layoutManager = null;
        }
        this.setJMenuBar(null);
        this.menuBar = null;
        if (this.recentLanguagesMenuItem != null) {
            this.recentLanguagesMenuItem.isClosing();
        }
        FrameManager.getInstance().fireWindowClosing(this, 2);
        this.dispose();
        System.gc();
        System.runFinalization();
    }

    public void addActionToMenu(Action action, int menuId, int index) {
        if (action == null) {
            return;
        }
        JMenuItem mm = this.getMenuById(menuId);
        if (mm instanceof JMenu) {
            JMenu menu = (JMenu)mm;
            if (menu == this.menuWindow) {
                JRadioButtonMenuItem item = new JRadioButtonMenuItem(action);
                menu.add((Component)item, index);
                this.windowsGroup.add(item);
            } else if (menu == this.menuMediaPlayer) {
                JCheckBoxMenuItem item = new JCheckBoxMenuItem(action);
                menu.add((Component)item, index);
            } else if (menu == this.menuWaveform) {
                JRadioButtonMenuItem item = new JRadioButtonMenuItem(action);
                menu.add((Component)item, index);
                this.waveFormGroup.add(item);
            } else if (menu == this.menuRecentFiles) {
                JMenuItem item = new JMenuItem(action);
                if (action.getValue("LongDescription") != null && ((String)action.getValue("Name")).length() != ((String)action.getValue("LongDescription")).length()) {
                    item.setToolTipText((String)action.getValue("LongDescription"));
                }
                menu.add((Component)item, index);
            } else {
                JMenuItem item = new JMenuItem(action);
                menu.add((Component)item, index);
            }
        }
    }

    public Action removeActionFromMenu(String actionId, int menuId) {
        if (actionId == null) {
            return null;
        }
        JMenuItem mm = this.getMenuById(menuId);
        if (mm instanceof JMenu) {
            JMenu menu = (JMenu)mm;
            for (int i = 0; i < menu.getMenuComponentCount(); ++i) {
                JMenuItem item;
                Action ac;
                Component mi = menu.getMenuComponent(i);
                if (!(mi instanceof JMenuItem) || (ac = (item = (JMenuItem)mi).getAction()) == null || !actionId.equals(ac.getValue("LongDescription"))) continue;
                menu.remove(item);
                if (menu == this.menuWindow) {
                    this.windowsGroup.remove(item);
                } else if (menu == this.menuWaveform) {
                    this.waveFormGroup.remove(item);
                }
                return ac;
            }
        }
        return null;
    }

    public void setMenuSelected(String actionId, int menuId) {
        if (actionId == null) {
            return;
        }
        JMenuItem mm = this.getMenuById(menuId);
        if (mm instanceof JMenu) {
            JMenu menu = (JMenu)mm;
            for (int i = 0; i < menu.getMenuComponentCount(); ++i) {
                JCheckBoxMenuItem chItem;
                Action ac;
                Component mi = menu.getMenuComponent(i);
                if (mi instanceof JRadioButtonMenuItem) {
                    JRadioButtonMenuItem item = (JRadioButtonMenuItem)mi;
                    ac = item.getAction();
                    if (ac == null || !actionId.equals(ac.getValue("LongDescription"))) continue;
                    item.setSelected(true);
                    continue;
                }
                if (!(mi instanceof JCheckBoxMenuItem) || (ac = (chItem = (JCheckBoxMenuItem)mi).getAction()) == null || !actionId.equals(ac.getValue("LongDescription"))) continue;
                chItem.setSelected(true);
            }
        }
    }

    public void setMenuEnabled(int menuId, boolean enabled) {
        JMenuItem menu = this.getMenuById(menuId);
        if (menu != null) {
            menu.setEnabled(enabled);
        }
    }

    public void updateMenu(int menuId) {
        if (menuId == 610) {
            this.pvMenuManager.reinitializePlayerMenu();
        } else if (menuId == 630) {
            this.wfvMenuManager.reinitializeWaveFormMenu();
        }
    }

    public void enableOrDisableMenus(List<String> actionIdList, int menuId, boolean enabled) {
        JMenuItem mm = this.getMenuById(menuId);
        if (mm instanceof JMenu) {
            JMenu menu = (JMenu)mm;
            if (actionIdList == null) {
                menu.setEnabled(enabled);
                return;
            }
            for (int i = 0; i < menu.getMenuComponentCount(); ++i) {
                String ca;
                JMenuItem item;
                Action ac;
                Component mi = menu.getMenuComponent(i);
                if (!(mi instanceof JMenuItem) || !((ac = (item = (JMenuItem)mi).getAction()) != null & (ca = item.getActionCommand()) != null) || !actionIdList.contains(ca)) continue;
                item.setEnabled(enabled);
                ac.setEnabled(enabled);
            }
        }
    }

    public void enableCommands(boolean enable) {
        ActionMap menuMap = this.menuBar.getActionMap();
        if (menuMap != null) {
            for (Object key : this.registeredActions.keySet()) {
                this.registeredActions.get(key).setEnabled(enable);
            }
        }
    }

    protected JMenuItem getMenuById(int id) {
        switch (id) {
            case 0: {
                return this.menuFile;
            }
            case 100: {
                return this.menuEdit;
            }
            case 200: {
                return this.menuAnnotation;
            }
            case 300: {
                return this.menuTier;
            }
            case 400: {
                return this.menuType;
            }
            case 500: {
                return this.menuSearch;
            }
            case 600: {
                return this.menuView;
            }
            case 700: {
                return this.menuOptions;
            }
            case 800: {
                return this.menuWindow;
            }
            case 900: {
                return this.menuHelp;
            }
            case 11: {
                return this.menuRecentFiles;
            }
            case 12: {
                return this.menuExport;
            }
            case 13: {
                return this.menuImport;
            }
            case 760: {
                return this.menuAppLanguage;
            }
            case 701: {
                return this.menuChangeTimePropMode;
            }
            case 740: {
                return this.menuFrameLength;
            }
            case 710: {
                return this.menuItemAnnoMode;
            }
            case 711: {
                return this.menuItemSyncMode;
            }
            case 712: {
                return this.menuItemKioskMode;
            }
            case 713: {
                return this.menuItemPlayAround;
            }
            case 714: {
                return this.menuItemRateVol;
            }
            case 610: {
                return this.menuMediaPlayer;
            }
            case 630: {
                return this.menuWaveform;
            }
        }
        return null;
    }

    public boolean isFullyInitialized() {
        return this.fullyInitialized;
    }

    public void macHandleQuit() {
        FrameManager.getInstance().exit();
    }

    public void macHandleAbout() {
        if (this.menuActions != null) {
            MenuAction ma2 = null;
            for (MenuAction ma2 : this.menuActions.values()) {
                if (!(ma2 instanceof AboutMA)) continue;
                ma2.actionPerformed(null);
                break;
            }
        }
    }

    public void macHandlePreferences() {
        MenuAction ma2 = null;
        if (this.menuActions != null) {
            for (MenuAction ma2 : this.menuActions.values()) {
                if (!(ma2 instanceof EditPreferencesMA)) continue;
                ma2.actionPerformed(null);
                break;
            }
        }
        if (!(ma2 instanceof EditPreferencesMA)) {
            EditPreferencesMA ma2 = new EditPreferencesMA("Menu.Edit.Preferences.Edit", this);
            ((MenuAction)ma2).actionPerformed(null);
        }
    }

    public void finalize() throws Throwable {
        System.out.println("Finalize ELAN window...");
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    static {
        if (System.getProperty("os.name").indexOf("Mac") > -1) {
            JTextComponent.KeyBinding[] bind = new JTextComponent.KeyBinding[]{new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), "copy-to-clipboard"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(88, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), "cut-to-clipboard"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(86, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), "paste-from-clipboard"), new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(65, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), "select-all")};
            JTextField comp = new JTextField();
            Keymap map = JTextComponent.getKeymap("default");
            JTextComponent.loadKeymap(map, bind, ((JTextComponent)comp).getActions());
        }
    }

    private class ElanFrameWindowListener
    extends WindowAdapter
    implements ComponentListener {
        private ElanFrameWindowListener() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            if (ElanFrame2.this.transcriptionForThisFrame != null) {
                ElanFrame2.this.checkSaveAndClose();
            } else {
                ElanFrame2.this.doClose(true);
            }
        }

        @Override
        public void windowActivated(WindowEvent e) {
            FrameManager.getInstance().frameActivated(ElanFrame2.this);
        }

        @Override
        public void componentHidden(ComponentEvent e) {
        }

        @Override
        public void componentMoved(ComponentEvent e) {
            if (ElanFrame2.this.transcriptionForThisFrame != null) {
                Preferences.set("FrameLocation", ElanFrame2.this.getLocation(), ElanFrame2.this.transcriptionForThisFrame, false, false);
            } else {
                Preferences.set("FrameLocation", ElanFrame2.this.getLocation(), null, false, false);
            }
        }

        @Override
        public void componentResized(ComponentEvent e) {
            if (ElanFrame2.this.transcriptionForThisFrame != null) {
                Preferences.set("FrameSize", ElanFrame2.this.getSize(), ElanFrame2.this.transcriptionForThisFrame, false, false);
            } else {
                Preferences.set("FrameSize", ElanFrame2.this.getSize(), null, false, false);
            }
        }

        @Override
        public void componentShown(ComponentEvent e) {
        }
    }
}

