/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator;

import java.awt.Component;
import java.awt.Container;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JSplitPane;
import javax.swing.ToolTipManager;
import mpi.eudico.client.annotator.ElanFrame2;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.ElanLocaleListener;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.PreferencesUser;
import mpi.eudico.client.annotator.ViewerManager2;
import mpi.eudico.client.annotator.Zoomable;
import mpi.eudico.client.annotator.commands.CommandAction;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.layout.AnnotationManager;
import mpi.eudico.client.annotator.layout.InterlinearizationManager;
import mpi.eudico.client.annotator.layout.ModeLayoutManager;
import mpi.eudico.client.annotator.layout.PlayerLayoutModel;
import mpi.eudico.client.annotator.layout.SegmentationManager;
import mpi.eudico.client.annotator.layout.SyncManager;
import mpi.eudico.client.annotator.layout.TranscriptionManager;
import mpi.eudico.client.annotator.layout.TurnsAndSceneManager;
import mpi.eudico.client.annotator.player.ElanMediaPlayer;
import mpi.eudico.client.annotator.viewer.AbstractViewer;
import mpi.eudico.client.annotator.viewer.InterlinearViewer;
import mpi.eudico.client.annotator.viewer.MultiTierControlPanel;
import mpi.eudico.client.annotator.viewer.MultiTierViewer;
import mpi.eudico.client.annotator.viewer.SignalViewer;
import mpi.eudico.client.annotator.viewer.TimeLineViewer;
import mpi.eudico.client.annotator.viewer.TimeSeriesViewer;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;

public class ElanLayoutManager
implements ElanLocaleListener,
PreferencesUser {
    public static final int SYNC_MODE = 0;
    public static final int NORMAL_MODE = 1;
    public static final int TRANSC_MODE = 2;
    public static final int SEGMENT_MODE = 3;
    public static final int INTERLINEAR_MODE = 4;
    public static final int TURN_SCENE_MODE = 5;
    public static final int MASTER_MEDIA_WIDTH = 352;
    private final int MIN_MEDIA_WIDTH = 80;
    public static final int MASTER_MEDIA_HEIGHT = 250;
    private final int MIN_MEDIA_HEIGHT = 40;
    public static final int CONTROL_PANEL_WIDTH = 120;
    public static final int CONTAINER_MARGIN = 3;
    public static final int BELOW_BUTTONS_MARGIN = 8;
    public static final int DEF_SIGNAL_HEIGHT = 70;
    private ElanFrame2 elanFrame;
    private Container container;
    private ViewerManager2 viewerManager;
    private int mode = -1;
    private int mediaAreaWidth = 352;
    private int mediaAreaHeight = 250;
    private int multiTierControlPanelWidth = 120;
    private boolean permanentDetached;
    private List<PlayerLayoutModel> playerList;
    private SignalViewer signalViewer;
    private TimeSeriesViewer timeseriesViewer;
    private ModeLayoutManager activeManager;
    private boolean initialized;

    public ElanLayoutManager(ElanFrame2 elanFrame, ViewerManager2 viewerManager) {
        this.elanFrame = elanFrame;
        this.container = elanFrame.getContentPane();
        this.viewerManager = viewerManager;
        this.playerList = new ArrayList<PlayerLayoutModel>(8);
        ElanLocale.addElanLocaleListener(viewerManager.getTranscription(), this);
        this.container.setLayout(null);
        this.container.addComponentListener(new ContainerComponentListener());
        Boolean permDetached = Preferences.getBool("PreferredMediaWindow", null);
        if (permDetached == null) {
            permDetached = Boolean.FALSE;
        }
        this.permanentDetached = permDetached;
        if (!System.getProperty("os.name").startsWith("Mac OS")) {
            this.permanentDetached = false;
        }
    }

    @Override
    public void updateLocale() {
        if (this.activeManager != null) {
            this.activeManager.updateLocale();
            if (this.mode != 1) {
                this.doLayout();
            }
        }
    }

    public void add(Object object) {
        if (object instanceof ElanMediaPlayer) {
            this.addMediaPlayer((ElanMediaPlayer)object);
        } else if (object instanceof SignalViewer) {
            this.signalViewer = (SignalViewer)object;
            if (this.activeManager != null) {
                this.activeManager.add(this.signalViewer);
            }
        } else if (object instanceof TimeSeriesViewer) {
            if (this.timeseriesViewer == null) {
                this.timeseriesViewer = (TimeSeriesViewer)object;
            }
            if (this.activeManager != null) {
                this.activeManager.createAndAddViewer("Menu.View.Viewers.TimeSeries");
            }
        } else if (this.activeManager != null) {
            this.activeManager.add(object);
        }
    }

    public void remove(Object object) {
        if (object instanceof ElanMediaPlayer) {
            this.removeMediaPlayer((ElanMediaPlayer)object);
        } else if (object instanceof SignalViewer) {
            if (this.activeManager != null) {
                this.activeManager.remove(object);
            }
            this.signalViewer = null;
            this.doLayout();
        } else if (this.activeManager != null) {
            this.activeManager.remove(object);
        }
    }

    public void updateViewer(String viewerName, boolean createViewer) {
        if (viewerName == null) {
            return;
        }
        if (this.activeManager != null) {
            if (createViewer) {
                this.activeManager.createAndAddViewer(viewerName);
                if (viewerName.equals("Menu.View.Viewers.Signal")) {
                    this.signalViewer = this.viewerManager.getSignalViewer();
                }
            } else {
                boolean doLayout = this.activeManager.destroyAndRemoveViewer(viewerName);
                if (viewerName.equals("Menu.View.Viewers.Signal")) {
                    this.signalViewer = null;
                }
                if (doLayout) {
                    this.doLayout();
                }
            }
        }
    }

    public void hide(Object object) {
    }

    private void addMediaPlayer(ElanMediaPlayer player) {
        Float ar;
        if (player == null) {
            return;
        }
        player.setLayoutManager(this);
        PlayerLayoutModel plModel = new PlayerLayoutModel(player, this);
        this.playerList.add(plModel);
        if (this.permanentDetached) {
            plModel.detach();
        }
        if (plModel.isVisual() && plModel.isAttached()) {
            this.container.add(plModel.visualComponent);
        }
        if (player.getMediaDescriptor() != null && (ar = Preferences.getFloat("AspectRatio(" + player.getMediaDescriptor().mediaURL + ")", this.viewerManager.getTranscription())) != null) {
            player.setAspectRatio(ar.floatValue());
        }
        if (player.getAspectRatio() == -1.0f) {
            plModel.visualComponent.setBounds(0, 0, 1, 1);
            plModel.visualComponent = null;
        }
        this.doLayout();
    }

    private void removeMediaPlayer(ElanMediaPlayer player) {
        if (player == null) {
            return;
        }
        PlayerLayoutModel plModel = null;
        for (int i = 0; i < this.playerList.size(); ++i) {
            plModel = this.playerList.get(i);
            if (plModel.player == player) break;
        }
        if (plModel == null) {
            return;
        }
        if (plModel.isVisual()) {
            if (plModel.isAttached()) {
                this.container.remove(plModel.visualComponent);
            } else {
                plModel.attach();
            }
        }
        this.playerList.remove(plModel);
        if (this.activeManager != null) {
            this.activeManager.remove(plModel);
        }
        this.doLayout();
    }

    public void detach(Object object) {
        block5: {
            block3: {
                block4: {
                    if (!(object instanceof AbstractViewer)) break block3;
                    if (this.mode != 1 || !(this.activeManager instanceof AnnotationManager)) break block4;
                    this.activeManager.detach(object);
                    break block5;
                }
                if (this.mode != 0 || !(this.activeManager instanceof SyncManager)) break block5;
                this.activeManager.detach(object);
                break block5;
            }
            if (object instanceof Component) {
                for (int i = 0; i < this.playerList.size(); ++i) {
                    PlayerLayoutModel model = this.playerList.get(i);
                    if (model.visualComponent != object) continue;
                    if (!model.isVisual() || !model.isAttached() || model.isSyncOnly() && this.mode == 0) break;
                    this.container.remove(model.visualComponent);
                    model.detach();
                    if (this.activeManager != null) {
                        this.activeManager.detach(model);
                    }
                    this.doLayout();
                    break;
                }
            }
        }
    }

    public void attach(Object object) {
        block4: {
            block3: {
                if (!(object instanceof AbstractViewer)) break block3;
                if (this.mode != 1 || !(this.activeManager instanceof AnnotationManager)) break block4;
                this.activeManager.attach(object);
                break block4;
            }
            if (object instanceof Component) {
                for (int i = 0; i < this.playerList.size(); ++i) {
                    PlayerLayoutModel model = this.playerList.get(i);
                    if (model.visualComponent != object) continue;
                    if (!model.isVisual() || model.isAttached()) break;
                    model.attach();
                    this.container.add(model.visualComponent);
                    if (this.mode == 0 && this.activeManager instanceof SyncManager) {
                        this.activeManager.attach(model);
                    }
                    this.doLayout();
                    if ((this.mode != 2 || !(this.activeManager instanceof TranscriptionManager)) && (this.mode != 5 || !(this.activeManager instanceof TurnsAndSceneManager))) break;
                    this.activeManager.attach(model);
                    break;
                }
            }
        }
    }

    public void setFirstPlayer(ElanMediaPlayer player) {
        if (player == null) {
            return;
        }
        for (int i = 0; i < this.playerList.size(); ++i) {
            PlayerLayoutModel model = this.playerList.get(i);
            if (model.player == player) {
                model.setDisplayedFirst(true);
                continue;
            }
            model.setDisplayedFirst(false);
        }
        this.doLayout();
    }

    public SignalViewer getSignalViewer() {
        return this.signalViewer;
    }

    public Container getContainer() {
        return this.container;
    }

    public TimeLineViewer getTimeLineViewer() {
        if (this.mode == 1 && this.activeManager instanceof AnnotationManager) {
            return ((AnnotationManager)this.activeManager).getTimeLineViewer();
        }
        return null;
    }

    public InterlinearViewer getInterlinearViewer() {
        if (this.mode == 1 && this.activeManager instanceof AnnotationManager) {
            return ((AnnotationManager)this.activeManager).getInterlinearViewer();
        }
        return null;
    }

    public TimeSeriesViewer getTimeSeriesViewer() {
        return this.timeseriesViewer;
    }

    public MultiTierControlPanel getMultiTierControlPanel() {
        if (this.mode == 1 && this.activeManager instanceof AnnotationManager) {
            return ((AnnotationManager)this.activeManager).getMultiTierControlPanel();
        }
        return null;
    }

    public MultiTierViewer getVisibleMultiTierViewer() {
        if (this.mode == 1 && this.activeManager instanceof AnnotationManager) {
            return ((AnnotationManager)this.activeManager).getVisibleMultiTierViewer();
        }
        return null;
    }

    public void showTimeLineViewer() {
        if (this.mode == 1 && this.activeManager instanceof AnnotationManager) {
            ((AnnotationManager)this.activeManager).showTimeLineViewer();
        }
    }

    public void showInterlinearViewer() {
        if (this.mode == 1 && this.activeManager instanceof AnnotationManager) {
            ((AnnotationManager)this.activeManager).showInterlinearViewer();
        }
    }

    public void changeMode(int mode) {
        if (this.mode == mode || this.mode == 5) {
            return;
        }
        if (!this.initialized) {
            this.loadMediaSizePreferences();
        }
        if (this.viewerManager.getMasterMediaPlayer() != null && this.viewerManager.getMasterMediaPlayer().isPlaying()) {
            this.viewerManager.getMasterMediaPlayer().stop();
        }
        if (this.activeManager != null) {
            this.elanFrame.clearShortcutsMap(this.getModeConstant(this.mode));
            this.activeManager.enableOrDisableMenus(true);
            this.activeManager.isClosing();
            this.activeManager.clearLayout();
        }
        this.activeManager = this.createManagerInstance(mode);
        if (this.activeManager != null) {
            this.mode = mode;
            this.elanFrame.updateShortcutMap(this.getModeConstant(mode));
            this.activeManager.initComponents();
            this.activeManager.enableOrDisableMenus(false);
            this.activeManager.shortcutsChanged();
            this.updateDetachedWindowsShortcuts();
            if (mode != 5) {
                this.setPreference("LayoutManager.CurrentMode", this.mode, this.viewerManager.getTranscription());
            }
            this.doLayout();
        }
    }

    public void shortcutsChanged() {
        this.elanFrame.updateShortcutMap(this.getModeConstant(this.mode));
        if (this.activeManager != null) {
            this.activeManager.shortcutsChanged();
        }
        this.updateDetachedWindowsShortcuts();
    }

    private void updateDetachedWindowsShortcuts() {
        PlayerLayoutModel model = null;
        for (int i = 0; i < this.playerList.size(); ++i) {
            model = this.playerList.get(i);
            if (!model.isVisual() || model.isAttached()) continue;
            model.detachedFrame.updateShortcuts();
        }
    }

    public String getModeConstant(int modeId) {
        String modeName = null;
        switch (modeId) {
            case 0: {
                modeName = "Menu.Options.SyncMode";
                break;
            }
            case 2: {
                modeName = "Menu.Options.TranscriptionMode";
                break;
            }
            case 3: {
                modeName = "Menu.Options.SegmentationMode";
                break;
            }
            case 4: {
                modeName = "Menu.Options.InterlinearizationMode";
                break;
            }
            case 5: {
                modeName = "Menu.Options.TurnsAndSceneMode";
                break;
            }
            default: {
                modeName = "Menu.Options.AnnotationMode";
            }
        }
        return modeName;
    }

    private ModeLayoutManager createManagerInstance(int mode) {
        this.activeManager = null;
        switch (mode) {
            case 1: {
                this.activeManager = new AnnotationManager(this.viewerManager, this);
                break;
            }
            case 0: {
                this.activeManager = new SyncManager(this.viewerManager, this);
                break;
            }
            case 2: {
                this.activeManager = new TranscriptionManager(this.viewerManager, this);
                break;
            }
            case 3: {
                this.activeManager = new SegmentationManager(this.viewerManager, this);
                break;
            }
            case 4: {
                this.activeManager = new InterlinearizationManager(this.viewerManager, this);
                break;
            }
            case 5: {
                this.activeManager = new TurnsAndSceneManager(this.viewerManager, this);
            }
        }
        return this.activeManager;
    }

    public int getMode() {
        return this.mode;
    }

    public void connectAllPlayers() {
        if (this.mode == 0 && this.activeManager instanceof SyncManager) {
            ((SyncManager)this.activeManager).reconnect();
        }
    }

    public void doLayout() {
        if (this.isIntialized() && this.activeManager != null) {
            this.activeManager.doLayout();
        }
    }

    public boolean containsComponent(Component component) {
        Component[] components = this.container.getComponents();
        for (int i = 0; i < components.length; ++i) {
            if (components[i] != component) continue;
            return true;
        }
        return false;
    }

    public List<MediaDescriptor> getVisualPlayers() {
        ArrayList<MediaDescriptor> visuals = new ArrayList<MediaDescriptor>(this.playerList.size());
        PlayerLayoutModel model = null;
        for (int i = 0; i < this.playerList.size(); ++i) {
            model = this.playerList.get(i);
            if (!model.isVisual()) continue;
            visuals.add(model.player.getMediaDescriptor());
        }
        return visuals;
    }

    public void cleanUpOnClose() {
        this.container.removeAll();
        if (this.activeManager != null) {
            this.activeManager.cleanUpOnClose();
        }
        this.setPreference("LayoutManager.CurrentMode", this.mode, this.viewerManager.getTranscription());
        for (int i = 0; i < this.playerList.size(); ++i) {
            PlayerLayoutModel model = this.playerList.get(i);
            if (!model.isVisual() || model.isAttached() || model.detachedFrame == null) continue;
            model.detachedFrame.getContentPane().remove(model.visualComponent);
            model.detachedFrame.resetShortcutMaps();
            model.detachedFrame.setVisible(false);
            model.detachedFrame.dispose();
            model.detachedFrame = null;
        }
        this.container = null;
        this.viewerManager = null;
        this.elanFrame = null;
    }

    public void isClosing() {
        if (this.activeManager != null) {
            this.activeManager.isClosing();
        }
    }

    public JFrame getElanFrame() {
        return this.elanFrame;
    }

    public ViewerManager2 getViewerManager() {
        return this.viewerManager;
    }

    public void enableOrDisableActions(List<String> actionList, boolean enabled) {
        for (int i = 0; i < actionList.size(); ++i) {
            CommandAction ca = ELANCommandFactory.getCommandAction(this.viewerManager.getTranscription(), actionList.get(i));
            if (ca == null) continue;
            ca.setEnabled(enabled);
        }
    }

    public int getMediaAreaHeight() {
        return this.mediaAreaHeight;
    }

    public int getMediaAreaWidth() {
        return this.mediaAreaWidth;
    }

    public boolean isIntialized() {
        return this.initialized;
    }

    public boolean isAttached(ElanMediaPlayer player) {
        PlayerLayoutModel model = null;
        for (int i = 0; i < this.playerList.size(); ++i) {
            model = this.playerList.get(i);
            if (model.player != player) continue;
            return model.isAttached();
        }
        return false;
    }

    public PlayerLayoutModel[] getAttachedVisualPlayers() {
        ArrayList<PlayerLayoutModel> plList = new ArrayList<PlayerLayoutModel>(this.playerList.size());
        PlayerLayoutModel model = null;
        for (int i = 0; i < this.playerList.size(); ++i) {
            model = this.playerList.get(i);
            if (!model.isVisual() || !model.isAttached()) continue;
            if (model.isDisplayedFirst()) {
                plList.add(0, model);
                continue;
            }
            plList.add(model);
        }
        return plList.toArray(new PlayerLayoutModel[0]);
    }

    public void setMediaAreaWidth(int mediaAreaWidth) {
        this.mediaAreaWidth = mediaAreaWidth >= 80 ? (mediaAreaWidth < this.container.getWidth() - 100 ? mediaAreaWidth : this.container.getWidth() - 100) : 80;
        this.setPreference("LayoutManager.MediaAreaWidth", this.mediaAreaWidth, this.viewerManager.getTranscription());
        this.doLayout();
    }

    public void setMediaAreaHeight(int mediaAreaHeight) {
        this.mediaAreaHeight = mediaAreaHeight >= 40 ? (mediaAreaHeight < this.container.getHeight() - 100 ? mediaAreaHeight : this.container.getHeight() - 100) : 40;
        this.setPreference("LayoutManager.MediaAreaHeight", this.mediaAreaHeight, this.viewerManager.getTranscription());
        this.doLayout();
    }

    public List<PlayerLayoutModel> getPlayerList() {
        return this.playerList;
    }

    public int getMultiTierControlPanelWidth() {
        return this.multiTierControlPanelWidth;
    }

    public void setMultiTierControlPanelWidth(int multiTierControlPanelWidth) {
        this.multiTierControlPanelWidth = multiTierControlPanelWidth >= 40 ? (multiTierControlPanelWidth < this.container.getWidth() - 50 ? multiTierControlPanelWidth : this.container.getWidth() - 50) : 40;
        this.setPreference("LayoutManager.ControlPanelWidth", this.multiTierControlPanelWidth, this.viewerManager.getTranscription());
        this.doLayout();
    }

    @Override
    public void setPreference(String key, Object value, Object document) {
        if (document instanceof Transcription) {
            Preferences.set(key, value, (Transcription)document, false, false);
        } else {
            Preferences.set(key, value, null, false, false);
        }
    }

    private void loadMediaSizePreferences() {
        Integer medWidth;
        Rectangle wRect = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        Integer medHeight = Preferences.getInt("LayoutManager.MediaAreaHeight", this.viewerManager.getTranscription());
        if (medHeight != null && medHeight >= 40) {
            this.mediaAreaHeight = medHeight;
            if (this.mediaAreaHeight > wRect.height - 120) {
                this.mediaAreaHeight = wRect.height - 120;
            }
        }
        if ((medWidth = Preferences.getInt("LayoutManager.MediaAreaWidth", this.viewerManager.getTranscription())) != null && medWidth >= 80) {
            this.mediaAreaWidth = medWidth;
            if (this.mediaAreaWidth > wRect.width - 120) {
                this.mediaAreaWidth = wRect.width - 120;
            }
        }
    }

    @Override
    public void preferencesChanged() {
        this.loadMediaSizePreferences();
        Integer cpWidth = Preferences.getInt("LayoutManager.ControlPanelWidth", this.viewerManager.getTranscription());
        if (cpWidth != null && cpWidth >= 40) {
            this.multiTierControlPanelWidth = cpWidth;
        }
        Boolean ttShown = Preferences.getBool("UI.ToolTips.Enabled", null);
        Integer lastMode = Preferences.getInt("LayoutManager.CurrentMode", this.viewerManager.getTranscription());
        if (lastMode != null && this.mode != lastMode) {
            this.changeMode(lastMode);
            if (lastMode == this.mode) {
                ((ElanFrame2)this.getElanFrame()).setMenuSelected(ElanLocale.getString(this.getModeConstant(lastMode)), 700);
            }
        }
        if (ttShown != null) {
            ToolTipManager.sharedInstance().setEnabled(ttShown);
        }
        if (this.activeManager != null) {
            this.activeManager.preferencesChanged();
        }
        this.initialized = true;
        this.doLayout();
    }

    public List<Zoomable> getZoomableViewers() {
        if (this.activeManager != null) {
            return this.activeManager.getZoomableViewers();
        }
        return null;
    }

    class ContainerComponentListener
    extends ComponentAdapter {
        ContainerComponentListener() {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            ElanLayoutManager.this.doLayout();
        }
    }

    public class SignalSplitPaneListener
    extends ComponentAdapter {
        @Override
        public void componentResized(ComponentEvent e) {
            if (e == null || e.getComponent() == null) {
                return;
            }
            JSplitPane splitPane = null;
            if (e.getComponent().getParent() instanceof JSplitPane) {
                splitPane = (JSplitPane)e.getComponent().getParent();
            }
            if (splitPane == null) {
                return;
            }
            if (splitPane != null) {
                Component bottom;
                Component top = splitPane.getTopComponent();
                if (top instanceof JSplitPane && ((JSplitPane)top).getBottomComponent() != null) {
                    top = ((JSplitPane)top).getBottomComponent();
                }
                if (top != null && top instanceof Container) {
                    int height = top.getHeight();
                    Component[] cc = ((Container)top).getComponents();
                    for (int i = 0; i < cc.length; ++i) {
                        if (cc[i].getHeight() == height) continue;
                        cc[i].setSize(cc[i].getWidth(), height);
                    }
                }
                if ((bottom = splitPane.getBottomComponent()) != null && bottom instanceof Container) {
                    int height = splitPane.getHeight() - splitPane.getDividerLocation() - splitPane.getDividerSize();
                    Component[] cc = ((Container)bottom).getComponents();
                    for (int i = 0; i < cc.length; ++i) {
                        if (cc[i].getHeight() == height) continue;
                        cc[i].setSize(cc[i].getWidth(), height);
                    }
                }
            }
        }
    }
}

