/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanLocaleListener;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.search.SearchLocale;

public class ElanLocale {
    private static Locale locale;
    private static ResourceBundle resourcebundle;
    private static Map<Object, List<ElanLocaleListener>> listenerGroups;
    public static final Locale CUSTOM;
    public static final Locale DUTCH;
    public static final Locale ENGLISH;
    public static final Locale CATALAN;
    public static final Locale SPANISH;
    public static final Locale SWEDISH;
    public static final Locale GERMAN;
    public static final Locale PORTUGUESE;
    public static final Locale BRAZILIAN_PORTUGUESE;
    public static final Locale FRENCH;
    public static final Locale JAPANESE;
    public static final Locale CHINESE_SIMP;
    public static final Locale RUSSIAN;
    public static final Locale KOREAN;

    ElanLocale() {
        locale = Locale.getDefault();
        resourcebundle = ResourceBundle.getBundle("mpi.eudico.client.annotator.resources.ElanLanguage", locale);
    }

    public static Locale getLocale() {
        return locale;
    }

    public static void setLocale(Locale locale_in) {
        FileInputStream stream;
        File custFile;
        block12: {
            if (locale != null && locale.equals(locale_in)) {
                return;
            }
            locale = locale_in;
            if (locale.equals(CUSTOM)) {
                try {
                    custFile = new File(Constants.ELAN_DATA_DIR + Constants.FILESEPARATOR + "ElanLanguage.properties");
                    if (custFile.exists()) {
                        stream = new FileInputStream(custFile);
                        resourcebundle = new PropertyResourceBundle(stream);
                        stream.close();
                        break block12;
                    }
                    ClientLogger.LOG.warning("No custom localisation file found.");
                    resourcebundle = ResourceBundle.getBundle("mpi.eudico.client.annotator.resources.ElanLanguage");
                }
                catch (Exception ex) {
                    ClientLogger.LOG.warning("Could not load custom localisation file: " + ex.getMessage());
                    resourcebundle = ResourceBundle.getBundle("mpi.eudico.client.annotator.resources.ElanLanguage");
                }
            } else {
                resourcebundle = ResourceBundle.getBundle("mpi.eudico.client.annotator.resources.ElanLanguage", locale);
            }
        }
        ElanLocale.notifyListeners();
        try {
            if (!locale.equals(CUSTOM)) {
                SearchLocale.setLocale(locale);
            } else {
                custFile = new File(Constants.ELAN_DATA_DIR + Constants.FILESEPARATOR + "SearchLanguage.properties");
                if (custFile.exists()) {
                    stream = new FileInputStream(custFile);
                    PropertyResourceBundle resBundle = new PropertyResourceBundle(stream);
                    stream.close();
                    SearchLocale.setResourceBundle(resBundle);
                } else {
                    ClientLogger.LOG.warning("No custom search localisation file found.");
                    SearchLocale.setLocale(locale);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getString(String str) {
        if (locale == null) {
            locale = Locale.getDefault();
            resourcebundle = ResourceBundle.getBundle("mpi.eudico.client.annotator.resources.ElanLanguage", locale);
        }
        try {
            return resourcebundle.getString(str);
        }
        catch (Exception ex) {
            return "";
        }
    }

    public static void addElanLocaleListener(Object key, ElanLocaleListener listener) {
        if (listenerGroups.containsKey(key)) {
            listenerGroups.get(key).add(listener);
            listener.updateLocale();
        } else {
            ArrayList<ElanLocaleListener> list = new ArrayList<ElanLocaleListener>();
            list.add(listener);
            listenerGroups.put(key, list);
            listener.updateLocale();
        }
    }

    public static void removeElanLocaleListener(ElanLocaleListener listener) {
        List<ElanLocaleListener> listeners;
        Iterator<Object> groupIt = listenerGroups.keySet().iterator();
        while (groupIt.hasNext() && !(listeners = listenerGroups.get(groupIt.next())).remove(listener)) {
        }
    }

    public static void removeElanLocaleListener(Object key) {
        listenerGroups.remove(key);
    }

    private static void notifyListeners() {
        Iterator<Object> groupIt = listenerGroups.keySet().iterator();
        while (groupIt.hasNext()) {
            List<ElanLocaleListener> listeners = listenerGroups.get(groupIt.next());
            for (int i = 0; i < listeners.size(); ++i) {
                listeners.get(i).updateLocale();
            }
        }
    }

    public static ResourceBundle getResourceBundle() {
        return resourcebundle;
    }

    static {
        listenerGroups = new HashMap<Object, List<ElanLocaleListener>>();
        CUSTOM = new Locale("cu", "", "");
        DUTCH = new Locale("nl", "NL");
        ENGLISH = new Locale("", "");
        CATALAN = new Locale("ca");
        SPANISH = new Locale("es", "ES");
        SWEDISH = new Locale("sv", "SE");
        GERMAN = new Locale("de", "DE");
        PORTUGUESE = new Locale("pt");
        BRAZILIAN_PORTUGUESE = new Locale("pt", "BR");
        FRENCH = new Locale("fr");
        JAPANESE = new Locale("ja", "JP");
        CHINESE_SIMP = new Locale("zh", "CN");
        RUSSIAN = new Locale("ru", "RU");
        KOREAN = new Locale("ko");
    }
}

